package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.metadata.KnowledgeMapsActionMetadataElement;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.metadata.KnowledgeMapsActionMetadataQueryResult;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.metadata.KnowledgeMapsActionMetadataResponse;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotApiMetadata;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotMetadataField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotMetadataPrecision;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Service
public class MetadataService {

    private static String patternStr = "^\\((?<length>\\d*?),(?<place>\\d*?)\\)$|^(?<size>\\d*?)$";
    private static Pattern pattern = Pattern.compile(patternStr);

    /**
     * 创建单个元数据结构
     *
     * @param metadataDataDTO
     * @return
     */
    public PcUiBotApiMetadata createApiMetadata(KnowledgeMapsActionMetadataQueryResult metadataDataDTO) {
        //通过bpm推送过来的元数据，重新构建元数据

        PcUiBotApiMetadata apiMetadata = new PcUiBotApiMetadata();
        String actionId = metadataDataDTO.getActionId();
        String serviceName = metadataDataDTO.getServiceName();
        apiMetadata.setActionId(actionId);
        apiMetadata.setServiceName(serviceName);
        if (metadataDataDTO.getRequest() != null && metadataDataDTO.getRequest().getParameters() != null) {
            apiMetadata.setRequestFields(createMetadataField(new ArrayList<>(), metadataDataDTO.getRequest().getParameters()));
        }
        if (metadataDataDTO.getResponse() != null && metadataDataDTO.getResponse().getData() != null) {
            apiMetadata.setResponseFields(createMetadataField(new ArrayList<>(), metadataDataDTO.getResponse().getData()));
        }

        return apiMetadata;
    }

    /**
     * 创建单个元数据结构
     *
     * @param apiMetadataObj
     * @return
     */
    public PcUiBotApiMetadata createApiMetadata(String actionId, String serviceName, Object apiMetadataObj) {
        //通过bpm推送过来的元数据，重新构建元数据
        KnowledgeMapsActionMetadataQueryResult metadataDataDTO = new KnowledgeMapsActionMetadataQueryResult();
        metadataDataDTO.setActionId(actionId);
        metadataDataDTO.setServiceName(serviceName);
        KnowledgeMapsActionMetadataElement data = JsonUtil.objectToJavaObject(apiMetadataObj, KnowledgeMapsActionMetadataElement.class);
        KnowledgeMapsActionMetadataResponse responseDTO = new KnowledgeMapsActionMetadataResponse();
        responseDTO.setData(data);
        metadataDataDTO.setResponse(responseDTO);
        PcUiBotApiMetadata apiMetadata = new PcUiBotApiMetadata();
        apiMetadata.setActionId(actionId);
        apiMetadata.setServiceName(serviceName);
        if (metadataDataDTO.getRequest() != null && metadataDataDTO.getRequest().getParameters() != null) {
            apiMetadata.setRequestFields(createMetadataField(new ArrayList<>(), metadataDataDTO.getRequest().getParameters()));
        }
        if (metadataDataDTO.getResponse() != null && metadataDataDTO.getResponse().getData() != null) {
            apiMetadata.setResponseFields(createMetadataField(new ArrayList<>(), metadataDataDTO.getResponse().getData()));
        }

        return apiMetadata;
    }

    /**
     * 创建对象
     *
     * @param metadataFieldDTOs
     * @return
     */
    private static List<PcUiBotMetadataField> createMetadataField(List<PcUiBotMetadataField> requestFields, List<KnowledgeMapsActionMetadataElement> metadataFieldDTOs) {
        for (KnowledgeMapsActionMetadataElement metadataFieldDTO : metadataFieldDTOs) {
            PcUiBotMetadataField metadataField = new PcUiBotMetadataField();
            metadataField.setName(metadataFieldDTO.getDataName());
            if (metadataFieldDTO.getRequired() == null) {
                metadataField.setRequired(false);
            } else {
                metadataField.setRequired("true".equalsIgnoreCase(metadataFieldDTO.getRequired().toString()));
            }
            metadataField.setDescription(metadataFieldDTO.getDescription());
            metadataField.setRemark(metadataFieldDTO.getRemark());
            metadataField.setBusinessKey("true".equalsIgnoreCase(StringUtil.valueOf(metadataFieldDTO.getIsBusinesskey())));
            metadataField.setDataKey(metadataFieldDTO.getIsDatakey());
            metadataField.setDataType(metadataFieldDTO.getDataType());
            metadataField.setEnumKey(StringUtil.valueOf(metadataFieldDTO.getEnumKey()));
            //解析数据精度或者长度
            if (metadataFieldDTO.getPrecision() != null) {
                Matcher m = pattern.matcher(StringUtil.valueOf(metadataFieldDTO.getPrecision()));
                if (m.matches()) {
                    PcUiBotMetadataPrecision precision = new PcUiBotMetadataPrecision();
                    //如果只有长度
                    if (m.group("size") != null) {
                        precision.setLength(Integer.parseInt(m.group("size")));
                        metadataField.setPrecision(precision);
                    } else if (m.group("length") != null && m.group("place") != null) {
                        precision.setLength(Integer.parseInt(m.group("length")));
                        precision.setPlace(Integer.parseInt(m.group("place")));
                        metadataField.setPrecision(precision);
                    }
                }
            }
            metadataField.setArray(metadataFieldDTO.getIsArray());
            if (!CollectionUtils.isEmpty(metadataFieldDTO.getField())) {
                List<PcUiBotMetadataField> subRequestFields = new ArrayList<>();
                metadataField.setSubFields(createMetadataField(subRequestFields, metadataFieldDTO.getField()));
            }
            requestFields.add(metadataField);
        }
        return requestFields;
    }


    /**
     * 创建对象
     *
     * @param metadataFieldDTO
     * @return
     */
    private static List<PcUiBotMetadataField> createMetadataField(List<PcUiBotMetadataField> requestFields, KnowledgeMapsActionMetadataElement metadataFieldDTO) {
        PcUiBotMetadataField metadataField = new PcUiBotMetadataField();
        metadataField.setName(metadataFieldDTO.getDataName());
        if (metadataFieldDTO.getRequired() == null) {
            metadataField.setRequired(false);
        } else {
            metadataField.setRequired("true".equalsIgnoreCase(metadataFieldDTO.getRequired().toString()));
        }
        metadataField.setDescription(metadataFieldDTO.getDescription());
        metadataField.setRemark(metadataFieldDTO.getRemark());
        metadataField.setDataKey(metadataFieldDTO.getIsDatakey());
        metadataField.setBusinessKey("true".equalsIgnoreCase(StringUtil.valueOf(metadataFieldDTO.getIsBusinesskey())));
        metadataField.setDataType(metadataFieldDTO.getDataType());
        metadataField.setArray(metadataFieldDTO.getIsArray());
        metadataField.setEnumKey(StringUtil.valueOf(metadataFieldDTO.getEnumKey()));
        if (!CollectionUtils.isEmpty(metadataFieldDTO.getField())) {
            List<PcUiBotMetadataField> subRequestFields = new ArrayList<>();
            metadataField.setSubFields(createMetadataField(subRequestFields, metadataFieldDTO.getField()));
        }
        requestFields.add(metadataField);
        return requestFields;
    }

}
