package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProjectData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotMessageUtils;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotPatternUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotSubmitActionUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.*;

/**
 * <p>功能描述：提交ACTION 服务</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: NewTaskSubmitActionCreateService.java
 * @Author: wangjwc
 * @Date: created at 2023/7/13 11:17
 */
@Service
public class NewTaskSubmitActionCreateService extends ActionCreateServiceBase {
    @Autowired
    private TaskEngineActionCreateService bpmService;
    @Autowired
    private DataEntryDrivenActionCreateService dataEntryDrivenActionCreateService;

    /**
     * 需要展示附件上传的签核任务类型
     */
    private final static String[] approvelTaskType = {"agree", "add-task", "reexecute", "disagree", "reapprove"};

    public PcUiBotSubmitAction create(PcUiBotExecuteContext executeContext, DigiwinAtmcProjectData projectData, DigiwinAtmcTaskWithBacklogData taskWithBacklogData, PcUiBotTmAction tmAction, PcUiBotTmActivity tmActivity) {
        // 任务的校验
        taskSubmitActionCheck(taskWithBacklogData);
        PcUiBotSubmitAction action = createSubmitActionInternal(executeContext, projectData, taskWithBacklogData, tmAction, tmActivity);
        action.setExecuteContext(PcUiBotSubmitExecuteContext.create(executeContext, taskWithBacklogData));
        if (tmAction.getIsCustomize() != null && tmAction.getIsCustomize()) {
            action.setIsCustomize(true);
            action.setUuid(tmAction.getUuid());
            action.setBtnId(tmAction.getBtnId());
            action.setBtnType(tmAction.getBtnType());
            action.setJumpAction(tmAction.getJumpAction());
            action.setTitle(tmAction.getTitle());
            action.setType(tmAction.getType());
            if (tmAction.getSchema() != null) {
                action.setSchema(tmAction.getSchema());
            }
            action.setSubmitType(tmAction.getSubmitType());
        }
        if (tmAction.isDispatch()) {
            //附加工作流推送关卡
            PcUiBotSubmitAction agreeAction = createTaskEngineAction(BpmServiceInvokeType.Dispatch.getName(), taskWithBacklogData, executeContext.getDataFrom());
            agreeAction.setTitle("同意");
            agreeAction.setActionId(BpmServiceInvokeType.Dispatch.getName());
            action.getAttachActions().add(agreeAction);

        }

        action.setExecuteAfterCheckCompleted(tmAction.getExecuteAfterCheckCompleted());
        return action;
    }


    private PcUiBotSubmitAction createSubmitActionInternal(PcUiBotExecuteContext executeContext, DigiwinAtmcProjectData projectData, DigiwinAtmcTaskWithBacklogData taskWithBacklogData, PcUiBotTmAction tmAction, PcUiBotTmActivity tmActivity) {

        PcUiBotSubmitAction action = null;
        if (Objects.equals(PcUiBotConstants.ACTION_CATEGORY_BPM_TASK_ENGINE, tmAction.getType())) {
            action = this.createTaskEngineAction(tmAction.getServiceName(), taskWithBacklogData, executeContext.getDataFrom());
            if (action != null) {
                if (!StringUtils.hasLength(tmAction.getId())) {
                    action.setId(tmAction.getActionId());
                } else {
                    action.setId(tmAction.getId());
                }
                action.setActionId(tmAction.getActionId());
                action.setDefaultAction(tmAction.isDefaultAction());
                action.setUuid(tmAction.getUuid());
                action.setBtnId(tmAction.getBtnId());
                action.setBtnType(tmAction.getBtnType());
                action.setJumpAction(tmAction.getJumpAction());
                action.setTitle(PcUiBotMessageUtils.getMessageByCurrentLanguage(tmAction.getTitle()));
                action.setActionParams(tmAction.getActionParams());
                action.executeExtendParas(tmAction.getExtendParas(), executeContext);
                processActionParas(action, executeContext);
            }
        } else if (Objects.equals(PcUiBotConstants.ACTION_CATEGORY_WORKFLOW, tmAction.getType())) {
            action = dataEntryDrivenActionCreateService.createWorkflowSubmitAction(executeContext, tmAction, tmActivity, taskWithBacklogData);
        } else {
            action = this.createSubmitAction(tmAction, projectData.getTenantId(), taskWithBacklogData.getBusinessUnit(), executeContext);
            action.setCategory(tmAction.getType());
        }
        if (action != null) {
            action.setAttachActions(this.createAttachActions(executeContext, projectData, taskWithBacklogData, tmAction, tmActivity));
        } else {
            String message = "不支持的action定义，请检查配置:" + tmAction.getActionId() + tmAction.getType();
            throw new ServiceException(message);
        }
        action.setSubmitType(tmAction.getSubmitType());
        action.setTrackCode(tmAction.getTrackCode());

        // 签核任务 同意、不同意、退回重办、加签弹窗增加附件配置  12019
        generateAttachConfig(executeContext, action, tmActivity, tmAction);

        // 设置禁用、隐藏等条件
        PcUiBotSubmitActionUtil.setCondition(tmAction, action);

        return action;
    }

    private void generateAttachConfig(PcUiBotExecuteContext executeContext, PcUiBotSubmitAction action, PcUiBotTmActivity tmActivity, PcUiBotTmAction tmAction) {
        if (("APPROVAL".equals(executeContext.getCategory()) && "BUSINESS".equals(executeContext.getPattern()))
                || PcUiBotPatternUtil.isModelDriven(executeContext)) {
            List<String> approvelTaskTypeList = Arrays.asList(approvelTaskType);
            if (approvelTaskTypeList.contains(tmAction.getServiceName())) {
                addAttachApprovalConfig(action, tmActivity);
            }
        }
    }

    /**
     * 创建 查询 ACTION
     *
     * @param tmAction
     * @param tenantId
     * @param businessUnit
     * @param executeContext
     * @return
     */
    private PcUiBotSubmitAction createSubmitAction(PcUiBotTmAction tmAction, String tenantId, Map<String, Object> businessUnit, PcUiBotExecuteContext executeContext) {
        return initSubmitAction(tmAction, tenantId, businessUnit, executeContext);
    }


    /**
     * 创建attach
     *
     * @param projectData
     * @param taskWithBacklogData
     * @param tmAction
     * @param tmActivity
     * @return
     */
    private List<PcUiBotSubmitAction> createAttachActions(PcUiBotExecuteContext executeContext, DigiwinAtmcProjectData projectData, DigiwinAtmcTaskWithBacklogData taskWithBacklogData, PcUiBotTmAction tmAction, PcUiBotTmActivity tmActivity) {
        List<PcUiBotSubmitAction> attachActions = new ArrayList<>();
        if (CollectionUtils.isEmpty(tmAction.getAttachActions())) {
            return attachActions;
        }
        tmAction.getAttachActions().forEach(attachTmDataSource -> {
            PcUiBotSubmitAction submitAction = create(executeContext, projectData, taskWithBacklogData, attachTmDataSource, tmActivity);
            submitAction.setExecuteContext(null);
            attachActions.add(submitAction);
        });
        return attachActions;
    }

    private PcUiBotSubmitAction createTaskEngineAction(String serviceName, DigiwinAtmcTaskWithBacklogData taskWithBacklogData, String dataFrom) {
        PcUiBotSubmitAction action = bpmService.createAction(serviceName, taskWithBacklogData, dataFrom);
        return action;
    }

//
//    /**
//     * 创建拒绝的submitAction
//     *
//     * @return
//     */
//    public SubmitAction createRejectAction(TaskWithBacklogData taskData, BacklogData backlogData) {
//        SubmitAction action = bpmService.createRejectAction(taskData,backlogData);
//        action.setTitle(messageUtils.getMessage("backlog.activity.reject"));
//        action.setDefaultAction(false);
//        action.setActionId(BpmServiceInvokeType.Reject.getName());
////        action.setTaskWithBacklogData(taskData);
//        return action;
//    }
//
//
//    /**
//     * 创建拒绝的submitAction
//     *
//     * @return
//     */
//    public SubmitAction createTerminateProcessAction(TaskWithBacklogData taskData, BacklogData backlogData) {
//        SubmitAction action = bpmService.createTerminateProcessAction(taskData,backlogData);
//        action.setTitle(messageUtils.getMessage("backlog.activity.reject"));
//        action.setDefaultAction(false);
//        action.setActionId(BpmServiceInvokeType.TerminateProcess.getName());
////        action.setTaskWithBacklogData(taskData);
//        return action;
//    }
//    /**
//     * 创建转派的submitAction
//     *
//     * @return
//     */
//    public SubmitAction createReassignAction(TaskWithBacklogData taskData, BacklogData backlogData) {
//        SubmitAction action = bpmService.createAction(taskData,backlogData, BpmServiceInvokeType.ReAssign);
//        action.setTitle(messageUtils.getMessage("backlog.activity.reassign"));
//        action.setDefaultAction(false);
//        action.setActionId(BpmServiceInvokeType.ReAssign.getName());
////        action.setTaskWithBacklogData(taskData);
//        return action;
//    }
//
//    /**
//     * 创建退回的submitAction
//     *
//     * @return
//     */
//    public SubmitAction createReExecuteAction(TaskWithBacklogData taskData, BacklogData backlogData) {
//        SubmitAction action = bpmService.createAction(taskData,backlogData, BpmServiceInvokeType.ReExecute);
//        action.setTitle(messageUtils.getMessage("backlog.activity.reexecute"));
//        action.setDefaultAction(false);
//        action.setActionId(BpmServiceInvokeType.ReExecute.getName());
////        action.setTaskWithBacklogData(taskData);
//        return action;
//    }
//
//    /**
//     * 创建重签的submitAction
//     *
//     * @return
//     */
//    public SubmitAction createReApproveAction(TaskWithBacklogData taskData, BacklogData backlogData) {
//        SubmitAction action = bpmService.createAction(taskData,backlogData, BpmServiceInvokeType.ReApprove);
//        action.setTitle(messageUtils.getMessage("backlog.activity.reapprove"));
//        action.setDefaultAction(false);
//        action.setActionId(BpmServiceInvokeType.ReExecute.getName());
////        action.setTaskWithBacklogData(taskData);
//        return action;
//    }
//
//    /**
//     * 创建加签的submitAction
//     *
//     * @return
//     */
//    public SubmitAction createAddTaskAction(TaskWithBacklogData taskData, BacklogData backlogData) {
//        SubmitAction action = bpmService.createAction(taskData,backlogData, BpmServiceInvokeType.AddTask);
////        action.setTitle(messageUtils.getMessage("backlog.activity.reapprove"));
//        action.setDefaultAction(false);
//        action.setActionId(BpmServiceInvokeType.ReExecute.getName());
////        action.setTaskWithBacklogData(taskData);
//        return action;
//    }

}
