package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.parser.TaskCombineSubmitActionParser;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Optional;

/**
 * <p>功能描述：页面提交类型按钮</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: NewTaskSubmitService.java
 * @Author: wangjwc
 * @Date: created at 2023/7/13 13:18
 */
@Service
public class NewTaskSubmitService {

    public void createTaskSubmit(PcUiBotExecuteContext executeContext, PcUiBotTmActivity tmActivity, PcUiBotTmDataState tmDataState, PcUiBotPageDefine action) {
        List<PcUiBotTmAction> submitActions = tmDataState.getSubmitActions();
        TaskCombineSubmitActionParser parser =
                SpringContextHolder.getBean(TaskCombineSubmitActionParser.class);
        parser.init(executeContext, tmActivity, tmDataState, action);
        List<PcUiBotSubmitAction> actionsList = parser.parse(submitActions);
        //判断是否存在默认DefaultAction
        boolean checkDefaultAction = Optional.ofNullable(submitActions)
                .orElse(Lists.newArrayList())
                .stream().anyMatch(PcUiBotTmAction::isDefaultAction);
        if (!checkDefaultAction && !CollectionUtils.isEmpty(actionsList)) {
            actionsList.get(0).setDefaultAction(true);
        }
        action.setSubmitType(tmDataState.getSubmitType());
        action.setMultipleSelectMerge(tmDataState.getMultipleSelectMerge());
        action.setSubmitActions(actionsList);
    }
}
