package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import org.springframework.stereotype.Service;

/**
 * <p>功能描述：打印 Action 创建服务</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PrintActionCreateService.java
 * @Author: wangjwc
 * @Date: created at 2024/12/17 19:44
 */
@Service
public class PrintActionCreateService extends ActionCreateServiceBase {

    public PcUiBotSubmitAction createAction(PcUiBotSubmitAction action, PcUiBotExecuteContext executeContext) {
        action.setType(PcUiBotConstants.ComponentType.OPERATION_ACTION_PRINT);
        PcUiBotTmAction tmAction = JsonUtil.objectToJavaObject(action, PcUiBotTmAction.class);
        PcUiBotSubmitAction submitAction = this.initSubmitAction(tmAction, executeContext.getTenantId(), executeContext.getBusinessUnit(), executeContext);
        submitAction.setExecuteContext(PcUiBotSubmitExecuteContext.create(executeContext, null));
        submitAction.setSubmitType(tmAction.getSubmitType());
        submitAction.setBusinessConfig(action.getBusinessConfig());
        return submitAction;
    }
}
