package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcActivityData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：dataSource 业务逻辑处理层</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ProjectDataSourceAnalysisService.java
 * @Author: wangjwc
 * @Date: created at 2024/12/3 20:46
 */
@Service
public class ProjectDataSourceAnalysisService extends DataSourceAnalysisServiceBase {

    public PcUiBotDataSourceSetDTO analysis(PcUiBotExecuteContext executeContext, PcUiBotTmActivity tmActivity, Map<String, PcUiBotTmQueryAction> dataSources, PcUiBotTmDataFilter tmDataFilter) {
        PcUiBotDataSourceSetDTO dataSourceSet = new PcUiBotDataSourceSetDTO();
        if (dataSources.size() == 0) {
            return dataSourceSet;
        }

        List<PcUiBotDataSourceDTO> dataSourceList = new ArrayList<>();
        dataSourceSet.setDataSourceList(dataSourceList);
        dataSourceSet.setDataProcess(new ArrayList<>());
        //人工、非人工关卡处理方式不一样
        boolean isUserTask = false;
        for (DigiwinAtmcTaskWithBacklogData taskWithBacklogData : executeContext.getTaskWithBacklogDataList()) {
            if (PcUiBotActivityConstant.TASK_TYPE_USER_TASK.equals(taskWithBacklogData.getBpmActivityType()) || PcUiBotActivityConstant.TASK_TYPE_WAITING_TASK.equals(taskWithBacklogData.getBpmActivityType())) {
                isUserTask = true;
                break;
            }
        }

        //循环所有的数据源
        boolean finalIsUserTask = isUserTask;
        dataSources.forEach((dataSourceName, tmQueryAction) -> {
            PcUiBotDataSourceDTO dataSourceDTO = null;
            //如果是人工关卡
            if (finalIsUserTask) {
                //如果是配置合并查询
                boolean dataStates = tmActivity.getPages().getDataStates().stream().anyMatch(s -> s.getMergeQuery() != null && s.getMergeQuery());
                if (Boolean.TRUE.equals(tmActivity.getPages().getMergeQuery()) || dataStates) {
                    //做合并查询，可以只调用一次api即可，提高效率
                    dataSourceDTO = this.createBatchQueryBacklog(executeContext, dataSourceName, tmQueryAction, executeContext.getTaskWithBacklogDataList(), executeContext.getProjectData(), tmDataFilter, true);
                    if (dataSourceDTO != null) {
                        dataSourceDTO.setMetadataFields(tmQueryAction.getMetadataFields());
                    }
                } else {
                    //需要根据活动查询多次，然后把结果合并，变成一个union查询
                    dataSourceDTO = this.createProjectUserTaskDataSource(executeContext, tmDataFilter, dataSourceName, tmQueryAction);
                }
            } else {
                //如果是非人工关卡
                if (tmQueryAction.getLeft() != null) {
                    //如果是组合查询，则不能做合并
                    dataSourceDTO = this.createProjectNotUserTaskDataSource(executeContext, tmDataFilter, dataSourceName, tmQueryAction);
                } else {
                    //做合并查询，可以只调用一次api即可，提高效率
                    dataSourceDTO = this.createBatchQueryWithoutBacklog(executeContext, dataSourceName, tmQueryAction, tmDataFilter);
                    if (dataSourceDTO != null) {
                        dataSourceDTO.setMetadataFields(tmQueryAction.getMetadataFields());
                    }
                }
            }
            if (dataSourceDTO != null) {
                dataSourceList.add(dataSourceDTO);
            }
        });


        for (PcUiBotTmQueryAction queryAction : dataSources.values()) {
            if (CollectionUtils.isNotEmpty(queryAction.getDataProcessors())) {
                for (PcUiBotTmDataProcess dataProcessor : queryAction.getDataProcessors()) {
                    if (PcUiBotConstants.DATA_PROCESS_ACTIVE_POINT_EXECUTE_COMPLETED.equals(dataProcessor.getActivePoint())) {
                        dataSourceSet.getDataProcess().add(dataProcessor);
                    }
                }
            }
        }
        return dataSourceSet;
    }


    private PcUiBotDataSourceDTO createProjectNotUserTaskDataSource(PcUiBotExecuteContext executeContext, PcUiBotTmDataFilter tmDataFilter, String dataSourceName, PcUiBotTmQueryAction tmAction) {
        List<PcUiBotDataSourceDTO> projectDataSourceList = new ArrayList<>();
        //为每个活动创建查询
        for (DigiwinAtmcTaskWithBacklogData task : executeContext.getTaskWithBacklogDataList()) {
            DigiwinAtmcActivityData newActivityData = new DigiwinAtmcActivityData();
            newActivityData.setProject(executeContext.getProjectData());
            DigiwinAtmcTaskWithBacklogData newTaskWithBacklogData = task.copy();
            List<DigiwinAtmcTaskWithBacklogData> taskWithBacklogDataList = new ArrayList<>();
            taskWithBacklogDataList.add(newTaskWithBacklogData);
            newActivityData.setTasks(taskWithBacklogDataList);
            PcUiBotDataSourceDTO dataSourceBase = this.create(executeContext, dataSourceName, tmAction, newTaskWithBacklogData, newActivityData.getProject(), tmDataFilter);
            if (dataSourceBase != null) {
                projectDataSourceList.add(dataSourceBase);
            }
        }
        if (projectDataSourceList.size() == 1) {
            PcUiBotDataSourceDTO dataSourceBase = projectDataSourceList.get(0);
            return dataSourceBase;
        } else if (projectDataSourceList.size() > 1) {
            PcUiBotDataSourceDTO unionDataSource = new PcUiBotDataSourceDTO();
            List<PcUiBotDataSourceDTO> unionItems = new ArrayList<>();
            for (PcUiBotDataSourceDTO dataSourceBase : projectDataSourceList) {
                unionItems.add(dataSourceBase);
            }
            unionDataSource.setType(PcUiBotConstants.ACTION_CATEGORY_MIX_UNION);
            unionDataSource.setActionId(projectDataSourceList.get(0).getActionId());
            unionDataSource.setName(projectDataSourceList.get(0).getName());
            unionDataSource.setUnionItems(unionItems);
            unionDataSource.setDataKeys(projectDataSourceList.get(0).getDataKeys());
            unionDataSource.setDataSourceProcessors(projectDataSourceList.get(0).getDataSourceProcessors());
            unionDataSource.setMetadataFields(projectDataSourceList.get(0).getMetadataFields());
            return unionDataSource;
        }
        return null;
    }


    private PcUiBotDataSourceDTO createProjectUserTaskDataSource(PcUiBotExecuteContext executeContext, PcUiBotTmDataFilter tmDataFilter, String dataSourceName, PcUiBotTmQueryAction tmAction) {
        List<PcUiBotDataSourceDTO> projectDataSourceList = new ArrayList<>();
        //为每个活动创建查询
        for (DigiwinAtmcTaskWithBacklogData task : executeContext.getTaskWithBacklogDataList()) {
            //如果没有执行人，忽略
            if (CollectionUtils.isEmpty(task.getBacklog())) {
                continue;
            }
            List<DigiwinAtmcBacklogData> backlogDatas = task.getBacklog();

            if (CollectionUtils.isEmpty(backlogDatas)) {
                continue;
            }
            for (DigiwinAtmcBacklogData backlogData : backlogDatas) {
                DigiwinAtmcActivityData newActivityData = new DigiwinAtmcActivityData();
                newActivityData.setProject(executeContext.getProjectData());
                DigiwinAtmcTaskWithBacklogData newTaskWithBacklogData = task.copy();
                List<DigiwinAtmcBacklogData> backlogDataArrayList = new ArrayList<>();
                backlogDataArrayList.add(backlogData);
                newTaskWithBacklogData.setBacklog(backlogDataArrayList);
                List<DigiwinAtmcTaskWithBacklogData> taskWithBacklogDataList = new ArrayList<>();
                taskWithBacklogDataList.add(newTaskWithBacklogData);
                newActivityData.setTasks(taskWithBacklogDataList);
                PcUiBotDataSourceDTO dataSourceBase = this.create(executeContext, dataSourceName, tmAction, newTaskWithBacklogData, newActivityData.getProject(), tmDataFilter);
                if (dataSourceBase != null) {
                    projectDataSourceList.add(dataSourceBase);
                }
            }
        }
        if (projectDataSourceList.size() == 1) {
            return projectDataSourceList.get(0);

        } else if (projectDataSourceList.size() > 1) {
            PcUiBotDataSourceDTO unionDataSource = new PcUiBotDataSourceDTO();
            List<PcUiBotDataSourceDTO> unionItems = new ArrayList<>();
            for (PcUiBotDataSourceDTO dataSourceBase : projectDataSourceList) {
                unionItems.add(dataSourceBase);
            }
            unionDataSource.setType(PcUiBotConstants.ACTION_CATEGORY_MIX_UNION);
            unionDataSource.setActionId(projectDataSourceList.get(0).getActionId());
            unionDataSource.setName(projectDataSourceList.get(0).getName());
            unionDataSource.setUnionItems(unionItems);
            unionDataSource.setDataKeys(projectDataSourceList.get(0).getDataKeys());
            return unionDataSource;
        }
        return null;
    }

}
