package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProjectData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableScriptFilter;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.DataViewService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotMapDataUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.*;

/**
 * <p>功能描述：查询数据ACTION</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: QueryActionCreateService.java
 * @Author: wangjwc
 * @Date: created at 2023/7/12 18:10
 */
@Service
public class QueryActionCreateService extends ActionCreateServiceBase {

    @Autowired
    private DigiwinEocProxyService digiwinEocProxyService;

    @Resource
    private DataViewService dataViewService;

    /**
     * 创建 查询 ACTION
     *
     * @param tmActionDTO
     * @param tenantId
     * @return
     */
    private PcUiBotQueryAction createAction(PcUiBotTmQueryAction tmActionDTO, String tenantId, Map<String, Object> businessUnit, PcUiBotExecuteContext executeContext) {
        // 类型为VIEWCODE,从KM系统获取视图数据源配置
        if (tmActionDTO.getType().equals(PcUiBotConstants.ACTION_CATEGORY_VIEW_CODE)) {
            String viewCode = tmActionDTO.getDataViewQuery().getCode();
            PcUiBotTmDataViewQuery tmDataViewQuery = dataViewService.queryDataView(viewCode, executeContext);
            PcUiBotTmQueryAction tempTmActionDTO = dataViewService.buildTmQueryAction(null, tmDataViewQuery);
            //ActionParams从定义中获取，dataViewService.buildTmQueryAction分析的没有此参数，进行对象拷贝此参数会丢失，所以进行一次赋值
            if (!CollectionUtils.isEmpty(tmActionDTO.getActionParams())) {
                tempTmActionDTO.setActionParams(tmActionDTO.getActionParams());
            }
            // 复制数据
            BeanUtils.copyProperties(tempTmActionDTO, tmActionDTO);
            tmActionDTO.setViewCode(viewCode);
        }

        appendActionInfo(tmActionDTO, executeContext);
        PcUiBotQueryAction action = new PcUiBotQueryAction();
        action.setActionId(tmActionDTO.getActionId());
        action.setServiceId(this.createActionServiceId(tmActionDTO, tenantId));
        action.setCategory(tmActionDTO.getType());
        action.setUuid(tmActionDTO.getUuid());
        action.setBtnId(tmActionDTO.getBtnId());
        action.setBtnType(tmActionDTO.getBtnType());
        action.setJumpAction(tmActionDTO.getJumpAction());
        action.setTitle(tmActionDTO.getTitle());
        action.setBusinessUnit(businessUnit);
        action.setAppendRowBusinessUnitSelect(tmActionDTO.getAppendRowBusinessUnitSelect());
        action.setActionParams(tmActionDTO.getActionParams());
        return action;
    }

    /**
     * 为基础资料录入创建查询数据源
     * 其中actionParameter解析不支持bpm流程数据
     *
     * @param executeContext
     * @param tmQueryAction
     * @return
     */
    public PcUiBotQueryAction createDataSourceWithoutTask(PcUiBotExecuteContext executeContext, PcUiBotTmQueryAction tmQueryAction) {
        PcUiBotQueryAction action = this.createAction(tmQueryAction, executeContext.getTenantId(), executeContext.getBusinessUnit(), executeContext);
        // dataSource 直传的入参配置
        action.setParas(new HashMap<>());
        if (!CollectionUtils.isEmpty(tmQueryAction.getParas())) {
            action.getParas().putAll(tmQueryAction.getParas());
        }


        // dataSource 需要转换的入参配置
        this.setActionConstantParameter(action.getParas(), tmQueryAction.getActionParams(), executeContext);

        if (!CollectionUtils.isEmpty(tmQueryAction.getActionParams())) {
            for (PcUiBotActionParameterMapping tmActionRequestParameter : tmQueryAction.getActionParams()) {
                if (PcUiBotActivityConstant.TASK_QUERY_PROCESS_VARIABLE.equals(tmActionRequestParameter.getType())) {
                    Map<String, Object> bpmdata = new HashMap<>();
                    if (!CollectionUtils.isEmpty(executeContext.getAllBpmData())) {
                        bpmdata = executeContext.getAllBpmData().get(0);
                    }
                    Map<String, Object> convertParas = this.setActionParameter(executeContext.getDataStateCode(), action.getParas(), tmQueryAction.getActionParams(), bpmdata, executeContext);
                    action.getParas().putAll(!CollectionUtils.isEmpty(convertParas) ? convertParas : new HashMap<>());
                }
            }
        }

        return action;
    }

    private Map<String, Object> setActionConstantParameter(Map paramsMap, List<PcUiBotActionParameterMapping> actionParams, PcUiBotExecuteContext executeContext) {

        if (CollectionUtils.isEmpty(actionParams)) {
            return paramsMap;
        }
        /**
         * 1、不考虑匹配bpm流程变量;
         * 2、不支持数组类型，只支持简单类型;
         */
        //最后再处理其他单个参数,ACTIVE_ROW 是前端参数，需要排除
        for (PcUiBotActionParameterMapping tmActionRequestParameter : actionParams) {
            if (!PcUiBotActivityConstant.TASK_QUERY_PROCESS_VARIABLE.equals(tmActionRequestParameter.getType())
                    && !"ACTIVE_ROW".equals(tmActionRequestParameter.getType())
                    && !"ACTIVE_ROW_CONSTANT".equals(tmActionRequestParameter.getType())
                    && !"RAW_ARRAY_PARAS".equals(tmActionRequestParameter.getType())
                    && !"PAGE_DATA".equals(tmActionRequestParameter.getType())) {
                //常规参数处理
                setSinglePara(paramsMap, tmActionRequestParameter, null, executeContext);
            }
        }
        return paramsMap;
    }

    /**
     * 创建 查询 ACTION 根据 activityTaskData
     *
     * @param tmAction
     * @param taskWithBacklogData
     * @return
     */
    public PcUiBotQueryAction createQueryAction(String dataStatusCode, PcUiBotTmQueryAction tmAction, DigiwinAtmcTaskWithBacklogData taskWithBacklogData, DigiwinAtmcProjectData projectData, PcUiBotTmDataFilter tmDataFilter, String dataSourceName, PcUiBotExecuteContext executeContext) {

        PcUiBotQueryAction action = this.createAction(tmAction, projectData.getTenantId(), taskWithBacklogData.getBusinessUnit(), executeContext);

        action.setParas(new HashMap<>());
        if (!CollectionUtils.isEmpty(tmAction.getParas())) {
            action.getParas().putAll(tmAction.getParas());
        }
        if (CollectionUtils.isEmpty(tmAction.getActionParams())) {
            action.getParas().putAll(!CollectionUtils.isEmpty(taskWithBacklogData.getBpmData()) ? taskWithBacklogData.getBpmData() : new HashMap<>());
            if (!CollectionUtils.isEmpty(taskWithBacklogData.getBacklog())) {
                action.getParas().put("backlogId", taskWithBacklogData.getBacklog().get(0).getBacklogId());
            }
        } else {
            JSONObject jsonObject = JsonUtil.objectToJavaObject(taskWithBacklogData.getBpmData(), JSONObject.class);
            Map<String, Object> convertParas = this.setActionParameter(dataStatusCode, action.getParas(), tmAction.getActionParams(), jsonObject, executeContext);
            if (!CollectionUtils.isEmpty(tmAction.getParas()) && !CollectionUtils.isEmpty(convertParas)) {
                convertParas = PcUiBotMapDataUtil.combine(convertParas, tmAction.getParas());
            }
            action.getParas().putAll(!CollectionUtils.isEmpty(convertParas) ? convertParas : new HashMap<>());
        }
        if (tmDataFilter != null && !Objects.equals(tmAction.getType(), PcUiBotConstants.ACTION_CATEGORY_RAW_DATA)) {
            if (tmDataFilter.getDataSourceNames() != null) {
                if (dataSourceName.equals(tmAction.getName())) {
                    addFilterParameterToActionParas(action, tmDataFilter, projectData, executeContext);
                }
            } else {
                addFilterParameterToActionParas(action, tmDataFilter, projectData, executeContext);
            }
        }
        return action;
    }

    /**
     * 创建 查询 ACTION 根据 activityTaskData
     *
     * @param tmAction
     * @return
     */
    public PcUiBotQueryAction createQueryAction(String tenantId, Map<String, Object> businessUnit, String dataStateCode, PcUiBotTmQueryAction tmAction, Map<String, Object> bpmData, PcUiBotExecuteContext executeContext) {
        PcUiBotQueryAction action = this.createAction(tmAction, tenantId, businessUnit, executeContext);
        action.setParas(!CollectionUtils.isEmpty(tmAction.getParas()) ? tmAction.getParas() : new HashMap<>());

        if (CollectionUtils.isEmpty(tmAction.getActionParams())) {
            action.getParas().putAll(!CollectionUtils.isEmpty(bpmData) ? bpmData : new HashMap<>());
        } else {
            JSONObject jsonObject = JsonUtil.objectToJavaObject(bpmData, JSONObject.class);
            Map<String, Object> convertParas = this.setActionParameter(dataStateCode, action.getParas(), tmAction.getActionParams(), jsonObject, executeContext);
            action.getParas().putAll(!CollectionUtils.isEmpty(convertParas) ? convertParas : new HashMap<>());
            //如果需要前端传如参数,则把需要传的参数放入到ActionParams
            action.setActionParams(new ArrayList<>());
            for (PcUiBotActionParameterMapping actionParam : tmAction.getActionParams()) {
                if ("ACTIVE_ROW".equals(actionParam.getType())
                        || "ACTIVE_ROW_CONSTANT".equals(actionParam.getType())
                        || "ACTIVE_PARENT_ROW".equals(actionParam.getType())
                        || "PAGE_DATA".equals(actionParam.getType())
                        || "TM_VARIABLE".equals(actionParam.getType())) {
                    action.getActionParams().add(actionParam);
                }
            }
        }
        action.setBusinessUnit(businessUnit);
        return action;
    }


    /**
     * 直接组装好参数--无需在此转换
     *
     * @param tmAction
     * @return
     */
    public PcUiBotQueryAction createQueryHasParasAction(String tenantId, Map<String, Object> businessUnit, PcUiBotTmQueryAction tmAction, Map<String, Object> paras, PcUiBotExecuteContext executeContext) {
        PcUiBotQueryAction action = this.createAction(tmAction, tenantId, businessUnit, executeContext);
        action.setParas(paras);
        action.setBusinessUnit(businessUnit);
        return action;
    }


    /**
     * 把filter 添加到action 参数中去
     *
     * @param action
     * @param tmDataFilter
     * @param executeContext
     */
    private void addFilterParameterToActionParas(PcUiBotQueryAction action, PcUiBotTmDataFilter tmDataFilter, DigiwinAtmcProjectData projectData, PcUiBotExecuteContext executeContext) {
        List<PcUiBotTmFilterCondition> apiCondition = tmDataFilter.getApiCondition();
        Map<String, Object> paras = action.getParas();
        if (tmDataFilter.isApiFilter()) {
            apiCondition.forEach(tmFilterCondition -> {
                setActionFilter(paras, tmFilterCondition, projectData, executeContext);
            });
        }
        if (tmDataFilter.getScriptCondition() != null) {
            action.setScriptFilters(createScriptFilters(tmDataFilter));
        }
    }

    /**
     * 生成前端过滤条件
     *
     * @param tmDataFilter
     * @return
     */
    private List<UiBotTableScriptFilter> createScriptFilters(PcUiBotTmDataFilter tmDataFilter) {
        List<UiBotTableScriptFilter> filters = new ArrayList<>();
        UiBotTableScriptFilter filter = new UiBotTableScriptFilter();
        filters.add(filter);
        filter.setDefaultFilter(tmDataFilter.getDefaultFilter());
        filter.setTitle(tmDataFilter.getTitle());
        filter.setDescription(tmDataFilter.getDescription());
        if (tmDataFilter.getScriptCondition() != null) {
            filter.setTarget(tmDataFilter.getScriptCondition().getTarget());
            filter.setFilterScript(tmDataFilter.getScriptCondition().getScript());
        }

        return filters;

    }

    /**
     * 增加action的后端过滤条件
     *
     * @param tmFilterCondition
     * @param executeContext
     */
    private void setActionFilter(Map<String, Object> paraMap, PcUiBotTmFilterCondition tmFilterCondition, DigiwinAtmcProjectData projectData, PcUiBotExecuteContext executeContext) {

        //服务端 过滤
        String conName = tmFilterCondition.getName();
        if (conName.contains(".")) {
            //指定过滤条件加在哪个参数中
            String[] conNames = conName.split("\\.");
            Object p = paraMap.get(conNames[0]);
            if (p instanceof JSONObject) {
                JSONObject pJson = (JSONObject) p;
                if ("{@SYSTEM_USER_ID}".equals(tmFilterCondition.getValue())) {
                    pJson.put(conNames[1], executeContext.getAuthoredUser().getUserId());
                } else if ("{@SYSTEM_EMPLOYEE_ID}".equals(tmFilterCondition.getValue())) {
                    pJson.put(conNames[1], digiwinEocProxyService.getEocId(executeContext.getAuthoredUser().getToken(), executeContext.getAuthoredUser().getUserId()));
                } else if ("{@SYSTEM_PROJECT_ID}".equals(tmFilterCondition.getValue())) {
                    pJson.put(conNames[1], projectData.getProjectId());
                } else {
                    pJson.put(conNames[1], tmFilterCondition.getValue());
                }
            } else if (p instanceof Map) {
                Map pJson = (Map) p;
                if ("{@SYSTEM_USER_ID}".equals(tmFilterCondition.getValue())) {
                    pJson.put(conNames[1], executeContext.getAuthoredUser().getUserId());
                } else if ("{@SYSTEM_EMPLOYEE_ID}".equals(tmFilterCondition.getValue())) {
                    pJson.put(conNames[1], digiwinEocProxyService.getEocId(executeContext.getAuthoredUser().getToken(), executeContext.getAuthoredUser().getUserId()));
                } else if ("{@SYSTEM_PROJECT_ID}".equals(tmFilterCondition.getValue())) {
                    pJson.put(conNames[1], projectData.getProjectId());
                } else {
                    pJson.put(conNames[1], tmFilterCondition.getValue());
                }
            } else if (p instanceof JSONArray) {
                JSONArray pJsonArray = (JSONArray) p;
                for (Object oJson : pJsonArray.toArray()) {
                    if (oJson instanceof JSONObject) {
                        JSONObject pJson = (JSONObject) oJson;
                        pJson.put(conNames[1], tmFilterCondition.getValue());
                    }
                }
            } else if (p instanceof List) {
                List pJsonArray = (List) p;
                for (Object o : pJsonArray) {
                    if (o instanceof Map) {
                        Map pJson = (Map) o;
                        pJson.put(conNames[1], tmFilterCondition.getValue());
                    }
                }
            }
        } else {
            //直接加到参数中
            if ("{@SYSTEM_USER_ID}".equals(tmFilterCondition.getValue())) {
                paraMap.put(tmFilterCondition.getName(), executeContext.getAuthoredUser().getUserId());
            } else if ("{@SYSTEM_EMPLOYEE_ID}".equals(tmFilterCondition.getValue())) {
                paraMap.put(tmFilterCondition.getName(), digiwinEocProxyService.getEocId(executeContext.getAuthoredUser().getToken(), executeContext.getAuthoredUser().getUserId()));
            } else if ("{@SYSTEM_PROJECT_ID}".equals(tmFilterCondition.getValue())) {
                paraMap.put(tmFilterCondition.getName(), projectData.getProjectId());
            } else {
                paraMap.put(tmFilterCondition.getName(), tmFilterCondition.getValue());
            }
        }

    }


    /**
     * 处理 查询ACTION 参数
     *
     * @param dataJson
     */
    private Map<String, Object> setActionParameter(String dataStatus, Map paraMap, List<PcUiBotActionParameterMapping> actionParameterMappings, Map dataJson, PcUiBotExecuteContext executeContext) {

        if (dataJson == null || CollectionUtils.isEmpty(actionParameterMappings)) {
            return paraMap;
        }

        //优先处理流程参数，因为其他参数是附加到流程参数内部的
        Map<String, Object> map = Maps.newHashMapWithExpectedSize(2); // 存入含有xx.aa映射的关系
        for (PcUiBotActionParameterMapping tmActionRequestParameter : actionParameterMappings) {
            if (PcUiBotActivityConstant.TASK_QUERY_PROCESS_VARIABLE.equals(tmActionRequestParameter.getType())) {
                if (dataJson.containsKey(tmActionRequestParameter.getValue())) {
                    if (StringUtils.hasText(dataStatus) && !dataStatus.startsWith("uibot__")) {
                        //如果有状态管理，则使用状态管理的参数来做数据查询
                        String key = tmActionRequestParameter.getValue() + "__" + dataStatus;
                        if (dataJson.containsKey(key)) {
                            //如果已经包括了相关状态的数据，则使用
                            paraMap.put(tmActionRequestParameter.getName(), dataJson.get(key));
                        } else {
                            //使用原始的数据，需要API自行控制数据的状态
                            paraMap.put(tmActionRequestParameter.getName(), dataJson.get(tmActionRequestParameter.getValue()));
                        }
                    } else {
                        //使用原始的数据，需要API自行控制数据的状态
                        paraMap.put(tmActionRequestParameter.getName(), dataJson.get(tmActionRequestParameter.getValue()));
                    }
                } else {
                    // 兼容xx.xx的value
                    String value = tmActionRequestParameter.getValue();
                    if (StringUtils.hasText(value)) {
                        // 根据.分割
                        String[] sourcesNames = value.split("\\.");
                        if (sourcesNames.length == 2) { // 含.的才走
                            // 取值
                            Object o = dataJson.get(sourcesNames[0]);
                            // 如果是map类型
                            if (o instanceof Map) {
                                // 对应当前value值
                                Object o1 = ((Map) o).get(sourcesNames[1]);
                                // 需要转换后的属性
                                String name = tmActionRequestParameter.getName();
                                String[] targetNames = name.split("\\.");
                                // 如果只有1个,直接放入当前值
                                if (targetNames.length == 1) {
                                    map.put(targetNames[0], o1);
                                } else if (targetNames.length == 2) {
                                    // 如果是2个代表结果值为map
                                    Map<String, Object> targetMap = (Map<String, Object>) map.computeIfAbsent(targetNames[0], e -> Maps.newHashMapWithExpectedSize(2));
                                    targetMap.put(targetNames[1], o1);
                                }
                            } else if (o instanceof List) {
                                // 如果为数组
                                List list = (List) o;
                                int size = list.size();
                                if (size > 0) {
                                    String name = tmActionRequestParameter.getName();
                                    String[] targetNames = name.split("\\.");
                                    // 目标的长度为1，代表值为集合为基本数据类型
                                    if (targetNames.length == 1) {
                                        for (Object o1 : list) {
                                            if (o1 instanceof Map) {
                                                map.put(targetNames[0], ((Map) o1).get(sourcesNames[1]));
                                            }
                                        }
                                    } else if (targetNames.length == 2) {
                                        // 目标的长度为2，代表值为集合中的类型为map
                                        // 进行初始化
                                        for (int i = 0; i < size; i++) {
                                            List<Map<String, Object>> targetList = (List<Map<String, Object>>) map.computeIfAbsent(targetNames[0], e -> Lists.newArrayListWithCapacity(size));
                                            Map<String, Object> row;
                                            if (targetList.size() < (i + 1)) {
                                                row = new HashMap<>();
                                                targetList.add(row);
                                            } else {
                                                row = targetList.get(i);
                                            }
                                            Object o1 = list.get(i);
                                            Object targetValue = null;
                                            if (o1 instanceof Map) {
                                                targetValue = ((Map) o1).get(sourcesNames[1]);
                                            }
                                            row.put(targetNames[1], targetValue);
                                        }
                                    }

                                }
                            }
                        }
                    }
                }
            }
        }

        if (!map.isEmpty()) {
            paraMap.putAll(map);
        }

        //优先处理指定参数，因为其他参数是附加到参数内部的
        for (PcUiBotActionParameterMapping tmActionRequestParameter : actionParameterMappings) {
            //结构 xxx.aa xxx:数组节点 aa: 对象KEY
            if ("RAW_ARRAY_PARAS".equals(tmActionRequestParameter.getType())) {
                //流程参数
                String pathName[] = StringUtils.split(tmActionRequestParameter.getName(), ".");
                String paramKey = pathName[0];
                String paramNodeKey = pathName[1];
                String value = tmActionRequestParameter.getValue();
                List<Map<String, Object>> dataList = new ArrayList<>();
                if (null != paraMap.get(paramKey)) {
                    dataList = (List<Map<String, Object>>) paraMap.get(paramKey);
                }
                Map dataP = new HashMap<>();
                if (!org.springframework.util.CollectionUtils.isEmpty(dataList)) {
                    dataP = dataList.get(0);
                } else {
                    dataList.add(dataP);
                }
                for (Object o : dataJson.keySet()) {
                    String dataKey = (String) o;
                    if (dataKey.equals(value)) {
                        dataP.put(paramNodeKey, dataJson.get(dataKey));
                    }
                }
                if (!org.springframework.util.CollectionUtils.isEmpty(dataList)) {
                    paraMap.put(paramKey, dataList);
                }
            }
        }

        //最后再处理其他单个参数,ACTIVE_ROW 是前端参数，需要排除
        for (PcUiBotActionParameterMapping tmActionRequestParameter : actionParameterMappings) {
            if (!PcUiBotActivityConstant.TASK_QUERY_PROCESS_VARIABLE.equals(tmActionRequestParameter.getType())
                    && !"ACTIVE_ROW".equals(tmActionRequestParameter.getType())
                    && !"RAW_ARRAY_PARAS".equals(tmActionRequestParameter.getType())
                    && !"PAGE_DATA".equals(tmActionRequestParameter.getType())
                    && !"PAGE_DATA_CONSTANT".equals(tmActionRequestParameter.getType())) {
                //常规参数处理
                setSinglePara(paraMap, tmActionRequestParameter, JsonUtil.objectToJavaObject(dataJson, JSONObject.class), executeContext);
            }
        }
        return paraMap;
    }

    /**
     * 增加action的后端过滤条件
     *
     * @param paraMap
     */
    private void setSinglePara(Map<String, Object> paraMap, PcUiBotActionParameterMapping tmActionRequestParameter, JSONObject dataJson, PcUiBotExecuteContext executeContext) {

        //服务端 过滤
        String conName = tmActionRequestParameter.getName();
        if (conName.contains(".")) {
            //指定过滤条件加在哪个参数中
            String[] conNames = conName.split("\\.");
            Object p = paraMap.get(conNames[0]);
            if (p instanceof JSONObject) {
                JSONObject pJson = (JSONObject) p;
                if ("{@SYSTEM_USER_ID}".equals(tmActionRequestParameter.getValue())) {
                    pJson.put(conNames[1], executeContext.getAuthoredUser().getUserId());
                } else if ("{@SYSTEM_EMPLOYEE_ID}".equals(tmActionRequestParameter.getValue())) {
                    pJson.put(conNames[1], digiwinEocProxyService.getEocId(executeContext.getAuthoredUser().getToken(), executeContext.getAuthoredUser().getUserId()));
                } else {
                    if ("[]".equals(tmActionRequestParameter.getValue())) {
                        //常量为[]进行特殊处理，表示空组数
                        pJson.put(tmActionRequestParameter.getName(), new ArrayList());
                    } else {
                        if (!convertAtmcSystemVariable(dataJson, pJson, conNames[1], tmActionRequestParameter.getValue())) {
                            pJson.put(conNames[1], tmActionRequestParameter.getValue());
                        }
                    }
                }
            } else if (p instanceof Map) {
                Map pJson = (Map) p;
                if ("{@SYSTEM_USER_ID}".equals(tmActionRequestParameter.getValue())) {
                    pJson.put(conNames[1], executeContext.getAuthoredUser().getUserId());
                } else if ("{@SYSTEM_EMPLOYEE_ID}".equals(tmActionRequestParameter.getValue())) {
                    pJson.put(conNames[1], digiwinEocProxyService.getEocId(executeContext.getAuthoredUser().getToken(), executeContext.getAuthoredUser().getUserId()));
                } else {
                    if ("[]".equals(tmActionRequestParameter.getValue())) {
                        //常量为[]进行特殊处理，表示空组数
                        pJson.put(tmActionRequestParameter.getName(), new ArrayList());
                    } else {
                        if (!convertAtmcSystemVariable(dataJson, pJson, conNames[1], tmActionRequestParameter.getValue())) {
                            pJson.put(conNames[1], tmActionRequestParameter.getValue());
                        }
                    }
                }
            } else if (p instanceof JSONArray) {
                JSONArray pJsonArray = (JSONArray) p;
                for (Object oJson : pJsonArray.toArray()) {
                    if (oJson instanceof JSONObject) {
                        JSONObject pJson = (JSONObject) oJson;
                        if ("{@SYSTEM_USER_ID}".equals(tmActionRequestParameter.getValue())) {
                            pJson.put(conNames[1], executeContext.getAuthoredUser().getUserId());
                        } else if ("{@SYSTEM_EMPLOYEE_ID}".equals(tmActionRequestParameter.getValue())) {
                            pJson.put(conNames[1], digiwinEocProxyService.getEocId(executeContext.getAuthoredUser().getToken(), executeContext.getAuthoredUser().getUserId()));
                        } else if ("[]".equals(tmActionRequestParameter.getValue())) {
                            //常量为[]进行特殊处理，表示空组数
                            pJson.put(tmActionRequestParameter.getName(), new ArrayList());
                        } else {
                            if (!convertAtmcSystemVariable(dataJson, pJson, conNames[1], tmActionRequestParameter.getValue())) {
                                pJson.put(conNames[1], tmActionRequestParameter.getValue());
                            }
                        }
                    }
                }
            } else if (p instanceof List) {
                List pJsonArray = (List) p;
                for (Object o : pJsonArray) {
                    if (o instanceof Map) {
                        Map pJson = (Map) o;
                        if ("[]".equals(tmActionRequestParameter.getValue())) {
                            //常量为[]进行特殊处理，表示空组数
                            pJson.put(tmActionRequestParameter.getName(), new ArrayList());
                        } else {
                            if (!convertAtmcSystemVariable(dataJson, pJson, conNames[1], tmActionRequestParameter.getValue())) {
                                pJson.put(conNames[1], tmActionRequestParameter.getValue());
                            }
                        }
                    }
                }
            } else {
                if ("{@SYSTEM_USER_ID}".equals(tmActionRequestParameter.getValue())) {
                    paraMap.put(conNames[1], executeContext.getAuthoredUser().getUserId());
                } else if ("{@SYSTEM_EMPLOYEE_ID}".equals(tmActionRequestParameter.getValue())) {
                    paraMap.put(conNames[1], digiwinEocProxyService.getEocId(executeContext.getAuthoredUser().getToken(), executeContext.getAuthoredUser().getUserId()));
                } else {
                    if (!convertAtmcSystemVariable(dataJson, paraMap, conNames[1], tmActionRequestParameter.getValue())) {
                        paraMap.put(conNames[1], null);
                    }
                }
            }
        } else {
            if ("{@SYSTEM_USER_ID}".equals(tmActionRequestParameter.getValue())) {
                paraMap.put(tmActionRequestParameter.getName(), executeContext.getAuthoredUser().getUserId());
            } else if ("{@SYSTEM_EMPLOYEE_ID}".equals(tmActionRequestParameter.getValue())) {
                paraMap.put(tmActionRequestParameter.getName(), digiwinEocProxyService.getEocId(executeContext.getAuthoredUser().getToken(), executeContext.getAuthoredUser().getUserId()));
            } else {
                if ("[]".equals(tmActionRequestParameter.getValue())) {
                    //常量为[]进行特殊处理，表示空组数
                    paraMap.put(tmActionRequestParameter.getName(), new ArrayList());
                } else {
                    if (!convertAtmcSystemVariable(dataJson, paraMap, tmActionRequestParameter.getName(), tmActionRequestParameter.getValue())) {
                        paraMap.put(tmActionRequestParameter.getName(), tmActionRequestParameter.getValue());
                    }
                }
            }
        }
    }


    private boolean convertAtmcSystemVariable(JSONObject dataJson, Map pJson, String addKeyName, String tmValue) {

        if (!StringUtils.isEmpty(tmValue) && dataJson != null && dataJson.containsKey("ATMC_GLOBAL_VARIABLE") && dataJson.get("ATMC_GLOBAL_VARIABLE") != null) {
            if (StringUtils.startsWithIgnoreCase(tmValue, "{@") && StringUtils.endsWithIgnoreCase(tmValue, "}")) {
                tmValue = tmValue.substring(2, tmValue.length() - 1);
                JSONObject atmcData = dataJson.getJSONObject("ATMC_GLOBAL_VARIABLE");
                if (atmcData.containsKey(tmValue)) {
                    pJson.put(addKeyName, atmcData.get(tmValue));
                    return true;
                }
            }
        }

        return false;
    }


}
