package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.DataSource;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.list.editcardlist.EditCardList;
import com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist.ZtbViewList;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotPageLayout;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>功能描述：组件查询信息设置服务</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: QueryInfoSetService.java
 * @Author: wangjwc
 * @Date: created at 2025/3/31 16:40
 */
@Service
public class QueryInfoSetService {
    @Autowired
    private UiBotDesignerRenderService uiBotDesignerRenderService;

    /**
     * 解析页面DSL，获取卡片列表是否自带分页参数
     */
    public void analysisLayoutDsl(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine, PcUiBotTmDataState dataState) {
        // 获取页面DSL
        UiBotPageLayout pageLayout = this.getPageLayout(dataState.getPageLayout());
        if (pageLayout == null) {
            // 页面不存在
            return;
        }
        //解析卡片列表是否自带分页参数
        PcUiBotQueryInfo queryInfo = this.analysisComponentQueryInfo(executeContext, pageLayout.getBody());
        if (queryInfo == null) {
            return;
        }
        this.analysisComponentPaging(pageDefine, queryInfo);
    }

    private UiBotPageLayout getPageLayout(List<UiBotPageLayout> pageLayout) {
        if (CollectionUtils.isEmpty(pageLayout)) {
            return null;
        }
        String pageId = AppRequestContext.getContextEntity().getPageId();
        if (StringUtils.isEmpty(pageId)) {
            // 任务卡其它数据状态/项目卡其它数据状态/数据录入其它查询方案 界面是异步请求的，入参pageId是为空，需要获取主页面
            return uiBotDesignerRenderService.getMainPageLayout(pageLayout, null);
        }
        PageSettingIdPresetEnum pageIdEnum = PageSettingIdPresetEnum.getEnumByName(pageId);
        if (pageIdEnum == null) {
            // 获取其它页面
            // 根据pageId获取设计态页面DSL
            return pageLayout
                    .stream()
                    .filter(layout -> pageId.equals(layout.getPageId()))
                    .findFirst()
                    .orElse(null);
        }
        // 获取主页面
        return uiBotDesignerRenderService.getMainPageLayout(pageLayout, null);
    }

    /**
     * 解析只读卡片列表/编辑卡片列表是否自带分页参数，只解析最外层的卡片列表组件
     */
    public PcUiBotQueryInfo analysisComponentQueryInfo(PcUiBotExecuteContext executeContext, List<BaseMobileComponentWrapper<BaseMobileComponent>> body) {
        if (CollectionUtils.isEmpty(body)) {
            return null;
        }
        // 列表组件
        List<String> listCmpt = Lists.newArrayList("DW_" + ZtbViewList.COMPONENT_TYPE, "DW_" + EditCardList.COMPONENT_TYPE);
        for (BaseMobileComponentWrapper<BaseMobileComponent> wrapper : body) {
            if (listCmpt.contains(wrapper.getComponentType())) {
                if (wrapper.getData() instanceof EditCardList) {
                    EditCardList editCardList = (EditCardList) wrapper.getData();
                    PcUiBotQueryInfo queryInfo = editCardList.getQueryInfo();
                    if (queryInfo != null) {
                        if (BooleanUtils.isTrue(this.checkMultiDataSource(executeContext, Optional.ofNullable(editCardList.getCardListData()).map(Card::getData).map(Card.DesignerRawCard::getDataSource).orElse(null)))) {
                            // 多数据源情况，此处不用处理
                            continue;
                        }
                        return queryInfo;
                    }
                } else if (wrapper.getData() instanceof ZtbViewList) {
                    ZtbViewList ztbViewList = (ZtbViewList) wrapper.getData();
                    PcUiBotQueryInfo queryInfo = ztbViewList.getQueryInfo();
                    if (queryInfo != null) {
                        if (BooleanUtils.isTrue(this.checkMultiDataSource(executeContext, Optional.ofNullable(ztbViewList.getCardListData()).map(Card::getData).map(Card.DesignerRawCard::getDataSource).orElse(null)))) {
                            // 多数据源情况，此处不用处理
                            continue;
                        }
                        return queryInfo;
                    }
                }
            }
        }
        return null;
    }

    private Boolean checkMultiDataSource(PcUiBotExecuteContext executeContext, DataSource dataSource) {
        if (dataSource == null || StringUtils.isEmpty(dataSource.getActionId())) {
            return false;
        }
        if (StringUtils.isEmpty(executeContext.getMainDataSourceName()) || StringUtils.isEmpty(dataSource.getActionName())) {
            // 主数据源不存在，不用处理
            return false;
        }
        if (Objects.equals(dataSource.getActionName(), executeContext.getMainDataSourceName())) {
            // 主数据源，不用处理
            return false;
        }
        return true;
    }


    public void analysisComponentPaging(PcUiBotPageDefine pageDefine, PcUiBotQueryInfo queryInfo) {
        PcUiBotPageInfo pageInfo = Optional.ofNullable(queryInfo).orElse(new PcUiBotQueryInfo()).getPageInfo();
        if (pageInfo != null && pageInfo.getPageSize() != null) {
            pageDefine.setUseHasNext(true);
            pageDefine.setEnablePaging(true);
            pageDefine.setEnableBackEndPaging(true);

            PcUiBotPageInfo tempPageInfo = new PcUiBotPageInfo();
            tempPageInfo.setPageNo(1);
            tempPageInfo.setPageSize(pageInfo.getPageSize());
            tempPageInfo.setPagingConfigOnList(true);
            pageDefine.setPageInfo(tempPageInfo);

            pageInfo.setPagingConfigOnList(true);
        }
    }

    public void buildLayoutDsl(PcUiBotExecuteContext executeContext, QueryResultSet queryResultSet, PcUiBotPageDefine pageDefine) {
        // 获取页面DSL
        UiBotPageLayout pageLayout = this.getPageLayout(pageDefine.getPageLayout());
        if (pageLayout == null) {
            // 页面不存在
            return;
        }
        //解析卡片列表是否自带分页参数
        PcUiBotQueryInfo queryInfo = this.analysisComponentQueryInfo(executeContext, pageLayout.getBody());
        if (queryInfo == null) {
            return;
        }
        this.processQueryInfoData(executeContext, queryResultSet, pageDefine, queryInfo);
    }

    public void processQueryInfoData(PcUiBotExecuteContext executeContext, QueryResultSet dataResult, PcUiBotPageDefine pageDefine, PcUiBotQueryInfo queryInfo) {
        if (pageDefine == null
                || pageDefine.getUseHasNext() == null
                || !pageDefine.getUseHasNext()) {
            return;
        }
        //兼容以前的代码
        if (pageDefine.getPageInfo() == null
                && (MapUtils.isEmpty(pageDefine.getParameter())
                || !pageDefine.getParameter().containsKey("page_size"))) {
            return;
        }

        if (dataResult == null
                || dataResult.getMainQueryResult() == null
                || dataResult.getMainQueryResult().getTotalResults() == null) {
            return;
        }

        //获取表格上的分页配置
        PcUiBotPageInfo pageInfo = queryInfo.getPageInfo();
        if (pageDefine.getPageInfo() != null && pageDefine.getPageInfo().isPagingConfigOnList() && pageInfo == null) {
            return;
        }

        double totalResults = Math.round(dataResult.getMainQueryResult().getTotalResults());
        pageInfo.setTotalResults((int) Math.floor(totalResults));
        if (dataResult.getMainQueryResult().isHasNext() && pageInfo.getTotalResults() > 0) {
            pageInfo.setHasNext(true);
        } else {
            pageInfo.setHasNext(false);
        }
        pageInfo.setPageCountSize(0);
        if (!CollectionUtils.isEmpty(dataResult.getMainQueryResult().getData())) {
            pageInfo.setPageCountSize(dataResult.getMainQueryResult().getData().size());
        }
    }
}
