package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.proxy.iam.service.DigiwinIamProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotApiMetadataConstants;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotMetadataField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotTagDefinition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotTagConstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;


/**
 * 处理根据购买应用情况显示字段
 * 当配了APPLICATION时，并且配置的应用CODE与当前租户拥有的应用CODE一致才显示，否则不显示；
 * 若没配APPLICATION时，默认与tag一致显示；
 */
@Service
public class ShowApplicationFieldsService {

    @Autowired
    private DigiwinIamProxyService digiwinIamProxyService;

    /**
     * 根据购买的应用过滤显示字段
     * 当配了APPLICATION时，并且配置的应用CODE与当前租户拥有的应用CODE一致才显示，否则不显示；
     * 若没配APPLICATION时，默认与tag一致显示；
     *
     * @param showFields
     */
    public List<PcUiBotMetadataField> applicationFilterShowField(PcUiBotMetadataField showFields) {
        return applicationFilterShowField(showFields, null);
    }

    /**
     * xuxx 根据购买的应用过滤显示字段
     * 当配了APPLICATION时，并且配置的应用CODE与当前租户拥有的应用CODE一致才显示，否则不显示；
     * 若没配APPLICATION时，默认与tag一致显示；
     *
     * @param showFields
     */
    private List<PcUiBotMetadataField> applicationFilterShowField(PcUiBotMetadataField showFields, List<String> appCodes) {
        if (appCodes == null) {
            //获取当前租户所购买的应用列表
            appCodes = digiwinIamProxyService.queryUserAppCodes(AppRequestContext.getContextEntity().getIamUserToken());
        }
        //用于存放整理后的显示字段
        List<PcUiBotMetadataField> newShowFields = new ArrayList<>();
        //遍历所有字段
        if (showFields.getSubFields() == null) {
            return newShowFields;
        }
        for (PcUiBotMetadataField responseField : showFields.getSubFields()) {
            //直接处理第二层，默认第一层是root
            List<PcUiBotMetadataField> needShowSubFields = getShowApplicationFields(responseField, appCodes);
            if (needShowSubFields.size() > 0) {
                newShowFields.addAll(needShowSubFields);
            }
        }

        return newShowFields;
    }

    /**
     * xuxx 根据购买的应用过滤显示字段---递归过滤字段
     * 当配了APPLICATION时，并且配置的应用CODE与当前租户拥有的应用CODE一致才显示，否则不显示；
     * 若没配APPLICATION时，默认全部显示；
     *
     * @param metadataField 字段列表
     * @param appCodes      已购买的应用列表
     * @return
     */
    private List<PcUiBotMetadataField> getShowApplicationFields(PcUiBotMetadataField metadataField, List<String> appCodes) {
        List<PcUiBotMetadataField> newShowFields = new ArrayList<PcUiBotMetadataField>();
        if (metadataField != null) {
            if (PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(metadataField.getDataType())) {
                applicationFilterShowField(metadataField, appCodes);

            } else {
                Set<String> tagCategory = new HashSet<>();
                if (metadataField.getTagDefinitions() != null) {
                    for (PcUiBotTagDefinition tag : metadataField.getTagDefinitions()) {
                        //当配了APPLICATION时，并且配置的应用CODE与当前租户拥有的应用CODE一致才显示，否则不显示
                        if (PcUiBotTagConstant.CATEGORY_APPLICATION.equals(tag.getCategory())) {
                            tagCategory.add(tag.getCategory());
                            if (appCodes.contains(tag.getCode())) {
                                newShowFields.add(metadataField);
                            }
                        }
                    }
                }
                //当没有配APPLICATION时，则全部显示；
                if (tagCategory.size() == 0) {
                    newShowFields.add(metadataField);
                }
            }
            //需要将OBJECT对象回填
            if (PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(metadataField.getDataType())
                    && newShowFields.size() == 0) {
                newShowFields.add(metadataField);
            }
        }

        return newShowFields;
    }
}
