package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotTagDefinition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotScriptUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotWordsConstants;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>功能描述：处理显示字段---共通部分</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ShowFieldService.java
 * @Author: wangjwc
 * @Date: created at 2023/11/14 10:32
 */
@Service
public class ShowFieldService {

//    @Autowired
//    private ESPService espService;

//    @Autowired
//    private ThemeMapService themeMapService;

    @Autowired
    protected TagDisplayRangeService tagDisplayRangeService;

//    @Autowired
//    protected AtmcService atmcService;

    @Autowired
    TagMergeService tagMergeService;

//    @Autowired
//    TableDataAttachmentInterpreter tableDataAttachmentInterpreter;

//    @Autowired
//    private UserService userService;

//    @Autowired
//    private ViewService viewService;

//    @Autowired
//    private WordCapabilityMapper wordCapabilityMapper;

    protected static final Map<String, String> TAG_CATEGORY_LIST = new HashMap();

    static {
        TAG_CATEGORY_LIST.put("POSITION", "提取字段标签");
    }

    /**
     * 根据元数据拼装显示字段
     *
     * @param fullName
     * @param rootField
     * @param needShowFields
     */
    public void addShowFieldByFullName(String fullName, PcUiBotMetadataField rootField, Map<String, PcUiBotMetadataField> needShowFields) {

        if (!fullName.contains(".")) {
            String newFullName = rootField.getName() + "." + fullName;
            if (rootField.getFieldMap() != null
                    && rootField.getFieldMap().containsKey(fullName)
                    && !needShowFields.containsKey(newFullName)) {
                //特别处理一些特殊类型的字段:true显示，false不显示
                boolean isShow = false;
                if (rootField.getFieldMap().get(fullName).getTagDefinitions() != null) {
                    isShow = true;
                    for (PcUiBotTagDefinition tag : rootField.getFieldMap().get(fullName).getTagDefinitions()) {
                        if (TAG_CATEGORY_LIST.containsKey(tag.getCategory())) {
                            isShow = false;
                            break;
                        }
                    }

                }
                if (rootField.getFieldMap().get(fullName).getDataType().equals(PcUiBotApiMetadataConstants.METADATA_OBJECT)) {
                    PcUiBotTagDefinition tagDefinitionDTO = tagMergeService.mergeTagAttributes(rootField.getFieldMap().get(fullName));
                    if (tagDefinitionDTO != null && "customizeComponentInterpreter".equals(tagDefinitionDTO.getInterpreterServiceName())) {
                        isShow = false;
                    } else {
                        isShow = true;
                    }

                }
                if (isShow) {
                    needShowFields.put(newFullName, rootField.getFieldMap().get(fullName));
                }
            }
        } else {
            String[] paths = fullName.split("\\.");
            PcUiBotMetadataField existedField = rootField.findByPath(paths);
            if (existedField != null) {
                //特别处理一些特殊类型的字段
                boolean isShow = true;
                if (existedField.getTagDefinitions() != null) {
                    for (PcUiBotTagDefinition tag : existedField.getTagDefinitions()) {
                        if (TAG_CATEGORY_LIST.containsKey(tag.getCategory())) {
                            isShow = false;
                            break;
                        }
                    }
                } else {
                    if (existedField.getDataType().equals(PcUiBotApiMetadataConstants.METADATA_OBJECT)) {
                        PcUiBotTagDefinition tagDefinitionDTO = tagMergeService.mergeTagAttributes(existedField);
                        if (tagDefinitionDTO != null && "customizeComponentInterpreter".equals(tagDefinitionDTO.getInterpreterServiceName())) {
                            isShow = false;
                        } else {
                            isShow = true;
                        }
                    } else {
                        isShow = false;
                    }
                }
                if (paths.length == 2) {
                    if (!needShowFields.containsKey(existedField.getFullName())) {
                        if (existedField.getTagDefinitions() != null && isShow) {
                            needShowFields.put(existedField.getFullName(), existedField);
                        }
                    }
                } else {
                    //根据路径去集合中寻找，找到则添加，找不到则创建
                    List<PcUiBotMetadataField> fieldList = new ArrayList<>();
                    fieldList.add(existedField);
                    PcUiBotMetadataField parentField = existedField.getParentField();
                    while (parentField != null && !parentField.equals(rootField)) {
                        fieldList.add(parentField);
                        parentField = parentField.getParentField();
                    }
                    PcUiBotMetadataField metadataField = fieldList.get(fieldList.size() - 1);
                    if (!needShowFields.containsKey(metadataField.getFullName())) {
                        if (metadataField.getTagDefinitions() != null && isShow) {
                            needShowFields.put(metadataField.getFullName(), metadataField.clone(null, new ArrayList<>()));
                        }
                    }
                    PcUiBotMetadataField parent = needShowFields.get(metadataField.getFullName());

                    for (int i = fieldList.size() - 2; i >= 0; i--) {
                        PcUiBotMetadataField subField = parent.getField(fieldList.get(i).getName());
                        if (subField == null) {
                            subField = fieldList.get(i).clone(parent, i == 0 ? null : new ArrayList<>());
                            parent.addField(subField);
                        }
                        parent = subField;
                    }
                }
            }
        }
    }

    /**
     * xuxx 重新整理object字段
     *
     * @param needShowFields
     * @param rootField
     * @return
     */
    public List<PcUiBotMetadataField> refreshObjectField(PcUiBotExecuteContext executeContext, Map<String, PcUiBotMetadataField> needShowFields,
                                                         PcUiBotMetadataField rootField,
                                                         QueryResultSet queryResultSet, PcUiBotPageDefine pageDefine) {
        //处理OBJECT对象
        Map<String, PcUiBotMetadataField> needShowFields_obj = new LinkedHashMap<>();

        List<PcUiBotMetadataField> tagMetadata = new ArrayList<>();
        tagMetadata.addAll(needShowFields.values());
        for (PcUiBotMetadataField subField : rootField.getSubFields()) {
            if (PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(subField.getDataType())
                    && !needShowFields.containsKey(rootField.getName() + "." + subField.getName())) {
                needShowFields_obj.put(rootField.getName() + "." + subField.getName(), subField);
                List<PcUiBotMetadataField> tagMetadata_obj = tagDisplayRangeService.getShowTagFields(executeContext, subField, queryResultSet, pageDefine);
                if (!CollectionUtils.isEmpty(tagMetadata_obj)) {
                    tagMetadata.addAll(tagMetadata_obj);
                }
            }
        }
        //List<MetadataField> tagMetadata_obj =  tagDisplayRangeService.showFields(new ArrayList(needShowFields_obj.values()));
        return tagMetadata;
    }

    /**
     * xuxx 根据pattern字段,获取词库字段
     *
     * @param getWords
     * @param keyword
     * @return
     */
//    public List<String> getWordList(Map getWords, String keyword) {
//        List<String> wordList = new ArrayList<String>();
//        if (getWords != null && getWords.containsKey(keyword)) {
//
//            List showWords = JSONArray.fromObject(getWords.get(keyword));
//            if (CollectionUtils.isNotEmpty(showWords)) {
//                showWords.forEach(word -> {
//                    if (word != null) {
//                        JSONObject word_json = JSONObject.fromObject(word);
//                        if (word_json.get("word") != null) {
//                            wordList.add(word_json.getString("word"));
//                        }
//                    }
//                });
//            }
//        }
//        return wordList;
//    }

    /**
     * 获取隐藏的词
     *
     * @param ruleList
     * @return
     */
//    public Set<String> getHiddenWords(ExecuteContext executeContext,
//                                      List<Map<String, Object>> ruleList) {
//        // 获取可用的词隐藏规则
//        List<RuleDTO.Rule> availableWordHiddenRules = this.getAvailableWordHiddenRule(ruleList);
//        // 解析词隐藏规则，判断词是否需要隐藏
//        Map<String, Boolean> wordHiddenMap = this.getWordHiddenMap(executeContext,
//                availableWordHiddenRules, null, null);
//        return this.getHiddenWords(wordHiddenMap);
//    }

    /**
     * 获取主业务数据
     *
     * @param queryResultSet
     * @return
     */
    private QueryResult getMainQueryResult(QueryResultSet queryResultSet) {
        if (null == queryResultSet
                || null == queryResultSet.getMainQueryResult()
                || CollectionUtils.isEmpty(queryResultSet.getMainQueryResult().getData())) {
            return null;
        }
        return queryResultSet.getMainQueryResult();
    }

    /**
     * 获取隐藏字段集合
     *
     * @param executeContext 上下文
     * @param apiMetadata    元数据
     * @param queryResultSet 数据源
     * @param pageDefine     页面定义
     * @return 隐藏字段集合
     */
    public List<String> getWordsByAbility(PcUiBotExecuteContext executeContext,
                                          List<Object> apiMetadata,
                                          QueryResultSet queryResultSet,
                                          PcUiBotPageDefine pageDefine) {
        // 解析无头能力
        List<String> enabledAcCodes = new ArrayList<>();
        List<String> disabledAcCodes = new ArrayList<>();
        QueryResult mainQueryResult = getMainQueryResult(queryResultSet);
        this.parseWordCapabilityAcCodes(enabledAcCodes, disabledAcCodes, mainQueryResult, pageDefine);
        PcUiBotWordQuery wordQuery = new PcUiBotWordQuery();
        wordQuery.setEnabledAcCodes(enabledAcCodes);
        wordQuery.setDisabledAcCodes(disabledAcCodes);
        // 保留原有逻辑
        Map<String, Set<String>> wordAbilityStateMap = new HashMap<>();//this.wordsByAbility(executeContext, apiMetadata, pageDefine, wordQuery);
        // 处理无头能力
        // 所有字段名
        List<String> fieldNameList = wordQuery.getFields();
        // 无头能力中【启用状态的能力】对应的字段名，用于rule中条件替换
        List<String> enableFieldNameList = new ArrayList<>();//this.enableFieldNameList(fieldNameList, enabledAcCodes);
        // 规则处理
        Map<String, Boolean> wordHiddenMap = this.parseWordHiddenRule(executeContext, pageDefine.getRules(),
                enableFieldNameList, mainQueryResult);
        // 隐藏字段合并（新旧逻辑）处理
        List<String> hiddenWords = this.mergeHiddenWords(wordAbilityStateMap, wordHiddenMap);
        this.setHiddenEffective(pageDefine.getRules(), hiddenWords);
        return hiddenWords;
    }

    /**
     * 设置隐藏规则是否生效
     *
     * @param rules
     * @param hiddenWords
     */
    private void setHiddenEffective(List<Map<String, Object>> rules, List<String> hiddenWords) {
        for (Map<String, Object> rule : rules) {
            String schema = String.valueOf(rule.get(PcUiBotConstants.RuleConfigKey.SCHEMA));
            String key = String.valueOf(rule.get(PcUiBotConstants.RuleConfigKey.KEY));
            // hidden规则且schema字段被隐藏
            if (PcUiBotConstants.RuleKeyType.HIDDEN.equals(key) && hiddenWords.contains(schema)) {
                rule.put(PcUiBotConstants.RuleConfigKey.EFFECTIVE, Boolean.TRUE);
            }
        }
    }

    /**
     * 筛选出配置了启用状态的能力的字段
     *
     * @param fieldNameList  所有字段名
     * @param enabledAcCodes 启用状态的能力
     * @return 没有无头能力，返回null
     */
//    public List<String> enableFieldNameList(List<String> fieldNameList, List<String> enabledAcCodes) {
//        if (CollectionUtils.isEmpty(enabledAcCodes)) {
//            return null;
//        }
//        List<String> enableFieldNameList = Lists.newArrayList();
//        List<WordCapability> words = wordCapabilityMapper.selectWordsBysc(fieldNameList);
//        for (WordCapability word : words) {
//            if (enabledAcCodes.contains(word.getScCode())) {
//                enableFieldNameList.add(word.getWordCode());
//            }
//        }
//        return enableFieldNameList;
//    }

    /**
     * 移除字段
     *
     * @param needShowFieldMap 需要显示的字段
     * @param executeContext   执行上下文
     * @param apiMetadata      字段名集合
     * @param queryResultSet   数据源
     * @param pageDefine       页面定义
     */
//    @Preview(PreviewAspect.VOID)
//    public void removeIfNecessary(Map<String, MetadataField> needShowFieldMap,
//                                  ExecuteContext executeContext,
//                                  List<Object> apiMetadata,
//                                  QueryResultSet queryResultSet,
//                                  PageDefine pageDefine) {
//        if (CollectionUtils.isEmpty(needShowFieldMap)) {
//            return;
//        }
//        List<String> notShowWords = this.getWordsByAbility(executeContext, apiMetadata, queryResultSet, pageDefine);
//        if (CollUtil.isEmpty(notShowWords)) {
//            return;
//        }
//        needShowFieldMap.entrySet().removeIf(entry -> {
//            String fieldName = entry.getKey();
//            fieldName = UiBotUtils.subAfter(fieldName, StrPool.DOT);
//            return notShowWords.contains(fieldName);
//        });
//    }

    /**
     * 移除词库字段隐藏规则；
     * 任务单号：61700
     *
     * @param ruleList 所有规则
     */
    public void removeWordHiddenRule(List<UiBotRule> ruleList) {
        ruleList = Optional.ofNullable(ruleList)
                .orElse(Lists.newArrayList());
        // 收集隐藏字段，包括关联的字段
        Set<String> hiddenWordAllSet = Sets.newHashSet();
        Set<String> hiddenWordOnlySet = Sets.newHashSet();
        ruleList.forEach(ruleMap -> {
            String ruleKey = ruleMap.getKey();
            String schema = ruleMap.getSchema();
            String targetSchema = ruleMap.getTargetSchema();
            String[] linkageSchemas = ruleMap.getLinkageSchemas();
            Boolean effective = ruleMap.getEffective();
            boolean isHidden = PcUiBotConstants.RuleKeyType.HIDDEN.equals(ruleKey);
            if (isHidden) {
                if (BooleanUtils.isTrue(effective)) {
                    hiddenWordAllSet.add(schema);
                    hiddenWordAllSet.add(targetSchema);
                    CollUtil.addAll(hiddenWordAllSet, linkageSchemas);
                } else {
                    hiddenWordOnlySet.add(schema);
                }
            }
        });
        // targetSchema可能为null，导致rowDefaultValue规则可能被误删（因为rowDefaultValue的schema是null）
        CollUtil.removeNull(hiddenWordAllSet);
        // 移除字段关联的所有规则;如果是false，则只移除schema的hidden规则;如果是true，则移除schema、targetSchema、linkageSchemas的所有规则;
        ruleList.removeIf(ruleMap -> {
            String ruleKey = ruleMap.getKey();
            String schema = ruleMap.getSchema();
            return hiddenWordAllSet.contains(schema)
                    || (PcUiBotConstants.RuleKeyType.HIDDEN.equals(ruleKey) && hiddenWordOnlySet.contains(schema));
        });
    }

    /**
     * 低代码平台wordHidden规则处理
     *
     * @param componentList
     * @param ruleList
     */
//    public void wordHiddenForDsl(ExecuteContext executeContext,
//                                 List<AbstractComponent> componentList,
//                                 List<Map<String, Object>> ruleList) {
//        if (CollectionUtils.isEmpty(ruleList)) {
//            return;
//        }
//        componentList.forEach(component -> {
//            if (component instanceof AbstractDslComponent) {
//                AbstractDslComponent dslComponent = (AbstractDslComponent) component;
//                List<String> hideFields = dslComponent.getHideFields();
//                Set<String> hiddenWords = this.getHiddenWords(executeContext, ruleList);
//                Set<String> allHiddenWords = CollUtil.unionDistinct(hideFields, hiddenWords);
//                if (CollectionUtils.isNotEmpty(allHiddenWords)) {
//                    dslComponent.setHideFields(Lists.newArrayList(allHiddenWords));
//                }
//            }
//        });
//    }

//    private Boolean isTaskInfoExists(ExecuteContext executeContext) {
//        if (executeContext != null
//                && executeContext.getTaskWithBacklogData() != null
//                && executeContext.getTaskWithBacklogData().getBacklog() != null
//                && executeContext.getTaskWithBacklogData().getBacklog().size() > 0) {
//            return true;
//        }
//        return false;
//    }

    /**
     * 解析wordHidden规则
     *
     * @param ruleList 所有规则
     * @return key:词(拥有隐藏规则的词)，value:是否隐藏
     */
    private Map<String, Boolean> parseWordHiddenRule(PcUiBotExecuteContext executeContext,
                                                     List<Map<String, Object>> ruleList,
                                                     List<String> enableFieldNameList,
                                                     QueryResult mainQueryResult) {
        // 获取可用的词隐藏规则
        List<PcUiBotRuleDTO.Rule> availableWordHiddenRules = this.getAvailableWordHiddenRule(ruleList);
        // 解析词隐藏规则，判断词是否需要隐藏
        return this.getWordHiddenMap(executeContext, availableWordHiddenRules, enableFieldNameList, mainQueryResult);
    }

    /**
     * 解析词隐藏规则，判断词是否需要隐藏
     *
     * @param wordHiddenRuleList
     * @param enableFieldNameList 无头能力中【启用能力】对应的【字段名】；null表示没有无头能力配置；
     * @param mainQueryResult     业务数据
     * @return key:词(拥有隐藏规则的词)，value:是否隐藏
     */
    private Map<String, Boolean> getWordHiddenMap(PcUiBotExecuteContext executeContext,
                                                  List<PcUiBotRuleDTO.Rule> wordHiddenRuleList,
                                                  List<String> enableFieldNameList,
                                                  QueryResult mainQueryResult) {
        Map<String, Boolean> wordHiddenMap = new HashMap<>();
        if (CollectionUtils.isEmpty(wordHiddenRuleList)) {
            return wordHiddenMap;
        }
        String tenantId = executeContext.getTenantId();//this.getSuitableTenantId(executeContext.getFirstBacklog());
        // 有cache
        List<String> productNameList = new ArrayList<>();//espService.getTenantProductListGet(tenantId);
        Map<String, Object> conditionParams = buildConditionParams(tenantId, productNameList, mainQueryResult);
        for (PcUiBotRuleDTO.Rule rule : wordHiddenRuleList) {
            String schema = rule.getSchema();
            String condition = rule.getTrigger().getCondition();
            // 无头能力处理；如果condition中包含了
            condition = this.dealForHeadlessAbility(schema, condition, enableFieldNameList);
            boolean conditionResult = this.conditionHandle(condition, conditionParams);
            wordHiddenMap.put(schema, conditionResult);
            List<String> linkageSchemas = rule.getLinkageSchemas();
            // 可能为空
            linkageSchemas = Optional.ofNullable(linkageSchemas).orElse(Lists.newArrayList());
            for (String linkageSchema : linkageSchemas) {
                wordHiddenMap.put(linkageSchema, conditionResult);
            }
        }
        return wordHiddenMap;
    }

    /**
     * 获取合适的租户id
     *
     * @param backlogData
     * @return
     */
//    private String getSuitableTenantId(DigiwinAtmcBacklogData backlogData) {
//        if (backlogData == null) {
//            return CommonUtil.getCurrentUser().getTenantId();
//        }
//        String tenantId = StringUtils.EMPTY;
//        // 执行者id
//        String performerId = backlogData.getPerformerId();
//        // 执行者所在租户id（可能为空）
//        String targetTenantId = backlogData.getTargetTenantId();
//        // 登录用户
//        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
//        // 代理用户
//        AuthoredUser proxyAuthoredUser = AppAuthContextHolder.getContext().getProxyAuthoredUser();
//        String loginUserId = authoredUser == null ? StringUtils.EMPTY : authoredUser.getUserId();
//        String loginUserTenantId = authoredUser == null ? StringUtils.EMPTY : authoredUser.getTenantId();
//        String loginUserProxyTenantId = proxyAuthoredUser == null ? StringUtils.EMPTY : proxyAuthoredUser.getTenantId();
//        // 登录用户不为执行者or没有代理用户，为执行者租户id；否则，为代理用户租户id
//        if (!loginUserId.equals(performerId) || StringUtils.isEmpty(loginUserProxyTenantId)) {
//            tenantId = targetTenantId;
//        }
//        // 优先取代理租户id
//        if (StringUtils.isEmpty(tenantId)) {
//            tenantId = loginUserProxyTenantId;
//        }
//        // 默认为登录用户的租户id
//        if (StringUtils.isEmpty(tenantId)) {
//            tenantId = loginUserTenantId;
//        }
//        return tenantId;
//    }

    /**
     * 构建条件入参
     *
     * @param tenantId
     * @param productNameList
     * @param mainQueryResult
     * @return
     */
    private Map<String, Object> buildConditionParams(String tenantId,
                                                     List<String> productNameList,
                                                     QueryResult mainQueryResult) {
        Map<String, Object> params = new HashMap<>();
        params.put("T", tenantId);
        params.put("P_A", "[" + String.join(",", productNameList) + "]");
        if (!CollectionUtils.isEmpty(productNameList)) {
            params.put("P", productNameList.get(0));
            params.put("P_E", productNameList.get(productNameList.size() - 1));
        }
        if (mainQueryResult != null) {
            params.put(mainQueryResult.getDataSourceName(), mainQueryResult.getData());
        }
        return params;
    }

    /**
     * 无头能力规则条件特殊处理
     *
     * @param fieldName           字段名，不含点
     * @param condition           原有条件
     * @param enableFieldNameList 无头能力中【启用能力】对应的【字段名】
     * @return 新条件
     */
    private String dealForHeadlessAbility(String fieldName,
                                          String condition,
                                          List<String> enableFieldNameList) {
        // 如果条件中包含关键字HEADLESS_ABILITY，则判断是否被enableFieldNameList包含，若没有，则隐藏（true）
        if (PcUiBotWordsConstants.HEADLESS_ABILITY.contains(condition)) {
            // 默认false，不隐藏
            String headlessCondition = Boolean.FALSE.toString();
            // 含有无头能力，且无头启用能力不包含该字段时，隐藏
            if (enableFieldNameList != null && !enableFieldNameList.contains(fieldName)) {
                headlessCondition = Boolean.TRUE.toString();
            }
            return StrUtil.replace(condition, PcUiBotWordsConstants.HEADLESS_ABILITY, headlessCondition);
        }
        return condition;
    }

    /**
     * 获取可用规则
     *
     * @param rules
     * @return
     */
    private List<PcUiBotRuleDTO.Rule> getAvailableWordHiddenRule(List<Map<String, Object>> rules) {
        List<PcUiBotRuleDTO.Rule> ruleList = JsonUtil.objectToJavaObject(rules, new TypeReference<List<PcUiBotRuleDTO.Rule>>() {
        });
        // 获取词隐藏规则：key+触发机制+condition不能为空
        return ruleList.stream()
                .filter(ele -> Objects.nonNull(ele.getTrigger()))
                .filter(ele -> PcUiBotConstants.RuleKeyType.HIDDEN.equals(ele.getKey()))
                .filter(ele -> PcUiBotConstants.TriggerPoint.DEFAULT.equals(ele.getTrigger().getPoint()))
                .filter(ele -> StringUtils.isNotEmpty(ele.getTrigger().getCondition()))
                .collect(Collectors.toList());
    }

    /**
     * 获取隐藏的词
     *
     * @param wordHiddenMap
     * @return
     */
    private Set<String> getHiddenWords(Map<String, Boolean> wordHiddenMap) {
        Set<String> hiddenWords = Sets.newHashSet();
        wordHiddenMap.forEach((k, v) -> {
            if (BooleanUtils.isTrue(v)) {
                hiddenWords.add(k);
            }
        });
        return hiddenWords;
    }

    /**
     * 隐藏字段合并处理；取并集后去重
     *
     * @param wordAbilityStateMap
     * @param wordHiddenMap
     * @return
     */
    private List<String> mergeHiddenWords(Map<String, Set<String>> wordAbilityStateMap,
                                          Map<String, Boolean> wordHiddenMap) {
        Set<String> excludeWords = wordAbilityStateMap.get("excludes");
        Set<String> hiddenWords = this.getHiddenWords(wordHiddenMap);
        return Lists.newArrayList(CollUtil.unionDistinct(excludeWords, hiddenWords));
    }

    /**
     * 执行condition脚本
     *
     * @param condition 条件表达式
     * @param params    租户id
     * @return true：隐藏，false：不隐藏（默认）
     */
    private boolean conditionHandle(String condition, Map<String, Object> params) {
        final Boolean[] result = {false};
        PcUiBotScriptUtil.evalJs(condition, params, (engine, executeResult) -> {
            if (executeResult instanceof Boolean) {
                result[0] = (Boolean) executeResult;
            }
        });
        return result[0] != null && result[0];
    }

//    private Map<String, Set<String>> wordsByAbility(PcUiBotExecuteContext executeContext, List<Object> apiMetadata,
//                                                    PcUiBotPageDefine pageDefine,
//                                                    PcUiBotWordQuery wordQuery) {
//        AuthoredUser authoredUser = CommonUtil.getCurrentUser();
//        //元数据
//        Object fields = apiMetadata.listIterator().next();
//        List<String> fieldList = new ArrayList<>();
//        if (fields != null) {
//            JSONArray jsonArrOptions = JSONArray.fromObject(fields);
//            if (CollectionUtils.isNotEmpty(jsonArrOptions)) {
//                List<String> finalFieldList = new ArrayList<>();
//                jsonArrOptions.forEach(a -> finalFieldList.add(a.toString()));
//                if (CollectionUtils.isNotEmpty(finalFieldList)) {
//                    fieldList = finalFieldList;
//                }
//            }
//        }
//        /**
//         * 词库需要对单身字段也进行显隐控制
//         */
//        if (!CollectionUtils.isEmpty(pageDefine.getShowMetadatas())
//                && !CollectionUtils.isEmpty(pageDefine.getShowDataProperties())) {
//            fieldList = pageDefine.getShowDataProperties();
//        }
//        //解析获取任务tag上的领域信息
//        List<String> categories = null;
//        if (!CollectionUtils.isEmpty(executeContext.getDomain())) {
//            categories = executeContext.getDomain();
//        }
//        String apiName = "";
//        List<String> products = espService.getTenantProductListGet(authoredUser.getTenantId(), apiName);
//        wordQuery.setProduct(products);
//        wordQuery.setCategories(categories);
//        wordQuery.setFields(fieldList);
//        return viewService.wordsByAbility(wordQuery);
//    }

    /**
     * xuxx 获取分词词库中的字段(保留，暂时不能放开，待词库完善后启用方可放开)
     * * fields 查询词的范围
     * <p>
     * * observers观察对象
     * * task 任务
     * * duty 职能
     * * app 应用
     * * categories 领域
     * <p>
     * * pattern模式
     */
//    public Map getViewWords(ExecuteContext executeContext, List<Object> apiMetadata) {
//
//        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
//        String user = authoredUser.getUserId();
//        String token = authoredUser.getToken();
//        //代理人、辅助执行人，被分享人，需要根据；要获取真正的当前者账号，显示字段；
//        if (!executeContext.isShared()) {
//            if (isTaskInfoExists(executeContext)) {
//                String performerId = executeContext.getTaskWithBacklogData().getBacklog().get(0).getPerformerId();
//                Long backlogId = executeContext.getTaskWithBacklogData().getBacklog().get(0).getBacklogId();
//                if (!user.equals(performerId)) {
//                   /* if(ActivityConstants.TASK_DETAIL.equals(executeContext.getPageCode())) {
//                        Map taskDetail = atmcService.getTaskDetail(backlogId, executeContext);
//                        if (taskDetail != null
//                                && taskDetail.get("isOwner") != null && (Boolean) taskDetail.get("isOwner") == false) {
//                            user = taskDetail.get("performerId").toString();
//                        }
//                    }else{*/
//                    user = executeContext.getTaskWithBacklogData().getBacklog().get(0).getPerformerId();
//                    //}
//                }
//            }
//        } else {
//            if (isTaskInfoExists(executeContext)) {
//                user = executeContext.getTaskWithBacklogData().getBacklog().get(0).getPerformerId();
//            }
//        }
//        if (StringUtils.isEmpty(user)) {
//            user = authoredUser.getUserId();
//        }
//        //元数据
//        Object fields = apiMetadata.listIterator().next();
//        //获取当前用户所有的职能
//        List<Object> duties = userService.getEmpDuties(user, token);
//        List<Object> duty = new ArrayList<Object>();
//        if (duties != null) {
//            duties.forEach(dt -> {
//                if (dt != null) {
//                    JSONObject duty_json = JSONObject.fromObject(dt);
//                    if (duty_json.get("id") != null) {
//                        duty.add(duty_json.getString("id"));
//                    }
//                }
//            });
//        }
//        //解析获取任务tag上的领域信息
//        List<String> categories = new ArrayList<>();
//        if (CollectionUtils.isNotEmpty(executeContext.getDomain())) {
//            categories = executeContext.getDomain();
//        }
//        List<Object> task = new ArrayList<>();
//        task.add(executeContext.getTmActivityId());
//        List<String> app = userService.queryUserApps();
//        String apiName = "";
//        /*if(executeContext.getDataSourceSet() != null &&executeContext.getDataSourceSet().getFirstAction() != null
//                &&  executeContext.getDataSourceSet().getFirstAction().getServiceId() != null){
//            apiName  =executeContext.getDataSourceSet().getFirstAction().getServiceId().getName();
//        }*/
//        List<String> products = espService.getTenantProductListGet(authoredUser.getTenantId(), apiName);
//        Map<String, List> observers = new HashMap<>();
//        observers.put("task", task);
//        observers.put("duty", duty);
//        observers.put("app", app);
//        //post body
//        Map<String, Object> param = new HashMap<>();
//        param.put("fields", fields);
//        param.put("observers", JSONObject.fromObject(observers));
//        //param.put("pattern",executeContext.getCategory());
//        param.put("categories ", categories);
//        param.put("product", products);
//
//        return themeMapService.getViewWords(param);
//    }

    /**
     * 解析词库 能力code
     *
     * @param enabledAcCodes
     * @param disabledAcCodes
     * @param mainQueryResult
     * @param pageDefine
     * @return
     */
    private void parseWordCapabilityAcCodes(List<String> enabledAcCodes,
                                            List<String> disabledAcCodes,
                                            QueryResult mainQueryResult,
                                            PcUiBotPageDefine pageDefine) {
        if (mainQueryResult == null) {
            return;
        }
        parseWordCapabilityAcCodes(enabledAcCodes, disabledAcCodes,
                mainQueryResult.getDataSourceName(),
                mainQueryResult.getData(),
                pageDefine.getWordCapability());
    }

    /**
     * 解析词库 能力code
     *
     * @param dataSourceName
     * @param pageDataList
     * @param wordCapabilities
     * @return
     */
    protected void parseWordCapabilityAcCodes(List<String> enabledAcCodes, List<String> disabledAcCodes,
                                              String dataSourceName, List<Map<String, Object>> pageDataList,
                                              List<PcUiBotTmWordCapability> wordCapabilities) {
        if (CollectionUtils.isEmpty(wordCapabilities) || CollectionUtils.isEmpty(pageDataList)) {
            return;
        }
        for (PcUiBotTmWordCapability wordCapability : wordCapabilities) {
            parseWordCapabilityAcCodes(enabledAcCodes, disabledAcCodes, dataSourceName, pageDataList, wordCapability);
        }
    }

    /**
     * 解析词库 能力code
     *
     * @param dataSourceName
     * @param pageDataList
     * @param wordCapability
     * @return
     */
    protected void parseWordCapabilityAcCodes(List<String> enabledAcCodes, List<String> disabledAcCodes,
                                              String dataSourceName, List<Map<String, Object>> pageDataList,
                                              PcUiBotTmWordCapability wordCapability) {
        if (StringUtils.isBlank(wordCapability.getCondition())
                || (CollectionUtils.isEmpty(wordCapability.getEnabledAcCodes()) && CollectionUtils.isEmpty(wordCapability.getDisabledAcCodes()))) {
            return;
        }
        // 执行workCapability.condition js脚本
        Map<String, Object> params = new HashMap<>();
        params.put(dataSourceName, pageDataList);
        // 执行js脚本，超时时长为200毫秒
        PcUiBotScriptUtil.evalJs(wordCapability.getCondition(), params, (engine, executeResult) -> {
            if (null != executeResult && executeResult instanceof Boolean && (Boolean) executeResult) {
                if (!CollectionUtils.isEmpty(wordCapability.getEnabledAcCodes())) {
                    enabledAcCodes.addAll(wordCapability.getEnabledAcCodes());
                }
                if (!CollectionUtils.isEmpty(wordCapability.getDisabledAcCodes())) {
                    disabledAcCodes.addAll(wordCapability.getDisabledAcCodes());
                }
            }
        });
    }

//    public Boolean arrangeShowFieldsByGetWords(String key, Boolean openWordsLibrary, Map getWords, List<String> notShowWords, Map<String, MetadataField> needShowFields, MetadataField rootField) {
//        if (openWordsLibrary && getWords != null && getWords.containsKey(key)) {
//            Map<String, MetadataField> fieldMap = rootField.getFieldMap();
//            List<String> wordList = getWordList(getWords, key);
//            if (CollectionUtils.isNotEmpty(wordList)) {
//                for (String fieldName : wordList) {
//                    if (!notShowWords.contains(fieldName)) {
//                        if (!needShowFields.containsKey(fieldName)) {
//                            needShowFields.put(rootField.getName() + "." + fieldName, fieldMap.get(fieldName));
//                        }
//                    }
//                }
//                return true;
//            }
//        }
//        return false;
//    }

}
