package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotMetadataTagResult;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotTagDefinition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotTaggingData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotDefaultTagUtils;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotTagConstant;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotTagUtil;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * <p>功能描述：打标签服务</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: SignTagService.java
 * @Author: wangjwc
 * @Date: created at 2023/10/27 14:55
 */
@Service
public class SignTagService {


//    @Autowired
//    TagService tagService;

    private static final String REQUEST = "request";

    private static final String RESPONSE = "response";

//    /**
//     * 需要给每个标签大自定义标签的pageCode集合
//     */
//    private static final List<String> SIGN_CUSTOMIZE_TAG_PAGE_CODE = Arrays.asList(ActivityConstants.PROJECT_DETAIL, ActivityConstants.TASK_DETAIL, ActivityConstants.BASIC_DATA);

    /**
     * 根据获取的标签 把标签执行到元数据上
     * metadataTags
     * 1.当为null的时候 字段全部打上数据标签
     * 2.当不为NULL的时候 打上外部获取的标签
     *
     * @param taggingData
     * @param masterApiMetadata
     */
    public void sinTagToMetadata(PcUiBotTaggingData taggingData, PcUiBotApiMetadata masterApiMetadata) {
        if (taggingData == null || org.springframework.util.CollectionUtils.isEmpty(taggingData.getMetadataTagResult())) {
            signCustomizeTagToAllFields(masterApiMetadata);
        } else if (taggingData != null) {
            signTagMetadataToFields(masterApiMetadata, taggingData);
        }
    }


    /**
     * 所有字段打上数据标签
     *
     * @param masterApiMetadata
     */
    private void signCustomizeTagToAllFields(PcUiBotApiMetadata masterApiMetadata) {
        if (masterApiMetadata == null) {
            return;
        }
        if (!CollectionUtils.isEmpty(masterApiMetadata.getRequestFields())) {
            //请求元数据格式
            List<PcUiBotMetadataField> requestMetadataFields = masterApiMetadata.getRequestFields();
            signCustomizeTag(requestMetadataFields);
        }
        //返回元数据格式
        List<PcUiBotMetadataField> responseMetadataFields = masterApiMetadata.getResponseFields();
        signCustomizeTag(responseMetadataFields);
    }

    public void signCustomizeTagForTest(List<PcUiBotMetadataField> metadataFields) {
        signCustomizeTag(metadataFields);
    }

    /**
     * 打上数据标签
     */
    private void signCustomizeTag(List<PcUiBotMetadataField> metadataFields) {
        if (CollectionUtils.isEmpty(metadataFields)) {
            return;
        }
        for (PcUiBotMetadataField metadataField : metadataFields) {
            if (CollectionUtils.isEmpty(metadataField.getTagDefinitions())) {
                metadataField.setTagDefinitions(PcUiBotDefaultTagUtils.createDataTypeTagDefinitions(metadataField));
            }

            if (!CollectionUtils.isEmpty(metadataField.getSubFields())) {
                signCustomizeTag(metadataField.getSubFields());
            }
        }
    }

    /**
     * 打上自定义页签标签
     *
     * @param needShowAppFields 元数据
     * @param tabs              页签配置
     */
    private void markCustomTagFromTab(List<PcUiBotMetadataField> needShowAppFields, List<PcUiBotTmTab> tabs) {
        if (CollectionUtils.isEmpty(tabs) || CollectionUtils.isEmpty(needShowAppFields)) {
            return;
        }
        Map<String, PcUiBotTmTab> tabTargetMap = tabs.stream()
                .collect(Collectors.toMap(PcUiBotTmTab::getTarget, Function.identity(), (v1, v2) -> v2));
        this.markCustomTagFromConfig(needShowAppFields, tabTargetMap);
    }

    /**
     * 打自定义标签，根据配置
     *
     * @param needShowAppFields
     * @param pageDefine
     */
    public void markCustomTagFromConfig(List<PcUiBotMetadataField> needShowAppFields, PcUiBotPageDefine pageDefine) {
        List<PcUiBotTmTab> tabs = pageDefine.getTabs();
        // 单身打上GROUP_TAB标签
        this.markCustomTagFromTab(needShowAppFields, tabs);
        // 子单身打上GROUP_TAB标签
        List<PcUiBotOperationDTO> operations = pageDefine.getOperations();
        if (!CollectionUtils.isEmpty(operations)) {
            for (PcUiBotOperationDTO operation : operations) {
                this.markCustomTagFromTab(needShowAppFields, operation.getTabs());
            }
        }
    }

    /**
     * 打页签标签
     *
     * @param metadataFields 元数据
     * @param tabTargetMap   页签targetMap
     */
    private void markCustomTagFromConfig(List<PcUiBotMetadataField> metadataFields,
                                         Map<String, PcUiBotTmTab> tabTargetMap) {
        for (PcUiBotMetadataField metadataField : metadataFields) {
            List<PcUiBotMetadataField> subFields = metadataField.getSubFields();
            if (!CollectionUtils.isEmpty(subFields)) {
                markCustomTagFromConfig(subFields, tabTargetMap);
            }
            PcUiBotTmTab tmTab = tabTargetMap.get(metadataField.getPath() + "." + metadataField.getName());
            if (tmTab == null) {
                continue;
            }
            PcUiBotTagDefinition tagDefinition = PcUiBotTagUtil.buildGroupTagDefinition(PcUiBotTagConstant.TagCode.TAB);
            List<PcUiBotTagDefinition> tagDefinitions = metadataField.getTagDefinitions();
            if (tagDefinitions == null) {
                metadataField.setTagDefinitions(Lists.newArrayList(tagDefinition));
            } else {
                tagDefinitions.add(tagDefinition);
            }
        }
    }

    /**
     * 根据获取的标签打上标签
     *
     * @param masterApiMetadata
     */
    public void signTagMetadataToFields(PcUiBotApiMetadata masterApiMetadata, PcUiBotTaggingData metadataTagsList) {

        if (masterApiMetadata == null) {
            return;
        }
        if (metadataTagsList == null || !masterApiMetadata.getActionId().equals(metadataTagsList.getMetadataId())) {
            return;
        }
        List<PcUiBotMetadataTagResult> metadataMetadataTagResultList = metadataTagsList.getMetadataTagResult();
        List<PcUiBotMetadataTagResult> requestTagResult = metadataMetadataTagResultList.stream()
                .filter(metadataTagResult -> metadataTagResult.getResourceContent() != null && metadataTagResult.getResourceContent().getResponse().contains(".request."))
                .collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(requestTagResult)) {
            String prefix = masterApiMetadata.getActionId() + ".request.";
            for (PcUiBotMetadataTagResult metadataTagResult : requestTagResult) {
                signTag(prefix, masterApiMetadata.getRequestFields(), metadataTagResult);
            }
        }

        List<PcUiBotMetadataTagResult> responseTagResult = metadataMetadataTagResultList.stream()
                .filter(metadataTagResult -> metadataTagResult.getResourceContent() != null && metadataTagResult.getResourceContent().getResponse().contains(".response."))
                .collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(responseTagResult)) {
            String prefix = masterApiMetadata.getActionId() + ".response.";
            for (PcUiBotMetadataTagResult metadataTagResult : responseTagResult) {
                signTag(prefix, masterApiMetadata.getResponseFields(), metadataTagResult);
            }
        }

    }

    /**
     * 打标签
     */
    private void signTag(String prefix, List<PcUiBotMetadataField> metadataFields, PcUiBotMetadataTagResult metadataTagResult) {
        List<PcUiBotTagDefinition> tagDefinitions = metadataTagResult.getTagDefinitions();
        String fullPath = metadataTagResult.getResourceContent().getResponse().replace(prefix, "");

        for (PcUiBotMetadataField metadataField : metadataFields) {
            PcUiBotMetadataField existField = metadataField.findByFullPath(fullPath);
            if (existField != null) {
                if (!CollectionUtils.isEmpty(existField.getTagDefinitions())) {
                    existField.getTagDefinitions().addAll(tagDefinitions);
                } else {
                    existField.setTagDefinitions(tagDefinitions);
                }
                //添加数据类型解析器定义
                PcUiBotDefaultTagUtils.createDataTypeTagDefinition(existField, metadataTagResult);
                break;
            }
        }
    }


//    private void addDataTypeTag(){
//
//    }


//    /**
//     * 根据人员是当职责/执行者和元数据来获取标签
//     *
//     * @param relationTag
//     * @param metadataId
//     * @return
//     */
//    private MetadataTags getMetadataTags(RelationTag relationTag, String metadataId, String sourceType, String clientAgent) {
//        MetadataTags metadataTags = new MetadataTags();
//        if (Objects.isNull(relationTag)) {
//            return null;
//        }
//        Map<String, Object> metadataTagParameter = new HashMap<>();
//        List<String> relationIds = new ArrayList<>();
//        if (StringUtils.isNotBlank(relationTag.getIdentity())) {
//            relationIds.add(relationTag.getIdentity());
//        }
//        if (StringUtils.isNotBlank(relationTag.getActivityId())) {
//            relationIds.add(relationTag.getActivityId());
//        }
//        //没有合适的查询条件
//        if (CollectionUtils.isEmpty(relationIds)) {
//            return null;
//        }
//        metadataTagParameter.put("resourceId", metadataId);
//        metadataTagParameter.put("relationIds", relationIds);
//
//        List<MetadataTagResultDTO> metadataTagResults = tagService.getMetadataTag(metadataTagParameter);
//        metadataTagResults = tagService.filterTagByClientAgent(metadataTagResults, clientAgent);
//        metadataTagResults = tagService.filterTagBySourceType(metadataTagResults, clientAgent);
//
//        //未获取到标签
//        if (CollectionUtils.isEmpty(metadataTagResults)) {
//            return null;
//        }
//        metadataTags.setMetadataId(metadataId);
//        metadataTags.setMetadataTagResult(metadataTagResults);
//        return metadataTags;
//    }
//
//    /**
//     * 打辅助元数API（目前不支持多层嵌套）
//     *
//     * @param metadataTags
//     * @param metadataFields
//     */
//    private void signSourceApiTag(MetadataTags metadataTags, List<MetadataField> metadataFields) {
//        List<MetadataTagResultDTO> metadataTagResultDTOList = metadataTags.getMetadataTagResult();
//        for (MetadataTagResultDTO metadataTagResultDTO : metadataTagResultDTOList) {
//            String response = metadataTagResultDTO.getResourceContent().getResponse();
//            String lastName = StringUtils.substringAfterLast(response, "response.");
//            if (StringUtils.isNotBlank(lastName)) {
//                String fileName = StringUtils.substringAfterLast(response, ".");
//                for (MetadataField metadataField : metadataFields) {
//                    if (metadataField.getName().equals(fileName)) {
//                        Set<String> fieldTags = metadataField.getFieldTags();
//                        if (CollectionUtils.isEmpty(fieldTags)) {
//                            fieldTags = new HashSet<>();
//                        }
//                        if (CollectionUtils.isEmpty(metadataTagResultDTO.getTags())) {
//                            fieldTags.add(UUID.randomUUID().toString());
//                        } else {
//                            for (MetadataTagsDTO tag : metadataTagResultDTO.getTags()) {
//                                fieldTags.add(tag.getCode());
//                            }
//                        }
//                        metadataField.setFieldTags(fieldTags);
//                    }
//                }
//            }
//        }
//    }

}
