package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotSubmitActionUtil;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：提交ACTION 服务</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: SubmitActionCreateService.java
 * @Author: wangjwc
 * @Date: created at 2023/7/12 18:33
 */
@Service
public class SubmitActionCreateService extends ActionCreateServiceBase {
    /**
     * 创建 查询 ACTION
     *
     * @param tmAction
     * @param tenantId
     * @return
     */
    public PcUiBotSubmitAction createSubmitAction(PcUiBotTmAction tmAction, String tenantId, Map<String, Object> businessUnit, PcUiBotExecuteContext executeContext) {
        if (tmAction == null) {
            return null;
        }
        appendActionInfo(tmAction, executeContext);
        PcUiBotSubmitAction action = new PcUiBotSubmitAction();
        action.setActionId(tmAction.getActionId());
        action.setServiceId(this.createActionServiceId(tmAction, tenantId));
        action.setCategory(tmAction.getType());
        action.setUuid(tmAction.getUuid());
        action.setBtnId(tmAction.getBtnId());
        action.setBtnType(tmAction.getBtnType());
        action.setJumpAction(tmAction.getJumpAction());
        action.setTitle(tmAction.getTitle());
        action.setReturnText(tmAction.getReturnText());
        action.setBusinessUnit(businessUnit);
        action.executeExtendParas(tmAction.getExtendParas(), executeContext);
        action.setExtendParas(tmAction.getExtendParas());
        action.setAddShowFileds(tmAction.getAddShowFileds());
        action.setBackFills(tmAction.getBackFills());
        action.setTargetDataState(tmAction.getTargetDataState());
        action.setConfirm(tmAction.getConfirm());
        action.setActionType(tmAction.getActionType());
        action.setSubmitType(tmAction.getSubmitType());
        //兼容性处理，迭代14兼容迭代13的配置
        if (action.getActionType() == null
                && tmAction.getExtendParas() != null
                && tmAction.getExtendParas().containsKey("actionType")) {
            action.setActionType(tmAction.getExtendParas().get("actionType").toString());
        }
        action.setId(tmAction.getId());
        action.setActionParams(tmAction.getActionParams());
        action.setCategory(tmAction.getType());

        action.setDefaultAction(true);
        action.setId(tmAction.getId());
        action.setParas(tmAction.getParas());
        action.setAttachActions(this.createAttachActions(tmAction, tenantId, businessUnit, executeContext));
        action.executeExtendParas(tmAction.getExtendParas(), executeContext);
        action.setExtendParas(tmAction.getExtendParas());
        action.setAddShowFileds(tmAction.getAddShowFileds());
        action.setDefaultAction(tmAction.isDefaultAction());
        action.setActionScript(tmAction.getActionScript());
        action.setAppendRowBusinessUnitSelect(tmAction.getAppendRowBusinessUnitSelect());
        processActionParas(action, executeContext);
        action.setTrackCode(tmAction.getTrackCode());
        PcUiBotSubmitActionUtil.setCondition(tmAction, action);
        return action;
    }

    /**
     * 创建基础资料录入 attach actions
     *
     * @param tmAction
     * @return
     */
    private List<PcUiBotSubmitAction> createAttachActions(PcUiBotTmAction tmAction, String tenantId, Map<String, Object> businessUnit, PcUiBotExecuteContext executeContext) {
        List<PcUiBotSubmitAction> attachActions = new ArrayList<>();
        if (CollectionUtils.isEmpty(tmAction.getAttachActions())) {
            return attachActions;
        }
        tmAction.getAttachActions().forEach(attachAction -> {
            PcUiBotSubmitAction submitAction = createSubmitAction(attachAction, tenantId, businessUnit, executeContext);
            submitAction.setExecuteContext(null);
            attachActions.add(submitAction);
        });
        return attachActions;
    }

}
