package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotTagDefinition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：处理原始的元数据
 * 1.确定元数据的范围
 * 2.更新元数据字段的编辑属性</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TagDisplayRangeService.java
 * @Author: wangjwc
 * @Date: created at 2023/11/14 10:21
 */
@Service
public class TagDisplayRangeService {

//    @Autowired
//    TableDataAttachmentInterpreter tableDataAttachmentInterpreter;

    @Autowired
    TagMergeService tagMergeService;

    @Autowired
    ShowFieldService showFieldService;
    /**
     * 标签显示的方式
     *
     * @param masterMetadata
     * @return
     */
    /*public ShowMetadata tagDisplayRange(ExecuteContext executeContext, ApiMetadata masterMetadata, QueryResultSet  queryResultSet, PageDefine pageDefine) {
        ShowMetadata showMetadata = new ShowMetadata();
        if (masterMetadata == null) {
            return showMetadata;
        }
        showMetadata.setActionId(masterMetadata.getActionId());
        showMetadata.setServiceName(masterMetadata.getServiceName());
//        showMetadata.setMetadataTags(masterMetadata.getApiTags());

        //原始字段服务
        List<MetadataField> headOriginalMetadata = masterMetadata.getResponseFields();

        //显示的字段
        List<MetadataField> showFields = new ArrayList<>();
        //优先处理HEAD标签
        MetadataField metadataFieldHead = HeadTagUtils.analysisTag(headOriginalMetadata);
        if (metadataFieldHead != null) {
            showFields.add(metadataFieldHead);
            if (queryResultSet != null && queryResultSet.getMainQueryResult().getData().size() > 0) {
                queryResultSet.appendData(QueryResult.withSingleData(queryResultSet.getMainQueryResult().getDataSourceName() + "_HEAD", queryResultSet.getMainQueryResult().getData().get(0)));
            }else {
                if (queryResultSet != null) {
                    queryResultSet.appendData(QueryResult.withSingleData(queryResultSet.getMainQueryResult().getDataSourceName() + "_HEAD", new HashMap<>()));
                }
            }
        }
        //处理所有的字段
        //List<MetadataField> tagMetadata = showFields(headOriginalMetadata);
        List<MetadataField> tagMetadata = new ArrayList<>();
        for (MetadataField subMetadataField : headOriginalMetadata) {
            //直接处理第二层，默认第一层是root
            List<MetadataField> needShowSubFields  = getShowFields(executeContext, subMetadataField, queryResultSet, pageDefine);
            if (needShowSubFields.size() > 0) {
                tagMetadata.add(subMetadataField.clone(null, needShowSubFields));
            }
        }
        if (CollectionUtils.isNotEmpty(tagMetadata)) {
            showFields.addAll(tagMetadata);
        }else{//没有tag显示全部
            showFields.addAll(headOriginalMetadata);
        }



        showMetadata.setShowFields(showFields);
        return showMetadata;
    }*/


    /**
     * 获取只显示字段
     * 暂时 废弃，用重构的部分，有问题在放开
     *
     * @param metadataFields
     * @return
     */
   /* public List<MetadataField> showFields(List<MetadataField> metadataFields) {
        List<MetadataField> showFields = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(metadataFields)) {
            for (MetadataField metadataField : metadataFields) {
                if (ApiMetadataConstants.METADATA_OBJECT.equals(metadataField.getDataType())) {
                    //处理导出字段
                    List<MetadataField> sonTagFields = showFields(metadataField.getSubFields());
                    if (CollectionUtils.isNotEmpty(sonTagFields)) {
                        MetadataField newMetadataField = metadataField.clone(null, sonTagFields);
                        showFields.add(newMetadataField);
                    } else if (CollectionUtils.isNotEmpty(metadataField.getTagDefinitions())) {
                        MetadataField newMetadataField = metadataField.clone(null, sonTagFields);
                        tableDataAttachmentInterpreter.addAttachmentFields(newMetadataField, metadataField);
                        showFields.add(newMetadataField);
                    }
                }
                if (CollectionUtils.isNotEmpty(metadataField.getTagDefinitions())
                        && !ApiMetadataConstants.METADATA_OBJECT.equals(metadataField.getDataType())
                ) {
                    if (!showFields.contains(metadataField)) {
                        showFields.add(metadataField);
                    }
                }
                if (CollectionUtils.isNotEmpty(metadataField.getTagDefinitions())
                        && ApiMetadataConstants.METADATA_OBJECT.equals(metadataField.getDataType())
                ) {
                    TagDefinition tagDefinitionDTO = tagMergeService.mergeTagAttributes(metadataField);
                    if (tagDefinitionDTO != null && "customizeComponentInterpreter".equals(tagDefinitionDTO.getInterpreterServiceName())) {
                        metadataField.setSubFields(new ArrayList<>());
                        MetadataField newMetadataField = metadataField.clone(null, metadataField.getSubFields());
                        if (!showFields.contains(newMetadataField)) {
                            showFields.add(newMetadataField);
                        }
                    } else {
                        List<MetadataField> sonTagFields = showFields(metadataField.getSubFields());
                        if (CollectionUtils.isNotEmpty(sonTagFields)) {
                            MetadataField newMetadataField = metadataField.clone(null, sonTagFields);
                            if (!showFields.contains(newMetadataField)) {
                                showFields.add(newMetadataField);
                            }
                        } else if (CollectionUtils.isNotEmpty(metadataField.getTagDefinitions())) {
                            MetadataField newMetadataField = metadataField.clone(null, sonTagFields);
                            tableDataAttachmentInterpreter.addAttachmentFields(newMetadataField, metadataField);
                            if (!showFields.contains(newMetadataField)) {
                                showFields.add(newMetadataField);
                            }
                        }
                    }
                }
            }
        }
        return showFields;
    }*/
    ////////////////////////////////////////////////////////////////////

    /**
     * xuxx 根据tag过滤显示字段
     *
     * @param showFields
     */
    public List<PcUiBotMetadataField> getShowFields(PcUiBotExecuteContext executeContext, PcUiBotMetadataField showFields, QueryResultSet queryResultSet, PcUiBotPageDefine pageDefine) {
        List<String> notShowWords = new ArrayList<>();
        Map<String, PcUiBotMetadataField> fieldMap = showFields.getFieldMap();
        if (!CollectionUtils.isEmpty(fieldMap)) {
            //TODO:xuxx 晓亮：开窗和基础资料都和任务走一样逻辑
           /* if ((ActivityConstants.TASK_DETAIL.equals(executeContext.getPageCode())
                    || ActivityConstants.PROJECT_DETAIL.equals(executeContext.getPageCode()))
                    &&  !ActivityConstants.PATTERN_DIALOG.equals(executeContext.getPattern()) ) {*/
            List<Object> apiMetadataStr = new ArrayList<Object>();
            apiMetadataStr.add(fieldMap.keySet());
            notShowWords.addAll(showFieldService.getWordsByAbility(executeContext, apiMetadataStr, queryResultSet, pageDefine));
            //}
        }

        List<PcUiBotMetadataField> newShowFields = new ArrayList<>();
        //遍历所有字段
        if (showFields.getSubFields() != null) {
            for (PcUiBotMetadataField responseField : showFields.getSubFields()) {
                //直接处理第二层，默认第一层是root
                if (!notShowWords.contains(responseField.getName())) {
                    List<PcUiBotMetadataField> needShowSubFields = getShowTagFields(executeContext, responseField, queryResultSet, pageDefine);
                    if (needShowSubFields.size() > 0) {
                        newShowFields.addAll(needShowSubFields);
                    }
                }
            }
            //兼容多层结构子单身不打tag时
            if (PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(showFields.getDataType()) && newShowFields.size() == 0
                    && CollectionUtils.isNotEmpty(showFields.getTagDefinitions())) {
                newShowFields.addAll(showFields.getSubFields());
            }
        }
        return newShowFields;
    }

    /**
     * @param metadataField 字段列表
     * @return
     */
    public List<PcUiBotMetadataField> getShowTagFields(PcUiBotExecuteContext executeContext, PcUiBotMetadataField metadataField, QueryResultSet queryResultSet, PcUiBotPageDefine pageDefine) {
        List<PcUiBotMetadataField> newShowFields = new ArrayList<PcUiBotMetadataField>();
        if (metadataField != null) {
            //判断如果是个对象
            if (PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(metadataField.getDataType())) {
                // 如果这个object有tag
                if (CollectionUtils.isNotEmpty(metadataField.getTagDefinitions())) {
                    PcUiBotTagDefinition tagDefinitionDTO = tagMergeService.mergeTagAttributes(metadataField);
                    //如果是客制的tag，则不需要生成subFields;
                    if (tagDefinitionDTO != null && "customizeComponentInterpreter".equals(tagDefinitionDTO.getInterpreterServiceName())) {
                        metadataField.setSubFields(new ArrayList<>());
                        PcUiBotMetadataField newMetadataField = metadataField.clone(null, metadataField.getSubFields());
                        if (!newShowFields.contains(newMetadataField)) {
                            newShowFields.add(newMetadataField);
                        }
                    } else {
                        //原有逻辑，导出表格的tag
                        List<PcUiBotMetadataField> sonTagFields = getShowFields(executeContext, metadataField, queryResultSet, pageDefine);
                        PcUiBotMetadataField newMetadataField = metadataField.clone(null, sonTagFields);
//                        tableDataAttachmentInterpreter.addAttachmentFields(newMetadataField, metadataField);
                        newShowFields.add(newMetadataField);
                    }
                } else {//没有tag的时候，需要递归
                    List<PcUiBotMetadataField> sonTagFields = getShowFields(executeContext, metadataField, queryResultSet, pageDefine);
                    if (CollectionUtils.isNotEmpty(sonTagFields)) {
                        PcUiBotMetadataField newMetadataField = metadataField.clone(null, sonTagFields);
                        newShowFields.add(newMetadataField);
                    }
                }
            } else {
                //非object需要根据tag定义来显示
                if (metadataField.getTagDefinitions() != null) {
                    newShowFields.add(metadataField);
                }
            }
        }
        //需要将OBJECT对象回填
        if (PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(metadataField.getDataType())//NOSONAR
                && newShowFields.isEmpty() && CollectionUtils.isNotEmpty(metadataField.getTagDefinitions())) {
            newShowFields.add(metadataField);
        }
        return newShowFields;
    }

}
