package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.designer.uibot.rule.DesignerTrigger;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotApiMetadataConstants;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotMetadataField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotTagDefinition;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * <p>功能描述：tag 合并服务</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TagMergeService.java
 * @Author: wangjwc
 * @Date: created at 2023/10/27 18:53
 */
@Service
public class TagMergeService {

    /**
     * 存在多TAG情况下 合并TAG服务
     * 一个字段 只能由一个TAG解析器来处理 生成组件
     * 其中有两种方式：优先使用serviceName 通过权重值来取其中一种
     * 规则：合并
     * icon:合并
     * <p>
     * 迭代9：实现字段级别的TAG
     * 字段OBJECT 级别的TAG
     * 如果没有的情况下，使用数据类型标签
     *
     * @param metadataField
     * @return
     */
    public PcUiBotTagDefinition mergeTagAttributes(PcUiBotMetadataField metadataField) {
        if (metadataField == null) {
            return null;
        }
        if (CollectionUtils.isEmpty(metadataField.getTagDefinitions())) {
            return null;
        }
        List<PcUiBotTagDefinition> tagDefinitions = metadataField.getTagDefinitions();
        PcUiBotTagDefinition tagDefinitionDTO = null;
        // 多个标签实例时，取最后一个interpreterServiceName
        for (PcUiBotTagDefinition tagDefinition : tagDefinitions) {
            if (StringUtils.isNotBlank(tagDefinition.getInterpreterServiceName())) {
                tagDefinitionDTO = tagDefinition;
            }
        }
        if (tagDefinitionDTO == null || StringUtils.isBlank(tagDefinitionDTO.getInterpreterServiceName())) {
            return null;
        }

        return tagDefinitionDTO;
    }

    /**
     * 返回所有含有解释器的tag
     *
     * @param metadataField
     * @return
     */
    public List<PcUiBotTagDefinition> getInterpreterTags(PcUiBotMetadataField metadataField) {
        if (CollectionUtils.isEmpty(metadataField.getTagDefinitions())) {
            return new ArrayList<>();
        }
        Set<String> codes = new HashSet<>();
        List<PcUiBotTagDefinition> result = new ArrayList<>();
        for (PcUiBotTagDefinition tagDefinition : metadataField.getTagDefinitions()) {
            if (StringUtils.isNotBlank(tagDefinition.getInterpreterServiceName())) {
                if (codes.contains(tagDefinition.getCode())) {
                    continue;
                }
                codes.add(tagDefinition.getCode());
                result.add(tagDefinition);
            }
        }
        return result;
    }


    /**
     * 默认OBJECT 上没有规则
     *
     * @param showFields
     * @param rules
     */
    public void addTagRules(String path, List<PcUiBotMetadataField> showFields, List<Map<String, Object>> rules) {
        for (PcUiBotMetadataField showField : showFields) {
            String pathName = "";
            if (StringUtils.isBlank(path)) {
                pathName = showField.getName();
            } else {
                pathName = path + "." + showField.getName();
            }

            if (PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(showField.getDataType())) {
                addTagRules(pathName, showField.getSubFields(), rules);
            } else {
                if (!CollectionUtils.isEmpty(showField.getTagDefinitions()) && showField.isCanEdit()) {
                    for (PcUiBotTagDefinition tagDefinition : showField.getTagDefinitions()) {
                        if (tagDefinition.getRuleDefinition() != null && !CollectionUtils.isEmpty(tagDefinition.getRuleDefinition().getRules())) {
                            for (JSONObject rule : tagDefinition.getRuleDefinition().getRules()) {
                                UiBotRule uiBotRule = JsonUtil.objectToJavaObject(rule, UiBotRule.class);
                                uiBotRule.setPath(path);
                                DesignerTrigger trigger = uiBotRule.getTrigger();
                                if (trigger != null) {
                                    trigger.setApiUrl(DigiwinAtmcProxyService.API_PREFIX + "/" + trigger.getApiUrl());
                                }
                                rules.add(rule);
                            }
                        }
                    }
                }
            }
        }
    }
}
