package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.KnowledgeMapsTagQueryResult;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotConstants;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotRelationTag;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTagRequest;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotMetadataTagResult;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotTaggingData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotThemeMapTag;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotTagConstant;
import com.fasterxml.jackson.core.type.TypeReference;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * tag系统提供的服务
 */
@Service
public class TagService {

    private final static String TEMPLATE = "TEMPLATE";
    private final static String TEMPLATE_PREFIX = "TEMPLATE_";

    private final static String MOBILEPLATFORM = "mobileplatform_";

    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;

//    @Autowired
//    private AthenaDesignerService athenaDesignerService;
//
//    @Autowired
//    private EnvProperties envProperties;

    /**
     * 获取TM TAG
     * 处理原始TAG
     * @param relationTag
     * @param metadataId
     * @param sourceType
     * @return
     */
    /**
     * 根据人员是当职责/执行者和元数据来获取标签
     *
     * @param relationTag
     * @param metadataId
     * @return
     */
    public PcUiBotTaggingData getThemeMapTag(String queryTagSuffix, PcUiBotRelationTag relationTag, String metadataId, String sourceType, PcUiBotExecuteContext executeContext) {
        if (Objects.isNull(relationTag)) {
            return null;
        }
        String activityId = relationTag.getActivityId();
        PcUiBotTaggingData metadataTags = new PcUiBotTaggingData();
        List<String> relationIds = new ArrayList<>();
        List<String> relationIdsDIALOG = new ArrayList<>();
        if (StringUtils.isNotBlank(relationTag.getIdentity())) {
            relationIdsDIALOG.add(relationTag.getIdentity());
            relationIds.add(relationTag.getIdentity());
        }
        if (StringUtils.isNotBlank(activityId)) {
            relationIdsDIALOG.add(activityId + queryTagSuffix);
            relationIds.add(activityId);
        }
        PcUiBotTagRequest tagRequest = PcUiBotTagRequest.builder()
                .resourceId(metadataId)
                .relationIds(relationIds)
                .activityCode(activityId)
                .build();
        //没有合适的查询条件
        if (CollectionUtils.isEmpty(relationIds)) {
            return null;
        }
        List<PcUiBotMetadataTagResult> metadataMetadataTagResults;

        if (StringUtils.isNotBlank(queryTagSuffix)) {
            PcUiBotTagRequest dialogTagRequest = JsonUtil.objectToJavaObject(tagRequest, PcUiBotTagRequest.class);
            dialogTagRequest.setRelationIds(relationIdsDIALOG);
            metadataMetadataTagResults = this.getMetadataTag(executeContext, dialogTagRequest);
            if (CollectionUtils.isEmpty(metadataMetadataTagResults)) {
                metadataMetadataTagResults = this.getMetadataTag(executeContext, tagRequest);
            }
        } else {
            metadataMetadataTagResults = this.getMetadataTag(executeContext, tagRequest);
        }

        if (CollectionUtils.isEmpty(metadataMetadataTagResults)) {
            return null;
        }
        //处理web和手机端TAG
        metadataMetadataTagResults = this.filterTagByClientAgent(metadataMetadataTagResults, executeContext.getClientAgent());
        //处理来源TAG
        metadataMetadataTagResults = this.filterTagBySourceType(metadataMetadataTagResults, sourceType);

        //处理顺序TAG ORDER
        this.orderTagHandle(metadataMetadataTagResults);
        //处理定位TAG  POSITION
        this.positionTagHandle(metadataMetadataTagResults);
        //处理分组TAG GROUP
        this.groupTagHandle(metadataMetadataTagResults);
        //TODO: xuxx 处理application的tag
        this.applicationTagHandle(metadataMetadataTagResults);
        //处理其他类型的
        this.otherTagHandle(metadataMetadataTagResults);

        metadataTags.setMetadataId(metadataId);
        metadataTags.setMetadataTagResult(metadataMetadataTagResults);
        return orderTag(metadataTags);
    }

    private List<PcUiBotMetadataTagResult> getMetadataTag(PcUiBotExecuteContext executeContext, PcUiBotTagRequest tagRequest) {
        // 调用知识图谱的API，获取任务详情字段与tag配置
        Map<String, String> features = new HashMap<>(1);
        features.put("deviceType", "mobile");

        DigiwinAthenaApiRequest apiRequest = DigiwinAthenaApiRequest.builder()
                .requestHead(new AthenaBasicHttpRequestHead("", executeContext.getLocale(),
                        executeContext.getAuthoredUser().getToken(), executeContext.getAuthoredUser().getTenantId()))
                .bodyPayloadMap("resourceId", tagRequest.getResourceId())
                .bodyPayloadMap("relationIds", tagRequest.getRelationIds())
                .bodyPayloadMap("activityCode", tagRequest.getActivityCode())
                .bodyPayloadMap("features", features)
                .build();
        List<KnowledgeMapsTagQueryResult> rawTagQueryResults =
                this.digiwinKnowledgeMapsProxyService.getTagQueryResult(apiRequest);
        return JsonUtil.objectToJavaObject(rawTagQueryResults, new TypeReference<List<PcUiBotMetadataTagResult>>() {
        });
    }

    /**
     * xuxx 处理当前租户购买应用的tag
     *
     * @param metadataTagResults
     */
    private void applicationTagHandle(List<PcUiBotMetadataTagResult> metadataTagResults) {
        for (PcUiBotMetadataTagResult metadataTagResult : metadataTagResults) {
            Iterator themeMapTags = metadataTagResult.getTags().iterator();
            while (themeMapTags.hasNext()) {
                PcUiBotThemeMapTag themeMapTag = (PcUiBotThemeMapTag) themeMapTags.next();
                if (PcUiBotTagConstant.CATEGORY_APPLICATION.equals(themeMapTag.getCategory())) {
                    themeMapTag.setCategory(PcUiBotTagConstant.CATEGORY_APPLICATION);
                    themeMapTag.setUiBotCode(themeMapTag.getCode());
                }
            }
        }
    }

    private PcUiBotTaggingData orderTag(PcUiBotTaggingData metadataTags) {
        PcUiBotTaggingData newTag = new PcUiBotTaggingData();
        newTag.setMetadataTagResult(new ArrayList<>());
        newTag.setMetadataId(metadataTags.getMetadataId());
        int[] index = new int[metadataTags.getMetadataTagResult().size()];
        for (PcUiBotMetadataTagResult metadataTagResult : metadataTags.getMetadataTagResult()) {
            if (metadataTagResult.getTags() != null && metadataTagResult.getTags().size() > 0) {
                int insertIndex = -1;
                for (PcUiBotThemeMapTag tag : metadataTagResult.getTags()) {
                    if (tag.getCategory() != null && tag.getCategory().equals("ORDER")) {
                        int value = Integer.valueOf(tag.getValue());
                        for (int i = 0; i < index.length; i++) {
                            int existValue = index[i];
                            if (existValue != 0) {
                                if (value <= existValue) {
                                    insertIndex = i;
                                    break;
                                }
                            } else {
                                insertIndex = i;
                                break;
                            }
                        }
                        if (index[insertIndex] > 0) {
                            for (int i = index.length - 1; i > insertIndex; i--) {
                                index[i] = index[i - 1];
                            }
                        }

                        index[insertIndex] = value;
                        break;
                    }
                }
                if (insertIndex > -1) {
//                    metadataTagResult.getTags().clear();
                    newTag.getMetadataTagResult().add(insertIndex, metadataTagResult);
                } else {
                    newTag.getMetadataTagResult().add(metadataTagResult);
                }
            }
        }
        return newTag;
    }

    /**
     * 产生UUID 一个随机标签或者业务标签，后续标签合并的时候 会弃用或者变成一个数据类型标签
     *
     * @return
     */
//    public TaggingData createCustomizeThemeMapTaggingData(String actionId, TaskPageDefine pageDefine) {
//        List<DataTag> dataTags = pageDefine.getDataTags();
//        if (CollectionUtils.isEmpty(dataTags)) {
//            return null;
//        }
//        TaggingData taggingData = new TaggingData();
//        taggingData.setMetadataId(actionId);
//        List<MetadataTagResult> metadataTagResult = new ArrayList<>();
//        for (DataTag dataTag : dataTags) {
//            MetadataTagResult tagResult = new MetadataTagResult();
//            ThemeMapTagResponse resourceContent = new ThemeMapTagResponse();
//            resourceContent.setResponse(dataTag.getField());
//            if (CollectionUtils.isNotEmpty(dataTag.getTags())) {
//                //xuxx add 2021-12-21 当是项目卡时，系统自动加上 line-table的tag
//                if (dataTags.size() == 1
//                        && (ActivityConstants.PROJECT_CARD.equals(pageDefine.getExecuteContext().getPageCode())
//                        || ActivityConstants.TASK_CARD.equals(pageDefine.getExecuteContext().getPageCode()))) {
//                    ThemeMapTag themeMapTag = new ThemeMapTag();
//                    themeMapTag.setCode("line-table-vertical");
//                    themeMapTag.setUiBotCode("line-table-vertical");
//                    themeMapTag.setCategory(TagConstant.CATEGORY_BUSINESS);
//                    dataTag.getTags().add(0, themeMapTag);
//                }
//                tagResult.setTags(dataTag.getTags());
//            } else if (StringUtils.isNotBlank(dataTag.getTag())) {
//                List<ThemeMapTag> tags = new ArrayList<>();
//                ThemeMapTag themeMapTag = new ThemeMapTag();
//                themeMapTag.setCode(dataTag.getTag());
//                themeMapTag.setUiBotCode(dataTag.getTag());
//                themeMapTag.setCategory(TagConstant.CATEGORY_BUSINESS);
//                tags.add(themeMapTag);
//                tagResult.setTags(tags);
//            }
//
//            tagResult.setResourceContent(resourceContent);
//            metadataTagResult.add(tagResult);
//        }
//        orderTagHandle(metadataTagResult);
//        taggingData.setMetadataTagResult(metadataTagResult);
//        return taggingData;
//    }

    /**
     * 过滤 模板还是非模板的TAG
     *
     * @param metadataMetadataTagResults
     * @param sourceType
     * @return
     */
    private List<PcUiBotMetadataTagResult> filterTagBySourceType(List<PcUiBotMetadataTagResult> metadataMetadataTagResults, String sourceType) {
        List<PcUiBotMetadataTagResult> newMetadataMetadataTagResults = new ArrayList<>();
        if (CollectionUtils.isEmpty(metadataMetadataTagResults)) {
            return newMetadataMetadataTagResults;
        }

        for (PcUiBotMetadataTagResult metadataMetadataTagResultDTO : metadataMetadataTagResults) {
            PcUiBotMetadataTagResult metadataTagResult = new PcUiBotMetadataTagResult();
            List<PcUiBotThemeMapTag> newTags = new ArrayList<>();

            if (CollectionUtils.isEmpty(metadataMetadataTagResultDTO.getTags()) && !sourceType.equals(TEMPLATE)) {
                metadataTagResult.setResourceContent(metadataMetadataTagResultDTO.getResourceContent());
                newMetadataMetadataTagResults.add(metadataTagResult);
            } else if (!CollectionUtils.isEmpty(metadataMetadataTagResultDTO.getTags())) {

                for (PcUiBotThemeMapTag tag : metadataMetadataTagResultDTO.getTags()) {
                    //只要有TEMPLATE  tag 都不显示；
                    boolean isTemplate = false;
                    if (TEMPLATE.equals(sourceType)) {
                        if (StringUtils.startsWith(tag.getCode(), TEMPLATE_PREFIX)) {
                            tag.setCode(StringUtils.substringAfterLast(tag.getCode(), TEMPLATE_PREFIX));
                            newTags.add(tag);
                        }
                    } else {
                        if (StringUtils.startsWith(tag.getCode(), TEMPLATE_PREFIX)) {
                            isTemplate = true;
                        }

                        if (!isTemplate) {
                            if (!StringUtils.contains(tag.getCode(), TEMPLATE)) {
                                newTags.add(tag);
                            }
                        }
                    }
                }
                if (!CollectionUtils.isEmpty(newTags)) {
                    metadataTagResult.setResourceContent(metadataMetadataTagResultDTO.getResourceContent());
                    metadataTagResult.setTags(newTags);
                    newMetadataMetadataTagResults.add(metadataTagResult);
                }
            }
        }
        return newMetadataMetadataTagResults;
    }

    /**
     * 过滤 web端还是非web端的TAG
     *
     * @param metadataMetadataTagResults
     * @param clientAgent
     * @return
     */
    private List<PcUiBotMetadataTagResult> filterTagByClientAgent(List<PcUiBotMetadataTagResult> metadataMetadataTagResults, String clientAgent) {
        List<PcUiBotMetadataTagResult> newMetadataTags = new ArrayList<>();
        if (CollectionUtils.isEmpty(metadataMetadataTagResults)) {
            return newMetadataTags;
        }
        //当是移动端时候 只是获取移动的TAG 字段 web端去掉移动TAG
        for (PcUiBotMetadataTagResult metadataMetadataTagResultDTO : metadataMetadataTagResults) {
            List<PcUiBotThemeMapTag> newTags = new ArrayList<>();
            for (PcUiBotThemeMapTag tag : metadataMetadataTagResultDTO.getTags()) {
                if (PcUiBotConstants.MOBILE_PLATFORM.equals(clientAgent)) {
                    if (tag.getCode().contains(MOBILEPLATFORM)) {
                        tag.setCode(StringUtils.substringAfterLast(tag.getCode(), MOBILEPLATFORM));
                        newTags.add(tag);
                    }
                } else {
                    if (!tag.getCode().contains(MOBILEPLATFORM)) {
                        newTags.add(tag);
                    }
                }
            }
            if (!CollectionUtils.isEmpty(newTags)) {
                PcUiBotMetadataTagResult newMetadataMetadataTagResultDTO = new PcUiBotMetadataTagResult();
                newMetadataMetadataTagResultDTO.setTags(newTags);
                newMetadataMetadataTagResultDTO.setResourceContent(metadataMetadataTagResultDTO.getResourceContent());
                newMetadataTags.add(newMetadataMetadataTagResultDTO);
            }
        }
        return newMetadataTags;
    }


    /**
     * 运行时--产生
     * 顺序类
     * 1.修改ORDER值
     * 2.移除重复ORDER-TAG标签
     *
     * @param metadataTagResults
     */
    private void orderTagHandle(List<PcUiBotMetadataTagResult> metadataTagResults) {
        for (PcUiBotMetadataTagResult metadataTagResult : metadataTagResults) {
            boolean orderRemoveFlag = false;
            Iterator themeMapTags = metadataTagResult.getTags().iterator();
            while (themeMapTags.hasNext()) {
                PcUiBotThemeMapTag themeMapTag = (PcUiBotThemeMapTag) themeMapTags.next();
//                if (themeMapTag.getCode().startsWith(TagConstant.ORDER_PREFIX)) {
                if (PcUiBotTagConstant.CATEGORY_ORDER.equals(themeMapTag.getCategory())) {
                    if (!orderRemoveFlag) {
                        orderRemoveFlag = true;
                        themeMapTag.setValue(StringUtils.substringAfterLast(themeMapTag.getCode(), PcUiBotTagConstant.ORDER_PREFIX));
                        if (themeMapTag.getValue() == null) {
                            themeMapTag.setValue("0");
                        }
                        themeMapTag.setCategory(PcUiBotTagConstant.ORDER_TAG);
                        themeMapTag.setUiBotCode(PcUiBotTagConstant.ORDER_TAG);
                    } else {
                        themeMapTags.remove();
                    }
                }
            }
        }
    }


    /**
     * 运行时--产生
     * 顺序类
     * 1.修改ORDER值
     * 2.移除重复ORDER-TAG标签
     *
     * @param metadataTagResults
     */
    private void groupTagHandle(List<PcUiBotMetadataTagResult> metadataTagResults) {
        for (PcUiBotMetadataTagResult metadataTagResult : metadataTagResults) {
            boolean orderRemoveFlag = false;
            Iterator themeMapTags = metadataTagResult.getTags().iterator();
            while (themeMapTags.hasNext()) {
                PcUiBotThemeMapTag themeMapTag = (PcUiBotThemeMapTag) themeMapTags.next();
//                if (themeMapTag.getCode().startsWith(TagConstant.GROUP_PREFIX)) {
                if (PcUiBotTagConstant.CATEGORY_GROUP.equals(themeMapTag.getCategory())) {
                    if (!orderRemoveFlag) {
                        orderRemoveFlag = true;
                        themeMapTag.setUiBotCode(PcUiBotTagConstant.GROUP_TAG);
                        themeMapTag.setCategory(PcUiBotTagConstant.GROUP_TAG);
                        themeMapTag.setTitle(themeMapTag.getName());
                        themeMapTag.setValue(themeMapTag.getCode());
                        if (themeMapTag.getCode().startsWith(PcUiBotTagConstant.GROUP_PREFIX)) {
                            themeMapTag.setGroupFieldShowTitle("Y");
                        } else {
                            themeMapTag.setGroupFieldShowTitle("N");
                        }
                    } else {
                        themeMapTags.remove();
                    }
                }
            }
        }
    }

    /**
     * 运行时--产生
     * 坐标类 --固定位置
     * 1.修改ORDER值
     * 2.移除重复ORDER-TAG标签
     *
     * @param metadataTagResults
     */
    private void positionTagHandle(List<PcUiBotMetadataTagResult> metadataTagResults) {
        for (PcUiBotMetadataTagResult metadataTagResult : metadataTagResults) {
            Iterator themeMapTags = metadataTagResult.getTags().iterator();
            while (themeMapTags.hasNext()) {
                PcUiBotThemeMapTag themeMapTag = (PcUiBotThemeMapTag) themeMapTags.next();
                if (PcUiBotTagConstant.HEAD_TAG.equals(themeMapTag.getCode())) {
                    themeMapTag.setValue(PcUiBotTagConstant.HEAD_TAG);
                    themeMapTag.setUiBotCode(PcUiBotTagConstant.HEAD_TAG);
                    themeMapTag.setCategory(PcUiBotTagConstant.POSITION_TAG);
                }
            }
        }
    }

    /**
     * 运行时--产生
     * 坐标类 --固定位置
     * 1.修改ORDER值
     * 2.移除重复ORDER-TAG标签
     *
     * @param metadataTagResults
     */
    private void otherTagHandle(List<PcUiBotMetadataTagResult> metadataTagResults) {
        for (PcUiBotMetadataTagResult metadataTagResult : metadataTagResults) {
            Iterator themeMapTags = metadataTagResult.getTags().iterator();
            while (themeMapTags.hasNext()) {
                PcUiBotThemeMapTag themeMapTag = (PcUiBotThemeMapTag) themeMapTags.next();
                if (StringUtils.isBlank(themeMapTag.getUiBotCode())) {
                    themeMapTag.setCategory(PcUiBotTagConstant.CATEGORY_BUSINESS);
                    themeMapTag.setUiBotCode(themeMapTag.getCode());
                }
            }
        }
    }

}
