package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：dataSource 业务逻辑处理层</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskDataSourceAnalysisService.java
 * @Author: wangjwc
 * @Date: created at 2023/7/12 17:29
 */
@Service
public class TaskDataSourceAnalysisService extends DataSourceAnalysisServiceBase {

    public PcUiBotDataSourceSetDTO analysis(PcUiBotExecuteContext executeContext, PcUiBotTmDataState tmDataState, Map<String, PcUiBotTmQueryAction> dataSources, PcUiBotTmDataFilter tmDataFilter) {
        PcUiBotDataSourceSetDTO dataSourceSet = new PcUiBotDataSourceSetDTO();
        if (dataSources.size() == 0) {
            return dataSourceSet;
        }


        List<PcUiBotDataSourceDTO> dataSourceList = new ArrayList<>();
        dataSourceSet.setDataSourceList(dataSourceList);
        dataSourceSet.setDataProcess(new ArrayList<>());
        if (executeContext.getTaskWithBacklogDataList() != null) {
            //如果是配置合并查询
            if (tmDataState != null
                    && Boolean.TRUE.equals(tmDataState.getMergeQuery())) {
                for (Map.Entry<String, PcUiBotTmQueryAction> stringTmQueryActionEntry : dataSources.entrySet()) {
                    //做合并查询，可以只调用一次api即可，提高效率
                    PcUiBotDataSourceDTO dataSourceDTO = this.createBatchQueryBacklog(executeContext, stringTmQueryActionEntry.getKey(), stringTmQueryActionEntry.getValue(), executeContext.getTaskWithBacklogDataList(), executeContext.getProjectData(), tmDataFilter, false);
                    if (dataSourceDTO != null) {
                        dataSourceDTO.setMetadataFields(stringTmQueryActionEntry.getValue().getMetadataFields());
                        dataSourceList.add(dataSourceDTO);

                    }
                }
            } else {
                for (DigiwinAtmcTaskWithBacklogData taskWithBacklogData : executeContext.getTaskWithBacklogDataList()) {
                    for (Map.Entry<String, PcUiBotTmQueryAction> stringTmQueryActionEntry : dataSources.entrySet()) {
                        PcUiBotTmQueryAction queryAction = stringTmQueryActionEntry.getValue();
                        PcUiBotDataSourceDTO dataSourceBase = create(executeContext, stringTmQueryActionEntry.getKey(), queryAction, taskWithBacklogData, executeContext.getProjectData(), tmDataFilter);

                        if (dataSourceBase != null) {
                            dataSourceList.add(dataSourceBase);
                        }
                    }
                }
            }
        }
        for (PcUiBotTmQueryAction queryAction : dataSources.values()) {
            if (!CollectionUtils.isEmpty(queryAction.getDataProcessors())) {
                for (PcUiBotTmDataProcess dataProcessor : queryAction.getDataProcessors()) {
                    if (PcUiBotConstants.DATA_PROCESS_ACTIVE_POINT_EXECUTE_COMPLETED.equals(dataProcessor.getActivePoint())) {
                        dataSourceSet.getDataProcess().add(dataProcessor);
                    }
                }
            }
        }
        return dataSourceSet;
    }

}
