package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import cn.hutool.core.map.MapUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotActionServiceId;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotConstants;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitAction;
import org.springframework.stereotype.Service;

import java.util.*;

@Service
public class TaskEngineActionCreateService extends ActionCreateServiceBase {

    private static HashMap<BpmServiceInvokeType, String> uriMap = new HashMap<>();

    TaskEngineActionCreateService() {
        //终止项目
        uriMap.put(BpmServiceInvokeType.TerminateProcess, "api/project/terminate");

        //终止任务
        uriMap.put(BpmServiceInvokeType.TerminateTask, "api/task/terminate");

        //提交数据，一般任务的提交
        uriMap.put(BpmServiceInvokeType.SubmitData, "api/task/manual/submit-data");

        //提交数据，发起新项目
        uriMap.put(BpmServiceInvokeType.StartNewProject, "api/task/manual/submit-data");

        //提交、派送，一般任务的提交，关卡推进
        uriMap.put(BpmServiceInvokeType.Dispatch, "v2/api/backlog/dispatch");

        //人工任务转派，般任务的转派
        uriMap.put(BpmServiceInvokeType.TaskEngineReAssign, "api/task/manual/reassign");

        //同意、派送，用于签核关卡的同意
        uriMap.put(BpmServiceInvokeType.Agree, "v2/api/workitem/approve/agree");

        //不同意，用于签核关卡的不同意、拒绝
        uriMap.put(BpmServiceInvokeType.Disagree, "v2/api/workitem/approve/disagree");

        //转派，用于签核关卡的转派
        uriMap.put(BpmServiceInvokeType.ReAssign, "api/task/approve/work/reassign");

        //退回重办，用于签核关卡的退回重办
        uriMap.put(BpmServiceInvokeType.ReExecute, "v2/api/workitem/approve/re-do");

        //退回重签，用于签核关卡的退回重签
        uriMap.put(BpmServiceInvokeType.ReApprove, "v2/api/workitem/approve/re-sign");

        //加签，用于签核关卡的加签
        uriMap.put(BpmServiceInvokeType.AddTask, "v2/api/workitem/approve/add");

        //撤回，用于撤回已完成的任务
        uriMap.put(BpmServiceInvokeType.Retrieve, "api/task/card/retrieve");

        //更新bpmdata
        uriMap.put(BpmServiceInvokeType.UpdateData, "v2/api/workitem/data/update");
        // 项目卡退回；ptm接口
        uriMap.put(BpmServiceInvokeType.TaskReturn, "api/task/card/taskReturn");
    }

    public PcUiBotSubmitAction createAction(String serviceName, DigiwinAtmcTaskWithBacklogData taskWithBacklogData, String dataFrom) {
        BpmServiceInvokeType invokeType = BpmServiceInvokeType.nameOf(serviceName);
        PcUiBotSubmitAction action = createSubmitAction(invokeType, taskWithBacklogData, dataFrom);

        Map<String, Object> paras = action.getParas();
        DigiwinAtmcBacklogData backlogData = taskWithBacklogData.getBacklog().get(0);

        switch (invokeType) {
            case Dispatch:
                //region 关卡派送特殊处理
                if (action.getExtendParas() == null) {
                    action.setExtendParas(new HashMap<>());
                }
                if (!action.getExtendParas().containsKey("dataSource")) {
                    //如果没有设置提交的数据源，则设置父节点转换后的结果
                    action.getExtendParas().put("dataSource", "parent");
                }
                break;
            //endregion

            case TaskEngineReAssign:
            case ReAssign:
                //region 普通关卡、签核关卡转派
                paras.put("newPerformerId", "");
                break;
            //endregion

            case ReApprove:
                //region 签核关卡-退回重签
                paras.put("activityId", "");
                break;
            //endregion

            case AddTask:
                //region 签核关卡-加签
                //  addType	加签类型	Forward->向前加签；BackwardDispatch->向后加签
                //      默认向后加签
                paras.put("addType", "BackwardDispatch");

                //加签关卡集合，目前只支持一个
                List<Map<String, Object>> activities = new ArrayList<>();
                Map<String, Object> activity = new HashMap<>();
                activity.put("activityName", backlogData.getPerformerName() + " " + "加签");
                activity.put("signType", "single");
                activity.put("performerIds", "");
                activities.add(activity);

                paras.put("activities", activities);
                break;
            //endregion

            case SubmitData:
            case UpdateData:
            case StartNewProject:
                //region 提交数据
                if (paras.containsKey("dispatchData")) {
                    List<Map<String, Object>> dispatchData = new ArrayList<>();
                    paras.put("dispatchData", dispatchData);
                }
                break;
            //endregion

            default:
                break;
        }

        return action;
    }

    /**
     * 创建 查询 ACTION
     *
     * @return
     */
    private PcUiBotSubmitAction createSubmitAction(BpmServiceInvokeType invokeType, DigiwinAtmcTaskWithBacklogData taskWithBacklogData, String dataFrom) {
        if (!uriMap.containsKey(invokeType)) {
            String message = "暂不支持当前类型的提交:" + invokeType.getName();
            throw new ServiceException(message);
        }
        if (invokeType == BpmServiceInvokeType.TerminateProcess) {
            return createTerminateProcessAction(taskWithBacklogData);
        } else if (invokeType == BpmServiceInvokeType.TerminateTask) {
            return createTerminateTaskAction(taskWithBacklogData);
        }

        DigiwinAtmcBacklogData backlogData = taskWithBacklogData.getBacklog().get(0);
        // 非空判断
        //理论上 getWorkitemList 中应该只有一个元素
        Map<String, Object> map = backlogData.getWorkitemList().get(0);
        String performerId = MapUtil.getStr(map, "performerId");
        String workitemId = MapUtil.getStr(map, "workitemId");
//        String performerName = backlogData.getWorkitemList().get(0).get("performerName").toString();
        Integer performerType = MapUtil.getInt(map, "performerType");
        if (Objects.equals(backlogData.getWorkitemList().get(0).get("state"), 3)) {
            //如果已经执行完成的，改为0。因为这里生成的是未完成的任务的action，对于已经执行完的任务，不能使用其原来的值
            performerType = 0;
        }

        String serviceUri = uriMap.get(invokeType);
        PcUiBotSubmitAction action = new PcUiBotSubmitAction();
        action.setTitle(invokeType.getTitle());
        action.setCategory(PcUiBotConstants.ACTION_CATEGORY_BPM_TASK_ENGINE);
        action.setServiceId(this.createActionServiceId(serviceUri, invokeType.getName()));
        action.setTrackCode(PcUiBotConstants.DEFAULT_BUTTON_TRACK_CODE);
        //设置通用参数
        Map<String, Object> paras = new HashMap<>();
        String workItemId = workitemId;
        if (workItemId == null) {
            String message = String.format("任务的workitemId为空，任务%s有异常", backlogData.getBacklogId());
            throw new ServiceException(message);
        }
        paras.put("workitemId", workitemId);
        paras.put("performerType", performerType);
        paras.put("performerId", performerId);
        if (!Objects.equals(performerId, AppRequestContext.getContextEntity().getUserId())) {
            //如果待办人员和当前人员不是同一个人，则指定为代理人
            paras.put("performerType", 1);
            paras.put("agentPerformerId", AppRequestContext.getContextEntity().getUserId());
        }
        paras.put("comment", "");
        paras.put("locale", AppRequestContext.getContextEntity().getLocale());
        action.setParas(paras);

        if (Objects.equals(dataFrom, PcUiBotConstants.ACTION_CATEGORY_BPM_PTM)
                && (invokeType == BpmServiceInvokeType.SubmitData
                || invokeType == BpmServiceInvokeType.TaskEngineReAssign)) {
            action.setCategory(PcUiBotConstants.ACTION_CATEGORY_BPM_PTM);
            paras.put("backlogId", backlogData.getPtmBacklogId());

            List<Map> dispatchDataList = new ArrayList<>();
            paras.put("dispatchData", dispatchDataList);

            if (invokeType == BpmServiceInvokeType.SubmitData) {
                action.getServiceId().setServiceUri("api/task/card/submit");
            } else {
                action.getServiceId().setServiceUri("api/task/card/reassign");
            }
        }

        return action;
    }

    /**
     * 创建终止项目的 action
     *
     * @param taskWithBacklogData
     * @return
     */
    private PcUiBotSubmitAction createTerminateProcessAction(DigiwinAtmcTaskWithBacklogData taskWithBacklogData) {
        BpmServiceInvokeType invokeType = BpmServiceInvokeType.TerminateProcess;
        if (!uriMap.containsKey(invokeType)) {
            String message = "暂不支持当前类型的提交:" + invokeType.getName();
            throw new ServiceException(message);
        }

        DigiwinAtmcBacklogData backlogData = taskWithBacklogData.getBacklog().get(0);

        //理论上 getWorkitemList 中应该只有一个元素
        String performerId = backlogData.getWorkitemList().get(0).get("performerId").toString();
        Integer performerType = Integer.parseInt(backlogData.getWorkitemList().get(0).get("performerType").toString());
        if (Objects.equals(backlogData.getWorkitemList().get(0).get("state"), 3)) {
            //如果已经执行完成的，改为0。因为这里生成的是未完成的任务的action，对于已经执行完的任务，不能使用其原来的值
            performerType = 0;
        }
        String serviceUri = uriMap.get(invokeType);
        PcUiBotSubmitAction action = new PcUiBotSubmitAction();
        action.setTitle(invokeType.getTitle());
        action.setCategory(PcUiBotConstants.ACTION_CATEGORY_BPM_TASK_ENGINE);
        action.setServiceId(this.createActionServiceId(serviceUri, invokeType.getName()));
        //设置通用参数
        Map<String, Object> paras = new HashMap<>();
        paras.put("serialNumber", taskWithBacklogData.getProcessSerialNumber());
        paras.put("performerType", performerType);
        paras.put("performerId", performerId);
        if (!Objects.equals(performerId, AppRequestContext.getContextEntity().getUserId())) {
            //如果待办人员和当前人员不是同一个人，则指定为代理人
            paras.put("performerType", 1);
            paras.put("agentPerformerId", AppRequestContext.getContextEntity().getUserId());
        }
        paras.put("comment", "");
        paras.put("locale", AppRequestContext.getContextEntity().getLocale());
        action.setParas(paras);
        return action;
    }

    /**
     * 创建终止任务的 action
     *
     * @param taskWithBacklogData
     * @return
     */
    public PcUiBotSubmitAction createTerminateTaskAction(DigiwinAtmcTaskWithBacklogData taskWithBacklogData) {
        BpmServiceInvokeType invokeType = BpmServiceInvokeType.TerminateTask;
        if (!uriMap.containsKey(invokeType)) {
            String message = "暂不支持当前类型的提交:" + invokeType.getName();
            throw new ServiceException(message);
        }

        //理论上 getWorkitemList 中应该只有一个元素
        String taskUid = taskWithBacklogData.getTaskUid();

        String serviceUri = uriMap.get(invokeType);
        PcUiBotSubmitAction action = new PcUiBotSubmitAction();
        action.setTitle(invokeType.getTitle());
        action.setCategory(PcUiBotConstants.ACTION_CATEGORY_BPM_TASK_ENGINE);
        action.setServiceId(this.createActionServiceId(serviceUri, invokeType.getName()));
        //设置通用参数
        Map<String, Object> paras = new HashMap<>();
        paras.put("taskUids", Arrays.asList(taskUid));
        action.setParas(paras);
        return action;
    }

    /**
     * 创建服务信息节点
     *
     * @param serviceUri
     * @param name
     */
    private PcUiBotActionServiceId createActionServiceId(String serviceUri, String name) {
        PcUiBotActionServiceId actionServiceId = new PcUiBotActionServiceId();
        actionServiceId.setServiceUri(serviceUri);
        actionServiceId.setName(name);
        return actionServiceId;
    }


}


