package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProjectData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotMessageUtils;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotSubmitActionUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * <p>功能描述：提交ACTION 服务</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskSubmitActionCreateService.java
 * @Author: wangjwc
 * @Date: created at 2023/7/13 9:36
 */
@Service
public class TaskSubmitActionCreateService extends ActionCreateServiceBase {

    @Autowired
    private BpmActionCreateService bpmService;

    public PcUiBotSubmitAction create(PcUiBotExecuteContext executeContext, DigiwinAtmcProjectData projectData, DigiwinAtmcTaskWithBacklogData taskWithBacklogData, PcUiBotTmAction tmAction) {

        PcUiBotSubmitAction action = createSubmitActionInternal(executeContext, projectData, taskWithBacklogData, tmAction);
        action.setExecuteContext(PcUiBotSubmitExecuteContext.create(executeContext, taskWithBacklogData));
        if (tmAction.getIsCustomize() != null && tmAction.getIsCustomize()) {
            action.setIsCustomize(true);
            action.setUuid(tmAction.getUuid());
            action.setBtnId(tmAction.getBtnId());
            action.setBtnType(tmAction.getBtnType());
            action.setJumpAction(tmAction.getJumpAction());
            action.setTitle(tmAction.getTitle());
            action.setType(tmAction.getType());
            action.setSubmitType(tmAction.getSubmitType());
            if (tmAction.getSchema() != null) {
                action.setSchema(tmAction.getSchema());
            }
        }
        if (tmAction.isDispatch()) {
            //附加工作流推送关卡
            PcUiBotSubmitAction agreeAction = createAgreeAction(taskWithBacklogData, taskWithBacklogData.getBacklog().get(0));
            action.getAttachActions().add(agreeAction);
        }
        if (tmAction.isTerminateProcess()) {
            //附加工作流推送关卡
            PcUiBotSubmitAction agreeAction = createTerminateProcessAction(taskWithBacklogData, taskWithBacklogData.getBacklog().get(0));
            action.getAttachActions().add(agreeAction);
        }

        action.setExecuteAfterCheckCompleted(tmAction.getExecuteAfterCheckCompleted());
        return action;
    }


    /**
     * TODO:xuxx 需要改造，从BpmServiceInvokeType类中去取定义的tmAction.getServiceName()
     *
     * @param executeContext
     * @param projectData
     * @param taskWithBacklogData
     * @param tmAction
     * @return
     */
    private PcUiBotSubmitAction createSubmitActionInternal(PcUiBotExecuteContext executeContext, DigiwinAtmcProjectData projectData, DigiwinAtmcTaskWithBacklogData taskWithBacklogData, PcUiBotTmAction tmAction) {
        PcUiBotSubmitAction action = null;
        if (PcUiBotActivityConstants.TmActionType.BPM.equals(tmAction.getType())) {
            if (Objects.equals("dispatch", tmAction.getServiceName()) || Objects.equals("agree", tmAction.getServiceName())) {
                action = this.createAgreeAction(taskWithBacklogData, taskWithBacklogData.getBacklog().get(0));
            } else if (Objects.equals("terminate", tmAction.getServiceName())) {
                action = this.createRejectAction(taskWithBacklogData, taskWithBacklogData.getBacklog().get(0));
            } else if (Objects.equals("reassign", tmAction.getServiceName())) {
                action = this.createReassignAction(taskWithBacklogData, taskWithBacklogData.getBacklog().get(0));
            } else if (Objects.equals("reexecute", tmAction.getServiceName())) {
                action = this.createReExecuteAction(taskWithBacklogData, taskWithBacklogData.getBacklog().get(0));
            } else if (Objects.equals("terminate-process", tmAction.getServiceName())) {
                action = this.createTerminateProcessAction(taskWithBacklogData, taskWithBacklogData.getBacklog().get(0));
            } else if (Objects.equals("reapprove", tmAction.getServiceName())) {
                action = this.createReApproveAction(taskWithBacklogData, taskWithBacklogData.getBacklog().get(0));
            } else if (Objects.equals("add-task", tmAction.getServiceName())) {
                action = this.createAddTaskAction(taskWithBacklogData, taskWithBacklogData.getBacklog().get(0));
            } else if (Objects.equals("reject", tmAction.getServiceName())) {
                action = this.createRejectAction(taskWithBacklogData, taskWithBacklogData.getBacklog().get(0));
            }
            if (action != null) {
                action.setUuid(tmAction.getUuid());
                action.setBtnId(tmAction.getBtnId());
                action.setBtnType(tmAction.getBtnType());
                action.setJumpAction(tmAction.getJumpAction());
                action.setActionId(tmAction.getActionId());
                action.setTitle(PcUiBotMessageUtils.getMessageByCurrentLanguage(tmAction.getTitle()));
                action.setActionParams(tmAction.getActionParams());
            }
        } else if (PcUiBotActivityConstants.TmActionType.COMBINE.equals(tmAction.getType())) {
            // todo

        } else {
            action = this.createSubmitAction(tmAction, projectData.getTenantId(), taskWithBacklogData.getBusinessUnit(), executeContext);
            action.setDefaultAction(true);
            action.setCategory(tmAction.getType());
        }
        if (action != null) {
            action.setDefaultAction(tmAction.isDefaultAction());
            action.setAttachActions(this.createAttachActions(executeContext, projectData, taskWithBacklogData, tmAction));
        } else {
            String message = "不支持的action定义，请检查配置:" + tmAction.getActionId() + tmAction.getType();
            throw new ServiceException(message);
        }
        action.setId(tmAction.getId());
        if (StringUtils.isBlank(action.getTrackCode())) {
            String trackCode = StringUtils.isNotBlank(tmAction.getTrackCode()) ? tmAction.getTrackCode() : PcUiBotConstants.DEFAULT_BUTTON_TRACK_CODE;
            action.setTrackCode(trackCode);
        }
        action.setSubmitType(tmAction.getSubmitType());

        // 设置禁用、隐藏等条件
        PcUiBotSubmitActionUtil.setCondition(tmAction, action);
        return action;
    }

    /**
     * 创建 查询 ACTION
     *
     * @param tmAction
     * @param tenantId
     * @return
     */
    private PcUiBotSubmitAction createSubmitAction(PcUiBotTmAction tmAction, String tenantId, Map<String, Object> businessUnit, PcUiBotExecuteContext executeContext) {
        appendActionInfo(tmAction, executeContext);
        PcUiBotSubmitAction action = new PcUiBotSubmitAction();
        action.setActionId(tmAction.getActionId());
        action.setServiceId(this.createActionServiceId(tmAction, tenantId));
        action.setCategory(tmAction.getType());
        action.setUuid(tmAction.getUuid());
        action.setBtnId(tmAction.getBtnId());
        action.setBtnType(tmAction.getBtnType());
        action.setJumpAction(tmAction.getJumpAction());
        action.setTitle(tmAction.getTitle());
        action.setReturnText(tmAction.getReturnText());
        action.setBusinessUnit(businessUnit);
        action.executeExtendParas(tmAction.getExtendParas(), executeContext);
        action.setExtendParas(tmAction.getExtendParas());
        action.setAddShowFileds(tmAction.getAddShowFileds());
        action.setBackFills(tmAction.getBackFills());
        action.setTargetDataState(tmAction.getTargetDataState());
        action.setConfirm(tmAction.getConfirm());
        action.setActionType(tmAction.getActionType());
        //兼容性处理，迭代14兼容迭代13的配置
        if (action.getActionType() == null
                && tmAction.getExtendParas() != null
                && tmAction.getExtendParas().containsKey("actionType")) {
            action.setActionType(tmAction.getExtendParas().get("actionType").toString());
        }
        action.setId(tmAction.getId());
        action.setActionParams(tmAction.getActionParams());
        action.setCategory(tmAction.getType());
        action.setActionParams(tmAction.getActionParams());

        action.setDefaultAction(true);
        action.setId(tmAction.getId());
        action.executeExtendParas(tmAction.getExtendParas(), executeContext);
        action.setExtendParas(tmAction.getExtendParas());
        action.setAddShowFileds(tmAction.getAddShowFileds());
        action.setDefaultAction(tmAction.isDefaultAction());
        action.setActionScript(tmAction.getActionScript());
        processActionParas(action, executeContext);
        return action;
    }


    /**
     * 创建attach
     *
     * @param projectData
     * @param tmAction
     * @param taskWithBacklogData
     * @return
     */
    private List<PcUiBotSubmitAction> createAttachActions(PcUiBotExecuteContext executeContext, DigiwinAtmcProjectData projectData, DigiwinAtmcTaskWithBacklogData taskWithBacklogData, PcUiBotTmAction tmAction) {
        List<PcUiBotSubmitAction> attachActions = new ArrayList<>();
        if (CollectionUtils.isEmpty(tmAction.getAttachActions())) {
            return attachActions;
        }
        tmAction.getAttachActions().forEach(attachAction -> {
            PcUiBotSubmitAction submitAction = create(executeContext, projectData, taskWithBacklogData, attachAction);
            submitAction.setExecuteContext(null);
            attachActions.add(submitAction);
        });
        return attachActions;
    }


    public PcUiBotSubmitAction createAgreeAction(DigiwinAtmcTaskWithBacklogData taskData, DigiwinAtmcBacklogData backlogData) {
        PcUiBotSubmitAction action = bpmService.createAgreeAction(taskData, backlogData);
        action.setDefaultAction(true);
        action.setTitle("同意");
        action.setActionId(BpmServiceInvokeType.Agree.getName());
        return action;
    }


    /**
     * 创建拒绝的submitAction
     *
     * @return
     */
    public PcUiBotSubmitAction createRejectAction(DigiwinAtmcTaskWithBacklogData taskData, DigiwinAtmcBacklogData backlogData) {
        PcUiBotSubmitAction action = bpmService.createRejectAction(taskData, backlogData);
        action.setTitle("backlog.activity.reject");
        action.setDefaultAction(false);
        action.setActionId(BpmServiceInvokeType.Reject.getName());
//        action.setTaskWithBacklogData(taskData);
        return action;
    }


    /**
     * 创建拒绝的submitAction
     *
     * @return
     */
    public PcUiBotSubmitAction createTerminateProcessAction(DigiwinAtmcTaskWithBacklogData taskData, DigiwinAtmcBacklogData backlogData) {
        PcUiBotSubmitAction action = bpmService.createTerminateProcessAction(taskData, backlogData);
        action.setTitle("拒绝");
        action.setDefaultAction(false);
        action.setActionId(BpmServiceInvokeType.TerminateProcess.getName());
        return action;
    }

    /**
     * 创建转派的submitAction
     *
     * @return
     */
    public PcUiBotSubmitAction createReassignAction(DigiwinAtmcTaskWithBacklogData taskData, DigiwinAtmcBacklogData backlogData) {
        PcUiBotSubmitAction action = bpmService.createAction(taskData, backlogData, BpmServiceInvokeType.ReAssign);
        action.setTitle("转派");
        action.setDefaultAction(false);
        action.setActionId(BpmServiceInvokeType.ReAssign.getName());
//        action.setTaskWithBacklogData(taskData);
        return action;
    }

    /**
     * 创建退回的submitAction
     *
     * @return
     */
    public PcUiBotSubmitAction createReExecuteAction(DigiwinAtmcTaskWithBacklogData taskData, DigiwinAtmcBacklogData backlogData) {
        PcUiBotSubmitAction action = bpmService.createAction(taskData, backlogData, BpmServiceInvokeType.ReExecute);
        action.setTitle("退回");
        action.setDefaultAction(false);
        action.setActionId(BpmServiceInvokeType.ReExecute.getName());
//        action.setTaskWithBacklogData(taskData);
        return action;
    }

    /**
     * 创建重签的submitAction
     *
     * @return
     */
    public PcUiBotSubmitAction createReApproveAction(DigiwinAtmcTaskWithBacklogData taskData, DigiwinAtmcBacklogData backlogData) {
        PcUiBotSubmitAction action = bpmService.createAction(taskData, backlogData, BpmServiceInvokeType.ReApprove);
        action.setTitle("重签");
        action.setDefaultAction(false);
        action.setActionId(BpmServiceInvokeType.ReExecute.getName());
//        action.setTaskWithBacklogData(taskData);
        return action;
    }

    /**
     * 创建加签的submitAction
     *
     * @return
     */
    public PcUiBotSubmitAction createAddTaskAction(DigiwinAtmcTaskWithBacklogData taskData, DigiwinAtmcBacklogData backlogData) {
        PcUiBotSubmitAction action = bpmService.createAction(taskData, backlogData, BpmServiceInvokeType.AddTask);
//        action.setTitle(messageUtils.getMessage("backlog.activity.reapprove"));
        action.setDefaultAction(false);
        action.setActionId(BpmServiceInvokeType.ReExecute.getName());
//        action.setTaskWithBacklogData(taskData);
        return action;
    }

}
