package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotAttachmentUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>功能描述：ThemeMap定义的审核信息</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TmApprovalService.java
 * @Author: wangjwc
 * @Date: created at 2023/7/13 11:44
 */
@Service
public class TmApprovalService {

    @Autowired
    private TaskSubmitActionCreateService submitActionCreateService;

    @Autowired
    private LocaleService localeService;

    /**
     * 分析ThemeMap定义的审核信息
     */
    public void process(PcUiBotExecuteContext executeContext, PcUiBotTmActivity tmActivity, PcUiBotTmDataState dataState, PcUiBotTaskPageDefine actionVO) {
        if (executeContext.isShared()) {
            //如果分享的，不解析submitAction
            //  注意：还有一个 isNotShared()
            return;
        }
        if (CollectionUtils.isEmpty(executeContext.getTaskWithBacklogDataList())) {
            return;
        }
        if (!actionVO.isDefaultShow()) {
            return;
        }
        if (!Objects.equals(executeContext.getIdentity(), PcUiBotActivityConstants.PERFORMER)) {
            return;
        }
        DigiwinAtmcTaskWithBacklogData taskWithBacklogData = executeContext.getTaskWithBacklogData();
        List<PcUiBotTmAction> submits = null;
        //1、优先使用新的签核配置
        //sequence|decision，顺序签核｜核决

        if (tmActivity.getApprove() != null) {
            if ("sequence".equals(tmActivity.getApprove().getType()) && tmActivity.getApprove().getSequence() != null) {
                List<PcUiBotTmSequence> sequence = tmActivity.getApprove().getSequence();
                //配置的key必须要推送任务的id一致，或者必须是加签，如果都不是，则默认返回第一个
                if (sequence.size() == 1) {
                    submits = tmActivity.getApprove().getSequence().get(0).getSubmits();
                } else {
                    for (PcUiBotTmSequence tmSequence : sequence) {
                        if (Objects.equals(taskWithBacklogData.getBpmActivityId(), tmSequence.getKey())
                                || (taskWithBacklogData.getBpmActivityId().contains("-ADD-") && taskWithBacklogData.getBpmActivityId().startsWith(tmSequence.getKey()))) {
                            submits = tmSequence.getSubmits();
                            break;
                        }
                    }
                }
            } else if ("decision".equals(tmActivity.getApprove().getType()) && tmActivity.getPages() != null) {
                //如果是核决，则需要取page上定义的提交
                submits = tmActivity.getPages().getSubmitActions();
            }
        }

        if (submits == null && tmActivity.getApproves() != null) {
            //2、如果没有则使用旧的，后续需要把旧的删除掉
            //配置的key必须要推送任务的id一致，或者必须是加签，如果都不是，则默认返回第一个
            if (tmActivity.getApproves().size() == 1) {
                submits = tmActivity.getApproves().get(0).getSubmits();
            } else {
                for (PcUiBotTmApproval tmApproval : tmActivity.getApproves()) {
                    if (Objects.equals(taskWithBacklogData.getBpmActivityId(), tmApproval.getKey())
                            || (taskWithBacklogData.getBpmActivityId().contains("-ADD-") && taskWithBacklogData.getBpmActivityId().startsWith(tmApproval.getKey()))) {
                        submits = tmApproval.getSubmits();
                        break;
                    }
                }
            }
        }
        if (!CollectionUtils.isEmpty(submits)) {
            // 为按钮设置 附件提交后才生效的attachAction
            PcUiBotAttachmentUtil.appendEffectAfterSubmitAction(executeContext, tmActivity.getAttachment(), submits);
            List<PcUiBotSubmitAction> actionsList = new ArrayList<>();
            for (PcUiBotTmAction tmAction : submits) {
                PcUiBotSubmitAction submitAction = submitActionCreateService.create(executeContext, executeContext.getProjectData(), taskWithBacklogData, tmAction);
                if (submitAction != null) {

                    submitAction.setSubmitType(dataState.getSubmitType());
                    if (submitAction.getSubmitType() == null) {
                        if (dataState.getSubmitType() != null) {
                            submitAction.setSubmitType(dataState.getSubmitType());
                        } else {
                            PcUiBotSubmitType submitType = new PcUiBotSubmitType();
                            submitType.setIsBatch(false);
                            submitType.setSchema(actionVO.getDataSourceSet().getMainDatasource());
                            submitAction.setSubmitType(submitType);
                            dataState.setSubmitType(submitType);
                        }
                    }

                    setApprovalActionStartApproveActivity(submitAction, tmActivity);

                    actionsList.add(submitAction);
                }
            }
            if (actionsList.size() > 0) {
                actionsList.get(0).setDefaultAction(true);
            }
            actionVO.setSubmitActions(actionsList);

            String finishedActionId = taskWithBacklogData.getBacklog().get(0).getFinishedActionId();
            if (!StringUtils.isEmpty(finishedActionId)) {
                //任务合并时，如果有多个 taskWithBacklogData ,优先使用未完成的
                for (DigiwinAtmcTaskWithBacklogData withBacklogData : executeContext.getTaskWithBacklogDataList()) {
                    if (StringUtils.isEmpty(withBacklogData.getBacklog().get(0).getFinishedActionId())) {
                        finishedActionId = null;
                        break;
                    }
                }
            }
            if (!StringUtils.isEmpty(finishedActionId)) {
                backlogFinishedByApprove(actionVO, submits, finishedActionId);
            }
        }
    }

//    /**
//     * 设置提交按钮执行上下文
//     * @param submitAction
//     * @param executeContext
//     * @param tmActivity
//     * @param activityData
//     */
//    private void setSubmitExecuteContext(SubmitAction submitAction, ExecuteContext executeContext, TmActivity tmActivity, ActivityData activityData){
//        SubmitExecuteContext newExecuteContext = SubmitExecuteContext.builder()
//                .pageCode(executeContext.getPageCode())
//                .pattern(executeContext.getPattern())
//                .category(tmActivity.getCategory())
//                .tmActivityId(tmActivity.getActivityId())
//                .tmProjectId(activityData.getProject().getTmProjectId())
//                .locale(executeContext.getLocale())
//                .clientAgent(executeContext.getClientAgent())
//                .deviceType(executeContext.getDeviceType())
//                .proxyToken(executeContext.getProxyToken())
//                .authoredUser(executeContext.getAuthoredUser())
//                .businessUnit(activityData.getTasks().get(0).getBusinessUnit())
//                .backlogId(activityData.getTasks().get(0).getBacklog().get(0).getBacklogId())
//                .bpmData(activityData.getTasks().get(0).getBpmData())
//                .processSerialNumber(activityData.getTasks().get(0).getProcessSerialNumber())
//                .build();
//        submitAction.setExecuteContext(newExecuteContext);
//    }

    public void setApprovalActionStartApproveActivity(PcUiBotSubmitAction submitAction, PcUiBotTmActivity tmActivity) {
        if ((PcUiBotConstants.ACTION_CATEGORY_BPM.equals(submitAction.getCategory())
                || PcUiBotConstants.ACTION_CATEGORY_BPM_TASK_ENGINE.equals(submitAction.getCategory()))
                && PcUiBotActivityConstant.APPROVAL_STEP_REAPPVORE_NAME.equals(submitAction.getServiceId().getName())) {
            //退回重签，直接使用当前任务ID
            List<String> startApproveActivity = new ArrayList<>();
            startApproveActivity.add(tmActivity.getActivityId());
            submitAction.setStartApproveActivity(startApproveActivity);
        } else if ((PcUiBotConstants.ACTION_CATEGORY_BPM.equals(submitAction.getCategory())
                || PcUiBotConstants.ACTION_CATEGORY_BPM_TASK_ENGINE.equals(submitAction.getCategory()))
                && PcUiBotActivityConstant.APPROVAL_STEP_REEXECUTE_NAME.equals(submitAction.getServiceId().getName())) {
            //退回重办，使用ThemeMap中设置的startApproveActivity
            submitAction.setStartApproveActivity(tmActivity.getStartApproveActivity());
        }

        if (!CollectionUtils.isEmpty(submitAction.getAttachActions())) {
            for (PcUiBotSubmitAction attachAction : submitAction.getAttachActions()) {
                setApprovalActionStartApproveActivity(attachAction, tmActivity);
            }
        }
    }

    private void backlogFinishedByApprove(PcUiBotTaskPageDefine action, List<PcUiBotTmAction> tmSubmitActions, String finishedActionId) {
        action.setFinished(true);
        action.setOperations(null);
//        action.setMultipleSelect(false);
        action.setSubmitActions(null);
        if (!CollectionUtils.isEmpty(tmSubmitActions)) {
            for (PcUiBotTmAction tmSubmitAction : tmSubmitActions) {
                if (Objects.equals(tmSubmitAction.getId(), finishedActionId) || Objects.equals(tmSubmitAction.getActionId(), finishedActionId)) {
                    if (StringUtils.isEmpty(tmSubmitAction.getReturnText())) {
                        action.setFinishedTitle(tmSubmitAction.getTitle());
                    } else {
                        action.setFinishedTitle(tmSubmitAction.getReturnText());
                    }
                    return;
                }
            }
        }

        String locale = Optional.ofNullable(action.getExecuteContext())
                .map(PcUiBotExecuteContext::getLocale).orElse("zh_CN");

        if (StringUtils.isEmpty(action.getFinishedTitle())) {
            if (Objects.equals(finishedActionId, "athena_bpm_reassign")) {
                action.setFinishedTitle(localeService.getLanguageValue(locale, "转派"));
            } else if (Objects.equals(finishedActionId, "athena_bpm_cancel")) {
                action.setFinishedTitle(localeService.getLanguageValue(locale, "撤销"));
            } else if (Objects.equals(finishedActionId, PcUiBotConstants.UIBOT_RETRIEVE)) {
                action.setFinishedTitle(localeService.getLanguageValue(locale, "已撤回"));
            } else if (Objects.equals(finishedActionId, "uibot_action_id_finished")) {
                action.setFinishedTitle(localeService.getLanguageValue(locale, "已结束"));
            }
        }

    }

}
