package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotConstants;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceSetDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataProcess;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmQueryAction;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @description: dataSource 业务逻辑处理层
 **/
@Service
public class TmDataSourceService extends DataSourceAnalysisServiceBase {

    /**
     * 为基础数据录入解析数据源，只支持Esp数据源
     *
     * @param executeContext
     * @param dataSources
     * @return
     */
    public PcUiBotDataSourceSetDTO analysis(PcUiBotExecuteContext executeContext, Map<String, PcUiBotTmQueryAction> dataSources) {
        PcUiBotDataSourceSetDTO dataSourceSet = new PcUiBotDataSourceSetDTO();
        if (CollectionUtils.isEmpty(dataSources)) {
            return dataSourceSet;
        }

        dataSourceSet.setDataSourceList(Lists.newArrayList());
        List<PcUiBotDataSourceDTO> dataSourceList = dataSourceSet.getDataSourceList();

        for (Map.Entry<String, PcUiBotTmQueryAction> tmQueryActionEntry : dataSources.entrySet()) {
            PcUiBotTmQueryAction queryAction = tmQueryActionEntry.getValue();
            PcUiBotDataSourceDTO dataSourceBase = createDataSourceWithoutTask(executeContext, tmQueryActionEntry.getKey(), queryAction);
            if (dataSourceBase != null) {
                // 查询前多少行数据
                dataSourceBase.setLimit(queryAction.getLimit());
                dataSourceBase.setNotArray(queryAction.getNotArray());
                dataSourceBase.setMetadataFields(queryAction.getMetadataFields());
                dataSourceList.add(dataSourceBase);
            }
        }
        //加上全局的数据处理器
        for (PcUiBotTmQueryAction queryAction : dataSources.values()) {
            if (!CollectionUtils.isEmpty(queryAction.getDataProcessors())) {
                for (PcUiBotTmDataProcess dataProcessor : queryAction.getDataProcessors()) {
                    if (PcUiBotConstants.DATA_PROCESS_ACTIVE_POINT_EXECUTE_COMPLETED.equals(dataProcessor.getActivePoint())) {
                        if (null == dataSourceSet.getDataProcess()) {
                            dataSourceSet.setDataProcess(new ArrayList<>());
                        }
                        dataSourceSet.getDataProcess().add(dataProcessor);
                    }
                }
            }
        }
        return dataSourceSet;
    }
}
