package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcActivityData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmActivity;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmPage;
import org.springframework.stereotype.Service;

import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Service
public class TmOtherInfoService {

    public void analysis(List<PcUiBotPageDefine> pageDefines, PcUiBotTmActivity tmActivity, DigiwinAtmcActivityData activityData) {

        PcUiBotTmPage tmPage = tmActivity.getPages();
        Optional<DigiwinAtmcTaskWithBacklogData> bpmDataOption = activityData.getTasks().stream().findFirst();

        Map<String, Object> bpmData = bpmDataOption.orElseGet(bpmDataOption::get).getBpmData();
        pageDefines.forEach(actionVO -> {
            //todo: 查询按钮的标题子标题不能通过
            actionVO.setTitle(replaceParameterValue(tmPage.getTitle(), bpmData));
            actionVO.setSubTitle(replaceParameterValue(tmPage.getSubTitle(), bpmData));
            actionVO.setDescription(replaceParameterValue(tmPage.getDescription(), bpmData));
            actionVO.setSubDescription(replaceParameterValue(tmPage.getSubDescription(), bpmData));
        });
    }

    public void analysis(PcUiBotPageDefine actionVO, PcUiBotTmPage tmPage, Map<String, Object> bpmData) {

        //todo: 查询按钮的标题子标题不能通过
        actionVO.setTitle(replaceParameterValue(tmPage.getTitle(), bpmData));
        actionVO.setSubTitle(replaceParameterValue(tmPage.getSubTitle(), bpmData));
        actionVO.setDescription(replaceParameterValue(tmPage.getDescription(), bpmData));
        actionVO.setSubDescription(replaceParameterValue(tmPage.getSubDescription(), bpmData));

    }

    private String replaceParameterValue(String content, Map bpmDataMap) {

        if (content == null || bpmDataMap == null || bpmDataMap.size() == 0) {
            return content;
        }

        if (content.contains("{@")) {
            //变量形如 {@varName},以@开头的，表示取流程、活动中的数据
            String pattern = "\\{@(?<var>.*?)\\}";
            Pattern p = Pattern.compile(pattern);
            Matcher m = p.matcher(content); // 获取 matcher 对象

            while (m.find()) {
                String varName = m.group("var");
                if (bpmDataMap.containsKey(varName)) {
                    String key = MessageFormat.format("'{'@{0}'}'", varName);
                    content = content.replace(key, bpmDataMap.get(m.group("var")).toString());
                }
            }
        }

        return content;
    }
}
