package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.designer.uibot.support.PcUiBotOpenWindowDefineAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotOpenWindowDefineDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperation;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperationOpenWindowDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperationScriptCondition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer.DataViewOpenWindowDefineAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotMessageUtils;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotOperationsUtil;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.*;

/**
 * <p>功能描述：页面操作 转换服务</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TmPageOperationService.java
 * @Author: wangjwc
 * @Date: created at 2023/7/12 20:39
 */
@Service
public class TmPageOperationService {

    @Autowired
    private ActionDataSourceAnalysisService tmDataSourceService;

    @Autowired
    private PcUiBotOpenWindowDefineAnalyzer pcUiBotOpenWindowDefineAnalyzer;


    @Autowired
    private SubmitActionCreateService submitActionCreateService;

//    @Autowired
//    private MdcService mdcService;

    @Autowired
    private DataViewOpenWindowDefineAnalyzer dataViewOpenWindowDefineAnalyzer;

    private static final List<String> OPEN_WINDOW_OPERATE_LIST = Arrays.asList("openwindow", "openChart", "open-task-window", "openpage");

    //需要特殊处理的一些operation--type
    private static final List<String> OPERATION_TYPE_LIST = Arrays.asList("add-row", "openpage");

    public void createOperations(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine, PcUiBotTmActivity tmActivity, List<PcUiBotTmOperation> tmOperationList) {
        if (CollectionUtils.isEmpty(tmOperationList)) {
            return;
        }
        tmOperationList.forEach(tmOperationDTO -> {
            handleOperationTypeRelation(tmOperationDTO);
        });
        List<PcUiBotOperationDTO> operationList = new ArrayList<>();
        for (PcUiBotTmOperation tmOperation : tmOperationList) {
            PcUiBotOperationDTO operationDTO = new PcUiBotOperationDTO();
            operationList.add(operationDTO);
            operationDTO.setId(tmOperation.getId());
            operationDTO.setTitle(PcUiBotMessageUtils.getMessageByCurrentLanguage(tmOperation.getTitle()));
            operationDTO.setPosition(tmOperation.getPosition());
            operationDTO.setIcon(tmOperation.getIcon());
            operationDTO.setDisplay(tmOperation.getDisplay());
            operationDTO.setCleanFields(tmOperation.getCleanFields());
            operationDTO.setIsMainButton(tmOperation.getIsMainButton());
            PcUiBotOperationsUtil.setCondition(tmOperation, operationDTO);
            operationDTO.setDescription(PcUiBotMessageUtils.getMessageByCurrentLanguage(tmOperation.getDescription()));
            operationDTO.setOperate(tmOperation.getOperate());
            operationDTO.setOperateTarget(tmOperation.getOperateTarget());
            operationDTO.setOperateScript(tmOperation.getOperateScript());
            operationDTO.setEditorDefine(tmOperation.getEditorDefine());
            operationDTO.setEditor(tmOperation.getEditor());
            operationDTO.setPageCode(executeContext.getPageCode());
            operationDTO.setTargetDetailField(tmOperation.getTargetDetailField());
            operationDTO.setSequenceField(tmOperation.getSequenceField());
            operationDTO.setSequence(tmOperation.getSequence());
            operationDTO.setType(tmOperation.getType());
            operationDTO.setBackFills(tmOperation.getBackFills());
            operationDTO.setExtendedFields(tmOperation.getExtendedFields());
            operationDTO.setConfirm(tmOperation.getConfirm());
            operationDTO.setApplyAlthoughFinished(tmOperation.getApplyAlthoughFinished());
            operationDTO.setOpenFreedomAddRow(tmOperation.getOpenFreedomAddRow());
            operationDTO.setNavigateTarget(tmOperation.getNavigateTarget());
            operationDTO.setIsToolBar(tmOperation.getIsToolBar());
            operationDTO.setCopyConfigs(tmOperation.getCopyConfigs());
            if (tmOperation.getIsCustomize() != null) {
                operationDTO.setIsCustomize(tmOperation.getIsCustomize());
                if (tmOperation.getIsCustomize()) {
                    operationDTO.setCustomType(tmOperation.getCustomType());
                    operationDTO.setPageCode(null);
                    if (tmOperation.getSchema() != null) {
                        operationDTO.setSchema(tmOperation.getSchema());
                    }
                }
            }
            if (tmOperation.getDisabledSelected() != null) {
                operationDTO.setDisabledSelected(tmOperation.getDisabledSelected());
            }

            if (!CollectionUtils.isEmpty(tmOperation.getFields())) {
                operationDTO.setFields(tmOperation.getFields());
            }

            if (tmOperation.getEnableReload() != null) {
                operationDTO.setEnableReload(tmOperation.getEnableReload());
            }

            if (tmOperation.getEnableToolShow() != null) {
                operationDTO.setEnableToolShow(tmOperation.getEnableToolShow());
            }

            /**
             * 解析Operation中定义的SubmitAction，适用于行“删除”按钮的后台提交操作
             * @author majfa
             * @date 2021/4/9
             */
            if (tmOperation.getSubmitAction() != null) {
                PcUiBotSubmitAction submitAction = submitActionCreateService.createSubmitAction(tmOperation.getSubmitAction(), executeContext.getTenantId(), executeContext.getBusinessUnit(), executeContext);
                if (null != submitAction) {
                    if (submitAction.getSubmitType() == null) {
                        submitAction.setSubmitType(tmActivity.getPages().getSubmitType());
                    }
                    submitAction.setExecuteContext(PcUiBotSubmitExecuteContext.create(executeContext, null));
                    operationDTO.setSubmitAction(submitAction);
                }
            }

            /**
             * 附加比对信息
             */
            PcUiBotAttachDTO attachDTO = new PcUiBotAttachDTO();
            operationDTO.setAttach(attachDTO);
            attachDTO.setTarget(tmOperation.getTarget());
            attachDTO.setMode(tmOperation.getMode());
            attachDTO.setTarget(tmOperation.getTarget());
            if (tmOperation.getAfterFilter() != null) {
                attachDTO.setAfterFilter(tmOperation.getAfterFilter());
            }
            if (!StringUtils.isEmpty(tmOperation.getTagGroup())) {
                attachDTO.setTarget(tmOperation.getTagGroup());
            }
            if (!StringUtils.isEmpty(tmOperation.getRuleScript())) {
                attachDTO.setRuleScript(tmOperation.getRuleScript());
            }
            if (!StringUtils.isEmpty(tmOperation.getRuleMessage())) {
                attachDTO.setRuleMessage(PcUiBotMessageUtils.getMessageByCurrentLanguage(tmOperation.getRuleMessage()));
            }
            attachDTO.setApplyToField(tmOperation.getApplyToField());
            attachDTO.setComparisonField(tmOperation.getComparisonField());
            attachDTO.setExportExcludeFields(tmOperation.getExportExcludeFields());
            if (Objects.isNull(tmActivity)) {
                this.parseOpenWindow(executeContext, false, tmOperation, operationDTO);
            } else {
                this.parseOpenWindow(executeContext, tmActivity.isFlowEngine(), tmOperation, operationDTO);
            }
            if (Objects.equals(tmOperation.getOperate(), "SELECT-API")) {
                PcUiBotOperationAPIDefineDTO aglieAPIDefineDTO = new PcUiBotOperationAPIDefineDTO();
                operationDTO.setApiDefine(aglieAPIDefineDTO);
                aglieAPIDefineDTO.setApi(tmOperation.getApiDefine().getApi());
                aglieAPIDefineDTO.setDisplay(tmOperation.getApiDefine().getDisplay());
                aglieAPIDefineDTO.setUpdateSchema(tmOperation.getApiDefine().getUpdateSchema());
                PcUiBotDataSourceDTO dataSourceBase = tmDataSourceService.analysis(executeContext, "", tmOperation.getApiDefine().getGetDataAction(), new HashMap<>());
                aglieAPIDefineDTO.setGetDataAction(dataSourceBase);
            }

            /**
             * table 过滤
             */
            if (Objects.equals(tmOperation.getOperate(), "scriptFilter")) {
                PcUiBotScriptFilterDTO scriptFilterDTO = new PcUiBotScriptFilterDTO();
                PcUiBotTmOperationScriptCondition tmOperationScriptCondition = tmOperation.getOperationScriptCondition();
                operationDTO.setScriptCondition(scriptFilterDTO);
                scriptFilterDTO.setDefaultFilter(tmOperationScriptCondition.getDefaultDisplay());
                scriptFilterDTO.setType(tmOperationScriptCondition.getType());
                scriptFilterDTO.setDescription(tmOperation.getDescription());
                scriptFilterDTO.setFilterScript(tmOperationScriptCondition.getScript());
                scriptFilterDTO.setTarget(tmOperationScriptCondition.getTarget());
                scriptFilterDTO.setTitle(tmOperation.getTitle());
            }

//            // “导航到客户端“的Operation解析
//            if (Objects.equals(operationDTO.getType(), "NAVIGATE_CLIENT")
//                    && null != executeContext.getBusinessUnit()
//                    && null != executeContext.getBusinessUnit().get("eoc_company_id")) {
//                // 解析businessUnit.eoc_company_id对应的erp公司代号
//                String erpCompanyCode = parseErpCompanyCode(executeContext.getTenantId(), (String) executeContext.getBusinessUnit().get("eoc_company_id"));
//                if (null == operationDTO.getExtendedFields()) {
//                    operationDTO.setExtendedFields(new HashMap<>());
//                }
//                operationDTO.getExtendedFields().put("erpCode", erpCompanyCode);
//            }

            this.parseDrawer(operationDTO, tmOperation);
        }
        pageDefine.setOperations(operationList);
    }

    /**
     * 解析开窗操作
     *
     * @param executeContext 执行上下文
     * @param isFlowEngine   是否是流程引擎
     * @param tmOperation    操作定义
     * @param operationDTO   操作dto
     */
    public void parseOpenWindow(PcUiBotExecuteContext executeContext,
                                Boolean isFlowEngine,
                                PcUiBotTmOperation tmOperation,
                                PcUiBotOperationDTO operationDTO) {
        // 考虑"openwindow", "openChart", "open-task-window", "openpage"
        if (!OPEN_WINDOW_OPERATE_LIST.contains(tmOperation.getOperate())) {
            return;
        }
        PcUiBotOpenWindowDefineDTO openwindowDefineDTO;
        boolean isDataView = Optional.of(tmOperation)
                .map(PcUiBotTmOperation::getOpenWindowDefine)
                .map(PcUiBotTmOperationOpenWindowDefine::getAllAction)
                .map(PcUiBotTmQueryAction::getViewCode)
                .map(org.apache.commons.lang3.StringUtils::isNotBlank)
                .orElse(Boolean.FALSE);
        if (isDataView) {
            openwindowDefineDTO = this.dataViewOpenWindowDefineAnalyzer.analysis(executeContext,
                    tmOperation,
                    isFlowEngine);
        } else {
            openwindowDefineDTO = this.pcUiBotOpenWindowDefineAnalyzer.analysis(executeContext,
                    tmOperation,
                    isFlowEngine);
        }
        operationDTO.setOpenWindowDefine(openwindowDefineDTO);
        operationDTO.setOpenWindowConditional(tmOperation.getCondition());
    }

    /**
     * 解析"抽屉"操作
     *
     * @param operation
     * @param tmOperation
     */
    private void parseDrawer(PcUiBotOperationDTO operation, PcUiBotTmOperation tmOperation) {
        String type = tmOperation.getType();
        if (!PcUiBotConstants.TmOperationType.DRAWER.equalsIgnoreCase(type)) {
            return;
        }
        operation.setTabs(tmOperation.getTabs());
        operation.setSwitchData(tmOperation.getSwitchData());
    }

//    private String parseErpCompanyCode(String tenantId, String eocCompanyId) {
//        List<EocOrgTypeCompanyDTO> eocOrgTypeCompanyList = mdcService.getTenantProdOperation(tenantId, null);
//        if (CollectionUtils.isNotEmpty(eocOrgTypeCompanyList)) {
//            Optional<String> omCompanyIdOpt = eocOrgTypeCompanyList.stream()
//                    .filter(eocOrgTypeCompany -> Objects.equals(eocCompanyId, eocOrgTypeCompany.getEocCompanyId()))
//                    .map(EocOrgTypeCompanyDTO::getOmCompanyId)
//                    .findFirst();
//            if (omCompanyIdOpt.isPresent()) {
//                return omCompanyIdOpt.get();
//            }
//        }
//        return "";
//    }

    public static void handleOperationTypeRelation(PcUiBotTmOperation operation) {
        // 是客户 或 operate为空 或 不属于OPERATION_TYPE_LIST
        if (BooleanUtils.isTrue(operation.getIsCustomize())
                || StringUtils.isEmpty(operation.getOperate())
                || !OPERATION_TYPE_LIST.contains(operation.getOperate())) {
            return;
        }
        switch (operation.getOperate()) {
            case "openpage":
                if ("BUTTON_GROUP".equals(operation.getApplyToField())) {
                    if (StringUtils.isEmpty(operation.getType())) {
                        //维护
                        operation.setType("edit");
                    } else if ("openpage".equals(operation.getType())) {
                        //维护
                        operation.setType("edit");
                    } else if ("copy".equals(operation.getType())) {
                        //复制需要更命，前端无法通过copy打开新界面
                        operation.setType("openpage_copy");
                    }
                } else {
                    if (StringUtils.isEmpty(operation.getType())) {
                        operation.setType("add");
                    }
                }
                break;
            case "add-row":
                operation.setType("add");
                break;
            default:
                break;
        }
    }
}
