package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.parser.CommonCombineSubmitActionParser;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @description: 页面提交类型按钮
 **/
@Service
public class TmPageSubmitService {

    /**
     * 解析提交Action </br>
     * 不支持checkCompleteAction
     *
     * @param executeContext
     * @param tmActivity
     */
    public void processBaseData(PcUiBotExecuteContext executeContext, PcUiBotTmActivity tmActivity, PcUiBotTmDataState tmDataState, PcUiBotPageDefine action) {
        if (action.isDefaultShow() && CollectionUtils.isNotEmpty(tmDataState.getSubmitActions())) {
            CommonCombineSubmitActionParser parser =
                    SpringContextHolder.getBean(CommonCombineSubmitActionParser.class);
            parser.init(executeContext, tmDataState, action);
            List<PcUiBotSubmitAction> actionsList = parser.parse(tmDataState.getSubmitActions());
            if (CollectionUtils.isNotEmpty(actionsList)) {
                actionsList.get(0).setDefaultAction(true);
            }
            action.setSubmitActions(actionsList);
            action.setSubmitType(tmDataState.getSubmitType());
            action.setMultipleSelectMerge(tmDataState.getMultipleSelectMerge());
        }
    }
}
