package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.parser.FlowEngineTaskCombineSubmitActionParser;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * <p>功能描述：页面提交类型按钮</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TmTaskPageSubmitService.java
 * @Author: wangjwc
 * @Date: created at 2023/7/13 11:34
 */
@Service
public class TmTaskPageSubmitService {

    public void createTaskSubmit(PcUiBotExecuteContext executeContext, PcUiBotTmActivity tmActivity, PcUiBotTmDataState tmDataState, PcUiBotPageDefine action) {
        FlowEngineTaskCombineSubmitActionParser parser =
                SpringContextHolder.getBean(FlowEngineTaskCombineSubmitActionParser.class);
        parser.init(executeContext, tmActivity, tmDataState, action);
        List<PcUiBotSubmitAction> actionsList = parser.parse(tmDataState.getSubmitActions());

        if (!CollectionUtils.isEmpty(actionsList)) {
            boolean actTrue = false;
            for (PcUiBotSubmitAction act : actionsList) {
                if (act.isDefaultAction()) {
                    actTrue = true;
                }
            }
            if (!actTrue) {
                actionsList.get(0).setDefaultAction(true);
            }
        }
        action.setSubmitActions(actionsList);
        action.setSubmitType(tmDataState.getSubmitType());
        action.setMultipleSelectMerge(tmDataState.getMultipleSelectMerge());
    }

}
