package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.athena.esp.sdk.util.StringUtil;
import com.digiwin.mobile.mobileuibot.proxy.audc.service.DigiwinAudcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotApiMetadata;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotUserDefinedCenterMetadataResult;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotMetadataTagResult;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotTaggingData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotThemeMapTag;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotThemeMapTagResponse;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotTagConstant;
import io.micrometer.core.instrument.util.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;


/**
 * <p>功能描述：获取用户自定义栏位的顺序</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UserDefinedService.java
 * @Author: wangjwc
 * @Date: created at 2023/11/14 16:16
 */
@Service
public class UserDefinedService<T extends PcUiBotPageDefine> {

    @Autowired
    private DigiwinAudcProxyService digiwinAudcProxyService;

    /**
     * 设置用户自定义配置
     *
     * @param pageDefine     页面定义
     * @param executeContext 执行上下文
     */
    public void setUserDefinedConfig(T pageDefine, PcUiBotExecuteContext executeContext) {
        String tmProjectId = "";
        if (StringUtils.isNotEmpty(executeContext.getTmProjectId())) {
            tmProjectId = executeContext.getTmProjectId();
        } else {
            tmProjectId = "__uibot__";
        }
        if (StringUtils.isNotEmpty(executeContext.getTmActivityId())) {
            List<PcUiBotUserDefinedCenterMetadataResult> userDefinedConfig =
                    digiwinAudcProxyService.getFieldsSeqByUser(executeContext.getLocale(), executeContext.getAuthoredUser().getToken(),
                            executeContext.getTenantId(), executeContext.getPageCode(), tmProjectId, executeContext.getTmActivityId());
            pageDefine.setUserDefinedCenterMetadataResultList(userDefinedConfig);
        }
    }

    /**
     * xuxx 获取用户自定义栏位的顺序
     */
    public PcUiBotTaggingData getFieldsSeqByUser(T pageDefine, PcUiBotExecuteContext executeContext,
                                                 PcUiBotTaggingData taggingData, PcUiBotApiMetadata apiMetadata) {
        if (executeContext == null) {
            return taggingData;
        }

        this.setUserDefinedConfig(pageDefine, executeContext);

        List<PcUiBotUserDefinedCenterMetadataResult> metadataMetadataTagResults = pageDefine.getUserDefinedCenterMetadataResultList();
        if (CollectionUtils.isEmpty(metadataMetadataTagResults)) {
            return taggingData;
        }

        Set<String> userSaveFields = new HashSet<>();
        if (taggingData != null && taggingData.getMetadataTagResult() != null) {
            for (PcUiBotMetadataTagResult metadataTagResult : taggingData.getMetadataTagResult()) {
                Iterator<PcUiBotUserDefinedCenterMetadataResult> metadataTagResults = metadataMetadataTagResults.iterator();
                while (metadataTagResults.hasNext()) {
                    PcUiBotUserDefinedCenterMetadataResult userSaveTagResult = metadataTagResults.next();
                    if (apiMetadata.getResponseFieldMap() != null) {
                        String fullPathName = apiMetadata.getActionId() + ".response." + userSaveTagResult.getResourceContent().getResponse();
                        //此处为了兼容以前的数据
                        if (!userSaveTagResult.getResourceContent().getResponse().contains(".")) {
                            fullPathName = apiMetadata.getActionId() + ".response." + apiMetadata.getResponseFieldMap().keySet().iterator().next() + "." + userSaveTagResult.getResourceContent().getResponse();
                        }
                        //此处需要修正主数据源与API的M名称不一致问题begin
                        if (userSaveTagResult.getResourceContent().getResponse().contains(".")
                                && userSaveTagResult.getResourceContent().getResponse().split("\\.").length < 3) {
                            if (!StringUtil.isEmpty(userSaveTagResult.getTableSchema())
                                    && userSaveTagResult.getTableSchema().equals(pageDefine.getDataSourceSet().getMainDatasource())) {
                                String startStr = userSaveTagResult.getTableSchema() + ".";
                                String replaceStr = apiMetadata.getResponseFieldMap().keySet().iterator().next() + ".";
                                String tempTableSchema = userSaveTagResult.getResourceContent().getResponse().replace(startStr, replaceStr);
                                fullPathName = apiMetadata.getActionId() + ".response." + tempTableSchema;
                            }
                        }
                        //此处需要修正主数据源与API的M名称不一致问题end

                        if (metadataTagResult.getResourceContent().getResponse().equals(fullPathName)) {
                            //纠正: 当配置数据源的时候名字被改之后，导致获取的用户自定义就失效了(由于单身名字不能通用数据源配置修改，单身暂不处理)
                            if (StringUtil.isEmpty(userSaveTagResult.getTableSchema())) {
                                metadataTagResults.remove();
                                continue;
                            }
                            if (userSaveTagResult.getResourceContent().getResponse().contains(".")
                                    && userSaveTagResult.getResourceContent().getResponse().split("\\.").length < 3) {
                                if (!userSaveTagResult.getTableSchema().equals(pageDefine.getDataSourceSet().getMainDatasource())) {
                                    metadataTagResults.remove();
                                    continue;
                                }
                            }
                            userSaveFields.add(fullPathName);
                            for (PcUiBotThemeMapTag tag : metadataTagResult.getTags()) {
                                if (tag.getCode().contains("ORDER")) {
                                    tag.setValue(userSaveTagResult.getTags().get(0).getValue());
                                    tag.setCode(userSaveTagResult.getTags().get(0).getCode());
                                }
                            }
                        }
                    }
                }
            }
            if (!CollectionUtils.isEmpty(userSaveFields)) {
                recombinationTaggingData(userSaveFields, taggingData);
            }
        }

        for (PcUiBotUserDefinedCenterMetadataResult metadataTagResult : metadataMetadataTagResults) {
            if (apiMetadata.getResponseFieldMap() != null) {
                String fullPathName = apiMetadata.getActionId() + ".response." + metadataTagResult.getResourceContent().getResponse();
                //此处为了兼容以前的数据
                if (!metadataTagResult.getResourceContent().getResponse().contains(".")) {
                    fullPathName = apiMetadata.getActionId() + ".response." + apiMetadata.getResponseFieldMap().keySet().iterator().next() + "." + metadataTagResult.getResourceContent().getResponse();
                }
                PcUiBotThemeMapTagResponse response = new PcUiBotThemeMapTagResponse();
                response.setResponse(fullPathName);
                metadataTagResult.setResourceContent(response);
            }
        }

        if (taggingData != null) {
            return taggingData;
        } else {
            if (!CollectionUtils.isEmpty(metadataMetadataTagResults)) {
                PcUiBotTaggingData taggingData_new = new PcUiBotTaggingData();
                taggingData_new.setMetadataId(apiMetadata.getActionId());
                List<PcUiBotMetadataTagResult> metadataTagResult = new ArrayList<>();
                metadataMetadataTagResults.forEach(a -> {
                    PcUiBotMetadataTagResult metadata = new PcUiBotMetadataTagResult();
                    metadata.setTags(a.getTags());
                    metadata.setResourceContent(a.getResourceContent());
                    metadataTagResult.add(metadata);
                });
                taggingData_new.setMetadataTagResult(metadataTagResult);
                return taggingData_new;
            }
        }
        return taggingData;
    }


    /**
     * 找到GROUP和内含外显字段，并重新生成顺序
     *
     * @param userSaveFields
     * @param taggingData
     */
    private void recombinationTaggingData(Set<String> userSaveFields, PcUiBotTaggingData taggingData) {
        //用于内含外显的统一
        // key:字段绝对路径，去掉内含外显关键字
        Map<String, List<PcUiBotMetadataTagResult>> nameNoFields = new HashMap<>();
        for (PcUiBotMetadataTagResult metadataTagResult : taggingData.getMetadataTagResult()) {
            List<PcUiBotMetadataTagResult> nameNoMetadataTagResult = new ArrayList<>();
            String absFieldName = metadataTagResult.getResourceContent().getResponse();
            String[] fieldNames = absFieldName.split("\\.");
            String fieldName = fieldNames[fieldNames.length - 1];
            // 同ContainExplicitMergeInterpreter
            if (absFieldName.endsWith("_no") || absFieldName.endsWith("_name")
                    || absFieldName.endsWith("_Id") || absFieldName.endsWith("_Name")
                    || fieldName.startsWith("new_") || fieldName.startsWith("old_")
            ) {
                String fieldKey = fieldNames[fieldNames.length - 2] + "." + fieldNames[fieldNames.length - 1].split("_")[0];
                if (fieldName.startsWith("new_") || fieldName.startsWith("old_")) {
                    fieldKey = fieldNames[fieldNames.length - 2] + "." + fieldNames[fieldNames.length - 1].split("_")[1];
                }
                if (nameNoFields.containsKey(fieldKey)) {
                    List<PcUiBotMetadataTagResult> nameNotTemp = nameNoFields.get(fieldKey);
                    nameNoMetadataTagResult.add(metadataTagResult);
                    nameNoMetadataTagResult.addAll(0, nameNotTemp);
                } else {
                    nameNoMetadataTagResult.add(metadataTagResult);
                }
                nameNoFields.put(fieldKey, nameNoMetadataTagResult);
            }
        }
        //用于保持顺序
        Map<String, List<PcUiBotMetadataTagResult>> groupFields = new HashMap<>();
        for (PcUiBotMetadataTagResult metadataTagResult : taggingData.getMetadataTagResult()) {
            //处理GROUP
            List<PcUiBotMetadataTagResult> groupMetadataTagResult = new ArrayList<>();
            for (PcUiBotThemeMapTag tag : metadataTagResult.getTags()) {
                String tagCode = tag.getCode();
                if (tagCode.contains(PcUiBotTagConstant.GROUP_TAG)) {
                    if (groupFields.containsKey(tagCode)) {
                        List<PcUiBotMetadataTagResult> nameNotTemp = groupFields.get(tagCode);
                        if (!nameNotTemp.contains(metadataTagResult)) {
                            groupMetadataTagResult.add(metadataTagResult);
                        }
                        groupMetadataTagResult.addAll(0, nameNotTemp);
                    } else {
                        if (!groupMetadataTagResult.contains(metadataTagResult)) {
                            groupMetadataTagResult.add(metadataTagResult);
                        }
                    }
                    groupFields.put(tagCode, groupMetadataTagResult);
                }
            }
        }
        if (!CollectionUtils.isEmpty(groupFields)) {
            getGroupOrder(groupFields, userSaveFields);
        }
        if (!CollectionUtils.isEmpty(nameNoFields)) {
            getGroupOrder(nameNoFields, userSaveFields);
        }
    }


    //重构GROUP组内的排序
    private void getGroupOrder(Map<String, List<PcUiBotMetadataTagResult>> groupFields,
                               Set<String> userSaveFields) {
        Set<String> groupKeys = groupFields.keySet();
        for (String key : groupKeys) {
            List<PcUiBotMetadataTagResult> groupList = groupFields.get(key);
            //重新排序
            groupList.sort((firstEntry, secondEntry) -> {
                int tag1;
                try {
                    Optional<PcUiBotThemeMapTag> tmTagOption = firstEntry.getTags()
                            .stream()
                            .filter(t1 -> t1.getCode().contains("ORDER"))
                            .findFirst();
                    tag1 = Integer.parseInt(tmTagOption.orElseGet(tmTagOption::get).getValue());
                } catch (Exception E) {
                    tag1 = 0;
                }
                int tag2;
                try {
                    Optional<PcUiBotThemeMapTag> tmTagOption = secondEntry.getTags()
                            .stream()
                            .filter(t1 -> t1.getCode().contains("ORDER"))
                            .findFirst();
                    tag2 = Integer.parseInt(tmTagOption.orElseGet(tmTagOption::get).getValue());
                } catch (Exception E) {
                    tag2 = 0;
                }
                return tag1 - tag2;
            });
            // 得到当前组中的保存在库中的字段
            Optional<PcUiBotMetadataTagResult> userFieldOpt = groupList.stream()
                    .filter(f -> userSaveFields.contains(f.getResourceContent().getResponse()))
                    .findFirst();
            if (userFieldOpt.isPresent()) {
                PcUiBotMetadataTagResult userField = userFieldOpt.get();
                int index = 1;
                for (PcUiBotMetadataTagResult metadataTagResult : groupList) {
                    //去掉实际保存的字段
                    if (!userSaveFields.contains(metadataTagResult.getResourceContent().getResponse())) {
                        for (PcUiBotThemeMapTag tag : metadataTagResult.getTags()) {
                            if (tag.getCode().contains("ORDER")) {
                                List<PcUiBotThemeMapTag> userList = userField.getTags()
                                        .stream()
                                        .filter(a -> a.getCode().contains("ORDER"))
                                        .collect(Collectors.toList());
                                if (!CollectionUtils.isEmpty(userList)) {
                                    int valueNew = Integer.parseInt(userList.get(0).getValue()) + index;
                                    tag.setValue(String.valueOf(valueNew));
                                    tag.setCode("ORDER_" + valueNew);
                                    index++;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    /**
     * 参考用户自定义配置
     *
     * @param pageDefine
     */
//    public void referenceUserDefinedConfig(T pageDefine) {
//        for (AbstractComponent layout : pageDefine.getLayout()) {
//            if (layout instanceof FormComponent) {
//                referenceUserDefinedConfig((FormComponent) layout, pageDefine);
//            } else if (layout instanceof GridComponent) {
//                referenceUserConfig((GridComponent) layout, pageDefine);
//            }
//        }
//    }

    /**
     * 表单处理
     *
     * @param formComponent
     * @param pageDefine
     */
//    private void referenceUserDefinedConfig(FormComponent formComponent, T pageDefine) {
//        // 待有需求后补充
//    }

    /**
     * 参考用户自定义数据
     *
     * @param gridComponent
     * @param pageDefine
     */
//    private void referenceUserConfig(GridComponent gridComponent, T pageDefine) {
//        if (pageDefine.hasUserDefinedConfig()) {
//            referenceUserDefinedConfig(gridComponent, pageDefine);
//        }
//        if (pageDefine.hasUserSetting()) {
//            referenceUserSetting(gridComponent, pageDefine);
//        }
//    }

    /**
     * 参考用户自定义排序设置
     *
     * @param gridComponent
     * @param pageDefine
     */
//    private void referenceUserSetting(GridComponent gridComponent, T pageDefine) {
//        // 添加order
//        GridComponentUtil.appendUserSettingOrder(pageDefine, gridComponent);
//        // 将setting中被schema包起来的配置释放出来
//        // {schema:{order:{}}} ===> {order:{}}
//        JSONObject setting = gridComponent.getSetting();
//        String schema = gridComponent.getSchema();
//        if (setting.containsKey(schema)) {
//            JSONObject settingSimple = setting.getJSONObject(schema);
//            setting.putAll(settingSimple);
//            setting.remove(schema);
//        }
//    }

    /**
     * 参考用户自定义配置
     *
     * @param gridComponent
     * @param pageDefine
     */
//    private void referenceUserDefinedConfig(GridComponent gridComponent, T pageDefine) {
//        List<GridColumnDef> columnDefs = gridComponent.getColumnDefs();
//        if (CollectionUtils.isEmpty(columnDefs)) {
//            return;
//        }
//        String gridComponentSchema = gridComponent.getSchema();
//        List<GridColumnDef> newColumnDefs = Lists.newArrayList();
//        Map<String, GridColumnDef> absFieldNameMap = new LinkedHashMap<>();
//        for (GridColumnDef columnDef : columnDefs) {
//            String path = columnDef.getPath();
//            AbstractComponent firstColumn = CollUtil.getFirst(columnDef.getColumns());
//            // 规避脏数据
//            if (firstColumn == null || StringUtils.isEmpty(firstColumn.getSchema())) {
//                continue;
//            }
//            String schema = firstColumn.getSchema();
//            absFieldNameMap.put(UiBotUtils.buildAbsFieldName(path, schema), columnDef);
//        }
//        List<UserDefinedCenterMetadataResult> userDefinedConfigs = pageDefine.getUserDefinedCenterMetadataResultList();
//        // 移除其他表格上的用户自定义数据
//        userDefinedConfigs.removeIf(userDefinedConfig ->
//                gridComponentSchema == null || !gridComponentSchema.equals(userDefinedConfig.getTableSchema()));
//        if (userDefinedConfigs.isEmpty()) {
//            return;
//        }
//        for (UserDefinedCenterMetadataResult userDefinedConfig : userDefinedConfigs) {
//            String absFieldName = userDefinedConfig.getResourceContent().getResponse();
//            if (!absFieldNameMap.containsKey(absFieldName)) {
//                continue;
//            }
//            Map<String, Object> extendedAttributes = userDefinedConfig.getExtendedAttributes();
//            Integer width = MapUtil.get(extendedAttributes, "width", Integer.class);
//            String pinned = MapUtil.get(extendedAttributes, "pinned", String.class);
//            GridColumnDef oriColumnDef = absFieldNameMap.get(absFieldName);
//            if (width != null) {
//                oriColumnDef.setWidth(width);
//                oriColumnDef.setIsUserDefined(Boolean.TRUE);
//            }
//            oriColumnDef.setPinned(pinned);
//            newColumnDefs.add(oriColumnDef);
//        }
//
//        gridComponent.setColumnDefs(newColumnDefs);
//    }

}
