package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.digiwin.mobile.mobileuibot.designer.uibot.page.ScoredFieldsSummary;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotTagDefinition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotDefaultTagUtils;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotTagConstant;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotTagUtil;
import com.google.common.collect.Lists;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Component
public class ViewWordsService {

    @Autowired
    private FlatMetadataByTagService flatMetadataByTagService;
    //    @Autowired
//    private TagDefinitionService tagDefinitionService;
    @Autowired
    TagMergeService tagMergeService;

    private final static String[] ACTIVITY_FIELDS_PUT = new String[]{"activity__startTime", "activity__endTime"};

    // 需要忽略的对象标签解析器；词库不再分析其子节点；
    private static final List<String> IGNORE_OBJECT_TAG_INTERPRETER_LIST = Lists.newArrayList(
            "objectRenderTagInterpreter",
            "attachmentFileInterpreter");

//    /**
//     * 是否走词库
//     *
//     * @param taggingData 标签
//     * @return true:没有order标签,false:有order标签
//     */
//    public boolean isShowViewWords(TaggingData taggingData) {
//        if (taggingData == null) {
//            return true;
//        }
//        List<MetadataTagResult> metadataTagResult = taggingData.getMetadataTagResult();
//        if (CollectionUtils.isNotEmpty(metadataTagResult)) {
//            for (MetadataTagResult tagResult : metadataTagResult) {
//                List<ThemeMapTag> tags = tagResult.getTags();
//                if (CollectionUtils.isNotEmpty(tags)) {
//                    return tags.stream().noneMatch(tag -> UiBotConstants.TagCategory.ORDER.equals(tag.getCategory()));
//                }
//            }
//        }
//        return false;
//    }

    public void analyseShowViewWords(PcUiBotPageDefine pageDefine, PcUiBotMetadataField rootField, List<String> notShowWords,
                                     Map<String, PcUiBotMetadataField> needShowFields) {
        if (rootField == null) {
            return;
        }
        Map<String, PcUiBotMetadataField> fieldMap = rootField.getFieldMap();
        //如果是项目详情，任务的执行人、进展、完成日需要在前面
        //activity__performerName
        if (fieldMap.containsKey("activity__performerName") && pageDefine.getShowDataProperties().contains("activity__performerName")) {
            needShowFields.put(rootField.getName() + ".activity__performerName", fieldMap.get("activity__performerName"));
        }
        //activity__backLog__data
        if (fieldMap.containsKey("activity__backLog__data") && pageDefine.getShowDataProperties().contains("activity__backLog__data")) {
            needShowFields.put(rootField.getName() + ".activity__backLog__data", fieldMap.get("activity__backLog__data"));
            fieldMap.get("activity__backLog__data").setTagDefinitions(PcUiBotDefaultTagUtils.createDefinitionByType("TASK_PROGRESS_STATUS", "活动任务状态", "activityTaskStatusInterpreter"));
        }
        //activity__planEndTime
        if (fieldMap.containsKey("activity__planEndTime") && pageDefine.getShowDataProperties().contains("activity__planEndTime")) {
            needShowFields.put(rootField.getName() + ".activity__planEndTime", fieldMap.get("activity__planEndTime"));
        }
        // 添加任务需要展示的任务字段
        putShowFields(rootField.getName(), needShowFields, pageDefine, fieldMap);
        // 最终需要被remove的字段名，一般是d和sd；当词库中含有d和sd，且d和sd含有平铺标签，需要移除，否则页面会展示多余的d和sd；
        List<String> removeFieldFullName = Lists.newArrayList();
        for (ScoredFieldsSummary scoreWords : pageDefine.getShowMetadatas()) {
            if (scoreWords == null) {
                continue;
            }
            //当type为M时，取单头的M字段，当type取单身D的字段
            String rootName = scoreWords.getTarget();
            if (rootName.contains(".")) {
                String names[] = rootName.split("\\.");
                rootName = names[names.length - 1];
            }

            List<String> showMetaDatasAll = getShowMetaDatasAll(pageDefine, scoreWords, rootName);
            if (showMetaDatasAll == null) {
                continue;
            }
            if (rootField.getName().equals(rootName)) {
                for (String fieldName : showMetaDatasAll) {
                    if (!notShowWords.contains(fieldName) && fieldMap.containsKey(fieldName)) {
                        //移除 order tag
                        PcUiBotTagUtil.removeTag(fieldMap.get(fieldName), PcUiBotTagConstant.ORDER_TAG);
                        needShowFields.put(rootField.getName() + "." + fieldName, fieldMap.get(fieldName));
                        if ("activity__approval__state".equals(fieldName)) {
//                            fieldMap.get(fieldName).setTagDefinitions(tagDefinitionService.getTagDefinitionByCodes(pageDefine.getExecuteContext(), Arrays.asList("SIGN_OFF_PROGRESS")));
                        }
                        if ("activity__data__status".equals(fieldName)) {
//                            fieldMap.get(fieldName).setTagDefinitions(tagDefinitionService.getTagDefinitionByCodes(pageDefine.getExecuteContext(), Arrays.asList("DATA_FLOW_STATUS")));
                        }
                    }
                }
            } else {
                List<PcUiBotMetadataField> subSubFields = new ArrayList<>();
                //单身
                if (PcUiBotConstants.ApiFieldType.SINGLE_BODY.equals(scoreWords.getType())) {
                    //获取单身元数据
                    if (!fieldMap.containsKey(rootName)) {
                        return;
                    }
                    //移除 order tag
                    PcUiBotTagUtil.removeTag(fieldMap.get(rootName), PcUiBotTagConstant.ORDER_TAG);
                    //这里需要处理对象字段的情况
                    if (unIgnoreObjectByTag(fieldMap.get(rootName))) {
                        needShowFields.putIfAbsent(rootField.getName() + "." + rootName, fieldMap.get(rootName));
                        continue;
                    }
                    Map<String, PcUiBotMetadataField> subFieldMap = fieldMap.get(rootName).getFieldMap();
                    getDetailMetaDatas(notShowWords, subSubFields, subFieldMap, rootName, showMetaDatasAll);
                    PcUiBotMetadataField subMetadataField = new PcUiBotMetadataField();
                    if (needShowFields.containsKey(rootField.getName() + "." + rootName)) {
                        BeanUtils.copyProperties(needShowFields.get(rootField.getName() + "." + rootName), subMetadataField);
                    } else {
                        BeanUtils.copyProperties(fieldMap.get(rootName), subMetadataField);
                    }
                    subMetadataField.setSubFields(subSubFields);
                    // 重置单身对象
                    needShowFields.put(subMetadataField.getFullName(), subMetadataField);
                    //对于平铺结构需要处理,判断当前结构是为需要平铺结构
                    if (flatMetadataByTagService.isRenderFlatMetadataComponent(pageDefine.getExecuteContext(), fieldMap.get(rootName))) {
                        if (CollectionUtils.isNotEmpty(subSubFields)) {
                            for (PcUiBotMetadataField ssm : subSubFields) {
                                needShowFields.put(ssm.getPath() + "." + ssm.getName(), ssm);
                            }
                        }
                        removeFieldFullName.add(subMetadataField.getFullName());
                    } else {
                        needShowFields.put(rootField.getName() + "." + rootName, subMetadataField);
                    }
                } else {
                    //子单身
                    String subRootName = scoreWords.getTarget();
                    if (subRootName.contains(".") && subRootName.split("\\.").length == 3) {
                        String names[] = subRootName.split("\\.");
                        subRootName = names[names.length - 2];
                    }
                    if (!fieldMap.containsKey(subRootName)) {
                        return;
                    }
                    //移除 order tag
                    PcUiBotTagUtil.removeTag(fieldMap.get(subRootName), PcUiBotTagConstant.ORDER_TAG);
                    //这里需要处理对象字段的情况
                    if (unIgnoreObjectByTag(fieldMap.get(subRootName))) {
                        needShowFields.putIfAbsent(rootField.getName() + "." + subRootName, fieldMap.get(subRootName));
                        continue;
                    }
                    PcUiBotMetadataField subMetadataField = new PcUiBotMetadataField();
                    if (needShowFields.containsKey(rootField.getName() + "." + subRootName)) {
                        BeanUtils.copyProperties(needShowFields.get(rootField.getName() + "." + subRootName), subMetadataField);
                    } else {
                        BeanUtils.copyProperties(fieldMap.get(subRootName), subMetadataField);
                    }
                    if (!fieldMap.get(subRootName).getFieldMap().containsKey(rootName)) {
                        return;
                    }
                    PcUiBotMetadataField subSubMetadataField = new PcUiBotMetadataField();
                    Map<String, PcUiBotMetadataField> subSubFieldMap = fieldMap.get(subRootName).getFieldMap().get(rootName).getFieldMap();
                    getDetailMetaDatas(notShowWords, subSubFields, subSubFieldMap, rootName, showMetaDatasAll);
                    BeanUtils.copyProperties(fieldMap.get(subRootName).getFieldMap().get(rootName), subSubMetadataField);
                    subSubMetadataField.setSubFields(subSubFields);

                    //对于平铺结构需要处理,判断当前结构是为需要平铺结构,SD平铺D就肯定需要平铺
                    if (flatMetadataByTagService.isRenderFlatMetadataComponent(pageDefine.getExecuteContext(), fieldMap.get(subRootName).getFieldMap().get(rootName))) {
                        subMetadataField.getSubFields().addAll(subSubFields);
                        for (PcUiBotMetadataField ssm : subMetadataField.getSubFields()) {
                            needShowFields.put(ssm.getPath() + "." + ssm.getName(), ssm);
                        }
                        removeFieldFullName.add(subSubMetadataField.getFullName());
                    } else {
                        subMetadataField.getSubFields().add(subSubMetadataField);
                        needShowFields.put(rootField.getName() + "." + subRootName, subMetadataField);
                    }
                }
            }
        }
        // 删除平铺后的d和sd
        MapUtil.removeAny(needShowFields, ArrayUtil.toArray(removeFieldFullName, String.class));
    }

    /**
     * 添加需要展示的元数据字段
     *
     * @param name           字段编码
     * @param needShowFields 需要展示的字段
     * @param pageDefine     页面定义
     * @param fieldMap       字段编码对应的元数据
     */
    private void putShowFields(String name, Map<String, PcUiBotMetadataField> needShowFields, PcUiBotPageDefine pageDefine, Map<String, PcUiBotMetadataField> fieldMap) {
        List<String> showDataProperties = pageDefine.getShowDataProperties();
        for (String key : ACTIVITY_FIELDS_PUT) {
            if (fieldMap.containsKey(key) && showDataProperties.contains(key)) {
                needShowFields.put(name + "." + key, fieldMap.get(key));
            }
        }
    }

    private void getDetailMetaDatas(List<String> notShowWords, List<PcUiBotMetadataField> subSubFields, Map<String, PcUiBotMetadataField> subFieldMap, String rootName, List<String> showMetaDatasAll) {
        for (String fieldName : showMetaDatasAll) {
            if (!notShowWords.contains(fieldName) && subFieldMap.containsKey(fieldName)) {
                PcUiBotMetadataField metadataField = subFieldMap.get(fieldName);
                if (PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(metadataField.getDataType()) && unIgnoreObjectByTag(metadataField)) {
                    getDetailMetaDatas(notShowWords, subSubFields, subFieldMap.get(fieldName).getFieldMap(), fieldName, showMetaDatasAll);
                } else {
                    subSubFields.add(subFieldMap.get(fieldName));
                }
            }
        }
    }

    /**
     * 根据标签判断字段是否不被忽略
     *
     * @param metadataField 字段
     * @return true：作为普通对象字段处理，false：不做处理
     */
    private boolean unIgnoreObjectByTag(PcUiBotMetadataField metadataField) {
        PcUiBotTagDefinition tagDefinitionDTO = tagMergeService.mergeTagAttributes(metadataField);
        if (tagDefinitionDTO == null) {
            return false;
        }
        return !IGNORE_OBJECT_TAG_INTERPRETER_LIST.contains(tagDefinitionDTO.getInterpreterServiceName());
    }

    /**
     * 1、以用户自定义栏位的顺序为准，并且栏位必须在设计器发布的词库中存在
     * 2、如果设计器发布的词库中有新词，则排放在最后（暂定）；
     *
     * @param pageDefine
     * @param scoreWords
     * @param rootName
     * @return
     */
    private List<String> getShowMetaDatasAll(PcUiBotPageDefine pageDefine, ScoredFieldsSummary scoreWords, String rootName) {
        List<String> showDataProperties = new ArrayList<String>();
        if (CollectionUtils.isEmpty(scoreWords.getFields())) {
            return null;
        }
        scoreWords.getFields().forEach(m -> showDataProperties.add(m.getFieldName()));

        //不存在用户自定义时就返回词库中全部
        if (CollectionUtils.isEmpty(pageDefine.getUserDefinedCenterMetadataResultList())) {
            return showDataProperties;
        }
        //用户自定义顺序
        List<String> userDefinedMateDatas = new ArrayList<String>();
        for (PcUiBotUserDefinedCenterMetadataResult userDefined : pageDefine.getUserDefinedCenterMetadataResultList()) {
            String userDefinedTableSchema = userDefined.getTableSchema();
            if (userDefinedTableSchema.contains(".")) {
                String userDefinedTableSchemas[] = userDefinedTableSchema.split("\\.");
                userDefinedTableSchema = userDefinedTableSchemas[userDefinedTableSchemas.length - 1];
            }
            if (rootName.equals(userDefinedTableSchema)) {
                if (userDefined.getResourceContent().getResponse().contains(".")) {
                    String fieldNames[] = userDefined.getResourceContent().getResponse().split("\\.");
                    //只有存在设计器中词的字段才会显示
                    if (showDataProperties.contains(fieldNames[fieldNames.length - 1])) {
                        userDefinedMateDatas.add(fieldNames[fieldNames.length - 1]);
                    }
                }
            }
        }
        //存在用户自定义时则需要组合显示，如果设计器发布的词库中有新词，则排放在最后（暂定，根据情况调整）；
        List<String> showMetaDatasAll = new ArrayList<>();
        showMetaDatasAll.addAll(userDefinedMateDatas);
        showMetaDatasAll.addAll(showDataProperties.stream().filter(meta -> !userDefinedMateDatas.contains(meta)).collect(Collectors.toList()));
        return showMetaDatasAll;
    }
}
