package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.builder;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.PcRuleService;
import com.fasterxml.jackson.core.type.TypeReference;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.time.LocalDate;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>功能描述：抽象页面构造器</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AbstractPageBuilder.java
 * @Author: wangjwc
 * @Date: created at 2023/10/17 14:44
 */
public abstract class AbstractPageBuilder<T extends PcUiBotPageDefine> implements PageBuilder<T>, InitializingBean {

    @Autowired
    protected DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;

    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;

    @Autowired
    private PcRuleService pcRuleService;

//    @Autowired
//    protected ShowFieldService showFieldService;
//
//    @Override
//    public void resetRule(DynamicForm dynamicForm) {
//        List<Map<String, Object>> rules = dynamicForm.getRules();
//        // 移除所有词库字段隐藏规则
//        this.resetRule(rules);
//    }
//
//    public void resetRule(List<Map<String, Object>> rules) {
//        showFieldService.removeWordHiddenRule(rules);
//    }

    /**
     * 创建业务规则
     *
     * @param executeContext
     * @param pageDefine
     * @param dynamicForm
     * @param apiRequest
     */
    protected void BuildRule(PcUiBotExecuteContext executeContext, T pageDefine, UiBotModel dynamicForm, ApiRequest apiRequest) {
        dynamicForm.setRules(JsonUtil.objectToJavaObject(pageDefine.getRules(), new TypeReference<List<UiBotRule>>() {
        }));
        // 当per rules中有配规则，以rules表中为准
        this.resetRuleFromPresetLibrary(executeContext, dynamicForm, apiRequest);
        // 移除特定逻辑下的可编辑规则
        this.removeEditRulesIfNecessary(executeContext, dynamicForm.getRules());
        // 回填规则
        pageDefine.setRules(JsonUtil.objectToJavaObject(dynamicForm.getRules(), new TypeReference<List<Map<String, Object>>>() {
        }));
    }

    /**
     * 以kg接口返回的规则为准
     *
     * @param executeContext 执行上下文
     * @param dynamicForm    动态表单
     * @param apiRequest
     */
    protected void resetRuleFromPresetLibrary(PcUiBotExecuteContext executeContext, UiBotModel dynamicForm, ApiRequest apiRequest) {
        PcUiBotRelationTag relationTag = executeContext.getRelationTag();
        if (relationTag != null && StringUtils.isNotEmpty(relationTag.getActivityId())) {
            List<UiBotRule> rules = this.getRules(apiRequest, relationTag.getActivityId());
            if (!CollectionUtils.isEmpty(rules)) {
                dynamicForm.setRules(rules);
            }
        }
    }

    protected List<UiBotRule> getRules(ApiRequest apiRequest, String activityId) {
        return pcRuleService.buildRuleOfKm(activityId, apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId());
    }

    protected QueryResultSet queryByPagedefineWithMetaData(PcUiBotExecuteContext executeContext, T pageDefine) {
        if (pageDefine.getDataSourceSet() == null) {
            return QueryResultSet.empty();
        }
        Map<String, Object> body = new HashMap<>();
        body.put("dataSourceSetDTO", pageDefine.getDataSourceSet());
        body.put("executeContext", executeContext);
        body.put("parameter", pageDefine.getParameter());
        body.put("settings", pageDefine.getSettings());
        if (pageDefine.getPageInfo() != null) {
            body.put("pageInfo", pageDefine.getPageInfo());
        }
        if (pageDefine.getSortInfo() != null && !pageDefine.getSortInfo().isEmpty()) {
            body.put("sortInfo", pageDefine.getSortInfo());
        }
        if (pageDefine.getSearchInfo() != null && !pageDefine.getSearchInfo().isEmpty()) {
            body.put("searchInfo", pageDefine.getSearchInfo());
        }
        QueryResultSet queryResultSet = digiwinAtdmProxyService.queryWithMetaData(executeContext.getLocale(),
                executeContext.getAuthoredUser().getToken(),
                JsonUtil.javaObjectToJsonString(body),
                executeContext.getAuthoredUser().getTenantId());
        try {
            this.handleQueryResultSet(queryResultSet, pageDefine, executeContext);
        } catch (Exception ignored) {
        }
        return queryResultSet;
    }

    private void handleQueryResultSet(QueryResultSet queryResultSet, T pageDefine, PcUiBotExecuteContext executeContext) {
        // PCC_项目问题清单定制：发生时间question_happen_datetime倒叙排序
        if ("DataEntry_pccProjectQuestionList".equals(executeContext.getTmActivityId())) {
            if (queryResultSet == null) {
                return;
            }
            List<QueryResult> queryResults = queryResultSet.getQueryResults();
            if (CollectionUtils.isEmpty(queryResults)) {
                return;
            }
            for (QueryResult queryResult : queryResults) {
                List<Map<String, Object>> data = queryResult.getData();
                if (CollectionUtils.isEmpty(data)) {
                    continue;
                }
                data = data.stream()
                        .sorted((o1, o2) -> {
                            LocalDate o1Data = DateTimeUtil.parseLocalDateUseDefaultPattern(StringUtil.valueOf(o1.get("question_happen_datetime")));
                            LocalDate o2Date = DateTimeUtil.parseLocalDateUseDefaultPattern(StringUtil.valueOf(o2.get("question_happen_datetime")));
                            return o2Date.compareTo(o1Data);
                        })
                        .collect(Collectors.toList());
                queryResult.setData(data);
                queryResult.setTotalResults(data.size());
            }
        }
    }

    /**
     * 非执行者或分享对象，去掉可编辑规则
     *
     * @param executeContext
     * @param rules
     */
    protected void removeEditRulesIfNecessary(PcUiBotExecuteContext executeContext, List<UiBotRule> rules) {
        if (executeContext.getRelationTag() != null && !CollectionUtils.isEmpty(rules)) {
            // 非performer 或者 是被分享的
            if ((!"performer".equals(executeContext.getRelationTag().getIdentity())) || executeContext.isShared()) {
                // 只加入非编辑类的规则
                Iterator<UiBotRule> ruleIterator = rules.listIterator();
                while (ruleIterator.hasNext()) {
                    UiBotRule rule = ruleIterator.next();
                    // 非编辑类：!x.containsKey("scope") || !Objects.equals("EDIT", x.get("scope")
                    // 编辑类：x.containsKey("scope") && Objects.equals("EDIT", x.get("scope")
                    // 去掉只有在可编辑时才起作用的规则
                    if (Objects.equals("EDIT", rule.getScope())) {
                        ruleIterator.remove();
                    }
                }
            }
        }
    }
}
