package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.builder;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.action.ConfirmPop;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldLabelStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldValueStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.*;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardOpenDetailTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePicker;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePickerTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumericTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputSingleText;
import com.digiwin.mobile.mobileuibot.core.component.input.switchcomponent.InputSwitch;
import com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist.ZtbViewList;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotPageLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.MetadataService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotApiMetadataUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>功能描述：创建页面</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AssistanPatternTaskBuilder.java
 * @Author: wangjwc
 * @Date: created at 2023/10/17 14:48
 */
@Service
public class AssistanPatternTaskBuilder extends ProcessTaskPatternBuilder {

//    @Autowired
//    private ArrayInterpreter arrayInterpreter;
//
//    @Autowired
//    private FormInterpreter formInterpreter;

    @Autowired
    private MetadataService metadataService;

    @Autowired
    private LocaleService localeService;

    /**
     * 返回支持的类型
     *
     * @return
     */
    @Override
    public String supportKey() {
        return "webplatform-business_assistan-assistan-2.0";
    }

    //    /**
//     * 已经查询好数据，不需要重新再查询
//     *
//     * @param executeContext
//     * @param queryResultSet
//     * @param pageDefine
//     * @return
//     */
//    @Override
//    public UiBotModel createPage(PcUiBotExecuteContext executeContext, QueryResultSet queryResultSet, PcUiBotTaskPageDefine pageDefine) {
//        List<UiBotLayout> layout = new ArrayList<>();
//        UiBotModel dynamicForm = UiBotModel.emptyUiBotModel();
//        dynamicForm.setLayout(layout);
//        createDynamicForm(executeContext, pageDefine, dynamicForm, queryResultSet);
//        return dynamicForm;
//    }
    public void createDynamicForm(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine mainQueryDTO, UiBotModel dynamicForm, QueryResultSet queryResultSet) {
        if (("BUSINESS_ASSISTAN".equalsIgnoreCase(executeContext.getPattern())
                && "ASSISTAN".equalsIgnoreCase(executeContext.getCategory()))) {
            // 从bpm中获取数据
            this.buildByBpm(apiRequest, executeContext, mainQueryDTO, dynamicForm, queryResultSet);
        } else {
            // 从action中获取数据
            this.buildByAction(apiRequest, executeContext, mainQueryDTO, dynamicForm, queryResultSet);
        }
    }

    private void buildByBpm(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine mainQueryDTO, UiBotModel dynamicForm, QueryResultSet queryResultSet) {
        if (executeContext.getTaskWithBacklogData() == null) {
            return;
        }
        if (executeContext.getTaskWithBacklogData().getBpmData() == null) {
            return;
        }
        if (!executeContext.getTaskWithBacklogData().getBpmData().containsKey("ASSISTAN_METADATA")) {
            return;
        }
        // 通过bpm推送过来的元数据，重新构建元数据
        Object apiMetadataObj = executeContext.getTaskWithBacklogData().getBpmData().get("ASSISTAN_METADATA");
        PcUiBotApiMetadata apiMetadata = metadataService.createApiMetadata("UIBOT_ASSISTAN", "", apiMetadataObj);
        PcUiBotApiMetadataUtil.flatMetaData(apiMetadata);
        //把tagData设置到元数据上,现在没有tag后续有在加上从kg获取TAG的逻辑
        signTagService.sinTagToMetadata(null, apiMetadata);
        // 字段显示范围
        PcUiBotShowMetadata showMetadata = getResponseShowFields(apiMetadata);
        // 处理操作服务
//        operationService.addMetadataOperation(showMetadata, mainQueryDTO.getOperations(), apiMetadata);
        // 构建pageLayout--通过数据驱动组件
        mainQueryDTO.setPageLayout(this.bulidPageLayout(apiRequest, executeContext, showMetadata, mainQueryDTO, apiMetadata, queryResultSet));
        // 创建界面
        createAssistanTaskPage(executeContext, showMetadata, mainQueryDTO, dynamicForm, apiMetadata);
        if (null == executeContext.getRelationTag() || (null != executeContext.getRelationTag()
                && StringUtils.isEmpty(executeContext.getRelationTag().getActivityId()))) {
            dynamicForm.setRules(new ArrayList<>());
        } else {
            dynamicForm.setRules(this.getRules(apiRequest, executeContext.getRelationTag().getActivityId()));
        }
        appendPageData(executeContext.getTaskWithBacklogData().getBpmData(), dynamicForm, apiMetadata, queryResultSet);
    }

    private void buildByAction(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, UiBotModel dynamicForm, QueryResultSet queryResultSet) {
        // 非空校验
        if (pageDefine == null
                || pageDefine.getDataSourceSet() == null
                || pageDefine.getDataSourceSet().getDataSourceList() == null) {
            return;
        }
        // 数据源id不能为空(但是在数据源类型RAWDATA清空可以为空)
        String actionId = pageDefine.getDataSourceSet().getFirstActionId();
//        if (Strings.isBlank(actionId)) {
//            return;
//        }
        // 获取并解析元数据
        PcUiBotApiMetadata apiMetadata = getApiMetadata(executeContext, queryResultSet, pageDefine, actionId);
        if (apiMetadata == null) {
            return;
        }
        PcUiBotRelationTag relationTag = executeContext.getRelationTag();
        this.addSubmitFiled(executeContext, pageDefine.getSubmitActions(), apiMetadata);
        PcUiBotApiMetadataUtil.flatMetaData(apiMetadata);

        if (null == relationTag || (null != relationTag && StringUtils.isEmpty(relationTag.getActivityId()))) {
            dynamicForm.setRules(new ArrayList<>());
        } else {
            dynamicForm.setRules(this.getRules(apiRequest, executeContext.getRelationTag().getActivityId()));
        }
        // 规则回填，用于词库字段隐藏规则处理
        pageDefine.setRules(JsonUtil.objectToJavaObject(dynamicForm.getRules(), new TypeReference<List<Map<String, Object>>>() {
        }));
        // 解析页面需要展示的元素
        PcUiBotShowMetadata showMetadata = createShowMetadata(executeContext, pageDefine, actionId, apiMetadata, queryResultSet);
        // 创建布局
        if (showMetadata != null) {
            // 添加tag上定义的规则
            addTagRules("", showMetadata.getShowFields(), dynamicForm.getRules());
            // 处理下数据源
            this.setDataSourceNameToShowMetadata(queryResultSet, showMetadata.getShowFields());

            // 获取所有元数据上的字段信息
            getPageDataSet(executeContext, queryResultSet, pageDefine, apiMetadata, showMetadata, dynamicForm);
        }
        // 移除特定逻辑下的可编辑规则
        this.removeEditRulesIfNecessary(executeContext, dynamicForm.getRules());

        // 构建pageLayout--通过数据驱动组件
        pageDefine.setPageLayout(this.bulidPageLayout(apiRequest, executeContext, showMetadata, pageDefine, apiMetadata, queryResultSet));
        // 创建界面
        createAssistanTaskPage(executeContext, showMetadata, pageDefine, dynamicForm, apiMetadata);
    }

    /**
     * getResponseShowFields
     *
     * @param masterMetadata
     * @return
     */
    private PcUiBotShowMetadata getResponseShowFields(PcUiBotApiMetadata masterMetadata) {
        PcUiBotShowMetadata showMetadata = new PcUiBotShowMetadata();
        if (masterMetadata == null) {
            return showMetadata;
        }
        showMetadata.setActionId(masterMetadata.getActionId());
        showMetadata.setServiceName(masterMetadata.getServiceName());

        // 请求元数据集
        List<PcUiBotMetadataField> responseFields = masterMetadata.getResponseFields();

        showMetadata.setShowFields(new ArrayList<>());
        List<PcUiBotMetadataField> tagMetadata = showFields(responseFields);
        if (CollectionUtils.isNotEmpty(tagMetadata)) {
            showMetadata.getShowFields().addAll(tagMetadata);
        } else {
            showMetadata.getShowFields().addAll(responseFields);
        }
        return showMetadata;
    }

    /**
     * 获取只显示字段
     *
     * @param metadataFields
     * @return
     */
    private List<PcUiBotMetadataField> showFields(List<PcUiBotMetadataField> metadataFields) {
        List<PcUiBotMetadataField> showFields = new ArrayList<>();
        for (PcUiBotMetadataField metadataField : metadataFields) {
            if (PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(metadataField.getDataType())) {
                List<PcUiBotMetadataField> sonTagFields = showFields(metadataField.getSubFields());
                if (CollectionUtils.isNotEmpty(sonTagFields) || CollectionUtils.isNotEmpty(metadataField.getTagDefinitions())) {
                    PcUiBotMetadataField newMetadataField = createMetadataField(metadataField, sonTagFields);
                    showFields.add(newMetadataField);
                }
            }
            if (CollectionUtils.isNotEmpty(metadataField.getTagDefinitions()) && !PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(metadataField.getDataType())) {
                showFields.add(metadataField);
            }
        }
        return showFields;
    }

    /**
     * 创建字段
     *
     * @param metadataField
     * @param sonTagFields
     * @return
     */
    private PcUiBotMetadataField createMetadataField(PcUiBotMetadataField metadataField, List<PcUiBotMetadataField> sonTagFields) {
        PcUiBotMetadataField newMetadataField = new PcUiBotMetadataField();
        newMetadataField.setDataType(metadataField.getDataType());
        newMetadataField.setDataKey(metadataField.getDataKey());
        newMetadataField.setRemark(metadataField.getRemark());
        newMetadataField.setDescription(metadataField.getDescription());
        newMetadataField.setRequired(metadataField.isRequired());
        newMetadataField.setName(metadataField.getName());
        newMetadataField.setArray(metadataField.isArray());
        newMetadataField.setCanEdit(metadataField.isCanEdit());
        newMetadataField.setTagDefinitions(metadataField.getTagDefinitions());
        newMetadataField.setFieldType(metadataField.getFieldType());
        newMetadataField.setSubFields(sonTagFields);
        return newMetadataField;
    }

    /**
     * 创建界面
     *
     * @param executeContext
     * @param showMetadata
     * @param pageDefine
     * @param dynamicForm
     * @param apiMetadata
     */
    private void createAssistanTaskPage(PcUiBotExecuteContext executeContext, PcUiBotShowMetadata showMetadata, PcUiBotTaskPageDefine pageDefine, UiBotModel dynamicForm, PcUiBotApiMetadata apiMetadata) {
//        //每组代表一个原生态的
//        BuildContext buildContext = this.createBuildContext(pageDefine, null, executeContext, apiMetadata);
//
//        List<AbstractComponent> topLayout = new ArrayList<>();
//        if (CollectionUtils.isNotEmpty(showMetadata.getShowFields())) {
//            // 无数据源，默认数据源名称和元数据的名称一致
//            for (MetadataField showField : showMetadata.getShowFields()) {
//                AbstractComponent layout = createAssistanPattenPage(buildContext, showField, showField.getSubFields(), apiMetadata);
//                if (layout instanceof Collection) {
//                    topLayout.addAll((Collection<AbstractComponent>) layout);
//                } else {
//                    if (layout instanceof FormComponent) {
//                        FormComponent layoutForm = (FormComponent) layout;
//                        if (CollectionUtils.isNotEmpty(layoutForm.getGroup())
//                                && layoutForm.getGroup().get(0) instanceof FormComponent) {
//                            FormComponent layoutFormGroup = (FormComponent) layoutForm.getGroup().get(0);
//                            layoutFormGroup.setMaxCol(2);
//                        }
//                        layoutForm.setDirection("COLUMN");
//
//                        topLayout.add(layoutForm);
//                    } else {
//                        topLayout.add(layout);
//                    }
//                }
//            }
//        }
//        //页面最大化时显示的区域
//        for (AbstractComponent component : topLayout) {
//            component.setSupportShowInMaxedWindow(true);
//        }
//        dynamicForm.getLayout().addAll(topLayout);
        setActionOperations(executeContext, pageDefine);
    }

//    private AbstractComponent createAssistanPattenPage(BuildContext buildContext, PcUiBotMetadataField headMetadataField, List<PcUiBotMetadataField> subFields, PcUiBotApiMetadata apiMetadata) {
//        List<PcUiBotMetadataField> bodyShowFields = new ArrayList<>();
//        //循环所有节点
//        if (TagUtil.renderObjectMetadataField(headMetadataField)) {
//            bodyShowFields.add(headMetadataField);
//        } else {
//            if (CollectionUtils.isNotEmpty(subFields)) {
//                for (MetadataField showField : subFields) {
//                    if (TagUtil.renderObjectMetadataField(showField)) {
//                        bodyShowFields.add(showField);
//                    } else if (showField.getDataType().equals(ApiMetadataConstants.METADATA_OBJECT)) {
//                        MetadataField newMetadataField = new MetadataField();
//                        newMetadataField.setDataType(ApiMetadataConstants.METADATA_OBJECT);
//                        newMetadataField.setDescription(showField.getDescription());
//                        newMetadataField.setName(showField.getName());
//                        newMetadataField.setTagDefinitions(showField.getTagDefinitions());
//
//                        newMetadataField.setObjectData(createAssistanPattenPage(buildContext, showField, showField.getSubFields(), apiMetadata));
//                        //导出table 下载使用
//                        newMetadataField.setExportTableFields(showField.getExportTableFields());
//                        bodyShowFields.add(newMetadataField);
//                    } else {
//                        bodyShowFields.add(showField);
//                    }
//                }
//            }
//        }
//
//        List<GroupMetadataField> groupMetadataFields = groupTagInterpreter.analysisTagGroup(bodyShowFields, buildContext);
//        // 创建TABLE
//        if (headMetadataField.isArray()) {
//            return arrayInterpreter.createComponent(headMetadataField, groupMetadataFields, buildContext, apiMetadata);
//        }
//        // 创建FORM
//        else {
//            return formInterpreter.createComponent(headMetadataField, groupMetadataFields, buildContext, apiMetadata);
//        }
//    }

    /**
     * 解析Operations
     *
     * @param executeContext
     * @param pageDefine
     */
    private void setActionOperations(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine) {
        List<PcUiBotOperationDTO> operations = pageDefine.getOperations();
        if (CollectionUtils.isNotEmpty(operations)) {
            for (PcUiBotOperationDTO operation : operations) {
                operation.setRelationTag(executeContext.getRelationTag());
                operation.setPageCode(executeContext.getPageCode());
            }
        }
    }

    /**
     * 数据修正，将平铺结构数据，组装成单头单身结构输出到界面
     *
     * @param bpmdata
     * @param dynamicForm
     * @param masterMetadata
     * @param queryResultSet
     */
    private void appendPageData(Map<String, Object> bpmdata, UiBotModel dynamicForm, PcUiBotApiMetadata masterMetadata, QueryResultSet queryResultSet) {
        UiBotPageData pageData = new UiBotPageData();
        String basic_reason = "";
        if (bpmdata.containsKey("BASIC_REASON")) {
            basic_reason = bpmdata.get("BASIC_REASON").toString();
        }
        String recommendation = "";
        if (bpmdata.containsKey("RECOMMENDATION")) {
            recommendation = bpmdata.get("RECOMMENDATION").toString();
        }
        if (bpmdata.containsKey("RECOMMENDATION")) {
            recommendation = bpmdata.get("RECOMMENDATION").toString();
        }
        Map data = new HashMap<>();
        data.put("BASIC_REASON", "");
        data.put("RECOMMENDATION", "");
        if (queryResultSet != null
                && queryResultSet.getMainQueryResult() != null
                && StringUtils.hasText(queryResultSet.getMainQueryResult().getDataSourceName())) {
            String dataSourceName = queryResultSet.getMainQueryResult().getDataSourceName();
            //当单身没有数据的时候，单头数据也不需要显示，除非有业务需要
            if (queryResultSet.getMainQueryResult().getData().size() > 0) {
                data.put("BASIC_REASON", basic_reason);
                data.put("RECOMMENDATION", recommendation);
            }
            //这里的datasourcename后续可能需要修改。暂时先这样。
            data.put("render_array", queryResultSet.getPageData().get(dataSourceName));
            pageData.put(dataSourceName, queryResultSet.getPageData().get(dataSourceName));
        }
        pageData.put(masterMetadata.getResponseFields().get(0).getName(), data);
        dynamicForm.setPageData(pageData);
    }

    private List<UiBotPageLayout> bulidPageLayout(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, PcUiBotShowMetadata showMetadata, PcUiBotTaskPageDefine pageDefine, PcUiBotApiMetadata apiMetadata, QueryResultSet queryResultSet) {
        UiBotPageLayout uiBotPageLayout = new UiBotPageLayout();
        uiBotPageLayout.setPageBackgroudColor(null);
        uiBotPageLayout.setShowMore(false);
        uiBotPageLayout.setTitle(localeService.getLanguageValue(executeContext.getLocale(), "数据驱动"));
        uiBotPageLayout.setTitleVisible(false);
        uiBotPageLayout.setPageId("page1");
        uiBotPageLayout.setSchema("a1h8t2ko0a");
        uiBotPageLayout.setComponentType("set-up-page");
        uiBotPageLayout.setHeader(new ArrayList<>());
        List<BaseMobileComponentWrapper<BaseMobileComponent>> bottom = this.buildBottom(executeContext, pageDefine, apiRequest.getSourceType(), apiRequest.getNanaMessageId());
        boolean existSubmitButton = this.checkExistSubmitButton(bottom);
        // 单笔数据 并且 非合并任务，主页面表单渲染------因为合并任务一笔一笔提交，最后一定会剩一笔数据应该以列表渲染
        boolean isOneData = this.onlyOneDataOfList(queryResultSet) && !BooleanUtils.isTrue(pageDefine.getMerge());
        uiBotPageLayout.setBody(this.buildBody(executeContext, showMetadata, existSubmitButton, isOneData, apiRequest.getSourceType(), apiRequest.getNanaMessageId(), pageDefine.getMerge()));
        // 非单笔数据 并且 合并任务，主页面不设置底部按钮
        if (isOneData || !BooleanUtils.isTrue(pageDefine.getMerge())) {
            uiBotPageLayout.setBottom(bottom);
        }
        return Lists.newArrayList(uiBotPageLayout);
    }

    private boolean onlyOneDataOfList(QueryResultSet queryResultSet) {
        if (queryResultSet == null || queryResultSet.getMainQueryResult() == null) {
            return false;
        }
        List<Map<String, Object>> data = queryResultSet.getMainQueryResult().getData();
        if (CollectionUtils.isEmpty(data)) {
            return false;
        }
        return data.size() == 1;
    }

    private boolean checkExistSubmitButton(List<BaseMobileComponentWrapper<BaseMobileComponent>> bottom) {
        if (CollectionUtils.isEmpty(bottom)) {
            return false;
        }
        ButtonGroup buttonGroup = (ButtonGroup) bottom.get(0).getData();
        if (buttonGroup == null) {
            return false;
        }
        List<BaseMobileComponentWrapper<BottomButtonDigiwinAthena>> contentGroup = buttonGroup.getContentGroup();
        if (CollectionUtils.isEmpty(contentGroup)) {
            return false;
        }
        return contentGroup.stream()
                .map(BaseMobileComponentWrapper::getData)
                .map(Button::getSubmitAction)
                .anyMatch(uiBotAction -> Optional
                        .ofNullable(uiBotAction)
                        .map(r -> ButtonTypeEnum.isSubmit(r.getBtnType()))
                        .orElse(false));
    }

    public List<BaseMobileComponentWrapper<BaseMobileComponent>> buildBody(PcUiBotExecuteContext executeContext, PcUiBotShowMetadata showMetadata, boolean existSubmitButton, boolean isOneData, String sourceType, String nanaMessageId, Boolean merge) {
        List<BaseMobileComponentWrapper<BaseMobileComponent>> bodyList = new ArrayList<>();
        if (CollectionUtils.isEmpty(showMetadata.getShowFields())) {
            return bodyList;
        }
        for (PcUiBotMetadataField showField : showMetadata.getShowFields()) {
            if (!isOneData && showField.isArray()) {
                // 组装cardList组件
                List<PcUiBotMetadataField> arraySimpleFields = Optional
                        .ofNullable(showField.getSubFields())
                        .orElse(new ArrayList<>()).stream()
                        .filter(PcUiBotMetadataField::isSimpleField)
                        .collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(arraySimpleFields)) {
                    bodyList.add(this.buildZtbViewList(executeContext.getLocale(), showField, arraySimpleFields, existSubmitButton, sourceType, nanaMessageId, merge));
                }
            } else {
                // 对象
                List<PcUiBotMetadataField> subFields = Optional
                        .ofNullable(showField.getSubFields())
                        .orElse(new ArrayList<>());
                List<PcUiBotMetadataField> simpleFields = subFields.stream()
                        .filter(PcUiBotMetadataField::isSimpleField)
                        .collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(simpleFields)) {
                    // 构建customGroup组件
                    bodyList.add(this.buildCustomGroup(executeContext.getLocale(), showField, simpleFields, existSubmitButton));
                }
                List<PcUiBotMetadataField> arrayFields = subFields.stream()
                        .filter(PcUiBotMetadataField::isArray)
                        .collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(arrayFields)) {
                    // 构建cardList组件
                    for (PcUiBotMetadataField arrayField : arrayFields) {
                        List<PcUiBotMetadataField> arraySimpleFields = Optional
                                .ofNullable(arrayField.getSubFields())
                                .orElse(new ArrayList<>()).stream()
                                .filter(PcUiBotMetadataField::isSimpleField)
                                .collect(Collectors.toList());
                        if (!CollectionUtils.isEmpty(arraySimpleFields)) {
                            bodyList.add(this.buildZtbViewList(executeContext.getLocale(), arrayField, arraySimpleFields, existSubmitButton, sourceType, nanaMessageId, merge));
                        }
                    }

                }
            }
        }
        return bodyList;
    }

    private BaseMobileComponentWrapper<BaseMobileComponent> buildCustomGroup(String locale, PcUiBotMetadataField parentField, List<PcUiBotMetadataField> subFields, boolean existSubmitButton) {
        CustomGroup customGroup = new CustomGroup();
        customGroup.setSchema(parentField.getName());
        customGroup.setName(localeService.getLanguageValue(locale, parentField.getDescription()));
        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_ZTB_SCAN_RECEIVE.getValue());
        customGroup.setContentGroup(this.buildCustomGroupContentGroup(locale, parentField, subFields, existSubmitButton));
        return new BaseMobileComponentWrapper<>(customGroup, "DW_" + CustomGroup.COMPONENT_TYPE, parentField.getName(), parentField.getFullName());
    }

    private List<BaseMobileComponentWrapper<BaseMobileComponent>> buildCustomGroupContentGroup(String locale, PcUiBotMetadataField parentField, List<PcUiBotMetadataField> subFields, boolean existSubmitButton) {
        List<BaseMobileComponentWrapper<BaseMobileComponent>> contentGroup = new ArrayList<>();
        for (PcUiBotMetadataField subField : subFields) {
            if ("true".equals(subField.getDataKey()) && subField.canNotEdit()) {
                // 主键不可编辑，隐藏
                continue;
            }
            if (!existSubmitButton) {
                // 不存在底部按钮时，栏位不可编辑
                subField.setCanEdit(false);
            }
            if (subField.isCanEdit()) {
                // 可编辑
                String dataType = subField.getDataType();
                if (PcUiBotAllFields.DATA_TYPE_BOOLEAN.equalsIgnoreCase(dataType)) {
                    InputSwitch inputSwitch = new InputSwitch();
                    //将true给1，false给0
                    inputSwitch.setState(0);
                    inputSwitch.setTitle(localeService.getLanguageValue(locale, subField.getDescription()));
                    contentGroup.add(new BaseMobileComponentWrapper<>(inputSwitch, "DW_" + InputSwitch.COMPONENT_TYPE, subField.getName(), subField.getFullName()));
                } else if (PcUiBotAllFields.DATA_TYPE_STRING.equalsIgnoreCase(dataType)) {
                    if ("remark".equals(subField.getName())) {
                        // 多行文本
                        InputMultiText inputMultiText = new InputMultiText();
                        inputMultiText.setSchema(subField.getName());
                        inputMultiText.setTitle(localeService.getLanguageValue(locale, subField.getDescription()));
                        inputMultiText.setEnable(true);
                        inputMultiText.setRequired(true);
                        inputMultiText.setShowShadow(false);
                        inputMultiText.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请输入"));
                        contentGroup.add(new BaseMobileComponentWrapper<>(inputMultiText, "DW_" + InputMultiText.COMPONENT_TYPE, subField.getName(), subField.getFullName()));
                    } else {
                        InputSingleText inputSingleText = new InputSingleText();
                        inputSingleText.setRequired(true);
                        inputSingleText.setTitle(localeService.getLanguageValue(locale, subField.getDescription()));
                        inputSingleText.setEnable(true);
                        inputSingleText.setPlaceholder(localeService.getLanguageValue(locale, "请输入"));
                        contentGroup.add(new BaseMobileComponentWrapper<>(inputSingleText, "DW_" + InputSingleText.COMPONENT_TYPE, subField.getName(), subField.getFullName()));
                    }
                } else if (PcUiBotAllFields.DATA_TYPE_DATE.equalsIgnoreCase(dataType)) {
                    InputDateTimePicker inputDateTimePicker = new InputDateTimePicker();
                    inputDateTimePicker.setRequired(true);
                    inputDateTimePicker.setTitle(localeService.getLanguageValue(locale, subField.getDescription()));
                    inputDateTimePicker.setEnable(true);
                    inputDateTimePicker.setPlaceholder(localeService.getLanguageValue(locale, "请输入"));
                    inputDateTimePicker.setType(InputDateTimePickerTypeEnum.YEAR_MONTH_DATE.getType());
                    contentGroup.add(new BaseMobileComponentWrapper<>(inputDateTimePicker, "DW_" + InputDateTimePicker.COMPONENT_TYPE, subField.getName(), subField.getFullName()));
                } else if (PcUiBotAllFields.DATA_TYPE_DATETIME.equalsIgnoreCase(dataType)) {
                    InputDateTimePicker inputDateTimePicker = new InputDateTimePicker();
                    inputDateTimePicker.setRequired(true);
                    inputDateTimePicker.setTitle(localeService.getLanguageValue(locale, subField.getDescription()));
                    inputDateTimePicker.setEnable(true);
                    inputDateTimePicker.setPlaceholder(localeService.getLanguageValue(locale, "请输入"));
                    inputDateTimePicker.setType(InputDateTimePickerTypeEnum.YEAR_MONTH_DATE_HOUR_MINUTE.getType());
                    contentGroup.add(new BaseMobileComponentWrapper<>(inputDateTimePicker, "DW_" + InputDateTimePicker.COMPONENT_TYPE, subField.getName(), subField.getFullName()));
                } else if (PcUiBotAllFields.DATA_TYPE_TIME.equalsIgnoreCase(dataType)) {
                    InputDateTimePicker inputDateTimePicker = new InputDateTimePicker();
                    inputDateTimePicker.setRequired(true);
                    inputDateTimePicker.setTitle(localeService.getLanguageValue(locale, subField.getDescription()));
                    inputDateTimePicker.setEnable(true);
                    inputDateTimePicker.setPlaceholder(localeService.getLanguageValue(locale, "请输入"));
                    inputDateTimePicker.setType(InputDateTimePickerTypeEnum.HOUR_MINUTE.getType());
                    contentGroup.add(new BaseMobileComponentWrapper<>(inputDateTimePicker, "DW_" + InputDateTimePicker.COMPONENT_TYPE, subField.getName(), subField.getFullName()));
                } else if (PcUiBotAllFields.DATA_TYPE_NUMERIC.equalsIgnoreCase(dataType)) {
                    InputNumeric inputNumeric = new InputNumeric();
                    inputNumeric.setRequired(true);
                    inputNumeric.setMaxLength(999);
                    inputNumeric.setPrecision(2);
                    inputNumeric.setEnable(true);
                    inputNumeric.setTitle(localeService.getLanguageValue(locale, subField.getDescription()));
                    inputNumeric.setType(InputNumericTypeEnum.INTEGER.getValue());
                    inputNumeric.setPlaceholder(localeService.getLanguageValue(locale, "请输入"));
                    contentGroup.add(new BaseMobileComponentWrapper<>(inputNumeric, "DW_" + InputNumeric.COMPONENT_TYPE, subField.getName(), subField.getFullName()));
                } else if (PcUiBotAllFields.DATA_TYPE_NUMBER.equalsIgnoreCase(dataType)) {
                    InputNumeric inputNumeric = new InputNumeric();
                    inputNumeric.setRequired(true);
                    inputNumeric.setMaxLength(999);
                    inputNumeric.setPrecision(0);
                    inputNumeric.setEnable(true);
                    inputNumeric.setTitle(localeService.getLanguageValue(locale, subField.getDescription()));
                    inputNumeric.setType(InputNumericTypeEnum.INTEGER.getValue());
                    inputNumeric.setPlaceholder(localeService.getLanguageValue(locale, "请输入"));
                    contentGroup.add(new BaseMobileComponentWrapper<>(inputNumeric, "DW_" + InputNumeric.COMPONENT_TYPE, subField.getName(), subField.getFullName()));
                }
            } else {
                // 不可编辑
                String dataType = subField.getDataType();
                if (PcUiBotAllFields.DATA_TYPE_BOOLEAN.equalsIgnoreCase(dataType)) {
                    InputSwitch inputSwitch = new InputSwitch();
                    //将true给1，false给0
                    inputSwitch.setState(0);
                    inputSwitch.setTitle(localeService.getLanguageValue(locale, subField.getDescription()));
                    inputSwitch.setEnable(false);
                    contentGroup.add(new BaseMobileComponentWrapper<>(inputSwitch, "DW_" + InputSwitch.COMPONENT_TYPE, subField.getName(), subField.getFullName()));
                } else {
                    if ("remark".equals(subField.getName())) {
                        // 多行文本
                        InputMultiText inputMultiText = new InputMultiText();
                        inputMultiText.setSchema(subField.getName());
                        inputMultiText.setTitle(localeService.getLanguageValue(locale, subField.getDescription()));
                        inputMultiText.setEnable(false);
                        inputMultiText.setShowShadow(false);
                        inputMultiText.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请输入"));
                        contentGroup.add(new BaseMobileComponentWrapper<>(inputMultiText, "DW_" + InputMultiText.COMPONENT_TYPE, subField.getName(), subField.getFullName()));
                    } else {
                        Field field = new Field();
                        field.setLabel(localeService.getLanguageValue(locale, subField.getDescription()));
                        field.setEnable(false);
                        field.setLabelStyleType(FieldLabelStyleTypeEnum.LABEL_GREY.getValue());
                        field.setValueStyleType(FieldValueStyleTypeEnum.VALUE_BLACK.getValue());
                        contentGroup.add(new BaseMobileComponentWrapper<>(field, "DW_" + Field.COMPONENT_TYPE, subField.getName(), subField.getFullName()));
                    }
                }
            }
        }
        return contentGroup;
    }

    private BaseMobileComponentWrapper<BaseMobileComponent> buildZtbViewList(String locale, PcUiBotMetadataField parentField, List<PcUiBotMetadataField> subFields, boolean existSubmitButton, String sourceType, String nanaMessageId, Boolean merge) {
        ZtbViewList ztbViewList = new ZtbViewList();
        ztbViewList.setSchema(parentField.getName());
        ztbViewList.setTitle(localeService.getLanguageValue(locale, parentField.getDescription()));
        ztbViewList.setTitleVisible(false);
        ztbViewList.setDetailPageSwiper(true);
        if (BooleanUtils.isTrue(merge)) {
            ztbViewList.setIsAllSubmitScene(false);
        } else {
            ztbViewList.setIsAllSubmitScene(true);
        }
        ztbViewList.setIsCheckList(true);
        ztbViewList.setCardListData(this.buildCardListData(locale, parentField, subFields, existSubmitButton, sourceType, nanaMessageId));
        return new BaseMobileComponentWrapper<>(ztbViewList, "DW_" + ZtbViewList.COMPONENT_TYPE, parentField.getName(), parentField.getFullName());
    }

    private Card buildCardListData(String locale, PcUiBotMetadataField parentField, List<PcUiBotMetadataField> subFields, boolean existSubmitButton, String sourceType, String nanaMessageId) {
        Card card = new Card();
        Card.DesignerRawCard designerRawCard = new Card.DesignerRawCard();
        card.setData(designerRawCard);

        designerRawCard.setNode(parentField.getName());
        designerRawCard.setNodePath(parentField.getFullName());

        List<Card.DesignerRawCard.Content> contentList = new ArrayList<>();
        designerRawCard.setContent(contentList);

        List<PcUiBotMetadataField> notEditFields = subFields.stream().filter(PcUiBotMetadataField::canNotEdit).collect(Collectors.toList());
        for (PcUiBotMetadataField notEditField : notEditFields) {
            if ("true".equals(notEditField.getDataKey()) && notEditField.canNotEdit()) {
                // 主键不可编辑，隐藏
                continue;
            }
            if (designerRawCard.getTitle() == null) {
                designerRawCard.setTitle(notEditField.getName());
                designerRawCard.setTitlePath(notEditField.getFullName());
            } else if (contentList.size() < 4) {
                Card.DesignerRawCard.Content content = new Card.DesignerRawCard.Content();
                content.setSchema(notEditField.getName());
                content.setLabel(localeService.getLanguageValue(locale, notEditField.getDescription()));
                content.setType("LABEL");
                contentList.add(content);
            }
        }

        Card.DesignerRawCard.DetailPage detailPage = new Card.DesignerRawCard.DetailPage();
        designerRawCard.setDetailPage(detailPage);

        // 开启弹窗、开启滑动特效
        detailPage.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        detailPage.setDetailPageSwiper(true);
        detailPage.setPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_DATA_DRIVEN_DSL_UNIVERSAL_PARSING_PAGE.name());
        Map<String, Object> rawData = new HashMap<>();
        rawData.put("parentField", parentField);
        rawData.put("existSubmitButton", existSubmitButton);
        rawData.put("sourceType", sourceType);
        rawData.put("nanaMessageId", nanaMessageId);
        detailPage.setRawData(rawData);

        // card按钮构建
        List<UiBotAction> buttonList = new ArrayList<>();
        designerRawCard.setButtonList(buttonList);

        UiBotAction uiBotAction = new UiBotAction();
        buttonList.add(uiBotAction);

        uiBotAction.setBtnId(parentField.getName());
        uiBotAction.setTitle(existSubmitButton ?
                localeService.getLanguageValue(locale, "去处理")
                :
                localeService.getLanguageValue(locale, "已处理"));
        uiBotAction.setBtnType(ButtonTypeEnum.JUMP.getValue());
        UiBotJumpAction uiBotJumpAction = new UiBotJumpAction();
        uiBotAction.setJumpAction(uiBotJumpAction);
        uiBotJumpAction.setDetailPageSwiper(true);
        uiBotJumpAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_DATA_DRIVEN_DSL_UNIVERSAL_PARSING_PAGE.name());
        uiBotJumpAction.setType(ActionTypeEnum.CUSTOMIZE_POPUP_DISPLAYS_PAGE.getValue());
        uiBotJumpAction.setIsCheckButton(false);
        uiBotJumpAction.setBtnStyleType(existSubmitButton ?
                BottomButtonStyleEnum.DETAIL_STRESS.getValue()
                :
                BottomButtonStyleEnum.DETAIL_NORMAL.getValue());
        uiBotJumpAction.setRawData(rawData);

        designerRawCard.setOpenDetailType(existSubmitButton ?
                CardOpenDetailTypeEnum.BY_BUTTON.getValue()
                :
                CardOpenDetailTypeEnum.BY_BUTTON_AND_CARD.getValue());
        return card;
    }

    private List<BaseMobileComponentWrapper<BaseMobileComponent>> buildBottom(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, String sourceType, String nanaMessageId) {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.setContentGroup(this.buildButtonGroupContentGroup(executeContext, pageDefine, sourceType, nanaMessageId));
        return Lists.newArrayList(new BaseMobileComponentWrapper<>(buttonGroup, "DW_" + ButtonGroup.COMPONENT_TYPE));
    }

    private List<BaseMobileComponentWrapper<BottomButtonDigiwinAthena>> buildButtonGroupContentGroup(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, String sourceType, String nanaMessageId) {
//        // wjw TODO: 2023/10/24 模拟提交按钮
//        PcUiBotSubmitAction submitAction = new PcUiBotSubmitAction();
//        submitAction.setSubmitType(new PcUiBotSubmitType());
        if (BooleanUtils.isTrue(pageDefine.getFinished())) {
            // 已完成任务，不展示提交按钮
            return new ArrayList<>();
        }
        List<PcUiBotSubmitAction> submitActions = pageDefine.getSubmitActions();
        if (CollectionUtils.isEmpty(submitActions)) {
            return new ArrayList<>();
        }
        // 只展示提交按钮
        Optional<PcUiBotSubmitAction> uiBotActionOptional = submitActions.stream().filter(r -> "TaskEngine".equals(r.getType()) && "submit-data".equals(r.getActionId())).findFirst();
        if (!uiBotActionOptional.isPresent()) {
            return new ArrayList<>();
        }
        // 封装提交action
        PcUiBotSubmitAction submitAction = uiBotActionOptional.get();

        String uuid = UUIDUtil.getUuid();
        submitAction.setUuid(uuid);
        submitAction.setBtnId(uuid);
        submitAction.setTitle(localeService.getLanguageValue(executeContext.getLocale(), "提交"));
        submitAction.setBtnType(ButtonTypeEnum.SUBMIT.getValue());
        UiBotJumpAction uiBotJumpAction = new UiBotJumpAction();
        submitAction.setJumpAction(uiBotJumpAction);
        uiBotJumpAction.setBtnStyleType(BottomButtonStyleEnum.STRESS.getValue());
        if ("nana".equals(sourceType) || StringUtils.hasLength(sourceType)) {
            // nana 来源，直接刷新主页面，因为无法处理跳转第三方
            uiBotJumpAction.setType(ActionTypeEnum.REFRESH.getValue());
            uiBotJumpAction.setJumpPageId("page1");
        } else {
            // 其它，返回上一页并刷新
            uiBotJumpAction.setType(ActionTypeEnum.BACK_ONE_WITH_REFRESH.getValue());
        }
        uiBotJumpAction.setNanaMessageId(nanaMessageId);
        uiBotJumpAction.setIsCheckButton(true);
        uiBotJumpAction.setConfirmPop(ConfirmPop
                .create(localeService.getLanguageValue(AppRequestContext.getContextEntity().getLocale(), "是否确定")
                                + submitAction.getTitle()
                                + "？",
                        true));

        BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
        button.setSubmitAction(JsonUtil.objectToJavaObject(submitAction, new TypeReference<UiBotAction>() {
        }));

        return Lists.newArrayList(new BaseMobileComponentWrapper<>(button, "DW_" + Button.COMPONENT_TYPE, uuid));
    }
}
