package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.builder;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotBaseDataUtil;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：低代码设计器DSL</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: BaseDataDesignerDocumentPageBuilder.java
 * @Author: wangjwc
 * @Date: created at 2023/11/21 13:06
 */
@Service
public class BaseDataDesignerDocumentPageBuilder extends DslPageBuilderBase<PcUiBotPageDefine> {
    /**
     * 返回支持的类型
     *
     * @return
     */
    public String supportKey() {
        return "baseDataDesignerDocumentPageBuilder";
    }

    @Override
    public UiBotModel createPage(PcUiBotExecuteContext executeContext, QueryResultSet queryResultSet, PcUiBotPageDefine pageDefine, ApiRequest apiRequest) {
        UiBotModel dynamicForm = super.createPage(executeContext, queryResultSet, pageDefine, apiRequest);
        return dynamicForm;
    }

//    @Override
//    public UiBotModel createPage(PcUiBotExecuteContext executeContext, QueryResultSet queryResultSet, PcUiBotPageDefine pageDefine, ApiRequest apiRequest) {
//        UiBotModel dynamicForm = super.createPage(executeContext, queryResultSet, pageDefine, apiRequest);
//        if (pageDefine.getParameter() == null) {
//            dynamicForm.getPageData().put(PcUiBotConstants.UIBOT_PAGE_PARAMETER, pageDefine.getParameter());
//            Object key = pageDefine.getDataSourceSet().getMainDatasource();
//            Object pageDataObj = dynamicForm.getPageData().get(key);
//            if (pageDataObj instanceof Map) {
//                Map pageDataMap = (Map) pageDataObj;
//                pageDataMap.put("manage_status", "N");
//                dynamicForm.getPageData().put(pageDefine.getDataSourceSet().getMainDatasource(), pageDataMap);
//            }
//        }
//        return dynamicForm;
//    }

    @Override
    public QueryResultSet BuildDataSource(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine) {
        QueryResultSet queryResultSet = super.BuildDataSource(executeContext, pageDefine);
        Map<String, Object> pageData = queryResultSet.getPageData();
        //往每行数据中塞入 标识行数据编辑状态的edit_type字段
        appendField(pageData);
        return queryResultSet;
    }

    protected void appendField(Map<String, Object> pageData) {
        if (CollectionUtils.isEmpty(pageData)) {
            return;
        }
        for (Object data : pageData.values()) {
            if (data instanceof List) {
                List rowDataList = (List) data;
                for (Object rowData : rowDataList) {
                    Map rowDataMap = (Map) rowData;
                    rowDataMap.putAll(PcUiBotActivityConstants.EDIT_TYPE_MAP);
                    PcUiBotBaseDataUtil.putManageStatusIfAbsent(rowDataMap);
                }
            } else if (data instanceof Map) {
                Map rowDataMap = (Map) data;
                rowDataMap.putAll(PcUiBotActivityConstants.EDIT_TYPE_MAP);
            }
        }
    }

//    /**
//     * 创建布局   基础资料双档需要将action放到layout中
//     *
//     * @param queryResultSet
//     * @param pageDefine
//     * @param dynamicForm
//     */
//    @Override
//    protected void BuildLayout(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, QueryResultSet queryResultSet, PcUiBotPageDefine pageDefine, UiBotModel dynamicForm) {
//        super.BuildLayout(apiRequest, executeContext, queryResultSet, pageDefine, dynamicForm);
    // 双档主页签-所有列都设置为不可编辑（submitAction要配合设置为ACTIVE_ROW）
//        if (PcUiBotActivityConstants.BROWSE_PAGE.equals(executeContext.getPageCode())) {
//            disableColumnEdit(dynamicForm);
//        }
//        analysisLayout(pageDefine, dynamicForm);
//        BuildExplanationLayout(pageDefine.getExplanation(), dynamicForm);
//    }

//    private void disableColumnEdit(UiBotModel dynamicForm) {
//        List<GridColumnDef> columnDefs = new ArrayList<>();
//        List<AbstractComponent> layout = dynamicForm.getLayout();
//        if (CollectionUtils.isEmpty(layout)) {
//            return;
//        }
//        for (AbstractComponent layoutTemp : layout) {
//            if (null != layoutTemp && layoutTemp instanceof GridComponent) {
//                GridComponent tableComponent = (GridComponent) layoutTemp;
//                columnDefs = tableComponent.getColumnDefs();
//                break;
//            }
//        }
//        if (CollectionUtils.isEmpty(columnDefs)) {
//            return;
//        }
//        for (GridColumnDef columnDef : columnDefs) {
//            List<AbstractComponent> columns = columnDef.getColumns();
//            if (CollectionUtils.isEmpty(columns)) {
//                continue;
//            }
//            List<AbstractComponent> tmpColumns = new ArrayList<>(columns);
//            Iterator<AbstractComponent> iterator = tmpColumns.iterator();
//            while (iterator.hasNext()) {
//                AbstractComponent column = iterator.next();
//                if (!"BUTTON_GROUP".equals(column.getType())) {
//                    column.setEditable(false);
//                    column.setDisabled(true);
//                }
//                //xuxx add 兼容 附件组件不editable与正常组件不一致情况，待组件优化后删除
//                if (column instanceof FormAttachmentComponent) {
//                    FormAttachmentComponent columnAtt = (FormAttachmentComponent) column;
//                    if (columnAtt.getAttribute() != null && columnAtt.getAttribute().containsKey("uploadEnable")) {
//                        columnAtt.getAttribute().put("uploadEnable", false);
//                    }
//                }
//            }
//            columnDef.setColumns(tmpColumns);
//        }
//    }


//    private void analysisLayout(PcUiBotPageDefine pageDefine, UiBotModel dynamicForm) {
//        List<UiBotLayout> layout = new ArrayList<>();
//        if (CollectionUtils.isNotEmpty(dynamicForm.getLayout())) {
//            int index = 0;
//            List<String> dataKeys = null;
//            if (pageDefine.getDataSourceSet() != null
//                    && pageDefine.getDataSourceSet().getFirstDataQuery() != null
//                    && CollectionUtils.isNotEmpty(pageDefine.getDataSourceSet().getFirstDataQuery().getDataKeys())) {
//                dataKeys = pageDefine.getDataSourceSet().getFirstDataQuery().getDataKeys();
//            }
//
//            for (UiBotLayout layoutTemp : dynamicForm.getLayout()) {
//                if (layoutTemp instanceof GridComponent) {
//                    BasicDataTableComponent tableComponent = new BasicDataTableComponent();
//                    BeanUtils.copyProperties(layoutTemp, tableComponent);
//                    if (index == 0) {
//                        tableComponent.setActions(pageDefine.getSubmitActions());
//
//                        Map<String, List<String>> pageDataKeys = new HashMap<>();
//                        pageDataKeys.put(tableComponent.getSchema(), dataKeys);
//                        tableComponent.setPageDataKeys(pageDataKeys);
//
//                    }
//                    tableComponent.setIsBaseData(true);
//                    //回收站情况下表格设置相关功能禁用，后续有需求在开启
//                    if (pageDefine.getExecuteContext() != null
//                            && UiBotConstants.ACTION_CATEGORY_RECYCLE.equals(pageDefine.getExecuteContext().getCategory())) {
//                        JSONArray settingList = new JSONArray();
//                        JSONObject setting = new JSONObject();
//                        settingList.add("composite-sort");
//                        settingList.add("setting");
//                        settingList.add("advanced-search");
//                        setting.put("hideDefaultToolbar", settingList);
//                        tableComponent.setSetting(setting);
//                    }
//                    layout.add(tableComponent);
//                } else if (layoutTemp instanceof FormComponent) {
//                    FormComponent formComponent = (FormComponent) layoutTemp;
//                    // actions和前端约定好，放入layout中
//                    if (index == 0) {
//                        formComponent.setActions(pageDefine.getSubmitActions());
//                        if (CollectionUtils.isNotEmpty(dataKeys) && CollectionUtils.isNotEmpty(formComponent.getGroup())) {
//                            List<String> finalDataKeys = dataKeys;
//                            formComponent.getGroup().forEach(group -> {
//                                //业务主键在编辑时不允许修改；新增和复制时可以修改
//                                if ("query".equals(pageDefine.getExecuteContext().getEditType())) {
//                                    group.setEditableDisabled(true);
//                                } else if (finalDataKeys.contains(group.getSchema())
//                                        && (pageDefine.getExecuteContext().getEditType() == null
//                                        || "edit".equals(pageDefine.getExecuteContext().getEditType()))) {
//                                    group.setEditableDisabled(false);
//                                }
//                            });
//                        }
//                    }
//                    layout.add(formComponent);
//                } else {
//                    layout.add(layoutTemp);
//                }
//                index++;
//            }
//            dynamicForm.setLayout(layout);
//        }
//    }

}
