package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.builder;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotActivityConstants;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDoubleDocumentPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.QueryResultSet;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotBuilderUtils;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：标准型任务模板--根据固定的模板创建页面</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: BaseDataDoubleDocumentPageBuilder.java
 * @Author: wangjwc
 * @Date: created at 2023/11/16 18:02
 */
@Service
public class BaseDataDoubleDocumentPageBuilder extends PageBuilderBase<PcUiBotDoubleDocumentPageDefine> {
    /**
     * 返回支持的类型
     *
     * @return
     */
    @Override
    public String supportKey() {
        return "baseDataDoubleDocumentPageBuilder";
    }

    private static final List<String> CUSTOM_OPEN_WINDOW_OPERATE = Arrays.asList("openwindow", "open-task-window", "openpage", "add", "edit");

    private static final String EDIT_TYPE_COPY = "copy";

    private static final String EDIT_TYPE_ADD = "add";

    public static final String INSTANCE_NAME = "buttonGroupInterpreter";


//    @Autowired
//    ShowFieldService showFieldService;

//    @Autowired
//    private MessageUtils messageUtils;

//    @Override
//    public DynamicForm createPage(ExecuteContext executeContext, QueryResultSet queryResultSet, DoubleDocumentPageDefine pageDefine) {
//        analysisCustomOpenWindowOperations(pageDefine);
//        if (this.businessKeyCanEdit(pageDefine.getEditType())) {
//            resetRowDataBusinessKey(queryResultSet.getQueryResults());
//        }
//        DynamicForm dynamicForm = super.createPage(executeContext, queryResultSet, pageDefine);
//        dynamicForm.getPageData().put(UiBotConstants.UIBOT_PAGE_PARAMETER, pageDefine.getParameter());
//        Object key = pageDefine.getDataSourceSet().getMainDatasource();
//        Object pageDataObj = dynamicForm.getPageData().get(key);
//        Map<String, Object> extendedFields = pageDefine.getExtendedFields();
//        if (MapUtils.isNotEmpty(extendedFields)) {
//            Object needStatusColumn = extendedFields.get("needStatusColumn");
//            // 只有显式配置了 needStatusColumn=true，才会去检查并创建空manage_status列
//            if (Boolean.valueOf(needStatusColumn.toString())) {
//                if (pageDataObj instanceof Map) {
//                    Map pageDataMap = (Map) pageDataObj;
//                    pageDataMap.put("manage_status", "Y");
//                    dynamicForm.getPageData().put(pageDefine.getDataSourceSet().getMainDatasource(), pageDataMap);
//                }
//            }
//        }
//        return dynamicForm;
//    }

//    private void resetRowDataBusinessKey(List<QueryResult> queryResults) {
//        for (QueryResult queryResult : queryResults) {
//            List<String> dataKeys = queryResult.getDataKeys();
//            if (CollectionUtils.isEmpty(dataKeys)) {
//                continue;
//            }
//
//            if (CollectionUtils.isEmpty(queryResult.getData())) {
//                return;
//            }
//            for (Map<String, Object> pageData : queryResult.getData()) {
//                if (MapUtils.isNotEmpty(pageData)) {
//                    for (String dataKey : dataKeys) {
//                        pageData.put(dataKey, null);
//                    }
//                }
//            }
//        }
//    }


//    private boolean businessKeyCanEdit(String editType) {
//        return EDIT_TYPE_COPY.equalsIgnoreCase(editType);
//    }

//    private void analysisCustomOpenWindowOperations(PageDefine mainAction) {
//        if (mainAction.getOperations() == null) {
//            return;
//        }
//        for (OperationDTO operation : mainAction.getOperations()) {
//            if (!CUSTOM_OPEN_WINDOW_OPERATE.contains(operation.getType())) {
//                continue;
//            }
//            OpenWindowDefineDTO openWindowDef = operation.getOpenWindowDefine();
//            if (null != openWindowDef && BooleanUtils.isTrue(openWindowDef.getIsCustomize())) {
//                changePatternToCustom(openWindowDef.getAllAction());
//                changePatternToCustom(openWindowDef.getGetDataAction());
//                changePatternToCustom(openWindowDef.getGetDataActions());
//                changePatternToCustom(openWindowDef.getSuggestAction());
//            }
//        }
//    }

//    private void changePatternToCustom(List<PageDefine> pageDefineList) {
//        if (CollectionUtils.isNotEmpty(pageDefineList)) {
//            pageDefineList.forEach(activityQueryDTO -> changePatternToCustom(activityQueryDTO));
//        }
//    }

//    private void changePatternToCustom(PageDefine pageDefine) {
//        if (null != pageDefine && null != pageDefine.getExecuteContext()) {
//            pageDefine.getExecuteContext().setPattern(ActivityConstants.PATTERN_CUSTOM);
//        }
//    }

    @Override
    public QueryResultSet BuildDataSource(PcUiBotExecuteContext executeContext, PcUiBotDoubleDocumentPageDefine pageDefine) {
        if (pageDefine.getExecuteContext() != null
                && PcUiBotActivityConstants.CATEGORY_TREEDATA_DOUBLE_DOC.equals(pageDefine.getExecuteContext().getCategory())) {
            QueryResultSet queryResultSet = QueryResultSet.empty();
            if (pageDefine.getDataSourceSet() != null) {
                queryResultSet.getMainQueryResult().setDataSourceName(pageDefine.getDataSourceSet().getMainDatasource());
            }
            PcUiBotBuilderUtils.setTotalResultsDefault(pageDefine, queryResultSet);
            return queryResultSet;
        }
        QueryResultSet queryResultSet = super.BuildDataSource(executeContext, pageDefine);
        Map<String, Object> pageData = queryResultSet.getPageData();
        //往每行数据中塞入，标识行数据编辑状态的edit_type字段
        this.appendField(pageData);
        PcUiBotBuilderUtils.setTotalResultsDefault(pageDefine, queryResultSet);
        return queryResultSet;
    }

//    private boolean needAppendButtonGroupField(PageDefine pageDefine) {
//        if (CollectionUtils.isEmpty(pageDefine.getOperations())) {
//            return false;
//        }
//        // 有operation.applyToField作用于行（row）且指向BUTTON_GROUP字段
//        Optional<OperationDTO> optional = pageDefine.getOperations().stream().filter(operationDTO ->
//                        null != operationDTO.getAttach()
//                                && StringUtils.equalsIgnoreCase(OperationService.ROW, operationDTO.getAttach().getMode())
//                                && StringUtils.equals(operationDTO.getAttach().getApplyToField(), ButtonGroupComponentImpl.COMPONENT_TYPE))
//                .findAny();
//        return optional.isPresent();
//    }

    protected void appendField(Map<String, Object> pageData) {
        if (CollectionUtils.isEmpty(pageData)) {
            return;
        }
        for (Object data : pageData.values()) {
            if (data instanceof List) {
                List rowDataList = (List) data;
                for (Object rowData : rowDataList) {
                    Map rowDataMap = (Map) rowData;
                    rowDataMap.putAll(PcUiBotActivityConstants.EDIT_TYPE_MAP);
                }
            } else if (data instanceof Map) {
                Map rowDataMap = (Map) data;
                rowDataMap.putAll(PcUiBotActivityConstants.EDIT_TYPE_MAP);
            }
        }
    }

//    /**
//     * 生成界面：双档结构
//     *
//     * @param buildContext
//     * @param dataKeys
//     * @param rootField
//     * @param pageDefine
//     * @return
//     */
//    @Override
//    public List<MetadataField> getShowFields(BuildContext buildContext, List<String> dataKeys, MetadataField rootField, DoubleDocumentPageDefine pageDefine) {
//        ExecuteContext executeContext = buildContext.getExecuteContext();
//        Map<String, MetadataField> needShowFields = new LinkedHashMap<>();
//
//        //主页签上加操作按钮
//        if ((ActivityConstants.BROWSE_PAGE.equals(executeContext.getPageCode())
//                || ActivityConstants.BASIC_DATA.equals(executeContext.getPageCode()))
//                && ActivityConstants.CATEGORY_DOUBLE_DOC.equals(executeContext.getCategory())) {
//            if (rootField.getFieldMap().containsKey(MANAGE_STATUS)
//                    && CollectionUtils.isNotEmpty(rootField.getFieldMap().get(MANAGE_STATUS).getTagDefinitions())) {
//                addManageStatusField(rootField, pageDefine);
//            } else {
//                Map<String, Object> extendedFields = buildContext.getPageDefine().getExtendedFields();
//                if (MapUtils.isNotEmpty(extendedFields)) {
//                    if (extendedFields.containsKey("needStatusColumn")) {
//                        Object needStatusColumn = extendedFields.get("needStatusColumn");
//                        // 只有显式配置了 needStatusColumn=true，才会去检查并创建空manage_status列
//                        if (Boolean.valueOf(needStatusColumn.toString())) {
//                            addManageStatusField(rootField, pageDefine);
//                        }
//                    }
//                }
//            }
//            // 添加全局数据源处理器，用于动态添加BUTTON_GROUP元数据
//            if (needAppendButtonGroupField(pageDefine)) {
//                addButtonGroupField(rootField);
//            }
//        }
//        Map<String, MetadataField> fieldMap = rootField.getFieldMap();
//
//        //1、主键列
//        if (CollectionUtils.isNotEmpty(dataKeys)) {
//            for (String dataKey : dataKeys) {
//                if (fieldMap.get(dataKey).getTagDefinitions() != null) {
//                    if (!dataKey.endsWith("_seq") && fieldMap.containsKey(dataKey)) {
//                        needShowFields.put(rootField.getName() + "." + dataKey, fieldMap.get(dataKey));
//                    }
//                }
//            }
//        }
//        //用于兼容，没有配置双档页面browse-page界面
//        if (CollectionUtils.isEmpty(pageDefine.getShowDataProperties())) {
//            List<String> showDataProperties = new ArrayList<String>();
//
//            fieldMap.entrySet()
//                    .stream()
//                    .map(m -> showDataProperties.add(m.getKey()))
//                    .collect(Collectors.toList());
//
//            pageDefine.setShowDataProperties(showDataProperties);
//        }
//        if (!pageDefine.getShowDataProperties().contains(MANAGE_STATUS)) {
//            pageDefine.getShowDataProperties().add(MANAGE_STATUS);
//        }
//        //2、显示字段，把按钮和子表过滤掉
//        for (String fieldName : pageDefine.getShowDataProperties()) {
//            //如果进入的是编辑页面，则需要解析主表信息
//            if ((fieldMap.containsKey(fieldName) && !fieldMap.get(fieldName).getDataType().equals(ApiMetadataConstants.METADATA_OBJECT)
//                    && !"Y".equals(fieldMap.get(fieldName).getUiBot()))
//                    && CollectionUtils.isNotEmpty(fieldMap.get(fieldName).getTagDefinitions())
//            ) {
//                needShowFields.put(rootField.getName() + "." + fieldName, fieldMap.get(fieldName));
//            }
//        }
//        //前端约定必有字段，当edit_type=1时，这条数据是update，当edit_type=0时，这条数据insert
//        Optional<String> tempOption = ActivityConstants.EDIT_TYPE_MAP.keySet().stream().findFirst();
//        tempOption.ifPresent(s -> pageDefine.getShowDataProperties().add(s));
//
//
//        //没有tag显示所有字段，先把按钮和子表过滤掉
//        if (needShowFields.size() == 0) {
//            if (CollectionUtils.isNotEmpty(dataKeys)) {
//                for (String dataKey : dataKeys) {
//                    if (fieldMap.containsKey(dataKey)) {
//                        needShowFields.put(rootField.getName() + "." + dataKey, fieldMap.get(dataKey));
//                    }
//                }
//            }
//            for (String fieldName : pageDefine.getShowDataProperties()) {
//                if (fieldMap.containsKey(fieldName)
//                        && !needShowFields.containsKey(rootField.getName() + "." + fieldName)) {
//                    if ((!fieldMap.get(fieldName).getDataType().equals(ApiMetadataConstants.METADATA_OBJECT)
//                            && !"Y".equals(fieldMap.get(fieldName).getUiBot()))) {
//                        needShowFields.put(rootField.getName() + "." + fieldName, fieldMap.get(fieldName));
//                    }
//                }
//            }
//        }
//
//        //先将双档的主页签上加生失效状态
//        if ((ActivityConstants.BROWSE_PAGE.equals(executeContext.getPageCode())
//                || ActivityConstants.BASIC_DATA.equals(executeContext.getPageCode()))
//                && ActivityConstants.CATEGORY_DOUBLE_DOC.equals(executeContext.getCategory())) {
//            if (!needShowFields.containsKey(MANAGE_STATUS) && fieldMap.containsKey(MANAGE_STATUS)
//                    && CollectionUtils.isNotEmpty(fieldMap.get(MANAGE_STATUS).getTagDefinitions())) {
//                needShowFields.put(rootField.getName() + "." + MANAGE_STATUS, fieldMap.get(MANAGE_STATUS));
//                fieldMap.get(MANAGE_STATUS).setCanEdit(false);
//            }
//
//            //将双档的主页签上增加操作列
//            if (needAppendButtonGroupField(pageDefine)) {
//                if (!needShowFields.containsKey("BUTTON_GROUP") && fieldMap.containsKey("BUTTON_GROUP")) {
//                    needShowFields.put(rootField.getName() + ".BUTTON_GROUP", fieldMap.get("BUTTON_GROUP"));
//                }
//            }
//        }
//
//        //3,添加按钮、附件等特殊字段，
//        for (MetadataField subField : rootField.getSubFields()) {
//            //如果是编辑或新增时，则需要显示，单头单身
//            if ("Y".equals(subField.getUiBot())
//                    && CollectionUtils.isNotEmpty(subField.getTagDefinitions())
//                    && !needShowFields.containsKey(rootField.getName() + "." + subField.getName())) {
//                needShowFields.put(rootField.getName() + "." + subField.getName(), subField);
//            }
//        }
//        //编辑页面需要显示的字段，单头放在上面，单身显示在下面；
//        if (ActivityConstants.EDIT_PAGE.equals(executeContext.getPageCode())) {
//            Map<String, Object> extendedFields = pageDefine.getExtendedFields();
//            if (MapUtils.isNotEmpty(extendedFields)) {
//                Object needStatusColumn = extendedFields.get("needStatusColumn");
//                // 只有显式配置了 needStatusColumn=true，才会去检查并创建空manage_status列
//                if (Boolean.valueOf(needStatusColumn.toString())) {
//                    if (!needShowFields.containsKey(MANAGE_STATUS) && fieldMap.containsKey(MANAGE_STATUS)) {
//                        needShowFields.put(rootField.getName() + "." + MANAGE_STATUS, fieldMap.get(MANAGE_STATUS));
//                        fieldMap.get(MANAGE_STATUS).setCanEdit(false);
//                    }
//                }
//            }
//            for (MetadataField subField : rootField.getSubFields()) {
//                if (subField.getDataType().equals(ApiMetadataConstants.METADATA_OBJECT)) {
//                    for (MetadataField metadataField : subField.getSubFields()) {
//                        if (!ApiMetadataConstants.METADATA_OBJECT.equals(metadataField.getDataType())) {
//                            if (UnEditableTagUtils.analysisTagNotMove(metadataField)) {
//                                metadataField.setCanEdit(false);
//                            } else {
//                                metadataField.setCanEdit(true);
//                            }
//                        }
//                    }
//                    needShowFields.put(rootField.getName() + "." + subField.getName(), subField);
//                } else {
//                    if (UnEditableTagUtils.analysisTagNotMove(subField)) {
//                        subField.setCanEdit(false);
//                    } else {
//                        subField.setCanEdit(true);
//                    }
//                }
//            }
//        }
//
//        //重新整理Object字段
//        Map<String, MetadataField> needShowFields_ok = new LinkedHashMap<>();
//        if (ActivityConstants.BROWSE_PAGE.equals(executeContext.getPageCode())
//                || ActivityConstants.BASIC_DATA.equals(executeContext.getPageCode())) {
//            for (MetadataField showFields : needShowFields.values()) {
//                if (!showFields.getDataType().equals(ApiMetadataConstants.METADATA_OBJECT)) {
//                    if (ActivityConstants.CATEGORY_DOUBLE_DOC.equals(executeContext.getCategory())) {
//                        showFields.setCanEdit(false);
//                    }
//                    needShowFields_ok.put(rootField.getName() + "." + showFields.getName(), showFields);
//                }
//            }
//        } else {
//            for (MetadataField showFields : needShowFields.values()) {
//                if (!showFields.getDataType().equals(ApiMetadataConstants.METADATA_OBJECT)) {
//                    needShowFields_ok.put(rootField.getName() + "." + showFields.getName(), showFields);
//                }
//            }
//        }
//        // 移除字段
//        List<Object> apiMetadataColumnNameList = new ArrayList<>();
//        apiMetadataColumnNameList.add(fieldMap.keySet());
//        showFieldService.removeIfNecessary(needShowFields_ok, executeContext, apiMetadataColumnNameList,
//                buildContext.getQueryResultSet(), pageDefine);
//        //重新整理Object字段
//        return showFieldService.refreshObjectField(executeContext, needShowFields_ok, rootField, buildContext.getQueryResultSet(), pageDefine);
//
//    }

//    /**
//     * 创建布局   基础资料双档需要将action放到layout中
//     *
//     * @param executeContext
//     * @param queryResultSet
//     * @param pageDefine
//     * @param dynamicForm
//     */
//    @Override
//    protected void BuildLayout(ExecuteContext executeContext, QueryResultSet queryResultSet, DoubleDocumentPageDefine pageDefine, DynamicForm dynamicForm) {
//        super.BuildLayout(executeContext, queryResultSet, pageDefine, dynamicForm);
//        // 双档主页签-所有列都设置为不可编辑（submitAction要配合设置为ACTIVE_ROW）
//        if (ActivityConstants.BROWSE_PAGE.equals(executeContext.getPageCode())
//                || ActivityConstants.BASIC_DATA.equals(executeContext.getPageCode())) {
//            disableColumnEdit(dynamicForm);
//        }
//        analysisLayout(pageDefine, dynamicForm);
//        super.BuildExplanationLayout(pageDefine.getExplanation(), dynamicForm);
//    }


//    private void analysisLayout(DoubleDocumentPageDefine pageDefine, DynamicForm dynamicForm) {
//        List<AbstractComponent> layout = new ArrayList<>();
//        if (CollectionUtils.isNotEmpty(dynamicForm.getLayout())) {
//            for (AbstractComponent layoutTemp : dynamicForm.getLayout()) {
//                if (layoutTemp instanceof GridComponent) {
//                    BasicDataTableComponent tableComponent = new BasicDataTableComponent();
//                    BeanUtils.copyProperties(layoutTemp, tableComponent);
//                    //tableComponent.setAllFields(appendAllFieldsButtonGroup(tableComponent.getAllFields()));
//                    // actions和前端约定好，放入layout中
//                    if (pageDefine.getDataSourceSet().getMainDatasource().equals(layoutTemp.getSchema())) {
//                        tableComponent.setActions(pageDefine.getSubmitActions());
//                    }
//                    tableComponent.setIsBaseData(true);
//                    layout.add(tableComponent);
//                    tableComponent.setAllFields(appendAllFieldsButtonGroup(tableComponent.getAllFields()));
//                } else if (layoutTemp instanceof FormComponent) {
//                    FormComponent formComponent = (FormComponent) layoutTemp;
//                    // actions和前端约定好，放入layout中
//                    if (pageDefine.getDataSourceSet().getMainDatasource().equals(layoutTemp.getSchema())) {
//                        formComponent.setActions(pageDefine.getSubmitActions());
//                    }
//                    layout.add(formComponent);
//                } else {
//                    layout.add(layoutTemp);
//                }
//            }
//            dynamicForm.setLayout(layout);
//        }
//    }

//    private void disableColumnEdit(DynamicForm dynamicForm) {
//        List<GridColumnDef> columnDefs = new ArrayList<>();
//        List<AbstractComponent> layout = dynamicForm.getLayout();
//        if (CollectionUtils.isEmpty(layout)) {
//            return;
//        }
//        for (AbstractComponent layoutTemp : layout) {
//            if (null != layoutTemp && layoutTemp instanceof GridComponent) {
//                GridComponent tableComponent = (GridComponent) layoutTemp;
//                columnDefs = tableComponent.getColumnDefs();
//                break;
//            }
//        }
//        if (CollectionUtils.isEmpty(columnDefs)) {
//            return;
//        }
//        for (GridColumnDef columnDef : columnDefs) {
//            List<AbstractComponent> columns = columnDef.getColumns();
//            if (CollectionUtils.isEmpty(columns)) {
//                continue;
//            }
//            List<AbstractComponent> tmpColumns = new ArrayList<>(columns);
//            Iterator<AbstractComponent> iterator = tmpColumns.iterator();
//            while (iterator.hasNext()) {
//                AbstractComponent column = iterator.next();
//                column.setEditable(false);
//            }
//            columnDef.setColumns(tmpColumns);
//        }
//    }

//    /**
//     * 添加提交的逻辑
//     *
//     * @param executeContext
//     * @param pageDefine
//     * @param dynamicForm
//     */
//    @Override
//    protected void BuildActions(ExecuteContext executeContext, DoubleDocumentPageDefine pageDefine, DynamicForm dynamicForm) {
//        // 基础资料录入，就算有没有业务数据，也要返回提交按钮
//        dynamicForm.setActions(pageDefine.getSubmitActions());
//    }


//    private void addManageStatusField(MetadataField responseField, PageDefine pageDefine) {
//        MetadataField field = new MetadataField();
//        field.setName(MANAGE_STATUS);
//        field.setDataType("string");
//        field.setPath(responseField.getName());
//        field.setDescription(messageUtils.getMessage("uibot.template.basicData.column.headerName"));
//        List<TagDefinition> tagDefs = Lists.newArrayList();
//        BaseDataManagerStatusTagDefinition tagDef = new BaseDataManagerStatusTagDefinition();
//        tagDef.setCode(TagConstant.BUSINESS_BASE_DATA_MANAGER_STATUS);
//        tagDef.setCategory(TagConstant.CATEGORY_BUSINESS);
//        tagDef.setInterpreterServiceName("baseDataManagerStatusInterpreter");
//        tagDef.setCustomize(false);
//        if (pageDefine != null) {
//            Map<String, Object> extendedFields = pageDefine.getExtendedFields();
//            if (MapUtils.isNotEmpty(extendedFields)
//                    && extendedFields.containsKey("stateConfig")
//                    && extendedFields.containsKey("stateTransferConfig")) {
//                tagDef.setStateConfig((List) extendedFields.get("stateConfig"));
//                tagDef.setStateTransferConfig((List) extendedFields.get("stateTransferConfig"));
//            }
//        }
//        tagDefs.add(tagDef);
//
//        MetadataField statusMetadataField = responseField.getFieldMap().get(MANAGE_STATUS);
//
//        TagDefinition orderTag = new TagDefinition();
//        orderTag.setCode("ORDER");
//        orderTag.setCategory("ORDER");
//        orderTag.setCustomize(false);
//        orderTag.setThemeMapTag(this.getOrderTag(statusMetadataField));
//        tagDefs.add(orderTag);
//
//        field.setTagDefinitions(tagDefs);
//        List<MetadataField> metadataFields = responseField.getSubFields().stream().filter(fd -> !MANAGE_STATUS.equals(fd.getName())).collect(Collectors.toList());
//        metadataFields.add(field);
//        responseField.setSubFields(metadataFields);
//        responseField.getFieldMap().put(MANAGE_STATUS, field);
//    }

//    private ThemeMapTag getOrderTag(MetadataField metadataField) {
//        ThemeMapTag themeMapTag = null;
//        if (metadataField != null && CollectionUtils.isNotEmpty(metadataField.getTagDefinitions()) &&
//                !Objects.equals("object", metadataField.getDataType())) {
//            Optional<TagDefinition> tagDefinition = metadataField.getTagDefinitions().stream().filter(tag -> StringUtils.equals("ORDER", tag.getCode())).findFirst();
//            if (tagDefinition.isPresent()) {
//                themeMapTag = tagDefinition.get().getThemeMapTag();
//            }
//        }
//        return themeMapTag;
//    }

//    private void addButtonGroupField(MetadataField responseField) {
//
//        MetadataField field = new MetadataField();
//        field.setUiBot("Y");
//        field.setName("BUTTON_GROUP");
//        field.setDataType("string");
//        field.setPath(responseField.getName());
//        field.setDescription(messageUtils.getMessage("uibot.activity.metadataField.operation"));
//        field.setTagDefinitions(buildButtonGroupTagDef());
//        List<MetadataField> metadataFields = responseField.getSubFields();
//        metadataFields.add(field);
//        responseField.getFieldMap().put("BUTTON_GROUP", field);
//    }

//    /**
//     * 构建附件tag
//     *
//     * @return 附件tag列表
//     */
//    private static List<TagDefinition> buildButtonGroupTagDef() {
//        List<TagDefinition> tagDefs = Lists.newArrayList();
//
//        TagDefinition tagDef = new TagDefinition();
//        tagDef.setCode(TagConstant.BUSINESS_BUTTON_GROUP);
//        tagDef.setCategory(TagConstant.CATEGORY_BUSINESS);
//        tagDef.setInterpreterServiceName("buttonGroupInterpreter");
//        tagDef.setCustomize(false);
//        tagDefs.add(tagDef);
//        return tagDefs;
//    }

//    private List<AllFields> appendAllFieldsButtonGroup(List<AllFields> allFields) {
//        if (CollectionUtils.isEmpty(allFields)) {
//            return null;
//        }
//        List<AllFields> allFieldsNew = allFields.stream().filter(field -> !"BUTTON_GROUP".equals(field.getName())).collect(Collectors.toList());
//        AllFields allFieldsButtonGroup = new AllFields();
//        allFieldsButtonGroup.setHeaderName(messageUtils.getMessage("uibot.activity.metadataField.operation"));
//        allFieldsButtonGroup.setName("btn_operations");
//        allFieldsButtonGroup.setDataType("string");
//        allFieldsButtonGroup.setIsDataKey(false);
//        allFieldsButtonGroup.setLevel(allFields.get(0).getLevel());
//        allFieldsButtonGroup.setPath(allFields.get(0).getPath());
//        allFieldsButtonGroup.setIsShow(true);
//        allFieldsButtonGroup.setSort(false);
//        allFieldsNew.add(allFieldsButtonGroup);
//        return allFieldsNew;
//    }
}
