package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.builder;


import cn.hutool.core.map.MapUtil;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.action.ConfirmPop;
import com.digiwin.mobile.mobileuibot.core.component.button.*;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.enums.BusinessTypeEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.KnowledgeMapsActivityDefinition;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotPageLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperation;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.DataViewService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.TmPageOperationService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotConvertTmActivityUtils;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.runtime.PcUiBotRuntimes;
import com.digiwin.mobile.mobileuibot.task.common.TaskDataExtractUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>功能描述：${请输入当前Class的用途}</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DesignerBusinessDataEntryDrivenTaskBuilder.java
 * @Author: wangjwc
 * @Date: created at 2024/1/16 10:39
 */
@Service
public class DesignerBusinessDataEntryDrivenTaskBuilder extends DslPageBuilderBase<PcUiBotTaskPageDefine> {

    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;

    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;

    @Autowired
    private TmPageOperationService tmPageOperationService;

    @Autowired
    private DataViewService dataViewService;

    @Autowired
    private LocaleService localeService;

    @Override
    public String supportKey() {
        return PcUibotSupportKeyConstant.Designer.BUSINESS_DATA_ENTRY_DRIVEN;
    }


    @Override
    public UiBotModel createPage(PcUiBotExecuteContext executeContext, QueryResultSet queryResultSet, PcUiBotTaskPageDefine pageDefine, ApiRequest apiRequest) {
        executeContext.setIsDesigner(true);
        // 获取原始layout和规则等前置处理 -- 必须放在createRawPage前面，因为需要初始化规则
        this.buildPageDefineRawlayoutAndRules(executeContext, pageDefine);
        UiBotModel uiBotModel = super.createRawPage(executeContext, queryResultSet, pageDefine, apiRequest);
        // 处理字段权限和底部按钮等后置处理 -- 必须放在createRawPage后面，因为需要完整的pageData数据等
        this.handleFieldVisibleAndBottom(executeContext, pageDefine, uiBotModel, apiRequest);
        return uiBotModel;
    }

    private void buildPageDefineRawlayoutAndRules(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine) {
        PcUiBotTmFormInfo bindForm = pageDefine.getBindForm();
        if (bindForm == null) {
            return;
        }
        String formCode = bindForm.getFormCode();
        if (StringUtils.isEmpty(formCode)) {
            return;
        }

        // 获取基础资料编辑页的DSL
        PcUiBotExecuteContext newExecuteContext = JsonUtil.objectToJavaObject(executeContext, PcUiBotExecuteContext.class);
        newExecuteContext.setPageCode(UiBotDesignerService.PAGECODE_EDIT_PAGE);
        newExecuteContext.setTmActivityId(formCode);
        PcUiBotTmActivity tmActivity = this.getActivityWithoutTaskId(newExecuteContext);

        //开发平台改动，现在基础资料布局5要素都会放到PageUIElement,所以这里需要去PageUIElement获取布局元素
        if (CollectionUtils.isEmpty(tmActivity.getPages().getLayout())) {

            //根据前面获取基础资料满足条件会分析出一个默认视图
            String viewCode =
                    PcUiBotRuntimes.getContext().get(PcUiBotConstants.RuntimesContextKey.VIEW_CODE, String.class).orElse(Strings.EMPTY);
            PcUiBotRuntimes.getContext().remove(PcUiBotConstants.RuntimesContextKey.VIEW_CODE);
            PcUiBotRuntimes.getContext().remove(PcUiBotConstants.RuntimesContextKey.DATA_VIEW_QUERYS);

            if (StringUtils.isNotBlank(viewCode)) {
                //viewCode这里和开发平台约定使用formCode
                PcUiBotPageUIElement pageUIElement = dataViewService.getDslByViewCode(viewCode,
                        UiBotDesignerService.PAGECODE_EDIT_PAGE, newExecuteContext);
                //查询结果覆盖
                if (pageUIElement != null) {
                    PcUiBotTmPage pages = tmActivity.getPages();
                    List<PcUiBotTmDataState.Layout> layout = JsonUtil.objectToJavaObject(pageUIElement.getLayout(), new TypeReference<List<PcUiBotTmDataState.Layout>>() {
                    });

                    pages.setLayout(layout);
                    pages.setOperations(pageUIElement.getOperations());
                    pages.setHooks(pageUIElement.getHooks());
                }
            }
        }

        // 重新生成标签 需要根据当前的活动id查询规则
        PcUiBotRelationTag relationTag = new PcUiBotRelationTag();
        relationTag.setIdentity(executeContext.getIdentity());
        relationTag.setActivityId(formCode);
        executeContext.setRelationTag(relationTag);

        PcUiBotTmPage pages = tmActivity.getPages();
        // 设置hooks
        pageDefine.setHooks(pages.getHooks());
        // 设置规则
        pageDefine.setRules(pages.getRules());
        // 获取当前操作
        List<PcUiBotTmOperation> operations = pages.getOperations();
        if (CollectionUtils.isNotEmpty(operations)) {
            // 调用和构造任务定义的构造器
            analysisOperators(executeContext, pageDefine, tmActivity, operations);
        }
        // 任务已结束移除编辑的规则
        if (BooleanUtils.isTrue(pageDefine.getFinished())) {
            pageDefine.getRules().removeIf(ruleMap -> StringUtils.equals("EDIT", String.valueOf(ruleMap.get("scope"))));
        }

        List<PcUiBotTmDataState.Layout> layout = tmActivity.getPages().getLayout();
        if (CollectionUtils.isEmpty(layout)) {
            return;
        }

        PcUiBotTmDataState tmDataState = new PcUiBotTmDataState();
        tmDataState.setLayout(layout);

        pageDefine.setPageLayout(tmDataState.getPageLayout());
    }

    private void handleFieldVisibleAndBottom(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, UiBotModel uiBotModel, ApiRequest apiRequest) {
        List<UiBotPageLayout> pageLayout = pageDefine.getPageLayout();
        if (CollectionUtils.isEmpty(pageLayout)) {
            return;
        }

        // 获取主页面
        UiBotPageLayout mainPageLayout = uiBotDesignerRenderService.getMainPageLayout(pageLayout, null);

        // 字段权限
        Map<String, PcUiBotModelField> modelFieldMap = pageDefine.getModelFieldMap();
        if (MapUtil.isNotEmpty(modelFieldMap)) {
            // 任务是否已结束
            boolean finished = BooleanUtils.isTrue(pageDefine.getFinished());
            // 设置栏位显隐
            this.setFieldVisible(mainPageLayout.getBody(), modelFieldMap, finished);
        }

        // 设置底部按钮 -- 不使用数据录入的底部按钮配置
        mainPageLayout.getBottom().clear();
        mainPageLayout.setBottom(this.buildBottom(pageDefine.getSubmitActions(), pageDefine.getDataSourceSet().getMainDatasource(), uiBotModel, apiRequest));

    }

    public void setFieldVisible(List<BaseMobileComponentWrapper<BaseMobileComponent>> cmptList, Map<String, PcUiBotModelField> modelFieldMap, boolean finished) {
        if (CollectionUtils.isEmpty(cmptList)) {
            return;
        }
        // 需要删除的组件
        List<BaseMobileComponentWrapper<BaseMobileComponent>> deleteCmptList = new ArrayList<>();
        cmptList.forEach(componentWrapper -> {
            String componentType = componentWrapper.getComponentType();
            String componentSchema = componentWrapper.getSchema();
            String componentMobilePath = componentWrapper.getMobilePath();
            if (componentWrapper.getData() instanceof CustomGroup) {
                this.setFieldVisible(((CustomGroup) componentWrapper.getData()).getContentGroup(), modelFieldMap, finished);
            } else {
                PcUiBotModelField modelField = modelFieldMap.get(componentMobilePath);
                if (modelField != null) {
                    // 已结束任务都要设置为不可编辑
                    boolean enable = finished ? false : BooleanUtils.isTrue(modelField.getEditable());
                    if (componentWrapper.getData() instanceof BaseInputMobileComponent) {
                        BaseInputMobileComponent component = (BaseInputMobileComponent) componentWrapper.getData();
                        component.applyHidden(BooleanUtils.isTrue(modelField.getHidden()));
                        component.applyEditable(enable);
                    } else {
                        BaseMobileComponent component = componentWrapper.getData();
                        component.applyHidden(BooleanUtils.isTrue(modelField.getHidden()));
                        component.applyEditable(enable);
                    }
                } else {
                    // 权限配置为空时，已结束任务都要设置为不可编辑
                    if (finished) {
                        if (componentWrapper.getData() instanceof BaseInputMobileComponent) {
                            BaseInputMobileComponent component = (BaseInputMobileComponent) componentWrapper.getData();
                            component.applyEditable(false);
                        } else {
                            BaseMobileComponent component = componentWrapper.getData();
                            component.applyEditable(false);
                        }
                    }
                }
            }
        });
        cmptList.removeAll(deleteCmptList);
    }

    private List<BaseMobileComponentWrapper<BaseMobileComponent>> buildBottom(List<PcUiBotSubmitAction> submitActions, String dataSourceName, UiBotModel uiBotModel, ApiRequest apiRequest) {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.setContentGroup(this.buildButtonGroupContentGroup(submitActions, dataSourceName, uiBotModel, apiRequest));
        return Lists.newArrayList(new BaseMobileComponentWrapper<>(buttonGroup, "DW_" + ButtonGroup.COMPONENT_TYPE));
    }

    private List<BaseMobileComponentWrapper<BottomButtonDigiwinAthena>> buildButtonGroupContentGroup(List<PcUiBotSubmitAction> submitActions, String dataSourceName, UiBotModel uiBotModel, ApiRequest apiRequest) {
        List<BaseMobileComponentWrapper<BottomButtonDigiwinAthena>> contentGroup = new ArrayList<>();
        if (CollectionUtils.isEmpty(submitActions)) {
            return contentGroup;
        }
        boolean isReverse = true;
        for (PcUiBotSubmitAction submitAction : submitActions) {
            if (PcUiBotActivityConstants.Category.START_PROJECT.equals(Optional.ofNullable(submitAction.getExecuteContext()).map(PcUiBotSubmitExecuteContext::getCategory).orElse(""))) {
                // 模型驱动 手动发起
                contentGroup.add(this.buildStartProjectButton(submitAction));
            } else if (PcUiBotActivityConstants.BasicDataActionType.BASIC_DATA_UPDATE.equals(submitAction.getActionType())) {
                // 数据录入保存
                isReverse = false;
                contentGroup.add(this.buildBasicDataUpdataButton(submitAction));
            } else {
                switch (submitAction.getId() == null ? "" : submitAction.getId()) {
                    // 提交 人工任务出现
                    case "workflow-act-submit":
                        contentGroup.add(this.buildSubmitButton(submitAction));
                        break;
                    // 同意 签核任务出现
                    case "workflow-act-agree":
                        contentGroup.add(this.buildAgreeButton(submitAction, dataSourceName, uiBotModel, apiRequest));
                        break;
                    // 不同意 签核任务出现
                    case "workflow-act-disagree":
                        contentGroup.add(this.buildDisagreeButton(submitAction, dataSourceName, uiBotModel, apiRequest));
                        break;
                    // 加签 签核任务出现
                    case "workflow-act-add":
                        contentGroup.add(this.buildAddButton(submitAction, dataSourceName, uiBotModel, apiRequest));
                        break;
                    // 退回 签核任务出现
                    case "workflow-act-return":
                    case "athena.workflow.process.activity.return":
                        contentGroup.add(this.buildReturnButton(submitAction, dataSourceName, uiBotModel, apiRequest));
                        break;
                    // 转派 签核任务出现
                    case "workflow-act-reassignment":
                        break;
                    // 流程终止
                    default:
                }
            }
        }
        if (isReverse) {
            // 反转顺序
            Collections.reverse(contentGroup);
        }
        return contentGroup;
    }

    private BaseMobileComponentWrapper<BottomButtonDigiwinAthena> buildReturnButton(PcUiBotSubmitAction submitAction, String dataSourceName, UiBotModel uiBotModel, ApiRequest apiRequest) {
        String id = submitAction.getId();
        submitAction.setUuid(id);
        submitAction.setBtnId(id);
        submitAction.setBtnType(ButtonTypeEnum.JUMP_V1.getValue());
        UiBotJumpAction uiBotJumpAction = new UiBotJumpAction();
        submitAction.setJumpAction(uiBotJumpAction);

        uiBotJumpAction.setBtnStyleType(submitAction.isDefaultAction() ? BottomButtonStyleEnum.STRESS.getValue() : BottomButtonStyleEnum.NORMAL.getValue());
        uiBotJumpAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        uiBotJumpAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_BIZ_APPROVAL_REAPPROVE.name());
        uiBotJumpAction.setBusinessType(BusinessTypeEnum.OTHER.getValue());
        uiBotJumpAction.setIsCheckButton(false);
        Map<String, Object> extendedFields = TaskDataExtractUtil.getWorkflowProgressRawData(uiBotModel.getPageData());
        uiBotJumpAction.setRawData(this.buildRawData(submitAction, dataSourceName, uiBotModel, apiRequest, extendedFields));

        BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
        button.setSubmitAction(JsonUtil.objectToJavaObject(submitAction, UiBotAction.class));
        button.setIconData(58978);

        return new BaseMobileComponentWrapper<>(button, "DW_" + Button.COMPONENT_TYPE);
    }

    private BaseMobileComponentWrapper<BottomButtonDigiwinAthena> buildAddButton(PcUiBotSubmitAction submitAction, String dataSourceName, UiBotModel uiBotModel, ApiRequest apiRequest) {
        String id = submitAction.getId();
        submitAction.setUuid(id);
        submitAction.setBtnId(id);
        submitAction.setBtnType(ButtonTypeEnum.JUMP_V1.getValue());
        UiBotJumpAction uiBotJumpAction = new UiBotJumpAction();
        submitAction.setJumpAction(uiBotJumpAction);

        uiBotJumpAction.setBtnStyleType(submitAction.isDefaultAction() ? BottomButtonStyleEnum.STRESS.getValue() : BottomButtonStyleEnum.NORMAL.getValue());
        uiBotJumpAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        uiBotJumpAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_BIZ_APPROVAL_ADDTASK.name());
        uiBotJumpAction.setBusinessType(BusinessTypeEnum.OTHER.getValue());
        uiBotJumpAction.setIsCheckButton(false);
        uiBotJumpAction.setRawData(this.buildRawData(submitAction, dataSourceName, uiBotModel, apiRequest));

        BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
        button.setSubmitAction(JsonUtil.objectToJavaObject(submitAction, UiBotAction.class));
        button.setIconData(59003);

        return new BaseMobileComponentWrapper<>(button, "DW_" + Button.COMPONENT_TYPE);
    }

    private BaseMobileComponentWrapper<BottomButtonDigiwinAthena> buildDisagreeButton(PcUiBotSubmitAction submitAction, String dataSourceName, UiBotModel uiBotModel, ApiRequest apiRequest) {
        String id = submitAction.getId();
        submitAction.setUuid(id);
        submitAction.setBtnId(id);
        submitAction.setBtnType(ButtonTypeEnum.JUMP_V1.getValue());
        UiBotJumpAction uiBotJumpAction = new UiBotJumpAction();
        submitAction.setJumpAction(uiBotJumpAction);

        uiBotJumpAction.setBtnStyleType(submitAction.isDefaultAction() ? BottomButtonStyleEnum.STRESS.getValue() : BottomButtonStyleEnum.NORMAL.getValue());
        uiBotJumpAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        uiBotJumpAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_BIZ_APPROVAL_DISAGREE.name());
        uiBotJumpAction.setBusinessType(BusinessTypeEnum.OTHER.getValue());
        uiBotJumpAction.setIsCheckButton(false);
        uiBotJumpAction.setRawData(this.buildRawData(submitAction, dataSourceName, uiBotModel, apiRequest));

        BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
        button.setSubmitAction(JsonUtil.objectToJavaObject(submitAction, UiBotAction.class));
        button.setIconData(58982);

        return new BaseMobileComponentWrapper<>(button, "DW_" + Button.COMPONENT_TYPE);
    }

    public BaseMobileComponentWrapper<BottomButtonDigiwinAthena> buildAgreeButton(PcUiBotSubmitAction submitAction, String dataSourceName, UiBotModel uiBotModel, ApiRequest apiRequest) {
        String id = submitAction.getId();
        submitAction.setUuid(id);
        submitAction.setBtnId(id);
        submitAction.setBtnType(ButtonTypeEnum.JUMP_V1.getValue());
        UiBotJumpAction uiBotJumpAction = new UiBotJumpAction();
        submitAction.setJumpAction(uiBotJumpAction);

        uiBotJumpAction.setBtnStyleType(submitAction.isDefaultAction() ? BottomButtonStyleEnum.STRESS.getValue() : BottomButtonStyleEnum.NORMAL.getValue());
        uiBotJumpAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        uiBotJumpAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_BIZ_APPROVAL_AGREE.name());
        uiBotJumpAction.setBusinessType(BusinessTypeEnum.OTHER.getValue());
        uiBotJumpAction.setIsCheckButton(false);
        uiBotJumpAction.setRawData(this.buildRawData(submitAction, dataSourceName, uiBotModel, apiRequest));

        BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
        button.setSubmitAction(JsonUtil.objectToJavaObject(submitAction, UiBotAction.class));

        return new BaseMobileComponentWrapper<>(button, "DW_" + Button.COMPONENT_TYPE);
    }

    private Map<String, Object> buildRawData(PcUiBotSubmitAction submitAction, String dataSourceName, UiBotModel uiBotModel, ApiRequest apiRequest) {
        return buildRawData(submitAction, dataSourceName, uiBotModel, apiRequest, null);
    }

    private Map<String, Object> buildRawData(PcUiBotSubmitAction submitAction, String dataSourceName, UiBotModel uiBotModel, ApiRequest apiRequest, Map<String, Object> extendedFields) {
        UiBotAction uiBotAction = JsonUtil.objectToJavaObject(submitAction, UiBotAction.class);
        DigiwinAtmcBacklogDetail backlogDetail = digiwinAtmcProxyService.getDigiwinAtmcBacklogDetailByShare(apiRequest.getLocale(),
                apiRequest.getIamUserToken(), apiRequest.getDataId());
        return BottomButtonDigiwinAthena.assembleRawData(uiBotAction,
                dataSourceName, uiBotModel.getPageData().get(dataSourceName),
                extendedFields, submitAction.getId(),
                Optional.ofNullable(backlogDetail).map(DigiwinAtmcBacklogDetail::getAppCode).orElse(""));
    }

    private BaseMobileComponentWrapper<BottomButtonDigiwinAthena> buildSubmitButton(PcUiBotSubmitAction submitAction) {
        String id = submitAction.getId();
        submitAction.setUuid(id);
        submitAction.setBtnId(id);
        submitAction.setBtnType(ButtonTypeEnum.SUBMIT.getValue());
        UiBotJumpAction uiBotJumpAction = new UiBotJumpAction();
        submitAction.setJumpAction(uiBotJumpAction);

        uiBotJumpAction.setBtnStyleType(submitAction.isDefaultAction() ? BottomButtonStyleEnum.STRESS.getValue() : BottomButtonStyleEnum.NORMAL.getValue());
        // 刷新当前页 MOBILE_MY_BIZ_DATA_ENTRY_DRIVEN_TASK_DETAIL
        uiBotJumpAction.setType(ActionTypeEnum.REFRESH.getValue());
        uiBotJumpAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_MY_BIZ_DATA_ENTRY_DRIVEN_TASK_DETAIL.name());
        uiBotJumpAction.setBusinessType(BusinessTypeEnum.OTHER.getValue());
        uiBotJumpAction.setIsCheckButton(true);
        uiBotJumpAction.setConfirmPop(ConfirmPop
                .create(localeService.getLanguageValue(AppRequestContext.getContextEntity().getLocale(), "是否确定")
                                + submitAction.getTitle()
                                + "？",
                        true));

        BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
        button.setSubmitAction(JsonUtil.objectToJavaObject(submitAction, UiBotAction.class));

        return new BaseMobileComponentWrapper<>(button, "DW_" + Button.COMPONENT_TYPE);
    }

    private BaseMobileComponentWrapper<BottomButtonDigiwinAthena> buildBasicDataUpdataButton(PcUiBotSubmitAction submitAction) {
        String actionType = submitAction.getActionType();
        submitAction.setUuid(actionType);
        submitAction.setBtnId(actionType);
        submitAction.setBtnType(ButtonTypeEnum.SUBMIT.getValue());
        UiBotJumpAction uiBotJumpAction = new UiBotJumpAction();
        submitAction.setJumpAction(uiBotJumpAction);

        uiBotJumpAction.setBtnStyleType(submitAction.isDefaultAction() ? BottomButtonStyleEnum.STRESS.getValue() : BottomButtonStyleEnum.NORMAL.getValue());
        // 刷新当前页 MOBILE_MY_BIZ_DATA_ENTRY_DRIVEN_TASK_DETAIL
        uiBotJumpAction.setType(ActionTypeEnum.REFRESH.getValue());
        uiBotJumpAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_MY_BIZ_DATA_ENTRY_DRIVEN_TASK_DETAIL.name());
        uiBotJumpAction.setBusinessType(BusinessTypeEnum.OTHER.getValue());
        uiBotJumpAction.setIsCheckButton(true);
        uiBotJumpAction.setConfirmPop(ConfirmPop
                .create(localeService.getLanguageValue(AppRequestContext.getContextEntity().getLocale(), "是否确定")
                                + submitAction.getTitle()
                                + "？",
                        true));

        BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
        button.setSubmitAction(JsonUtil.objectToJavaObject(submitAction, UiBotAction.class));

        return new BaseMobileComponentWrapper<>(button, "DW_" + Button.COMPONENT_TYPE);
    }

    private BaseMobileComponentWrapper<BottomButtonDigiwinAthena> buildStartProjectButton(PcUiBotSubmitAction submitAction) {
        String id = UUIDUtil.getUuid();
        submitAction.setUuid(id);
        submitAction.setBtnId(id);
        submitAction.setBtnType(ButtonTypeEnum.SUBMIT.getValue());
        UiBotJumpAction uiBotJumpAction = new UiBotJumpAction();
        submitAction.setJumpAction(uiBotJumpAction);

        uiBotJumpAction.setBtnStyleType(submitAction.isDefaultAction() ? BottomButtonStyleEnum.STRESS.getValue() : BottomButtonStyleEnum.NORMAL.getValue());
        // 手动发起 提交后 返回上一页
        uiBotJumpAction.setType(ActionTypeEnum.BACK.getValue());
        uiBotJumpAction.setJumpPageId("");
        uiBotJumpAction.setBusinessType(BusinessTypeEnum.OTHER.getValue());
        uiBotJumpAction.setIsCheckButton(true);
        uiBotJumpAction.setConfirmPop(ConfirmPop
                .create(localeService.getLanguageValue(AppRequestContext.getContextEntity().getLocale(), "是否确定")
                                + submitAction.getTitle()
                                + "？",
                        true));

        BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
        button.setSubmitAction(JsonUtil.objectToJavaObject(submitAction, UiBotAction.class));
        // 防止buildButtonSubmitAction方法映射失败
        button.setComponentId(id);
        button.setCmptUuid(id);
        button.setSchema(id);
        return new BaseMobileComponentWrapper<>(button, "DW_" + Button.COMPONENT_TYPE, id);
    }

    public PcUiBotTmActivity getActivityWithoutTaskId(PcUiBotExecuteContext executeContext) {
        Map<String, String> uriVariables = new HashMap<>();
        uriVariables.put("activityId", executeContext.getTmActivityId());
        uriVariables.put("pageCode", executeContext.getPageCode());
        DigiwinAthenaApiRequest athenaApiRequest =
                DigiwinAthenaApiRequest.builder()
                        .requestHead(new AthenaBasicHttpRequestHead("",
                                executeContext.getLocale(), executeContext.getAuthoredUser().getToken(),
                                executeContext.getTenantId()))
                        .uriVariables(uriVariables)
                        .build();
        KnowledgeMapsActivityDefinition rawActivityDefinition =
                this.digiwinKnowledgeMapsProxyService.getActivityDefinitionWithoutTaskId(athenaApiRequest);
        PcUiBotTmActivity tmActivity = JsonUtil.objectToJavaObject(rawActivityDefinition, PcUiBotTmActivity.class);
        PcUiBotConvertTmActivityUtils.convert(executeContext.getPageCode(), executeContext.getLocale(), tmActivity);
        return tmActivity;
    }

    public void analysisOperators(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, PcUiBotTmActivity tmActivity, List<PcUiBotTmOperation> operations) {
        //4.1 解析 operations
        tmPageOperationService.createOperations(executeContext, pageDefine, tmActivity, operations);
        if (!UiBotDesignerService.PAGECODE_PROJECT_DETAIL.equals(executeContext.getPageCode()) && BooleanUtils.isTrue(pageDefine.getFinished())) {
            pageDefine.setOperations(filterActiveOperationsWhenBacklogFinished(pageDefine.getOperations()));
        }
    }

    protected List<PcUiBotOperationDTO> filterActiveOperationsWhenBacklogFinished(List<PcUiBotOperationDTO> operationList) {
        if (CollectionUtils.isEmpty(operationList)) {
            return operationList;
        }
        return operationList.stream().filter(operation -> BooleanUtils.isTrue(operation.getApplyAlthoughFinished())).collect(Collectors.toList());
    }

//    /**
//     * 模型驱动的页面内容需要取编辑页的content内容
//     *
//     * @param queryResultSet
//     * @param pageDefine
//     * @param dynamicForm
//     */
//    @Override
//    protected void BuildLayout(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, QueryResultSet queryResultSet, T pageDefine, UiBotModel dynamicForm) {
//        // 查询
//        super.BuildLayout(apiRequest, executeContext, queryResultSet, pageDefine, dynamicForm);
//    }
}

