package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.builder;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.common.BackgroundColorEnum;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.*;
import com.digiwin.mobile.mobileuibot.core.component.layout.singlelistcontainer.SingleListContainer;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.*;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.bean.PcModuleEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.enums.BusinessTypeEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.enums.SourceCategoryEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.button.UiBotQueryButton;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotPageLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.DslPageDataSetService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.QueryInfoSetService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template.BusinessProcessPerformerImpl;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotBaseDataUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotBuilderUtils;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotPatternUtil;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>功能描述：用于解析基础资料 设计器DSL的基类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DslPageBuilderBase.java
 * @Author: wangjwc
 * @Date: created at 2023/11/17 10:10
 */
public abstract class DslPageBuilderBase<T extends PcUiBotPageDefine> extends AbstractPageBuilder<T> {

    private static final String EDIT_TYPE_ADD = "add";

    @Autowired
    protected UiBotDesignerRenderService uiBotDesignerRenderService;

    @Autowired
    protected BusinessProcessPerformerImpl businessProcessPerformer;

//    @Autowired
//    protected DataQueryService dataQueryService;

//    @Autowired
//    protected UserDefinedService<T> userDefinedService;

//    @Autowired
//    protected DslFormComponentService dslFormComponentService;

//    @Autowired
//    protected DslGridComponentService dslGridComponentService;

//    @Autowired
//    private DslOperationsService dslOperationsService;

    @Autowired
    protected DslPageDataSetService dslPageDataSetService;

//    @Autowired
//    private List<TemplateService> templateList;

//    private final Map<String, TemplateService> templateContainer = new HashMap<>();

//    @Autowired
//    private List<PageBuilder> pageBuilders;

//    @Autowired
//    private ButtonGroupComponentImpl buttonGroupComponent;

//    @Autowired
//    private MessageUtils messageUtils;

//    @Autowired
//    private RuleService ruleService;

    @Autowired
    private QueryInfoSetService queryInfoSetService;


//    private final Map<String, PageBuilder> builderContainer = new HashMap<>();

    @Override
    public void afterPropertiesSet() throws Exception {
//        if (templateList != null) {
//            for (TemplateService template : templateList) {
//                if (templateContainer.containsKey(template.supportKey())) {
//                    throw new IllegalStateException("存在重复的模板，请重修改代码：" + template.supportKey());
//                }
//                templateContainer.put(template.supportKey(), template);
//            }
//        }
//        if (pageBuilders != null) {
//            for (PageBuilder pageBuilder : pageBuilders) {
//                if (builderContainer.containsKey(pageBuilder.supportKey())) {
//                    throw new IllegalStateException("存在重复的builder，请重修改代码：" + pageBuilder.supportKey());
//                }
//                builderContainer.put(pageBuilder.supportKey(), pageBuilder);
//            }
//        }
    }

    /**
     * 已经查询好数据，不需要重新再查询
     *
     * @param executeContext
     * @param queryResultSet
     * @param pageDefine
     * @return
     */
    public UiBotModel createPage(PcUiBotExecuteContext executeContext, QueryResultSet queryResultSet, T pageDefine, ApiRequest apiRequest) {
        UiBotModel uiBotModel = this.createRawPage(executeContext, queryResultSet, pageDefine, apiRequest);
        if (ObjectUtils.isEmpty(uiBotModel.getRenderData())) {
            uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
        }
        // 双档 -- 编辑页面存在本地新增单身数据情况
        if (UiBotDesignerService.PAGECODE_EDIT_PAGE.equals(executeContext.getPageCode())) {
            // 处理原始按钮定制跳转页面 -- 撤审按钮定制处理
            this.handleRawBottomButton(executeContext, pageDefine, uiBotModel);

            // 向uibotMode中存入layout，获取path使用
            addLayout(pageDefine, uiBotModel);
            // 处理单身新增功能--ZtbViewList卡片列表组件与表单组件
            UiBotDesignerRenderService.handleRawPageData(apiRequest, uiBotModel);
        }
        // 页面内容
        this.bulidRanderData(apiRequest, executeContext, uiBotModel, pageDefine, null);
        // 原始数据
        uiBotModel.setRawUiBotPageData(JsonUtil.objectToJavaObject(uiBotModel.getPageData(), UiBotPageData.class));
        uiBotModel.getLayout().clear();
        uiBotModel.getPageData().clear();
        uiBotModel.getActions().clear();
        uiBotModel.setPageDataIndex(null);
        uiBotModel.setPageDataKeys(null);
        uiBotModel.initMobileLayoutType();
        uiBotModel.setExecuteContext(JsonUtil.objectToJavaObject(executeContext, UiBotExecuteContext.class));
        uiBotModel.setPageBackgroudColor(StringUtils.hasLength(uiBotModel.getPageBackgroudColor())
                ?
                uiBotModel.getPageBackgroudColor()
                :
                BackgroundColorEnum.APP_MAIN_GREY.getValue());
        return uiBotModel;
    }

    private void handleRawBottomButton(PcUiBotExecuteContext executeContext, T pageDefine, UiBotModel uiBotModel) {
        List<UiBotPageLayout> pageLayout = pageDefine.getPageLayout();
        if (CollectionUtils.isEmpty(pageLayout)) {
            return;
        }
        // 获取主页面
        UiBotPageLayout mainPageLayout = uiBotDesignerRenderService.getMainPageLayout(pageLayout, null);
        List<BaseMobileComponentWrapper<BaseMobileComponent>> bottom = mainPageLayout.getBottom();
        if (CollectionUtils.isEmpty(bottom)) {
            return;
        }
        BaseMobileComponentWrapper<BaseMobileComponent> wrapper = bottom.get(0);
        if (!(wrapper.getData() instanceof ButtonGroup)) {
            return;
        }
        ButtonGroup buttonGroup = (ButtonGroup) wrapper.getData();
        List<BaseMobileComponentWrapper<BottomButtonDigiwinAthena>> contentGroup = buttonGroup.getContentGroup();
        if (CollectionUtils.isEmpty(contentGroup)) {
            return;
        }
        for (BaseMobileComponentWrapper<BottomButtonDigiwinAthena> componentWrapper : contentGroup) {
            Button button = componentWrapper.getData();
            if (button != null) {
                // submitAction已经替换到按钮中了
                UiBotAction submitAction = button.getSubmitAction();
                if (submitAction != null && "workflow-abort".equals(submitAction.getActionServiceIdName())) {
                    // 设置提交的paras
                    this.buildSubmitActionParas(submitAction, executeContext, pageDefine, uiBotModel);

                    submitAction.setId("workflow-abort");
                    submitAction.setBtnType(ButtonTypeEnum.JUMP_V1.getValue());
                    UiBotJumpAction uiBotJumpAction = submitAction.getJumpAction();
                    if (uiBotJumpAction == null) {
                        uiBotJumpAction = new UiBotJumpAction();
                    }
                    // 必须重新赋值，否则下面修改map中数据失败
                    submitAction.setJumpAction(uiBotJumpAction);

                    uiBotJumpAction.setBtnStyleType(submitAction.getDefaultAction() ? BottomButtonStyleEnum.STRESS.getValue() : BottomButtonStyleEnum.NORMAL.getValue());
                    uiBotJumpAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
                    uiBotJumpAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_WORKFLOW_ABORT.name());
                    uiBotJumpAction.setBusinessType(BusinessTypeEnum.OTHER.getValue());
                    uiBotJumpAction.setIsCheckButton(false);
                    uiBotJumpAction.setRawData(this.buildRawData(submitAction, pageDefine.getDataSourceSet().getMainDatasource(), uiBotModel));
                }
            }
        }
    }

    private void buildSubmitActionParas(UiBotAction submitAction, PcUiBotExecuteContext executeContext, T pageDefine, UiBotModel uiBotModel) {
        Map<String, Object> paras = submitAction.getParas();
        if (paras == null) {
            paras = new HashMap<>();
        }
        paras.put("comment", "");
        paras.put("serialNumber", this.getSerialNumber(pageDefine, uiBotModel));
        paras.put("performerId", executeContext.getAuthoredUser().getUserId());
        submitAction.setParas(paras);
    }

    private String getSerialNumber(T pageDefine, UiBotModel uiBotModel) {
        String serialNumber = "";
        String mainDatasource = pageDefine.getDataSourceSet().getMainDatasource();
        Object v = uiBotModel.getPageData().get(mainDatasource);
        if (v instanceof Map) {
            serialNumber = (String) ((Map<?, ?>) v).get("serial_number");
        } else if (v instanceof List) {
            if (!CollectionUtils.isEmpty((Collection<?>) v)) {
                serialNumber = (String) ((Map<?, ?>) ((List<?>) v).get(0)).get("serial_number");
            }
        }
        return serialNumber;
    }

    private Map<String, Object> buildRawData(UiBotAction uiBotAction, String dataSourceName, UiBotModel uiBotModel) {
        return BottomButtonDigiwinAthena.assembleRawData(uiBotAction,
                dataSourceName, uiBotModel.getPageData().get(dataSourceName),
                null, uiBotAction.getId(),
                "");
    }

    /**
     * 创建未加工的页面
     *
     * @param executeContext
     * @param queryResultSet
     * @param pageDefine
     * @param apiRequest
     * @return
     */
    public UiBotModel createRawPage(PcUiBotExecuteContext executeContext, QueryResultSet queryResultSet, T pageDefine, ApiRequest apiRequest) {
        // 构建动态表单
        UiBotModel dynamicForm = UiBotModel.emptyUiBotModel();
        //低代码平台必备属性
        executeContext.setIsDesigner(true);
        if (pageDefine == null
                || pageDefine.getDataSourceSet() == null
                || pageDefine.getDataSourceSet().getDataSourceList() == null) {
            return dynamicForm;
        }
        // 构建规则 -- 必须在构建pageData之前执行
        BuildRule(executeContext, pageDefine, dynamicForm, apiRequest);
        // 构建布局
        BuildLayout(executeContext, queryResultSet, pageDefine);
        // 构建PageData
        BuildPageData(executeContext, queryResultSet, pageDefine, dynamicForm);
        // 填充submitActions属性值
        BuildActions(pageDefine, dynamicForm.getPageData());
        // 设置页面需要的一些附加变量
        PcUiBotBuilderUtils.BuildVariables(dynamicForm);

        return dynamicForm;
    }

    private void addLayout(T pageDefine, UiBotModel uiBotModel) {
        UiBotQueryButton queryButton = JsonUtil.objectToJavaObject(pageDefine, UiBotQueryButton.class);
        UiBotLayout uiBotLayout = new UiBotLayout();
        uiBotLayout.setType(PcModuleEnum.CONTENT_QUERY_BUTTON.getValue());
        uiBotLayout.setQueryButtons(Lists.newArrayList(queryButton));
        uiBotModel.addLayout(uiBotLayout);
    }

    private void BuildLayout(PcUiBotExecuteContext executeContext, QueryResultSet queryResultSet, T pageDefine) {
        // 填充卡片列表分页配置
        queryInfoSetService.buildLayoutDsl(executeContext, queryResultSet, pageDefine);
    }

    public void BuildActions(T pageDefine, UiBotPageData pageData) {
        if (requireRenderActions(pageDefine, pageData)) {
            String key = pageDefine.getDataSourceSet().getMainDatasource();
            for (PcUiBotSubmitAction action : pageDefine.getSubmitActions()) {
                if (action.getSubmitType() != null
                        && key != null
                        && !key.equals(action.getSubmitType().getSchema())) {
                    action.getSubmitType().setSchema(key);
                }
            }
        }
        uiBotDesignerRenderService.buildCmptSubmitAction(pageDefine);
    }

    private void BuildPageData(PcUiBotExecuteContext executeContext, QueryResultSet queryResultSet, T pageDefine, UiBotModel dynamicForm) {
        // 设置初始化数据
        dslPageDataSetService.getPageDataSet(executeContext, pageDefine, queryResultSet, dynamicForm);
        this.supplyPageData(dynamicForm, pageDefine);
    }

    private void supplyPageData(UiBotModel dynamicForm, PcUiBotPageDefine pageDefine) {
//        Map<String, Object> pageData = dynamicForm.getPageData();
        if (pageDefine instanceof PcUiBotDoubleDocumentPageDefine) {
//            pageData.put(PcUiBotConstants.UIBOT_PAGE_PARAMETER, pageDefine.getParameter());
            PcUiBotBaseDataUtil.setManageStatusDefaultValue(pageDefine.getExecuteContext(), pageDefine, dynamicForm);
        }
    }

    private void bulidRanderData(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, UiBotModel uiBotModel, T pageDefine, String componentType) {
        ComponentContext cmptContext = JsonUtil.objectToJavaObject(apiRequest, ComponentContext.class);
        cmptContext.setPageDefine(pageDefine);
        MobilePageRawData mobilePageRawData = new MobilePageRawData();
        mobilePageRawData.setExtendedFields(pageDefine.getExtendedFields());
        mobilePageRawData.setSourceCategory(SourceCategoryEnum.DATA_ENTRY.name());
        mobilePageRawData.setDataKeys(Optional.ofNullable(pageDefine.getDataSourceSet())
                .map(PcUiBotDataSourceSetDTO::getFirstDataQuery)
                .map(PcUiBotDataSourceDTO::getDataKeys)
                .orElse(null));

        // 高级属性--构建主页面hooks与上下文中组件级hooks
        uiBotDesignerRenderService.buildMainPageHooksByPageDefine(pageDefine, cmptContext, uiBotModel, componentType);

        if (!this.checkIsExistTabs(pageDefine)) {
            UiBotQueryButton queryButton = JsonUtil.objectToJavaObject(pageDefine, UiBotQueryButton.class);
            // 不显示tabs组件
            List<BaseMobileComponentWrapper<BaseMobileComponent>> bodyCmptList =
                    businessProcessPerformer.buildBodyCmpt(executeContext, uiBotModel, cmptContext, queryButton, mobilePageRawData, componentType);
            if (CollectionUtils.isEmpty(bodyCmptList)) {
                // 添加空组件
                uiBotModel.getRenderData().addEmptyComponentToBody();
            } else {
                int bodyContainerType = UiBotDesignerRenderService.getBodyContainerType(bodyCmptList);
                if (bodyContainerType == 1) {
                    SingleListContainer<BaseMobileComponent> singleListContainer = new SingleListContainer<>();
                    singleListContainer.addAll(bodyCmptList);
                    uiBotModel.getRenderData().addWrapperedComponentToBody(
                            new BaseMobileComponentWrapper<>(singleListContainer, "DW_" + singleListContainer.returnComponentType()));
                } else {
                    uiBotModel.getRenderData().addWrapperedComponentListToBody(bodyCmptList);
                }

                // 构建bottom
                List<BaseMobileComponentWrapper<BaseMobileComponent>> bottomCmptList =
                        businessProcessPerformer.buildBottomCmpt(executeContext, uiBotModel, cmptContext, queryButton, mobilePageRawData, componentType);
                if (!CollectionUtils.isEmpty(bottomCmptList)) {
                    uiBotModel.getRenderData().addWrapperedComponentListToBottom(bottomCmptList);
                }
            }
        } else {
            // 数据录入驱动模型浏览页面下存在视图，显示tabs
            BaseMobileComponent tabs = this.buildTabs(executeContext, uiBotModel, cmptContext, pageDefine, mobilePageRawData, componentType);
            uiBotModel.getRenderData().addWrapperedComponentToBody(
                    new BaseMobileComponentWrapper<>(tabs, "DW_" + tabs.returnComponentType()));
        }
    }

    private boolean checkIsExistTabs(T pageDefine) {
        if (!(pageDefine instanceof PcUiBotDoubleDocumentPageDefine)) {
            return false;
        }
        PcUiBotDoubleDocumentPageDefine pcUiBotDoubleDocumentPageDefine = (PcUiBotDoubleDocumentPageDefine) pageDefine;
        if (CollectionUtils.isEmpty(pcUiBotDoubleDocumentPageDefine.getDataViewQueryList())) {
            // 不存在视图
            return false;
        }
        return true;
    }

    private BaseMobileComponent buildTabs(PcUiBotExecuteContext executeContext, UiBotModel uiBotModel, ComponentContext cmptContext,
                                          T pageDefine, MobilePageRawData mobilePageRawData, String componentType) {
        PcUiBotDoubleDocumentPageDefine doubleDocumentPageDefine = (PcUiBotDoubleDocumentPageDefine) pageDefine;
        List<PcUiBotDataViewQueryDTO> dataViewQueryList = doubleDocumentPageDefine.getDataViewQueryList();
        UiBotQueryButton queryButton = JsonUtil.objectToJavaObject(doubleDocumentPageDefine, UiBotQueryButton.class);

        CustomTabController customTabController = new CustomTabController();
        customTabController.setSwipeable(true);
        customTabController.setTabAlign(0);
        List<CustomTabControllerItem> items = new ArrayList<>(dataViewQueryList.size());
        customTabController.setTabLayoutType(CustomTabControllerItemLayoutTypeEnum.HORIZONTAL.getValue());
        customTabController.setTabItems(items);
        customTabController.setDefaultSelected(0);
        for (int i = 0; i < dataViewQueryList.size(); i++) {
            if (BooleanUtils.isTrue(dataViewQueryList.get(i).getIsDefault())) {
                customTabController.setDefaultSelected(i);
            }
        }
        for (int i = 0; i < dataViewQueryList.size(); i++) {
            CustomTabControllerItem item = new CustomTabControllerItem();
            items.add(item);
            item.setFlushType(1);
            item.setContentUseSchema(CustomTabControllerItemContentEnum.CONTENT_AREA.getValue());
            PcUiBotDataViewQueryDTO dataViewQueryDTO = dataViewQueryList.get(i);
            String tabTitle = dataViewQueryDTO.getViewName();
            item.setId(dataViewQueryDTO.getViewCode());
            item.setName(tabTitle);
            item.setLayoutType(CustomTabControllerItemLayoutTypeEnum.VERTICAL.getValue());
            item.setScrollable(true);
            CustomTabContentArea contentArea = new CustomTabContentArea();
            if (i == customTabController.getDefaultSelected()) {
                item.setContentArea(contentArea);
                item.setAsyncForData(false);

                List<BaseMobileComponentWrapper<BaseMobileComponent>> bodyCmptList =
                        businessProcessPerformer.buildBodyCmpt(executeContext, uiBotModel, cmptContext, queryButton, mobilePageRawData, componentType);
                if (CollectionUtils.isEmpty(bodyCmptList)) {
                    CustomTabContentContainer<BaseMobileComponent> customTabContentContainer = CustomTabContentContainer.emptyContainerUnContainCustomGroup(cmptContext.getLocale());
                    customTabContentContainer.setContentCmptType("DW_" + customTabContentContainer.getContentCmptType());
                    contentArea.getBodyArea().add(customTabContentContainer);
                } else {
                    contentArea.getBodyArea().addAll(bodyCmptList
                            .stream()
                            .map(r -> {
                                CustomTabContentContainer<BaseMobileComponent> container = new CustomTabContentContainer<>();
                                container.setMobilePath(r.getMobilePath());
                                container.setSchema(r.getSchema());
                                container.setContentCmptType(r.getComponentType());
                                container.setData(r.getData());
                                return container;
                            })
                            .collect(Collectors.toList()));
                }
                // wjw FIXME: 2024/1/2 数据录入-视图转换tab时，底部按钮要显示(现只有新增按钮)
                // 构建bottom
                List<BaseMobileComponentWrapper<BaseMobileComponent>> bottomCmptList =
                        businessProcessPerformer.buildBottomCmpt(executeContext, uiBotModel, cmptContext, queryButton, mobilePageRawData, componentType);
                if (!CollectionUtils.isEmpty(bottomCmptList)) {
                    contentArea.getBottomArea().addAll(bottomCmptList
                            .stream()
                            .map(r -> {
                                CustomTabContentContainer<BaseMobileComponent> container = new CustomTabContentContainer<>();
                                container.setMobilePath(r.getMobilePath());
                                container.setSchema(r.getSchema());
                                container.setContentCmptType(r.getComponentType());
                                container.setData(r.getData());
                                return container;
                            })
                            .collect(Collectors.toList()));
                }

                // 塞入内容
                contentArea.resetSize();
            } else {
                item.setContentArea(contentArea);
                item.setAsyncForData(true);
                contentArea.setSize(0);

                Map<String, Object> rawData = new HashMap<>();
                rawData.put("executeContext", executeContext);
                // 构建同步tab时，dataViewQueryDTO使用了什么属性，则rawdata中就存放什么属性，为了异步加载中返回当前tab信息
                // 数据源转为数据视图的tab情况：viewCode=null ---- 使用KM任务定义datastate中的pagelayout
                rawData.put("viewCode", dataViewQueryDTO.getViewCode());
                rawData.put("viewName", dataViewQueryDTO.getViewName());
                // 数据源转为数据视图的tab情况、默认的数据视图的tab情况 : dataSourceSet !=null
                rawData.put("dataSourceSet", dataViewQueryDTO.getDataSourceSet());

                // 塞入异步请求配置
                item.setAsyncConfig(CustomTabControllerItemAsyncConfig.create(
                        cmptContext.getIamUserToken(),
                        cmptContext.getLocale(), cmptContext.getRequestId(),
                        AppContext.getBaseUrl() + "/mobile/v1/uibot/dataView/show",
                        cmptContext.getClientId(), cmptContext.getTenantId(), rawData));
                item.setAsyncResponseType(CustomTabControllerItemAsyncResponseTypeEnum.UIBOTMODE.getType());
            }
        }
        return customTabController;
    }

//    public UiBotModel createPage(PcUiBotExecuteContext executeContext, T pageDefine) {
//        return this.createPage(executeContext, null, pageDefine);
//    }

//    /**
//     * 已经查询好数据，不需要重新再查询
//     *
//     * @param executeContext
//     * @param queryResultSet
//     * @param pageDefine
//     * @return
//     */
//    public UiBotModel createPage(PcUiBotExecuteContext executeContext, QueryResultSet queryResultSet, T pageDefine, ApiRequest apiRequest) {
//        // 构建动态表单
//        UiBotModel dynamicForm = UiBotModel.emptyUiBotModel();
//        //低代码平台必备属性
//        executeContext.setIsDesigner(true);
//        if (pageDefine == null
//                || pageDefine.getDataSourceSet() == null
//                || pageDefine.getDataSourceSet().getDataSourceList() == null) {
//            return dynamicForm;
//        }
////        dynamicForm.setStyle(new HashMap<>());
////        dynamicForm.setPageData(new HashMap<>());
//        dynamicForm.setRules(JsonUtil.objectToJavaObject(pageDefine.getRules(), new TypeReference<List<UiBotRule>>() {
//        }));
//        //当per rules中有配规则，以rules表中为准
//        this.resetRuleFromPresetLibrary(executeContext, dynamicForm, apiRequest);
//        // 根据hidden规则隐藏字段
////        this.wordHidden(executeContext, pageDefine, dynamicForm);
////        BuildContext buildContext = this.createBuildContext(pageDefine, queryResultSet, executeContext, null);
////        buildContext.setDynamicForm(dynamicForm);
//        // 获取用户自定义配置
////        userDefinedService.setUserDefinedConfig(pageDefine, executeContext);
//        // 构建布局
////        BuildLayout(apiRequest, executeContext, queryResultSet, pageDefine, dynamicForm);
//        // 设置初始化数据
////        dslPageDataSetService.getPageDataSet(pageDefine, buildContext, dynamicForm);
//        // 移除特定逻辑下的可编辑规则
//        this.removeEditRulesIfNecessary(executeContext, dynamicForm.getRules());
//        // 设置提交的按钮
////        BuildActions(pageDefine, dynamicForm);
//        // 设置执行上下文
////        dynamicForm.setExecuteContext(executeContext);
//        // 设置页面需要的一些附加变量
//        PcUiBotBuilderUtils.BuildVariables(dynamicForm);
////        dynamicForm.setExecuteContext(executeContext);
//        // 规则的后置处理
////        ruleService.rulePostProcessor(RuleService.ProcessType.DSL_BUILDER, buildContext);
//        return dynamicForm;
//    }

//    /**
//     * 隐藏列；需要在从km获取规则之后，在rebuildLayout之前
//     *
//     * @param executeContext
//     * @param pageDefine
//     * @param dynamicForm
//     */
//    private void wordHidden(ExecuteContext executeContext, T pageDefine, DynamicForm dynamicForm) {
//        List<Map<String, Object>> ruleList = dynamicForm.getRules();
//        List<AbstractComponent> componentList = pageDefine.getLayout();
//        if (CollectionUtils.isEmpty(ruleList) || CollectionUtils.isEmpty(componentList)) {
//            return;
//        }
//        this.wordHidden(executeContext, componentList, ruleList);
//    }

//    protected void wordHidden(PcUiBotExecuteContext executeContext,
//                              List<AbstractComponent> componentList,
//                              List<Map<String, Object>> ruleList) {
//        showFieldService.wordHiddenForDsl(executeContext, componentList, ruleList);
//    }

//    /**
//     * 低代码设计界面DSL rebuild
//     *
//     * @param buildContext
//     * @param pageDefine
//     * @return
//     */
//    private List<AbstractComponent> rebuildLayout(BuildContext buildContext, T pageDefine) {
//        String actionId = buildContext.getPageDefine().getDataSourceSet().getFirstActionId();
//
//        //每组代表一个原生态的
//        List<AbstractComponent> components = new ArrayList<>();
//        if (CollectionUtils.isEmpty(pageDefine.getLayout())) {
//            return null;
//        }
//        if (CollectionUtils.isEmpty(pageDefine.getOperations())) {
//            pageDefine.setOperations(new ArrayList<>());
//        }
//
//        // 参考用户自定义配置
//        userDefinedService.referenceUserDefinedConfig(pageDefine);
//
//        //开始rebuild 主要rebuild： Operations、allFields
//        for (AbstractComponent layout : pageDefine.getLayout()) {
//            rebuildPerLayout(buildContext, pageDefine, actionId, components, layout);
//        }
//        return components;
//    }

//    public void rebuildPerLayout(BuildContext buildContext,
//                                 T pageDefine,
//                                 String actionId,
//                                 List<AbstractComponent> components,
//                                 AbstractComponent layout) {
//        if (layout.getOperations() == null) {
//            layout.setOperations(new ArrayList<>());
//        }
//        // 不需要重构的组件
//        // rebuildResult:为重构结果，是否重构成功
//        boolean rebuildResult = this.rebuildNotComponent(components, layout);
//        if (!rebuildResult) {
//            // rebuild FORM_LIST，主要重新绑定operations到具体栏位上
//            rebuildResult = this.rebuildFormComponent(buildContext, pageDefine, actionId, components, layout);
//        }
//        // rebuild操作栏
//        Tuple tuple = resetLayoutOperation(buildContext, layout, pageDefine);
//        if (!rebuildResult) {
//            // rebuild整单操作
//            rebuildResult = this.rebuildToolBarComponent(pageDefine, components, layout, tuple);
//        }
//        if (!rebuildResult) {
//            //rebuild状态栏
//            GridColumnDef managerStatusColumnDef = getManageStatus(pageDefine, layout);
//            //rebuild ATHENA_TABLE，主要重新绑定operations到具体栏位上
//            this.rebuildGridComponent(buildContext, pageDefine, actionId, components, layout, tuple, managerStatusColumnDef);
//            //rebuild TABS，与ATHENA_TABLE类似，主要重新绑定operations到具体栏位上
//            this.rebuildTabComponent(buildContext, pageDefine, actionId, components, layout, tuple, managerStatusColumnDef);
//        }
//    }

//    /**
//     * 重构ToolBar组件，主要是items重置
//     * 例如：operations有按钮a和b，ToolBar的items中是b和c，则合并去重结果是a、b（operations）、c；去重逻辑是operations优先级高于ToolBar组件；
//     *
//     * @param components
//     * @param component
//     * @param tuple
//     * @return 是否重构成功
//     */
//    private boolean rebuildToolBarComponent(T pageDefine,
//                                            List<AbstractComponent> components,
//                                            AbstractComponent component,
//                                            Tuple tuple) {
//        if (component instanceof ToolBarComponent) {
//            List<OperationDTO> toolBarOperations = tuple.get(2);
//            // 配置中的operations
//            Map<String, OperationDTO> operationTypeMap = toolBarOperations.stream()
//                    .collect(Collectors.toMap(OperationDTO::getType, Function.identity(), (v1, v2) -> v2));
//            ToolBarComponent toolBarComponent = (ToolBarComponent) component;
//            // 组件内部的operations
//            List<OperationDTO> items = toolBarComponent.getItems();
//            List<OperationDTO> result = Lists.newArrayList();
//            for (OperationDTO item : items) {
//                String type = item.getType();
//                // 【配置中的operations】优先级高于【组件内部的operations】
//                if (operationTypeMap.containsKey(type)) {
//                    result.add(operationTypeMap.get(type));
//                    // 移除
//                    operationTypeMap.remove(type);
//                } else {
//                    result.add(item);
//                }
//            }
//            // 回填剩余的
//            result.addAll(operationTypeMap.values());
//            // 排序
//            OperationsUtil.sortBySequence(result);
//            toolBarComponent.setItems(result);
//            // 数据源设置
//            if (StringUtils.isNotBlank(toolBarComponent.getTarget())) {
//                pageDefine.getDataSourceSet().setMainDatasource(toolBarComponent.getTarget());
//            }
//            if (pageDefine.getDataSourceSet().getFirstDataQuery() != null) {
//                pageDefine.getDataSourceSet().getFirstDataQuery().setName(pageDefine.getDataSourceSet().getMainDatasource());
//            }
//            toolBarComponent.setDataSourceSet(pageDefine.getDataSourceSet());
//            components.add(toolBarComponent);
//            return true;
//        }
//        return false;
//    }

//    /**
//     * 不需要重构的组件
//     *
//     * @param components
//     * @param layout
//     * @return 是否重构成功
//     */
//    private boolean rebuildNotComponent(List<AbstractComponent> components,
//                                        AbstractComponent layout) {
//        if (isNotRebuildComponent(layout)) {
//            components.add(layout);
//            return true;
//        }
//        return false;
//    }

//    /**
//     * 是否不需要重构
//     *
//     * @param layout
//     * @return
//     */
//    protected boolean isNotRebuildComponent(AbstractComponent layout) {
//        return layout instanceof CommonComponent
//                || layout instanceof QueryButtonComponent
//                || layout instanceof TreeDataComponent
//                || layout instanceof CustomizeContainerComponent
//                || layout instanceof ApprovalDescriptionComponent;
//    }

//    /**
//     * 重构页签组件
//     *
//     * @param buildContext
//     * @param pageDefine
//     * @param actionId
//     * @param components
//     * @param layout
//     * @param btnTuple
//     * @param managerStatusColumnDef
//     */
//    private void rebuildTabComponent(BuildContext buildContext,
//                                     T pageDefine,
//                                     String actionId,
//                                     List<AbstractComponent> components,
//                                     AbstractComponent layout,
//                                     Tuple btnTuple,
//                                     GridColumnDef managerStatusColumnDef) {
//        if (layout instanceof TabGroupComponent) {
//            TabGroupComponent tabGroupComponent = (TabGroupComponent) layout;
//            if (CollectionUtils.isEmpty(tabGroupComponent.getTabs())) {
//                return;
//            }
//            AbstractComponent buttonGroup = btnTuple.get(0);
//            GridColumnDef uibotButtonGroupColumnDef = btnTuple.get(1);
//            for (AbstractComponent tab : tabGroupComponent.getTabs()) {
//                if (tab instanceof TabComponent) {
//                    TabComponent tabComponent = (TabComponent) tab;
//                    if (CollectionUtils.isEmpty(tabComponent.getGroup())) {
//                        continue;
//                    }
//                    if (StringUtils.isEmpty(tabComponent.getTitle())) {
//                        tabComponent.setTitle(tabComponent.getId());
//                    }
//
//                    for (AbstractComponent tabSubComponent : tabComponent.getGroup()) {
//                        AtomicBoolean checkUibotButton = new AtomicBoolean(false);
//                        AtomicReference<GridColumnDef> uibotButtonGroupColDef = new AtomicReference<>(new GridColumnDef());
//                        pageDefine.getOperations().forEach(opr -> {
//                            AttachDTO attach = opr.getAttach();
//                            String headName = tabSubComponent.getSchema();
//                            if (attach != null && !attach.getTarget().contains(".")) {
//                                if (!StringUtils.isEmpty(headName) && headName.contains(".")) {
//                                    headName = tabSubComponent.getSchema().split("\\.")[tabSubComponent.getSchema().split("\\.").length - 1];
//                                }
//                            }
//                            if ("all".equals(attach.getMode())
//                                    && attach.getTarget().equals(headName)) {
//                                if (CollectionUtils.isEmpty(tabSubComponent.getOperations())) {
//                                    tabSubComponent.setOperations(new ArrayList<>());
//                                }
//                                tabSubComponent.getOperations().add(opr);
//                            } else if ("row".equals(attach.getMode())
//                                    && attach.getTarget().equals(headName)
//                                    && "UIBOT_BUTTON_GROUP".equals(attach.getApplyToField())) {
//                                checkUibotButton.set(true);
//                                uibotButtonGroupColDef.set(getUibotButtonGroup(tabSubComponent, opr));
//                            }
//                        });
//                        if (checkUibotButton.get()) {
//                            uibotButtonGroupColumnDef = uibotButtonGroupColDef.get();
//                        }
//                        if (tabSubComponent instanceof GridComponent) {
//                            GridComponent gridComponent = (GridComponent) tabSubComponent;
//                            dslGridComponentService.getGridComponent(buildContext, pageDefine, actionId, gridComponent, buttonGroup, uibotButtonGroupColumnDef, managerStatusColumnDef);
//                        } else if (tabSubComponent instanceof FormComponent) {
//                            FormComponent formComponent = (FormComponent) tabSubComponent;
//                            if (CollectionUtils.isEmpty(formComponent.getGroup())) {
//                                continue;
//                            }
//                            dslFormComponentService.getFormComponent(buildContext, actionId, formComponent);
//                            formComponent.getGroup()
//                                    .stream()
//                                    .filter(type -> DslOperationsService.oprList.contains(type.getType()) && CollectionUtils.isEmpty(type.getOperations()))
//                                    .forEach(g -> {
//                                        List<String> relationSchemas = new ArrayList<>();
//                                        g.setRelationSchemas(relationSchemas);
//                                        List<Map<String, Object>> fields = new ArrayList<>();
//                                        if (CollectionUtils.isEmpty(g.getOperations())) {
//                                            g.setOperations(new ArrayList<>());
//                                            g.getOperations().addAll(dslOperationsService.getOperations(pageDefine, formComponent.getSchema(), g.getSchema(), relationSchemas, fields));
//
//                                        } else {
//                                            for (OperationDTO opr : g.getOperations()) {
//                                                dslOperationsService.getRelationSchemas(opr, relationSchemas);
//                                                dslOperationsService.getFields(opr, fields);
//                                            }
//                                        }
//                                        if (CollectionUtils.isNotEmpty(fields)) {
//                                            g.setFields(fields);
//                                        }
//                                    });
//                        }
//
//                    }
//                }
//            }
//            components.add(tabGroupComponent);
//        }
//    }

//    /**
//     * 重构表格组件
//     *
//     * @param buildContext
//     * @param pageDefine
//     * @param actionId
//     * @param components
//     * @param layout
//     * @param btnTuple
//     * @param managerStatusColumnDef
//     */
//    private void rebuildGridComponent(BuildContext buildContext,
//                                      T pageDefine,
//                                      String actionId,
//                                      List<AbstractComponent> components,
//                                      AbstractComponent layout,
//                                      Tuple btnTuple,
//                                      GridColumnDef managerStatusColumnDef) {
//        if (layout instanceof GridComponent) {
//            AbstractComponent buttonGroup = btnTuple.get(0);
//            GridColumnDef uibotButtonGroupColumnDef = btnTuple.get(1);
//            GridComponent gridComponent = (GridComponent) layout;
//            dslGridComponentService.getGridComponent(buildContext, pageDefine, actionId, gridComponent, buttonGroup,
//                    uibotButtonGroupColumnDef, managerStatusColumnDef);
//            // 将表格包装到groupOrder组件中；只需要在项目详情页，且只有表格的场景；
//            GroupOrderComponent groupOrderComponent = GridComponentUtil.wrapByGroupOderIfNecessary(buildContext, gridComponent);
//            if (groupOrderComponent != null) {
//                components.add(groupOrderComponent);
//            } else if (CollectionUtils.isNotEmpty(gridComponent.getColumnDefs())) {
//                components.add(gridComponent);
//            }
//            // 与uibot对齐
//            Optional.ofNullable(buildContext.getExecuteContext())
//                    .ifPresent(ec -> ec.setGridSchema(gridComponent.getSchema()));
//            if (pageDefine.getSettings() == null) {
//                pageDefine.setSettings(new JSONObject());
//            }
//        }
//    }

//    /**
//     * 重构表单组件
//     *
//     * @param buildContext
//     * @param pageDefine
//     * @param actionId
//     * @param components
//     * @param layout
//     * @return 是否重构成功
//     */
//    private boolean rebuildFormComponent(BuildContext buildContext,
//                                         T pageDefine,
//                                         String actionId,
//                                         List<AbstractComponent> components,
//                                         AbstractComponent layout) {
//        if (layout instanceof FormComponent) {
//            FormComponent formComponent = (FormComponent) layout;
//            if (CollectionUtils.isEmpty(formComponent.getGroup())) {
//                return true;
//            }
//            dslFormComponentService.getFormComponent(buildContext, actionId, formComponent);
//            components.add(formComponent);
//            formComponent.getGroup().stream()
//                    .filter(type -> DslOperationsService.oprList.contains(type.getType()))
//                    .forEach(g -> {
//                        List<String> relationSchemas = new ArrayList<>();
//                        g.setRelationSchemas(relationSchemas);
//                        List<Map<String, Object>> fields = new ArrayList<>();
//                        if (CollectionUtils.isEmpty(g.getOperations())) {
//                            g.setOperations(new ArrayList<>());
//                            g.getOperations().addAll(dslOperationsService.getOperations(pageDefine, formComponent.getSchema(), g.getSchema(), relationSchemas, fields));
//
//                        } else {
//                            for (OperationDTO opr : g.getOperations()) {
//                                dslOperationsService.getRelationSchemas(opr, relationSchemas);
//                                dslOperationsService.getFields(opr, fields);
//                            }
//                        }
//                        if (CollectionUtils.isNotEmpty(fields)) {
//                            g.setFields(fields);
//                        }
//                    });
//            //当有多个收起功能

    ////            if (pageDefine.getLayout().size() > 1 && components.size() == 1) {
    ////                formComponent.setCollapse(true);
    ////            }
//            return true;
//        }
//        return false;
//    }

//    private Tuple resetLayoutOperation(BuildContext buildContext, AbstractComponent layout, T pageDefine) {
//        AbstractComponent buttonGroup = null;
//        GridColumnDef uibotButtonGroupColumnDef = null;
//        List<OperationDTO> toolBarOperations = Lists.newArrayList();
//        //获取容器组件右上角的opertions
//        List<OperationDTO> operations = pageDefine.getOperations();
//        Iterator<OperationDTO> operationDTOIterator = operations.iterator();
//        while (operationDTOIterator.hasNext()) {
//            OperationDTO opr = operationDTOIterator.next();
//            AttachDTO attach = opr.getAttach();
//            if (attach == null) {
//                continue;
//            }
//            // 收集ToolBar按钮，并从pageDefine中删除该按钮
//            if (BooleanUtils.isTrue(opr.getIsToolBar())) {
//                toolBarOperations.add(opr);
//                operationDTOIterator.remove();
//                continue;
//            }
//            String headName = layout.getSchema();
//            if (!attach.getTarget().contains(".")) {
//                if (!StringUtils.isEmpty(headName) && headName.contains(".")) {
//                    headName = layout.getSchema().split("\\.")[layout.getSchema().split("\\.").length - 1];
//                }
//            }
//            // 对于行内开窗，已经有OpenWindowConditional，则需要清空condition参数
//            // 处理逻辑同：AbstractTopComponentService.processOpenWindowEditor
//            if (UiBotConstants.TmOperationMode.ROW.equals(attach.getMode())
//                    && UiBotConstants.OPEN_WINDOW_OPERATE_LIST.contains(opr.getOperate())
//                    && StringUtils.isNotBlank(opr.getOpenWindowConditional())) {
//                opr.setCondition(null);
//            }
//            if ("all".equals(attach.getMode())
//                    && attach.getTarget().equals(headName)) {
//                layout.getOperations().add(opr);
//            } else if ("row".equals(attach.getMode())
//                    && attach.getTarget().equals(headName)
//                    && "BUTTON_GROUP".equals(attach.getApplyToField())) {
//                if (buttonGroup != null) {
//                    buttonGroup.getOperations().add(opr);
//                } else {
//                    buttonGroup = getButtonGroup(buildContext, layout, opr);
//                }
//            } else if ("row".equals(attach.getMode())
//                    && attach.getTarget().equals(headName)
//                    && "UIBOT_BUTTON_GROUP".equals(attach.getApplyToField())) {
//                if (uibotButtonGroupColumnDef != null) {
//                    uibotButtonGroupColumnDef.getOperations().add(opr);
//                } else {
//                    uibotButtonGroupColumnDef = getUibotButtonGroup(layout, opr);
//                }
//            }
//        }
//        return new Tuple(buttonGroup, uibotButtonGroupColumnDef, toolBarOperations);
//    }

//    /**
//     * rebuild UIBOT_BUTTON_GROUP操作列
//     *
//     * @param layout
//     * @param opr
//     * @return
//     */
//    private GridColumnDef getUibotButtonGroup(AbstractComponent layout, OperationDTO opr) {
//        MetadataField field = new MetadataField();
//        field.setOperations(new ArrayList<>());
//        field.getOperations().add(opr);
//        addButtonGroupField(field, "UIBOT_BUTTON_GROUP");
//        GridColumnDef uibotButtonGroup = new GridColumnDef();
//        uibotButtonGroup.setHeaderName(field.getDescription());
//        uibotButtonGroup.setSchema("UIBOT_BUTTON_GROUP");
//        uibotButtonGroup.setType("UIBOT_BUTTON_GROUP");
//
//        uibotButtonGroup.setDataType("string");
//        uibotButtonGroup.setOperations(new ArrayList<>());
//        GridColumnDef uibotButtonGroupColumnDef = new GridColumnDef();
//        uibotButtonGroupColumnDef.setHeaderName(uibotButtonGroup.getHeaderName());
//        uibotButtonGroupColumnDef.setColumns(Collections.singletonList(uibotButtonGroup));
//        uibotButtonGroupColumnDef.setWidth(70);
//        uibotButtonGroupColumnDef.setPath(layout.getSchema());
//        uibotButtonGroupColumnDef.setEditable(false);
//        uibotButtonGroupColumnDef.setPinned("right");
//        uibotButtonGroupColumnDef.setOperations(new ArrayList<>());
//        uibotButtonGroupColumnDef.getOperations().add(opr);
//        return uibotButtonGroupColumnDef;
//    }

//    /**
//     * rebuild BUTTON_GROUP操作列
//     *
//     * @param buildContext
//     * @param layout
//     * @param opr
//     * @return
//     */
//    private AbstractComponent getButtonGroup(BuildContext buildContext, AbstractComponent layout, OperationDTO opr) {
//        AbstractComponent buttonGroup;
//        MetadataField field = new MetadataField();
//        field.setOperations(new ArrayList<>());
//        field.getOperations().add(opr);
//        addButtonGroupField(field, "BUTTON_GROUP");
//        buttonGroup = buttonGroupComponent.initComponent(field, null, buildContext);
//        buttonGroup.setLevel(0);
//        buttonGroup.setPath(layout.getSchema());
//        buttonGroup.setDataType("string");
//        buttonGroup.setEditable(false);
//        return buttonGroup;
//    }

//    /**
//     * rebuild 状态栏位
//     *
//     * @param pageDefine
//     * @param layout
//     */
//    private GridColumnDef getManageStatus(T pageDefine, AbstractComponent layout) {
//        GridColumnDef managerStatusColumnDef = null;
//        if (MapUtils.isNotEmpty(pageDefine.getExtendedFields())) {
//            Map<String, Object> extendedFields = pageDefine.getExtendedFields();
//            if (extendedFields.containsKey("needStatusColumn")) {
//                Object needStatusColumn = extendedFields.get("needStatusColumn");
//                // 只有显式配置了 needStatusColumn=true，才会去检查并创建空manage_status列
//                if (Boolean.valueOf(needStatusColumn.toString())) {
//                    BaseDataManagerStatusComponent managerStatusComponent = new BaseDataManagerStatusComponent();
//                    managerStatusComponent.setHeaderName(messageUtils.getMessage("uibot.template.basicData.column.headerName"));
//                    managerStatusComponent.setSchema(MANAGE_STATUS);
//                    managerStatusComponent.setType(BUSINESS_BASE_DATA_MANAGER_STATUS);
//                    managerStatusComponent.setRelationSchemas(Collections.singletonList(MANAGE_STATUS));
//                    if (extendedFields.containsKey("stateConfig")
//                            && extendedFields.containsKey("stateTransferConfig")) {
//                        managerStatusComponent.setStateConfig((List) extendedFields.get("stateConfig"));
//                        managerStatusComponent.setStateTransferConfig((List) extendedFields.get("stateTransferConfig"));
//                    }
//                    managerStatusComponent.setDataType("string");
//                    managerStatusComponent.setWidth(90);
//                    managerStatusComponent.setId(MANAGE_STATUS);
//                    managerStatusComponent.setPath(layout.getSchema());
//                    managerStatusComponent.setRowGroupable(true);
//
//                    managerStatusColumnDef = new GridColumnDef();
//                    managerStatusColumnDef.setHeaderName(managerStatusComponent.getHeaderName());
//                    managerStatusColumnDef.setColumns(Collections.singletonList(managerStatusComponent));
//                    managerStatusColumnDef.setWidth(90);
//                    managerStatusColumnDef.setPath(layout.getSchema());
//                    managerStatusColumnDef.setEditable(false);
//                    managerStatusColumnDef.setPinned("right");
//                }
//            }
//        }
//        return managerStatusColumnDef;
//    }


//    /**
//     * 构建操作列
//     *
//     * @param field
//     * @param btnName
//     */
//    private void addButtonGroupField(PcUiBotMetadataField field, String btnName) {
//        field.setUiBot("Y");
//        field.setName(btnName);//"BUTTON_GROUP"
//        field.setDataType("string");
//        field.setDescription(messageUtils.getMessage("uibot.activity.metadataField.operation"));
//    }

//    /**
//     * 之后用的判断条件
//     *
//     * @param pageDefine
//     * @return
//     */
//    protected BuildContext createBuildContext(T pageDefine, QueryResultSet queryResultSet, ExecuteContext executeContext, ApiMetadata apiMetadata) {
//        BuildContext buildContext = new BuildContext();
//        buildContext.setPageDefine(pageDefine);
//        buildContext.setQueryResultSet(queryResultSet);
//        buildContext.setExecuteContext(executeContext);
//        buildContext.setIsOrder(true);
//        buildContext.setApiMetadata(apiMetadata);
//        return buildContext;
//    }


//    /**
//     * 添加提交的逻辑
//     */
//    protected void BuildActions(T pageDefine, UiBotModel dynamicForm) {
//        if (requireRenderActions(pageDefine, dynamicForm)) {
//            String dataSourceName = pageDefine.getDataSourceSet().getMainDatasource();
//            for (PcUiBotSubmitAction action : pageDefine.getSubmitActions()) {
//                // 将提交schema重置为dataSourceName
//                if (action.getSubmitType() != null && dataSourceName != null
//                        && !dataSourceName.equals(action.getSubmitType().getSchema())) {
//                    action.getSubmitType().setSchema(dataSourceName);
//                }
//            }
//            dynamicForm.setActions(JsonUtil.objectToJavaObject(pageDefine.getSubmitActions(), new TypeReference<List<UiBotAction>>() {
//            }));
//        }
//    }

//    /**
//     * 是否需要渲染提交按钮
//     *
//     * @return
//     */
//    protected boolean requireRenderActions(T pageDefine, UiBotModel dynamicForm) {
//        return requireRenderActions(pageDefine, dynamicForm.getPageData());
//    }
    private boolean requireRenderActions(T pageDefine, Map<String, Object> pageData) {
        // 空集合仍需要处理并返回
        if (pageDefine.getSubmitActions() == null) {
            return false;
        }
        PcUiBotDataSourceSetDTO dataSourceSetDTO = pageDefine.getDataSourceSet();
        // 基础资料录入/报表条件，要设置actions
        PcUiBotExecuteContext executeContext = pageDefine.getExecuteContext();
        if (null != executeContext && (
                PcUiBotPatternUtil.isBaseData(executeContext.getPattern())
                        || PcUiBotPatternUtil.isStatement(executeContext.getPattern())
                        || PcUiBotPatternUtil.isWorkBench(executeContext.getPattern()))
        ) {
            return true;
        }

        // 没有配置数据源，不关心是否渲染提交按钮
        if (null == dataSourceSetDTO || CollectionUtils.isEmpty(dataSourceSetDTO.getDataSourceList())) {
            return true;
        }
        // 有配置数据源，但没有相关业务数据，不需要渲染提交按钮
        if (CollectionUtils.isEmpty(pageData)) {
            return false;
        }

        for (PcUiBotDataSourceDTO dataSourceDTO : dataSourceSetDTO.getDataSourceList()) {
            Object dataObj = pageData.get(dataSourceDTO.getName());
            if (null == dataObj) {
                continue;
            }
            // 不是集合，返回true
            if (!(dataObj instanceof Collection)) {
                return true;
            }
            // 是非空集合，返回true
            else if (!CollectionUtils.isEmpty((Collection) dataObj)) {
                return true;
            }
        }
        return false;
    }

//    /**
//     * 创建布局
//     */
//    protected void BuildLayout(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, QueryResultSet queryResultSet, T pageDefine, UiBotModel dynamicForm) {
//        dynamicForm.setLayout(rebuildLayout(buildContext, pageDefine));
//    }

    protected QueryResultSet BuildDataSource(PcUiBotExecuteContext executeContext, T pageDefine) {
        if (pageDefine == null) {
            return null;
        }
        // 获取数据源的数据
        QueryResultSet queryResultSet = super.queryByPagedefineWithMetaData(pageDefine.getExecuteContext(), pageDefine);
        return queryResultSet;
    }

//    /**
//     * 创建布局
//     */
//    protected void BuildExplanationLayout(String explanation, UiBotModel dynamicForm) {
//        if (StringUtils.isEmpty(explanation)) {
//            return;
//        }
//        UiBotLayout explanationComponent = new UiBotLayout();
//        explanationComponent.setExplanation(explanation);
//        explanationComponent.setId(UUID.randomUUID().toString());
//        explanationComponent.setType("DESCRIPTION");
//        explanationComponent.setDisabled(Boolean.FALSE);
//        explanationComponent.setEditable(Boolean.FALSE);
//        if (dynamicForm.getLayout() == null) {
//            dynamicForm.setLayout(new ArrayList<>());
//        }
//        dynamicForm.getLayout().add(0, explanationComponent);
//    }

//    @Override
//    public List<PcUiBotMetadataField> getShowFields(BuildContext buildContext, List<String> dataKeys, PcUiBotMetadataField rootField, T pageDefine) {
//        return null;
//    }
//
//    @Override
//    public PcUiBotShowMetadata createShowMetadata(PcUiBotExecuteContext executeContext, T pageDefine, String actionId, PcUiBotApiMetadata apiMetadata, QueryResultSet queryResultSet) {
//        return null;
//    }

}
