package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.builder;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.metadata.KnowledgeMapsActionMetadataQueryResult;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotTagDefinition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotTaggingData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.*;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.*;
import java.util.stream.Collectors;

public abstract class PageBuilderBase<T extends PcUiBotPageDefine> extends AbstractPageBuilder<T> {

    @Autowired
    protected MetadataService metadataService;
    @Autowired
    protected TagService tagService;
    //    @Autowired
//    private ThemeMapService themeMapService;
//    @Autowired
//    protected TagDefinitionService tagDefinitionService;
    @Autowired
    protected TagDisplayRangeService tagDisplayRangeService;

    //    @Autowired
//    protected OperationService operationService;
    @Autowired
    protected SignTagService signTagService;
//    @Autowired
//    protected TagMergeService tagMergeService;
//
//    @Autowired
//    protected GroupTagInterpreter groupTagInterpreter;
//
//    @Autowired
//    protected ComponentTagInterpreter componentTagInterpreter;

    @Autowired
    EditRangeService editRangeService;

    @Autowired
    AnalyseSubmitActionFieldService analyseSubmitActionFieldService;

//    @Autowired
//    GroupSettingService groupSettingService;
//
//    @Autowired
//    OrderTagInterpreter orderTagInterpreter;
//
//    @Autowired
//    private DataQueryService dataQueryService;

    @Autowired
    ShowApplicationFieldsService showApplicationFieldsService;

    @Autowired
    CustomizeTagSetByActivityConfigsService customizeTagSetByActivityConfigsService;

    @Autowired
    UserDefinedService userDefinedService;

//    @Autowired
//    TagBuilder pageBuilder;

    @Autowired
    AllFieldsService allFieldsService;

    @Autowired
    FlatMetadataByTagService flatMetadataByTagService;
//
//    @Autowired
//    GridPatternService gridPatternService;

//    @Autowired
//    private List<TemplateService> templateList;
//
//    private Map<String, TemplateService> templateContainer = new HashMap<>();
//
//    @Autowired
//    private List<PageBuilder> pageBuilders;
//
//    protected Map<String, PageBuilder> builderContainer = new HashMap<>();

    @Autowired
    protected ViewWordsService viewWordsService;

    @Override
    public void afterPropertiesSet() throws Exception {
//        if (templateList != null) {
//            for (TemplateService template : templateList) {
//                if (templateContainer.containsKey(template.supportKey())) {
//                    throw new IllegalStateException("存在重复的模板，请重修改代码：" + template.supportKey());
//                }
//                templateContainer.put(template.supportKey(), template);
//            }
//        }
//        if (pageBuilders != null) {
//            for (PageBuilder pageBuilder : pageBuilders) {
//                if (builderContainer.containsKey(pageBuilder.supportKey())) {
//                    throw new IllegalStateException("存在重复的builder，请重修改代码：" + pageBuilder.supportKey());
//                }
//                builderContainer.put(pageBuilder.supportKey(), pageBuilder);
//            }
//        }
    }

    /**
     * 已经查询好数据，不需要重新再查询
     *
     * @param executeContext
     * @param queryResultSet
     * @param pageDefine
     * @return
     */
//    @Override
//    public DynamicForm createPage(ExecuteContext executeContext, QueryResultSet queryResultSet, T pageDefine) {
//        // 非空校验
//        if (pageDefine == null
//                || pageDefine.getDataSourceSet() == null
//                || pageDefine.getDataSourceSet().getDataSourceList() == null) {
//            return new DynamicForm();
//        }
//        // 数据源id不能为空
//        String actionId = pageDefine.getDataSourceSet().getFirstActionId();
//        if (Strings.isBlank(actionId)) {
//            return new DynamicForm();
//        }
//        // 获取并解析元数据
//        long start = System.currentTimeMillis();
//        ApiMetadata apiMetadata = getApiMetadata(executeContext, queryResultSet, pageDefine, actionId);
//        if (apiMetadata == null) {
//            return new DynamicForm();
//        }
//        Long firstBacklogId = executeContext.getFirstBacklogId();
//        RelationTag relationTag = executeContext.getRelationTag();
//        this.addSubmitFiled(executeContext.getLocale(), pageDefine.getSubmitActions(), apiMetadata);
//        ApiMetadataUtil.flatMetaData(apiMetadata);
//        BuildContext buildContext = this.createBuildContext(pageDefine, queryResultSet, executeContext, apiMetadata);
//        log.info("[{}]元数据解析，cost：{} ms", firstBacklogId, System.currentTimeMillis() - start);
//        start = System.currentTimeMillis();
//        // 构建动态页面对象
//        DynamicForm page = new DynamicForm();
//        page.setStyle(new HashMap<>());
//        page.setPageData(new HashMap<>());
//        if (relationTag == null || StringUtils.isEmpty(relationTag.getActivityId())) {
//            page.setRules(new ArrayList<>());
//        } else {
//            page.setRules(themeMapService.getRules(relationTag.getActivityId(), executeContext.getLocale()));
//        }
//        buildContext.setDynamicForm(page);
//        // 规则回填，用于词库字段隐藏规则处理
//        pageDefine.setRules(page.getRules());
//        // 解析页面需要展示的元素
//        ShowMetadata showMetadata = createShowMetadata(executeContext, pageDefine, actionId, apiMetadata, queryResultSet);
//        log.info("[{}]要显示的字段解析，cost：{} ms", firstBacklogId, System.currentTimeMillis() - start);
//        start = System.currentTimeMillis();
//        // 创建布局
//        if (showMetadata != null) {
//            // 添加tag上定义的规则
//            addTagRules("", showMetadata.getShowFields(), page.getRules());
//            // 处理下数据源
//            setDataSourceNameToShowMetadata(buildContext.getQueryResultSet(), showMetadata.getShowFields());
//            //待优化、暂时先这样处理，栅格化的layout渲染
//            // 根据页面展示元素，创建布局对象
//            if (buildContext.getPageDefine().getGridConfigDTO() != null) {
//                page.getStyle().put("grid_layout", pageDefine.getGridConfigDTO());
//                page.setLayout(gridPatternService.createComponents(buildContext, showMetadata, apiMetadata));
//            } else {
//                page.setLayout(createComponents(buildContext, showMetadata, apiMetadata));
//            }
//            // 获取所有元数据上的字段信息
//            getPageDataSet(queryResultSet, pageDefine, apiMetadata, buildContext, showMetadata, page);
//            log.info("[{}]布局解析，cost：{} ms", firstBacklogId, System.currentTimeMillis() - start);
//            start = System.currentTimeMillis();
//        }
//        // 移除特定逻辑下的可编辑规则
//        this.removeEditRulesIfNecessary(executeContext, page.getRules());
//        // 设置提交的按钮
//        BuildActions(executeContext, pageDefine, page);
//        // 设计布局
//        BuildLayout(executeContext, queryResultSet, pageDefine, page);
//        // 设置页面需要的一些附加变量
//        BuilderUtils.BuildVariables(page);
//        // 重置规则
//        super.resetRule(page);
//        log.info("[{}]规则、变量解析，cost：{} ms", firstBacklogId, System.currentTimeMillis() - start);
//
//        // 将hooks规则放入mechnismConfig中并在rules中删除
//        dealHooksRule(page);
//
//        return page;
//    }
    protected PcUiBotApiMetadata getApiMetadata(PcUiBotExecuteContext executeContext, QueryResultSet queryResultSet, T pageDefine, String actionId) {
        PcUiBotApiMetadata apiMetadata;
        if (queryResultSet != null) {
            QueryResult queryResult = queryResultSet.getMainQueryResult();
            if (queryResult.getApiMetadataCollection() != null) {
                apiMetadata = queryResult.getApiMetadataCollection().getMasterApiMetadata();
            } else {
                apiMetadata = this.getMetadata(executeContext, actionId);
                if (apiMetadata == null) {
                    apiMetadata = new PcUiBotApiMetadata();
                }
                PcUiBotApiMetadataCollection apiMetadataCollection = PcUiBotApiMetadataCollection.empty();
                if (pageDefine.getDataSourceSet().getFirstDataQuery() != null && pageDefine.getDataSourceSet().getFirstDataQuery().getNotArray() != null
                        && CollectionUtils.isNotEmpty(apiMetadata.getResponseFields()) && apiMetadata.getResponseFields().size() > 0) {
                    apiMetadata.getResponseFields().get(0).setArray(!pageDefine.getDataSourceSet().getFirstDataQuery().getNotArray());
                }
                //xuxx add 根据数据源配置字段信息拼接元数据
                if (pageDefine.getDataSourceSet() != null && pageDefine.getDataSourceSet().getFirstDataQuery() != null) {
                    apiMetadata.addResponseFields(pageDefine.getDataSourceSet().getFirstDataQuery().getMetadataFields());
                }
                apiMetadataCollection.setMasterApiMetadata(apiMetadata);
                queryResult.withMetaData(apiMetadataCollection);
            }
        } else {
            apiMetadata = this.getMetadata(executeContext, actionId);
            if (apiMetadata == null) {
                apiMetadata = new PcUiBotApiMetadata();
            }
            if (pageDefine.getDataSourceSet() != null && pageDefine.getDataSourceSet().getFirstDataQuery() != null) {
                apiMetadata.addResponseFields(pageDefine.getDataSourceSet().getFirstDataQuery().getMetadataFields());
            }
        }
        return apiMetadata;
    }

    private PcUiBotApiMetadata getMetadata(PcUiBotExecuteContext executeContext, String actionId) {
        if (!org.springframework.util.StringUtils.hasText(actionId)) {
            return null;
        }
        // 调用知识图谱的API，获取数据源对应行动（Action）的元数据
        DigiwinAthenaApiRequest athenaApiRequest =
                DigiwinAthenaApiRequest.builder()
                        .requestHead(new AthenaBasicHttpRequestHead("",
                                executeContext.getLocale(),
                                executeContext.getAuthoredUser().getToken(),
                                executeContext.getTenantId()))
                        .uriVariables("actionId", actionId)
                        .build();
        KnowledgeMapsActionMetadataQueryResult rawMetadataQueryResult =
                this.digiwinKnowledgeMapsProxyService.actionMetadata(athenaApiRequest);
        return metadataService.createApiMetadata(rawMetadataQueryResult);
    }

    protected void getPageDataSet(PcUiBotExecuteContext executeContext, QueryResultSet queryResultSet, PcUiBotTaskPageDefine pageDefine, PcUiBotApiMetadata apiMetadata, PcUiBotShowMetadata showMetadata, UiBotModel dynamicForm) {
        List<String> dataKeys = null;
        if (pageDefine != null && pageDefine.getDataSourceSet() != null && pageDefine.getDataSourceSet().getFirstDataQuery() != null) {
            dataKeys = pageDefine.getDataSourceSet().getFirstDataQuery().getDataKeys();
        } else {
            dataKeys = PcUiBotApiMetadataUtil.getDataKeys(showMetadata.getShowFields());
        }
        List<PcUiBotAllFields> allFields = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(showMetadata.getShowFields())) {
            allFields = allFieldsService.showAllFields(executeContext, showMetadata.getShowFields().get(0), apiMetadata, null, null, dataKeys);
        }

        if (queryResultSet != null
                && queryResultSet.getMainQueryResult() != null
                && org.springframework.util.StringUtils.hasText(queryResultSet.getMainQueryResult().getDataSourceName())) {
            if (!org.springframework.util.CollectionUtils.isEmpty(queryResultSet.getPageData())) {
                dynamicForm.getPageData().putAll(queryResultSet.getPageData(allFields));
            } else {
                if (CollectionUtils.isNotEmpty(showMetadata.getShowFields())) {
                    initPageData(queryResultSet.getMainQueryResult().getDataSourceName(), showMetadata.getShowFields(), dynamicForm, allFields);
                }
            }

            dynamicForm.setPageDataIndex(JsonUtil.objectToJavaObject(queryResultSet.getPageDataIndex(), UiBotPageData.class));
            if (CollectionUtils.isNotEmpty(dataKeys)) {
                Map<String, List<String>> pageDataKeys = new HashMap<>();
                pageDataKeys.put(queryResultSet.getMainQueryResult().getDataSourceName(), dataKeys);
                dynamicForm.setPageDataKeys(JsonUtil.objectToJavaObject(pageDataKeys, UiBotPageData.class));
            } else {
                dynamicForm.setPageDataKeys(JsonUtil.objectToJavaObject(queryResultSet.getPageDataKeys(), UiBotPageData.class));
            }
//            page.setPageCountSize(queryResultSet.getMainQueryResult().size());
        } else {
            String dataSourceName = "";
            if (queryResultSet == null && pageDefine != null
                    && pageDefine.getDataSourceSet() != null
                    && pageDefine.getDataSourceSet().getFirstDataQuery() != null) {
                dataSourceName = pageDefine.getDataSourceSet().getFirstDataQuery().getName();
            }
            if (StringUtils.isNotEmpty(dataSourceName)) {
                if (CollectionUtils.isNotEmpty(showMetadata.getShowFields())) {
                    initPageData(dataSourceName, showMetadata.getShowFields(), dynamicForm, allFields);
                }
            }
//            page.setPageCountSize(0);
        }
    }

    /**
     * 构建空数据集
     */
    public Map bindEmptyPageData(List<PcUiBotAllFields> allFields) {
        if (CollectionUtils.isEmpty(allFields)) {
            return new HashMap();
        }
        Set<String> keys = allFields.stream().map(PcUiBotAllFields::getName).collect(Collectors.toSet());
        if (keys.isEmpty()) {
            return new HashMap();
        }
        Map pageDataMap = new HashMap();
        //只获取第一层数据结构
        for (String key : keys) {
            Optional<String> dataType = allFields.stream().filter(field -> key.equals(field.getName())).map(PcUiBotAllFields::getDataType).findAny();
            if (dataType.isPresent()) {
                String type = dataType.get();
                /*if (DATA_TYPE_NUMBER.equals(type) || DATA_TYPE_NUMERIC.equals(type)) {
                    pageDataMap.put(key,null);
                } else if (DATA_TYPE_BOOLEAN.equals(type)) {
                    pageDataMap.put(key,null);
                } else */
                // TODO:先将数字和布尔型强制给空字符串。
                if ("array".equals(type)) {
                    pageDataMap.put(key, new Object[0]);
                } else if ("object".equals(type)) {
                    pageDataMap.put(key, new HashMap<>());
                } else {
                    pageDataMap.put(key, "");
                }
            }
        }
        return pageDataMap;
    }

    /**
     * 初始化pagedata
     *
     * @param dataSourceName
     * @param showFields
     * @param page
     */
    public void initPageData(String dataSourceName, List<PcUiBotMetadataField> showFields, UiBotModel page, List<PcUiBotAllFields> allFields) {
        UiBotPageData pageData = new UiBotPageData();
        if (showFields.size() > 0 && !showFields.get(0).isArray()) {
            pageData.put(dataSourceName, bindEmptyPageData(allFields));
        } else {
            List dataList = new ArrayList();
            //dataList.add(bindEmptyPageData(allFields));
            pageData.put(dataSourceName, dataList);
        }
        page.setPageData(pageData);
    }

    /**
     * 将提交Api的请求参数，添加到getApi元数据中
     *
     * @param executeContext
     * @param submitActions  提交操作
     * @param apiMetadata    getApi元数据
     */
    protected void addSubmitFiled(PcUiBotExecuteContext executeContext, List<PcUiBotSubmitAction> submitActions, PcUiBotApiMetadata apiMetadata) {
        if (CollectionUtils.isEmpty(submitActions)) {
            return;
        }
        if (apiMetadata == null || CollectionUtils.isEmpty(apiMetadata.getResponseFields())) {
            return;
        }
        //todo：暂时放在第一个字段上
        List<PcUiBotMetadataField> metadataFields = apiMetadata.getResponseFields().get(0).getSubFields();
        if (metadataFields == null) {
            return;
        }
        List<PcUiBotMetadataField> addFields = new ArrayList<>();
        for (PcUiBotSubmitAction submitAction : submitActions) {
            if (CollectionUtils.isNotEmpty(submitAction.getCombineActions())) {
                for (PcUiBotSubmitAction combineSubAction : submitAction.getCombineActions()) {
                    addSubmitFields(executeContext, metadataFields, addFields, combineSubAction);
                }
            } else {
                addSubmitFields(executeContext, metadataFields, addFields, submitAction);
            }
        }
        for (PcUiBotMetadataField addField : addFields) {
            PcUiBotMetadataField metadataField = new PcUiBotMetadataField();
            metadataField.setUiBot("Y");
            metadataField.setName(addField.getName());
            metadataField.setDataType(addField.getDataType());
            metadataField.setDescription(addField.getDescription());
            metadataFields.add(metadataField);
        }
    }

    /**
     * 将提交Api的请求参数，添加到getApi元数据中
     *
     * @param executeContext
     * @param metadataFields getApi元数据
     * @param addFields      添加的字段
     * @param submitAction   提交操作
     */
    private void addSubmitFields(PcUiBotExecuteContext executeContext, List<PcUiBotMetadataField> metadataFields, List<PcUiBotMetadataField> addFields, PcUiBotSubmitAction submitAction) {
        if (!"ESP".equals(submitAction.getCategory())) {
            return;
        }
        PcUiBotApiMetadata submitMetadataData = this.getMetadata(executeContext, submitAction.getActionId());
        if (submitMetadataData == null) {
            return;
        }
        List<PcUiBotMetadataField> fields = submitMetadataData.getRequestFields();
        for (PcUiBotMetadataField field : fields) {
            if (PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(field.getDataType())) {
                continue;
            }
            boolean addFlag = true;
            for (PcUiBotMetadataField metadataField : metadataFields) {
                if (PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(metadataField.getDataType())) {
                    continue;
                }
                if (field.getName().equals(metadataField.getName())) {
                    addFlag = false;
                }
            }
            if (addFlag) {
                addFields.add(field);
            }
        }
    }

    /**
     * xuxx 2021-09-04 创建界面显示的元素
     *
     * @param executeContext
     * @param pageDefine
     * @param actionId
     * @param apiMetadata
     * @param queryResultSet
     * @return
     */
    protected PcUiBotShowMetadata createShowMetadata(PcUiBotExecuteContext executeContext, T pageDefine, String actionId, PcUiBotApiMetadata apiMetadata, QueryResultSet queryResultSet) {
        //
        analyseSubmitActionFieldService.submitMetadataFiledToGetMetadata(executeContext, apiMetadata, pageDefine.getSubmitActions());
        PcUiBotApiMetadataUtil.flatMetaData(apiMetadata);

        //获取themeMap里定义的业务tag，包括分组
        PcUiBotTaggingData taggingData = null;
        // 在数据源类型RAWDATA的情况actionId有可能为空
        if (actionId != null) {
            taggingData = tagService.getThemeMapTag(pageDefine.getQueryTagSuffix(), executeContext.getRelationTag(), actionId, "TAG", executeContext);
        }
        //xuxx 2021-12-16 add 获取activityConfigs中的tag信息（客制tag）
        customizeTagSetByActivityConfigsService.getCustomizeTags(actionId, pageDefine, taggingData);

        //xuxx 2022-12-09 add 判断是否存在ORDER TAG，如果存在就走TAG 排序
        //xuxx 2023-4-20 edit 判断当走词库时，不走order TAG 排序
        /*if (CollectionUtils.isNotEmpty(pageDefine.getShowMetadatas()) && !viewWordsService.isShowViewWords(taggingData)) {
            pageDefine.setShowMetadatas(null);
        }*/

        //xuxx 2022-1-5 add 获取用户自定义的tag
        //TODO XUXX 2022-12-09需要调到词库后面执行！！！！！！！
        if (executeContext.getOpenWindow() == null || BooleanUtils.isFalse(executeContext.getOpenWindow())) {
            taggingData = userDefinedService.getFieldsSeqByUser(pageDefine, executeContext, taggingData, apiMetadata);
        }

        if (taggingData != null) {
            //在tagData上添加tag相关的定义
//            tagDefinitionService.processTagDefinitions(taggingData, executeContext);
            //把tagData设置到元数据上
            signTagService.signTagMetadataToFields(apiMetadata, taggingData);
        }

        // 决策因子虚拟字段场景，用户保存了顺序，然后增加一个隐藏字段，会导致失效，需要再这里进行移除，必选要在打tag后面
        removeTagByHiddenFields(executeContext, apiMetadata);

        // 处理字段是否可以编辑(理论上需要放在这里将数据源上的名字和元数据对应，但是为了兼容以前的，不能删)，必须在平铺之前做可编辑处理
        tagEditFields(pageDefine, apiMetadata.getResponseFields());

        // todo : xuxx 没有走词库的，还是需要在这里进行平铺元数据，后续全部走词库则需去除，词库中的平铺将在解析词库的时候，一并进行；
        //解析flatmetadata tag 平铺单身到父节点上；
        if (CollectionUtils.isEmpty(pageDefine.getShowMetadatas()) && flatMetadataByTagService.isMetadataTag(apiMetadata)) {
            /**
             * 正常情况下，我们建议应用提交单头+单身整包数据。
             * 但有些应用配置的是只提交单身数据，因此这里必须在平铺metadata之前根据dataSourceName重命名metadata的name+path、tagEdit SD字段。
             * 否则一旦执行完平铺metadata后，单身D数组字段将不存在，再根据actionParams tagEdit SD字段会失效。
             */
            this.setDataSourceNameToApiMetadata(apiMetadata, queryResultSet);
            this.tagEditFields(pageDefine, apiMetadata.getResponseFields());

            flatMetadataByTagService.flatMetadata(executeContext, apiMetadata);
        }

        List<String> dataKeys = pageDefine.getDataSourceSet().getFirstDataQuery().getDataKeys();
        List<PcUiBotMetadataField> needShowFields = new ArrayList<>();
        //优先处理HEAD标签
        PcUiBotMetadataField metadataFieldHead = PcUiBotHeadTagUtils.analysisTag(apiMetadata.getResponseFields());

        if (metadataFieldHead != null) {
            if (queryResultSet != null && queryResultSet.getMainQueryResult().getData().size() > 0) {
                needShowFields.add(metadataFieldHead);
                queryResultSet.appendData(QueryResult.withSingleData(queryResultSet.getMainQueryResult().getDataSourceName() + "_HEAD", queryResultSet.getMainQueryResult().getData().get(0)));
            } else {
                if (queryResultSet != null) {
                    queryResultSet.appendData(QueryResult.withSingleData(queryResultSet.getMainQueryResult().getDataSourceName() + "_HEAD", new HashMap<>()));
                }
            }
        }

        setDataSourceNameToApiMetadata(apiMetadata, queryResultSet);
        //把元数据变成字典
        for (PcUiBotMetadataField responseField : apiMetadata.getResponseFields()) {
            if (CollectionUtils.isEmpty(dataKeys)) {
                dataKeys = PcUiBotApiMetadataUtil.getDataKeys(responseField.getSubFields());
                pageDefine.getDataSourceSet().getFirstDataQuery().setDataKeys(dataKeys);
            }
            //直接处理第二层，默认第一层是root
            List<PcUiBotMetadataField> needShowSubFields = getShowFields(executeContext, queryResultSet, dataKeys, responseField, pageDefine);
            if (needShowSubFields.size() > 0) {
                needShowFields.add(responseField.clone(null, needShowSubFields));
            }
        }

        // TODO -xuxx  根据购买的应用做过滤，
        //  当配了APPLICATION时，并且配置的应用CODE与当前租户拥有的应用CODE一致才显示，否则不显示；
        //  若没配APPLICATION时，默认与tag一致显示；
        List<PcUiBotMetadataField> needShowAppFields = new ArrayList<>();
        for (PcUiBotMetadataField subMetadataField : needShowFields) {
            //直接处理第二层，默认第一层是root
            List<PcUiBotMetadataField> needShowSubFields = showApplicationFieldsService.applicationFilterShowField(subMetadataField);
            if (needShowSubFields.size() > 0) {
                needShowAppFields.add(subMetadataField.clone(null, needShowSubFields));
            }
        }

        //当没有tag时需显示全部
        if (CollectionUtils.isEmpty(needShowAppFields)) {
            needShowAppFields = apiMetadata.getResponseFields();
        }

        // 根据配置打上自定义标签
        signTagService.markCustomTagFromConfig(needShowAppFields, pageDefine);

        //setDataSourceNameToApiMetadata(apiMetadata, queryResultSet);
        // todo : xuxx 没有走词库的，还是需要在这里进行平铺元数据，后续全部走词库则需去除，词库中的平铺将在解析词库的时候，一并进行；
        //解析词库解析完之后。。。元数据也需要  flatmetadata tag 平铺单身到父节点上；
        if (CollectionUtils.isNotEmpty(pageDefine.getShowMetadatas()) && flatMetadataByTagService.isMetadataTag(apiMetadata)) {
            flatMetadataByTagService.flatMetadata(executeContext, apiMetadata);
        }

        //重新整理数据
        if (executeContext.getIsRowSpanTree()) {
            for (PcUiBotMetadataField needShowField : needShowAppFields) {
                needShowField.flatMetaDataNotFlatPath(null);
            }
        } else {
            for (PcUiBotMetadataField needShowField : needShowAppFields) {
                needShowField.flatMetaData(null);
            }
        }

        //处理下数据源
        setDataSourceNameToShowMetadata(queryResultSet, needShowAppFields);

        //  处理字段是否可以编辑(理论上需要放在这里将数据源上的名字和元数据对应，但是为了兼容以前的，不能删)
        tagEditFields(pageDefine, needShowAppFields);

        PcUiBotShowMetadata showMetadata = new PcUiBotShowMetadata();
        showMetadata.setActionId(apiMetadata.getActionId());
        showMetadata.setServiceName(apiMetadata.getServiceName());
        showMetadata.setShowFields(needShowAppFields);

        //添加默认的tagdefine
        addDefaultTag(showMetadata.getShowFields());
        // 排序功能 ：没有配置标准的pattern才需要根据TAG来排序！
        // 当不走词库并存在用户自定义顺序的时候，即使是配置标准的pattern，也要启用tag排序
//        if (CollectionUtils.isEmpty(pageDefine.getShowMetadatas()) && CollectionUtils.isNotEmpty(pageDefine.getUserDefinedCenterMetadataResultList())) {
//            buildContext.setIsOrder(true);
//        }
//        if (buildContext.getIsOrder()) {
//            orderTagInterpreter.analysisTag(showMetadata);
//        }
        // 特殊处理栏位只打导航TAG的场景
        PcUiBotTagUtil.handleOnlyHasNavigateTagScene(showMetadata);
        // 统一处理不可编辑字段
        PcUiBotUnEditableTagUtils.analysisTag(showMetadata.getShowFields());
        //获取主数据源名称
        String dataSourceName = "";

        if (queryResultSet == null &&
                pageDefine.getDataSourceSet() != null && pageDefine.getDataSourceSet().getFirstDataQuery() != null) {
            dataSourceName = pageDefine.getDataSourceSet().getFirstDataQuery().getName();
        }
        if (queryResultSet != null && queryResultSet.getMainQueryResult() != null) {
            dataSourceName = queryResultSet.getMainQueryResult().getDataSourceName();
        }
//        //处理操作服务 不能提到前面，这里操作服务需要对应配置数据源
//        operationService.addMetadataOperation(showMetadata, pageDefine.getOperations(), apiMetadata);
//        //处理分组业务逻辑
//        if (!ActivityConstants.PATTERN_DIALOG.equals(executeContext.getPattern())) {
//            groupSettingService.addTableInsideGroup(executeContext, dataSourceName, showMetadata, pageDefine);
//        }
        return showMetadata;
    }

    /**
     * 决策因子需要根据隐藏标签进行隐藏
     *
     * @param executeContext
     * @param apiMetadata
     */
    private void removeTagByHiddenFields(PcUiBotExecuteContext executeContext, PcUiBotApiMetadata apiMetadata) {
        Map<String, Object> bpmData = executeContext.getBpmData();
        if (bpmData == null) {
            return;
        }
        if (!bpmData.containsKey(PcUiBotConstants.UIBOT_ACTION_METADATA)) {
            return;
        }
        // 根据bpm中的隐藏字段的配置处理第一层级的隐藏,移除tag
        Object o = bpmData.get(PcUiBotConstants.UIBOT_HIDDEN_FIELDS);
        if (o == null) {
            return;
        }
        List<String> hiddenFields = null;
        if (o instanceof List) {
            hiddenFields = (List<String>) o;
            if (CollectionUtils.isNotEmpty(hiddenFields)) {
                List<PcUiBotMetadataField> responseFields = apiMetadata.getResponseFields();
                if (CollectionUtils.isNotEmpty(responseFields)) {
                    removeTagByHiddenFields(responseFields, hiddenFields);
                }
            }
        }
    }

    private void removeTagByHiddenFields(List<PcUiBotMetadataField> metadataFieldList, List<String> hiddenFields) {
        for (PcUiBotMetadataField metadataField : metadataFieldList) {
            if (hiddenFields.contains(metadataField.getName())) {
                metadataField.setTagDefinitions(null);
            }
            List<PcUiBotMetadataField> subFields = metadataField.getSubFields();
            if (CollectionUtils.isNotEmpty(subFields)) {
                removeTagByHiddenFields(subFields, hiddenFields);
            }
        }
    }

    protected void tagEditFields(T pageDefine, List<PcUiBotMetadataField> needShowFields) {
        if (pageDefine.getCanEdit() != null) {
            if (pageDefine.getCanEdit()) {
                editRangeService.allEidtToSingle(needShowFields, true);
            }
        } else {
            // 移除项目卡根据入参将字段变成可编辑
            PcUiBotExecuteContext executeContext = pageDefine.getExecuteContext();
            if (!UiBotDesignerService.PAGECODE_PROJECT_DETAIL.equals(executeContext.getPageCode())) {
                editRangeService.tagEditRange(pageDefine.getSubmitActions(), needShowFields, isAllowBizKeyEdit(pageDefine.getExecuteContext()));
            }
        }
    }

    /**
     * 是否允许主键可编辑，如：基础资料录入的主键就可以编辑
     *
     * @param executeContext
     * @return
     */
    private boolean isAllowBizKeyEdit(PcUiBotExecuteContext executeContext) {
        return PcUiBotActivityConstants.PATTERN_BASIC_DATA.equals(executeContext.getPattern());
    }

    protected List<PcUiBotMetadataField> getShowFields(PcUiBotExecuteContext executeContext, QueryResultSet queryResultSet, List<String> dataKeys, PcUiBotMetadataField rootField, T pageDefine) {
        return tagDisplayRangeService.getShowFields(executeContext, rootField, queryResultSet, pageDefine);
    }

    private void addDefaultTag(List<PcUiBotMetadataField> showFields) {
        if (CollectionUtils.isEmpty(showFields)) {
            return;
        }
        for (PcUiBotMetadataField showField : showFields) {
            if (CollectionUtils.isEmpty(showField.getTagDefinitions())
                    && !PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(showField.getDataType())) {
                //Object不能打tag
                showField.setTagDefinitions(PcUiBotDefaultTagUtils.createDataTypeTagDefinitions(showField));

            }
            addDefaultTag(showField.getSubFields());
        }
    }


    /**
     * 平铺layout结构，减少嵌套
     *
     * @param components
     */
//    private List<AbstractComponent> flatComponents(List<AbstractComponent> components) {
//        List<AbstractComponent> layouts = new ArrayList<>();
//        if (CollectionUtils.isEmpty(components)) {
//            return components;
//        }
//
//        for (AbstractComponent component : components) {
//            if (component instanceof FormComponent) {
//                //转化为FormComponent
//                FormComponent formComponent = (FormComponent) component;
//                //用于存放新的FormComponent
//                FormComponent newlayout = new FormComponent();
//                BeanUtils.copyProperties(component, newlayout);
//                layouts.add(newlayout);
//                List<AbstractComponent> groups = new ArrayList<>();
//                newlayout.setGroup(groups);
//                this.getGroups(layouts, newlayout, formComponent);
//                if (CollectionUtils.isNotEmpty(newlayout.getGroup()) && newlayout.getGroup().size() == 1) {
//                    if (newlayout.getGroup().get(0) instanceof FormComponent) {
//                        FormComponent formComponent1 = (FormComponent) newlayout.getGroup().get(0);
//                        if (CollectionUtils.isNotEmpty(formComponent1.getGroup())) {
//                            newlayout.setGroup(formComponent1.getGroup());
//                            newlayout.setDirection(null);
//                        }
//                    }
//                }
//            } else {
//                layouts.add(component);
//            }
//        }
//        return layouts;
//    }

    /**
     * 平铺layout中 FORM_LIST下结构
     *
     * @param layouts
     * @param layout
     * @param formComponent
     */
//    private void getGroups(List<AbstractComponent> layouts, FormComponent layout, FormComponent formComponent) {
//        if (CollectionUtils.isEmpty(formComponent.getGroup())) {
//            return;
//        }
//        //用于存放新的group
//        for (AbstractComponent group : formComponent.getGroup()) {
//            if (group instanceof FormComponent) {
//                //转化为FormComponent
//                FormComponent groupForm = (FormComponent) group;
//                if (CollectionUtils.isEmpty(groupForm.getGroup())) {
//                    continue;
//                }
//                if (groupForm.getGroup().isEmpty()) {
//                    continue;
//                }
//                for (AbstractComponent component : groupForm.getGroup()) {
//                    if (component instanceof GridComponent) {
//                        String schema = component.getSchema();
//                        component.setSchema(schema);
//                        component.setTableTitle(groupForm.getTitle());
//                        layouts.add(component);
//                    } else if (component instanceof TabGroupComponent) {
//                        layouts.add(component);
//                    } else if (component instanceof FormComponent) {
//                        FormComponent groupForm2 = (FormComponent) component;
//                        groupForm2.setSchema(groupForm.getSchema());
//                        this.getGroups(layouts, layout, groupForm2);
//                    } else {
//                        layout.getGroup().add(groupForm);
//                        break;
//                    }
//                }
//            } else if (group instanceof GridComponent
//                    || group instanceof TabGroupComponent
//                    || group instanceof SplitLayoutComponent) {
//                String schema = group.getSchema();
//                group.setSchema(schema);
//                layouts.add(group);
//            } else {
//                Optional<AbstractComponent> optional = layouts.stream().filter(ly -> ly.getType().equals("ATHENA_TABLE")).findFirst();
//                if (optional.isPresent()) {
//                    if (StringUtils.isEmpty(formComponent.getSchema())) {
//                        String formSchema = group.getPath();
//                        if (group.getPath() != null && group.getPath().contains(".")) {
//                            formSchema = group.getPath().split("\\.")[group.getPath().split("\\.").length - 1];
//                        }
//                        formComponent.setSchema(formSchema);
//                    }
//                    if (StringUtils.isEmpty(formComponent.getPath())) {
//                        String formPath = group.getPath();
//                        if (group.getPath() != null && group.getPath().contains(".")) {
//                            formPath = group.getPath().split("\\.")[0];
//                        }
//                        formComponent.setPath(formPath);
//                    }
//                    layouts.add(formComponent);
//                } else {
//                    layout.getGroup().add(formComponent);
//                    break;
//                }
//            }
//        }
//    }

//    public List<AbstractComponent> createComponentsForTest(BuildContext buildContext,
//                                                           ShowMetadata showMetadata,
//                                                           ApiMetadata apiMetadata) {
//        return this.createComponents(buildContext, showMetadata, apiMetadata);
//    }

//    private List<AbstractComponent> createComponents(BuildContext buildContext, ShowMetadata showMetadata, ApiMetadata apiMetadata) {
//        //支持多个API合集
//        //每组代表一个原生态的
//        List<AbstractComponent> layoutList = new ArrayList<>();
//        if (CollectionUtils.isEmpty(showMetadata.getShowFields())) {
//            return layoutList;
//        }
//        //因为存在多个数据源，且可能和元数据的名称不一致，需要做个判断，如果在数据源中不存在，则指定为指向主要的数据源
//        for (MetadataField showField : showMetadata.getShowFields()) {
//            AbstractComponent layout = createComponent(showField, showField.getSubFields(), buildContext, apiMetadata);
//            layoutList.add(layout);
//        }
//        //xuxx平铺layout结构，减少嵌套
//        layoutList = flatComponents(layoutList);
//        //解析components层级，放置一些设置变量
//        ComponentUtils.analysisComponents(layoutList);
//        // 创建toolBar
//        ToolBarComponent toolBarComponent = operationService.createToolBarComponent(buildContext);
//        CollUtil.addIfAbsent(layoutList, toolBarComponent);
//        return layoutList;
//    }
//
//    private AbstractComponent createComponent(MetadataField metadataField, List<MetadataField> subFields, BuildContext buildContext, ApiMetadata apiMetadata) {
//        List<MetadataField> bodyShowFields = new ArrayList<>();
//        //循环所有节点
//        if (TagUtil.renderObjectMetadataField(metadataField)) {
//            bodyShowFields.add(metadataField);
//        } else {
//            for (MetadataField subField : subFields) {
//                String subFieldPath = subField.getPath();
//                String subFieldName = subField.getName();
//                String subFieldDataType = subField.getDataType();
//                List<MetadataField> grandsonFields = subField.getSubFields();
//                //特殊处理check_item 和 count_item 当做一个字段来处理
//                if (TagUtil.renderObjectMetadataField(subField)) {
//                    bodyShowFields.add(subField);
//                } else {
//                    // object字段，子节点不为空，名称不为CHECK_RESULT和COUNT_RESULT
//                    if (ApiMetadataConstants.METADATA_OBJECT.equals(subFieldDataType)
//                            && CollectionUtils.isNotEmpty(grandsonFields)
//                            && !ApiMetadataConstants.CHECK_RESULT.equals(subFieldName)
//                            && !ApiMetadataConstants.COUNT_RESULT.equals(subFieldName)) {
//                        MetadataField newMetadataField = new MetadataField();
//                        newMetadataField.setDataType(ApiMetadataConstants.METADATA_OBJECT);
//                        newMetadataField.setDescription(subField.getDescription());
//                        newMetadataField.setPath(subFieldPath);
//                        newMetadataField.setName(subFieldName);
//                        newMetadataField.setTagDefinitions(subField.getTagDefinitions());
//                        newMetadataField.setObjectData(createComponent(subField, grandsonFields, buildContext, apiMetadata));
//                        //导出table 下载使用
//                        newMetadataField.setExportTableFields(subField.getExportTableFields());
//                        bodyShowFields.add(newMetadataField);
//                    } else {
//                        bodyShowFields.add(subField);
//                    }
//                }
//            }
//        }
//        // 字段分组
//        List<GroupMetadataField> groupMetadataFields = groupTagInterpreter.analysisTagGroup(bodyShowFields, buildContext);
//        // 特殊处理eoc分组
//        EocSelectInterpreter.handleEocGroup(groupMetadataFields);
//        return componentTagInterpreter.componentInterpreter(metadataField, groupMetadataFields, buildContext, apiMetadata);
//    }

    /**
     * 之后用的判断条件
     *
     * @param pageDefine
     * @return
     */
//    protected BuildContext createBuildContext(PcUiBotPageDefine pageDefine, QueryResultSet queryResultSet, PcUiBotExecuteContext executeContext, PcUiBotApiMetadata apiMetadata) {
//        BuildContext buildContext = new BuildContext();
//        buildContext.setPageDefine(pageDefine);
//        buildContext.setQueryResultSet(queryResultSet);
//        buildContext.setExecuteContext(executeContext);
//        buildContext.setIsOrder(true);
//        buildContext.setApiMetadata(apiMetadata);
//        return buildContext;
//    }

    /**
     * 默认OBJECT 上没有规则
     *
     * @param showFields
     */
    protected void addTagRules(String path, List<PcUiBotMetadataField> showFields, List<UiBotRule> rules) {
        if (showFields == null) {
            return;
        }
        for (PcUiBotMetadataField showField : showFields) {
            String pathName = "";
            if (StringUtils.isBlank(path)) {
                pathName = showField.getName();
            } else {
                pathName = path + "." + showField.getName();
            }

            if (PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(showField.getDataType())) {
                addTagRules(pathName, showField.getSubFields(), rules);
            } else {
                if (CollectionUtils.isNotEmpty(showField.getTagDefinitions()) && showField.isCanEdit()) {
                    for (PcUiBotTagDefinition tagDefinition : showField.getTagDefinitions()) {
                        if (tagDefinition.getRuleDefinition() != null && CollectionUtils.isNotEmpty(tagDefinition.getRuleDefinition().getRules())) {
                            for (JSONObject rule : tagDefinition.getRuleDefinition().getRules()) {
                                UiBotRule uiBotRule = JsonUtil.objectToJavaObject(rule, UiBotRule.class);
                                uiBotRule.setPath(path);
                                rules.add(uiBotRule);
                            }
                        }
                    }
                }
            }
        }
    }


    /**
     * 添加提交的逻辑
     */
//    protected void BuildActions(ExecuteContext executeContext, T pageDefine, DynamicForm dynamicForm) {
//        if (requireRenderActions(pageDefine, dynamicForm)) {
//            dynamicForm.setActions(pageDefine.getSubmitActions());
//        }
//    }

    /**
     * 是否需要渲染提交按钮
     *
     * @return
     */
//    private boolean requireRenderActions(T pageDefine, DynamicForm dynamicForm) {
//        DataSourceSetDTO dataSourceSetDTO = pageDefine.getDataSourceSet();
//        // 基础资料录入，要设置actions
//        if (null != pageDefine.getExecuteContext() && PatternUtil.isBaseData(pageDefine.getExecuteContext().getPattern())) {
//            return true;
//        }
//
//        // 没有配置数据源，不关心是否渲染提交按钮
//        if (null == dataSourceSetDTO || org.apache.commons.collections.CollectionUtils.isEmpty(dataSourceSetDTO.getDataSourceList())) {
//            return true;
//        }
//        Map<String, Object> pageData = dynamicForm.getPageData();
//        // 有配置数据源，但没有相关业务数据，不需要渲染提交按钮
//        if (MapUtils.isEmpty(pageData)) {
//            return false;
//        }
//
//        for (DataSourceDTO dataSourceDTO : dataSourceSetDTO.getDataSourceList()) {
//            Object dataObj = pageData.get(dataSourceDTO.getName());
//            if (null == dataObj) {
//                continue;
//            }
//            // 不是集合，返回true
//            if (!(dataObj instanceof Collection)) {
//                return true;
//            }
//            // 是非空集合，返回true
//            else if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection) dataObj)) {
//                return true;
//            }
//        }
//        return false;
//    }

    /**
     * 创建布局
     */
//    protected void BuildLayout(ExecuteContext executeContext, QueryResultSet queryResultSet, T pageDefine, DynamicForm dynamicForm) {
//        dynamicForm.setExecuteContext(executeContext);
//    }
    protected QueryResultSet BuildDataSource(PcUiBotExecuteContext executeContext, T pageDefine) {
        if (pageDefine == null) {
            return null;
        }
        // 获取数据源的数据
        QueryResultSet queryResultSet = super.queryByPagedefineWithMetaData(pageDefine.getExecuteContext(), pageDefine);
        return queryResultSet;
    }

    /**
     * xuxx add 处理数据源名称与元数据名称不致，以数据源定义为准
     *
     * @param queryResultSet
     * @param showFields
     */
    protected void setDataSourceNameToShowMetadata(QueryResultSet queryResultSet, List<PcUiBotMetadataField> showFields) {
        if (CollectionUtils.isEmpty(showFields)) {
            return;
        }
        if (queryResultSet == null) {
            return;
        }
        //因为存在多个数据源，且可能和元数据的名称不一致，需要做个判断，如果在数据源中不存在，则指定为指向主要的数据源
        for (PcUiBotMetadataField showField : showFields) {
            boolean isExist = false;
            for (QueryResult queryResult : queryResultSet.getQueryResults()) {
                if (showField.getName() != null
                        && showField.getName().equals(queryResult.getDataSourceName())) {
                    isExist = true;
                    break;
                }
            }
            if (!isExist) {
                showField.setName(queryResultSet.getMainQueryResult().getDataSourceName());
            }
        }
    }

    /**
     * xusj add 处理数据源与元数据名称不致，以数据源定义的为准去更新各个field的path
     *
     * @param mainDataSourceName
     * @param fields
     */
    private void setPathToFields(String mainDataSourceName, List<PcUiBotMetadataField> fields) {
        if (CollectionUtils.isEmpty(fields)) {
            return;
        }
        //因为存在多个数据源，且可能和元数据的名称不一致，需要做个判断，如果在数据源中不存在，则指定为指向主要的数据源
        for (PcUiBotMetadataField showField : fields) {
            if (StringUtils.isNotEmpty(showField.getPath())) {
                int fristIndex = showField.getPath().indexOf(".");
                if (showField.getPath().contains(".")) {
                    showField.setPath(mainDataSourceName + "." + showField.getPath().substring(fristIndex + 1));
                } else {
                    showField.setPath(mainDataSourceName);
                }
            }
            List<PcUiBotMetadataField> subFields = showField.getSubFields();
            if (CollectionUtils.isEmpty(subFields)) {
                continue;
            }
            setPathToFields(mainDataSourceName, subFields);
        }
    }

    //
//    /**
//     * xusj add 处理数据源与元数据名称不致，以数据源定义的为准去更新path
//     *
//     * @param apiMetada
//     * @param queryResultSet
//     */
    private void setDataSourceNameToApiMetadata(PcUiBotApiMetadata apiMetada, QueryResultSet queryResultSet) {
        QueryResult queryResult = queryResultSet.getMainQueryResult();
        List<PcUiBotMetadataField> responseFields = apiMetada.getResponseFields();
        String mainDataSourceName = queryResultSet.getMainQueryResult().getDataSourceName();
        if (CollectionUtils.isEmpty(responseFields)) {
            return;
        }
        if (responseFields.size() == 0 || mainDataSourceName.equals(responseFields.get(0).getName())) {
            return;
        }
        responseFields.get(0).setName(mainDataSourceName);
        setPathToFields(mainDataSourceName, apiMetada.getResponseFields().get(0).getSubFields());
        queryResult.getApiMetadataCollection().setMasterApiMetadata(apiMetada);
    }
//
//    /**
//     * 将hooks规则放入mechnismConfig中并在rules中删除
//     *
//     * @param dynamicForm
//     */
//    private void dealHooksRule(DynamicForm dynamicForm) {
//        List<Map<String, Object>> rules = dynamicForm.getRules();
//        if (CollectionUtils.isEmpty(rules)) {
//            return;
//        }
//        // 复制规则
//        List<Map<String, Object>> ruleCopyList = JsonUtils.jsonToObject(JsonUtils.objectToString(rules), List.class);
//        // 机制规则
//        List<Map<String, Object>> apiTriggerRules = new ArrayList<>();
//        // 处理特殊规则
//        for (Map<String, Object> rule : ruleCopyList) {
//            if (UiBotConstants.RuleKeyType.API_TRIGGER.equals(rule.get("key"))) {
//                apiTriggerRules.add(rule);
//                // 在原来的rules中删除apiTrigger
//                rules.remove(rule);
//            }
//        }
//        // 已有的mechnismConfig
//        Map<String, Object> mechnismConfigMap = new HashMap<>();
//        if (null != dynamicForm.getMechnismConfig() && dynamicForm.getMechnismConfig().containsKey("rules")) {
//            mechnismConfigMap = dynamicForm.getMechnismConfig();
//        }
//        // 已有的机制rules
//        List<Map<String, Object>> mechnismConfigRules = new ArrayList<>();
//        if (mechnismConfigMap.containsKey("rules") && null != mechnismConfigMap.get("rules")) {
//            mechnismConfigRules = JsonUtils.jsonToObject(JsonUtils.objectToString(mechnismConfigMap.get("rules")), List.class);
//        }
//        mechnismConfigRules.addAll(apiTriggerRules);
//
//        mechnismConfigMap.put("rules", mechnismConfigRules);
//        dynamicForm.setMechnismConfig(mechnismConfigMap);
//    }
//
//    /**
//     * 创建布局
//     */
//    protected void BuildExplanationLayout(String explanation, DynamicForm dynamicForm) {
//        if (StringUtils.isBlank(explanation)) {
//            return;
//        }
//        ExplanationComponent explanationComponent = new ExplanationComponent();
//        explanationComponent.setExplanation(explanation);
//        explanationComponent.setId(UUID.randomUUID().toString());
//        explanationComponent.setType("DESCRIPTION");
//        explanationComponent.setDisabled(Boolean.FALSE);
//        explanationComponent.setEditable(Boolean.FALSE);
//        if (dynamicForm.getLayout() == null) {
//            dynamicForm.setLayout(new ArrayList<>());
//        }
//        dynamicForm.getLayout().add(0, explanationComponent);
//    }
}
