package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.builder;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.ShowFieldService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.TagDisplayRangeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：标准型任务模板</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ProcessTaskPatternBuilder.java
 * @Author: wangjwc
 * @Date: created at 2023/11/14 13:35
 */
@Service("processTaskPatternBuilder")
public class ProcessTaskPatternBuilder extends PageBuilderBase<PcUiBotTaskPageDefine> {
    /**
     * 返回支持的类型
     *
     * @return
     */
    @Override
    public String supportKey() {
        return "webplatform-business-process-2.0";
    }

    @Autowired
    private ShowFieldService showFieldService;

    @Autowired
    private TagDisplayRangeService tagDisplayRangeService;

    @Override
    public PcUiBotShowMetadata createShowMetadata(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, String actionId, PcUiBotApiMetadata apiMetadata, QueryResultSet queryResultSet) {
        return super.createShowMetadata(executeContext, pageDefine, actionId, apiMetadata, queryResultSet);
    }

    /**
     * xuxx 组装显示字段
     * 先根据pattern在TM中的配置字段；
     * 其次，从词库中获取；
     * 当配置中和词库中都存在时，求并集；且以TM配置显示顺序为准；
     * 当配置中和词库中都没有，获取所有元数据中字段，并根据tag显示；
     *
     * @param dataKeys
     * @param rootField
     * @param pageDefine
     * @return
     */
    @Override
    public List<PcUiBotMetadataField> getShowFields(PcUiBotExecuteContext executeContext, QueryResultSet queryResultSet, List<String> dataKeys, PcUiBotMetadataField rootField, PcUiBotTaskPageDefine pageDefine) {
        Map<String, PcUiBotMetadataField> needShowFields = new LinkedHashMap<>();
        Map<String, PcUiBotMetadataField> fieldMap = rootField.getFieldMap();
        int i = 0;

        // 用于保存元数据第一层字段
        List<Object> apiMetadataStr = new ArrayList<Object>();
        apiMetadataStr.add(fieldMap.keySet());

        //显隐词库,已经在使用中
        //显隐词库的功能是，如果显隐词库中配置了的字段，从tag的控制中把该字段拿掉，即：使该字段配置的tag失效，改用词库控制
        List<String> notShowWords = showFieldService.getWordsByAbility(executeContext, apiMetadataStr, queryResultSet, pageDefine);

        //xuxx 2022-12-09 add 词库解析
        if (CollectionUtils.isNotEmpty(pageDefine.getShowMetadatas())) {
            viewWordsService.analyseShowViewWords(pageDefine, rootField, notShowWords, needShowFields);
            if (CollectionUtils.isNotEmpty(needShowFields)) {
                i++;
            }
        }

        //1、主键列
        if (CollectionUtils.isNotEmpty(dataKeys)) {
            for (String dataKey : dataKeys) {
                if (!dataKey.endsWith("_seq") && fieldMap.containsKey(dataKey)) {
                    //业务主键可能会不必显示
                    if (fieldMap.get(dataKey).getTagDefinitions() != null) {
                        needShowFields.put(rootField.getName() + "." + dataKey, fieldMap.get(dataKey));
                    }
                }
            }
        }
        //2、业务主键的关联属性
        if (CollectionUtils.isNotEmpty(pageDefine.getDataKeyProperties())) {
            i++;
            for (String fieldName : pageDefine.getDataKeyProperties()) {
                if (!notShowWords.contains(fieldName)) {
                    showFieldService.addShowFieldByFullName(fieldName, rootField, needShowFields);
                }
            }
        }
        //3、执行标的物目标
        if (CollectionUtils.isNotEmpty(pageDefine.getSubjectMatterTargets())) {
            i++;
            for (String fieldName : pageDefine.getSubjectMatterTargets()) {
                if (!notShowWords.contains(fieldName)) {
                    showFieldService.addShowFieldByFullName(fieldName, rootField, needShowFields);
                }
            }
        }
        //4、执行标的物  subjectMatter
        if (CollectionUtils.isNotEmpty(pageDefine.getSubjectMatter())) {
            i++;
            for (String fieldName : pageDefine.getSubjectMatter()) {
                if (!notShowWords.contains(fieldName)) {
                    showFieldService.addShowFieldByFullName(fieldName, rootField, needShowFields);
                }
            }
        }

        //5、执行标物的属性
        if (CollectionUtils.isNotEmpty(pageDefine.getSubjectMatterProperties())) {
            i++;
            for (String fieldName : pageDefine.getSubjectMatterProperties()) {
                if (!notShowWords.contains(fieldName)) {
                    showFieldService.addShowFieldByFullName(fieldName, rootField, needShowFields);
                }
            }
        }

        //6、执行者关注
        if (CollectionUtils.isNotEmpty(pageDefine.getRoleAttention())) {
            i++;
            for (String fieldName : pageDefine.getRoleAttention()) {
                if (!notShowWords.contains(fieldName)) {
                    showFieldService.addShowFieldByFullName(fieldName, rootField, needShowFields);
                }
            }
        }

        //7、执行期望
        if (CollectionUtils.isNotEmpty(pageDefine.getSubjectExpect())) {
            i++;
            for (String fieldName : pageDefine.getSubjectExpect()) {
                if (!notShowWords.contains(fieldName)) {
                    showFieldService.addShowFieldByFullName(fieldName, rootField, needShowFields);
                }
            }
        }

        //8、可编辑、执行内容
        //9、执行落差量化结果
        if (CollectionUtils.isNotEmpty(pageDefine.getSubjectShortfall())) {
            i++;
            for (String fieldName : pageDefine.getSubjectShortfall()) {
                if (!notShowWords.contains(fieldName)) {
                    showFieldService.addShowFieldByFullName(fieldName, rootField, needShowFields);
                }
            }
        }

        //用于兼容，没有配置标准属性页面
        if (i == 0) {
            //减少调用KG的API，从里层开始
            List<PcUiBotMetadataField> newShowFields = new ArrayList<>();
            if (CollectionUtils.isNotEmpty(rootField.getSubFields())) {

                for (PcUiBotMetadataField responseField : rootField.getSubFields()) {
                    //直接处理第二层，默认第一层是root
                    if (!notShowWords.contains(responseField.getName())) {
                        List<PcUiBotMetadataField> needShowSubFields = tagDisplayRangeService.getShowTagFields(executeContext, responseField, queryResultSet, pageDefine);
                        if (needShowSubFields.size() > 0) {
                            newShowFields.addAll(needShowSubFields);
                        }
                    }
                }
                //兼容多层结构子单身不打tag时
                if (PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(rootField.getDataType()) && newShowFields.size() == 0
                        && CollectionUtils.isNotEmpty(rootField.getTagDefinitions())) {
                    newShowFields.addAll(rootField.getSubFields());
                }
            }
            return newShowFields;


        } else {
            //通过pattern和词库中没有获取到的客制tag定义
            customizeTagSetByActivityConfigsService.getCustomizeTagFieldNotExist(pageDefine, needShowFields, rootField);
            if (executeContext.getTaskType() != null && executeContext.getTaskType() == 89) {
                String[] abnormalFieldArr = {"data_uniformity_optType", "data_uniformity_lastModifyTime", "data_uniformity_dealType"};
                for (String abnormalField : abnormalFieldArr) {
                    if (!needShowFields.containsKey(rootField.getName() + "." + abnormalField)) {
                        needShowFields.put(rootField.getName() + "." + abnormalField, fieldMap.get(abnormalField));
                    }
                }
            }
        }
        if (CollectionUtils.isNotEmpty(pageDefine.getShowMetadatas())) {
            return new ArrayList(needShowFields.values());
        }
        //重新整理Object字段
        List<PcUiBotMetadataField> needShowFields_ok = showFieldService.refreshObjectField(executeContext, needShowFields, rootField, queryResultSet, pageDefine);
        return needShowFields_ok;
    }
}
