package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.builder;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.common.BackgroundColorEnum;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.layout.singlelistcontainer.SingleListContainer;
import com.digiwin.mobile.mobileuibot.designer.uibot.enums.SourceCategoryEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.button.UiBotQueryButton;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * <p>功能描述：工作台作业页面构建器</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: WorkbenchPageBuilder.java
 * @Author: wangjwc
 * @Date: created at 2024/8/26 20:38
 */
@Service
public class WorkbenchPageBuilder extends DslPageBuilderBase<PcUiBotPageDefine> {
    /**
     * 返回支持的类型
     */
    @Override
    public String supportKey() {
        return "workbenchPageBuilder";
    }

    @Override
    public UiBotModel createPage(PcUiBotExecuteContext executeContext, QueryResultSet queryResultSet, PcUiBotPageDefine pageDefine, ApiRequest apiRequest) {
        UiBotModel uiBotModel = this.createRawPage(executeContext, queryResultSet, pageDefine, apiRequest);
        if (ObjectUtils.isEmpty(uiBotModel.getRenderData())) {
            uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
        }
        // 页面内容
        this.bulidRanderData(apiRequest, executeContext, uiBotModel, pageDefine, null);
        // 原始数据
        uiBotModel.setRawUiBotPageData(JsonUtil.objectToJavaObject(uiBotModel.getPageData(), UiBotPageData.class));
        uiBotModel.getLayout().clear();
        uiBotModel.getPageData().clear();
        uiBotModel.getActions().clear();
        uiBotModel.setPageDataIndex(null);
        uiBotModel.setPageDataKeys(null);
        uiBotModel.initMobileLayoutType();
        uiBotModel.setExecuteContext(JsonUtil.objectToJavaObject(executeContext, UiBotExecuteContext.class));
        uiBotModel.setPageBackgroudColor(StringUtils.hasLength(uiBotModel.getPageBackgroudColor())
                ?
                uiBotModel.getPageBackgroudColor()
                :
                BackgroundColorEnum.APP_MAIN_GREY.getValue());
        return uiBotModel;
    }

    private void bulidRanderData(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, UiBotModel uiBotModel, PcUiBotPageDefine pageDefine, String componentType) {
        ComponentContext cmptContext = JsonUtil.objectToJavaObject(apiRequest, ComponentContext.class);
        cmptContext.setPageDefine(pageDefine);
        MobilePageRawData mobilePageRawData = new MobilePageRawData();
        mobilePageRawData.setSourceCategory(SourceCategoryEnum.WORKBENCH.name());

        UiBotQueryButton queryButton = JsonUtil.objectToJavaObject(pageDefine, UiBotQueryButton.class);

        // 高级属性--构建主页面hooks与上下文中组件级hooks
        uiBotDesignerRenderService.buildMainPageHooksByPageDefine(pageDefine, cmptContext, uiBotModel, componentType);

        // 不显示tabs组件
        List<BaseMobileComponentWrapper<BaseMobileComponent>> bodyCmptList =
                businessProcessPerformer.buildBodyCmpt(executeContext, uiBotModel, cmptContext, queryButton, mobilePageRawData, componentType);
        if (CollectionUtils.isEmpty(bodyCmptList)) {
            // 添加空组件
            uiBotModel.getRenderData().addEmptyComponentToBody();
        } else {
            int bodyContainerType = UiBotDesignerRenderService.getBodyContainerType(bodyCmptList);
            if (bodyContainerType == 1) {
                SingleListContainer<BaseMobileComponent> singleListContainer = new SingleListContainer<>();
                singleListContainer.addAll(bodyCmptList);
                uiBotModel.getRenderData().addWrapperedComponentToBody(
                        new BaseMobileComponentWrapper<>(singleListContainer, "DW_" + singleListContainer.returnComponentType()));
            } else {
                uiBotModel.getRenderData().addWrapperedComponentListToBody(bodyCmptList);
            }

            // 构建bottom
            List<BaseMobileComponentWrapper<BaseMobileComponent>> bottomCmptList =
                    businessProcessPerformer.buildBottomCmpt(executeContext, uiBotModel, cmptContext, queryButton, mobilePageRawData, componentType);
            if (!CollectionUtils.isEmpty(bottomCmptList)) {
                uiBotModel.getRenderData().addWrapperedComponentListToBottom(bottomCmptList);
            }
        }
    }


    @Override
    public QueryResultSet BuildDataSource(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine) {
        return super.BuildDataSource(executeContext, pageDefine);
    }
}
