package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.impl;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.BaseDataPageService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer.BaseDataDoubleDocumentPageDefineAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer.BaseDataPageDefineAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.builder.BaseDataDesignerDocumentPageBuilder;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.builder.BaseDataDoubleDocumentPageBuilder;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.builder.DslLayoutPageBuilder;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：基础资料录入页面 生成服务</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: BaseDataPageServiceImpl.java
 * @Author: wangjwc
 * @Date: created at 2023/11/16 13:05
 */
@Service
public class BaseDataPageServiceImpl implements BaseDataPageService, InitializingBean {

    private static final String EDIT_TYPE_ADD = PcUiBotConstants.BaseDataEditType.ADD;

    @Autowired
    BaseDataDoubleDocumentPageBuilder baseDataDoubleDocumentPageBuilder;

    @Autowired
    BaseDataDesignerDocumentPageBuilder baseDataDesignerDocumentPageBuilder;

    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;

    @Autowired
    DslLayoutPageBuilder dslLayoutPageBuilder;

//    @Autowired
//    UibotLayoutPageBuilder uibotLayoutPageBuilder;

//    @Autowired
//    private BasicDataSingleDocumentPageBuilder basicDataSingleDocumentPageBuilder;

    @Autowired
    private BaseDataPageDefineAnalyzer baseDataPageDefineAnalyzer;

    @Autowired
    private BaseDataDoubleDocumentPageDefineAnalyzer baseDataDoubleDocumentPageDefineAnalyzer;

//    @Autowired
//    private BaseDataTreeDocumentPageDefineAnalyzer baseDataTreeDocumentPageDefineAnalyzer;

//    @Autowired
//    private List<AbstractBasicDataGeneralPageTemplate> allTemplateService;

//    @Autowired
//    private GeneralPageService generalPageService;

//    @Autowired
//    private BasicDataTreeDataDocmentGeneralPageTemplate basicDataTreeDataDocmentGeneralPageTemplate;

//    @Autowired
//    private DesignerTreeDataPageTemplate designerTreeDataPageTemplate;

//    @Autowired
//    private DataQueryService dataQueryService;

//    private final Map<String, AbstractBasicDataGeneralPageTemplate> templateServiceRegister = new HashMap<>();

    @Override
    public void afterPropertiesSet() throws Exception {
//        if (CollectionUtils.isNotEmpty(allTemplateService)) {
//            for (AbstractBasicDataGeneralPageTemplate basicDataTemplateService : allTemplateService) {
//                String supportKey = basicDataTemplateService.supportKey();
//                if (StringUtils.isEmpty(supportKey)) {
//                    continue;
//                }
//                if (templateServiceRegister.containsKey(supportKey)) {
//                    throw new IllegalStateException("存在重复的模板，请重修改代码：" + supportKey);
//                }
//                templateServiceRegister.put(supportKey, basicDataTemplateService);
//            }
//        }
    }

    /**
     * 创建双档页面-浏览页面
     *
     * @param executeContext
     * @return
     */
    @Override
    public UiBotModel creatDoubleBrowsePageBasicDataTaskTemplateForm(PcUiBotExecuteContext executeContext, ApiRequest apiRequest) {
        List<PcUiBotDoubleDocumentPageDefine> pageDefineList = baseDataDoubleDocumentPageDefineAnalyzer.analysis(executeContext);
        if (CollectionUtils.isEmpty(pageDefineList)) {
            return UiBotModel.emptyUiBotModel();
        }
        PcUiBotDoubleDocumentPageDefine doubleDocumentPageDefine = pageDefineList.get(0);
        PcUiBotExecuteContext executeContextInner = doubleDocumentPageDefine.getExecuteContext();
        QueryResultSet queryResultSet = baseDataDoubleDocumentPageBuilder.BuildDataSource(executeContextInner, doubleDocumentPageDefine);
        if (!CollectionUtils.isEmpty(doubleDocumentPageDefine.getPageLayout())) {
            executeContext.setCategory(PcUiBotActivityConstants.CATEGORY_DOUBLE_DOC);
            executeContextInner.setCategory(PcUiBotActivityConstants.CATEGORY_DOUBLE_DOC);
            return baseDataDesignerDocumentPageBuilder.createPage(executeContextInner, queryResultSet, doubleDocumentPageDefine, apiRequest);
        }
//            return baseDataDoubleDocumentPageBuilder.createPage(pageDefineList.get(0).getExecuteContext(), queryResultSet, pageDefineList.get(0));
        return UiBotModel.emptyUiBotModel();
    }

//    /**
//     * 创建双档页面-编辑页面
//     *
//     * @param executeContext
//     * @return
//     */
//    @Deprecated
//    @Override
//    public DynamicForm creatDoubleEditPageBasicDataTaskTemplateForm(ExecuteContext executeContext, DoubleDocumentPageDefine pageDefine) {
//        DynamicForm dynamicForm = new DynamicForm();
//        List<DoubleDocumentPageDefine> pageDefineList = baseDataDoubleDocumentPageDefineAnalyzer.analysis(executeContext);
//        if (CollectionUtils.isNotEmpty(pageDefineList)) {
//
//            // 往每行数据中塞入 标识行数据编辑状态的edit_type字段
//            DoubleDocumentPageDefine actionPageDefine = pageDefineList.get(0);
//
//            if (pageDefine.getParameter() == null) {
//                actionPageDefine.setEditType(EDIT_TYPE_ADD);
//            } else {
//                actionPageDefine.setEditType(pageDefine.getEditType());
//            }
//            actionPageDefine.setParameter(pageDefine.getParameter());
//            QueryResultSet queryResultSet = QueryResultSet.empty();
//            if (EDIT_TYPE_ADD.equals(actionPageDefine.getEditType())) {
//                queryResultSet.getMainQueryResult().setDataSourceName(actionPageDefine.getDataSourceName());
//            } else {
//                queryResultSet = getQueryResultSet(actionPageDefine);
//            }
//            //低代码设计器DSL rebuild
//            if (CollectionUtils.isNotEmpty(actionPageDefine.getLayout())) {
//                executeContext.setCategory(ActivityConstants.CATEGORY_DOUBLE_DOC);
//                pageDefineList.get(0).getExecuteContext().setCategory(ActivityConstants.CATEGORY_DOUBLE_DOC);
//                dynamicForm = baseDataDesignerDocumentPageBuilder.createPage(pageDefineList.get(0).getExecuteContext(),
//                        queryResultSet, pageDefineList.get(0));
//            } else {
//                dynamicForm = baseDataDoubleDocumentPageBuilder.createPage(actionPageDefine.getExecuteContext(),
//                        queryResultSet, actionPageDefine);
//            }
//        }
//        return dynamicForm;
//    }

    @Override
    public UiBotModel creatDoubleEditPage(PcUiBotExecuteContext executeContext, PcUiBotDoubleDocumentPageDefine pageDefine, ApiRequest apiRequest) {
        List<PcUiBotDoubleDocumentPageDefine> pageDefineList = baseDataDoubleDocumentPageDefineAnalyzer.analysis(executeContext);
        if (CollectionUtils.isEmpty(pageDefineList)) {
            return UiBotModel.emptyUiBotModel();
        }
        PcUiBotDoubleDocumentPageDefine actionPageDefine = pageDefineList.get(0);
        QueryResultSet queryResultSet = getQueryResultSet(pageDefine, actionPageDefine);
        if (!CollectionUtils.isEmpty(actionPageDefine.getPageLayout())) {
            executeContext.setCategory(PcUiBotActivityConstants.CATEGORY_DOUBLE_DOC);
            actionPageDefine.getExecuteContext().setCategory(PcUiBotActivityConstants.CATEGORY_DOUBLE_DOC);
            // 浏览页面传递过来的状态管理属性
            actionPageDefine.setExtendedFields((Map<String, Object>) apiRequest.getRawData().get("baseEntryExtendedFields"));
            return dslLayoutPageBuilder.createDynamicLayout(executeContext, actionPageDefine, queryResultSet, apiRequest);
        } else {
//            DynamicForm dynamicForm = baseDataDoubleDocumentPageBuilder.createPage(actionPageDefine.getExecuteContext(),
//                    queryResultSet, actionPageDefine);
//            return uibotLayoutPageBuilder.convertFromDynamicForm(dynamicForm);
        }
        return UiBotModel.emptyUiBotModel();
    }

    private QueryResultSet getQueryResultSet(PcUiBotDoubleDocumentPageDefine pageDefineInput,
                                             PcUiBotDoubleDocumentPageDefine pageDefineInner) {
        // wjw FIXME: 2023/11/30 新增编辑都掉接口获取
//        if (pageDefineInput.getParameter() == null) {
//            pageDefineInner.setEditType(EDIT_TYPE_ADD);
//        } else {
        pageDefineInner.setEditType(pageDefineInput.getEditType());
//        }
        pageDefineInner.setParameter(pageDefineInput.getParameter());
        QueryResultSet queryResultSet = QueryResultSet.empty();
//        if (EDIT_TYPE_ADD.equals(pageDefineInner.getEditType())) {
//            queryResultSet.getMainQueryResult().setDataSourceName(pageDefineInner.getDataSourceName());
//        } else {
        queryResultSet = getQueryResultSet(pageDefineInner);
//        }
        return queryResultSet;
    }

    private QueryResultSet getQueryResultSet(PcUiBotDoubleDocumentPageDefine pageDefine) {
        //拼接入參  暫時只支持一個數據源接口
        // parameterSetService.getParameters(pageDefine);

        QueryResultSet queryResultSet = this.queryByPagedefineWithMetaData(pageDefine.getExecuteContext(), pageDefine);
        if (!CollectionUtils.isEmpty(queryResultSet.getPageData())) {
            //编辑打开时，对于主数据，只可能存在一条主表数据
            //queryResultSet.getQueryResults().get(0).setSingle(true);
            //queryResultSet.getMainQueryResult().setSingle(true);
            appendFieldForRowData(queryResultSet.getPageData());
        }
        return queryResultSet;
    }

    private QueryResultSet queryByPagedefineWithMetaData(PcUiBotExecuteContext executeContext, PcUiBotDoubleDocumentPageDefine pageDefine) {
        if (pageDefine.getDataSourceSet() == null) {
            return QueryResultSet.empty();
        }
        Map<String, Object> body = new HashMap<>();
        body.put("dataSourceSetDTO", pageDefine.getDataSourceSet());
        body.put("executeContext", executeContext);
        body.put("parameter", pageDefine.getParameter());
        body.put("settings", pageDefine.getSettings());
        if (pageDefine.getPageInfo() != null) {
            body.put("pageInfo", pageDefine.getPageInfo());
        }
        if (pageDefine.getSortInfo() != null && !pageDefine.getSortInfo().isEmpty()) {
            body.put("sortInfo", pageDefine.getSortInfo());
        }
        if (pageDefine.getSearchInfo() != null && !pageDefine.getSearchInfo().isEmpty()) {
            body.put("searchInfo", pageDefine.getSearchInfo());
        }
        return digiwinAtdmProxyService.queryWithMetaData(executeContext.getLocale(),
                executeContext.getAuthoredUser().getToken(),
                JsonUtil.javaObjectToJsonString(body),
                executeContext.getAuthoredUser().getTenantId());
    }

    private void appendFieldForRowData(Map<String, Object> pageData) {
        for (Object data : pageData.values()) {
            if (data instanceof List) {
                List rowDataList = (List) data;
                for (Object rowData : rowDataList) {
                    Map rowDataMap = (Map) rowData;
                    rowDataMap.putAll(PcUiBotActivityConstants.EDIT_TYPE_MAP);
                }
            } else if (data instanceof Map) {
                Map rowDataMap = (Map) data;
                rowDataMap.putAll(PcUiBotActivityConstants.EDIT_TYPE_MAP);
            }
        }

    }

    @Override
    public UiBotModel createBasicDataTaskTemplateForm(PcUiBotExecuteContext executeContext, ApiRequest apiRequest) {
        List<PcUiBotPageDefine> pageDefineList = baseDataPageDefineAnalyzer.analysis(executeContext);

        if (CollectionUtils.isEmpty(pageDefineList)) {
            return UiBotModel.emptyUiBotModel();
        }
//        if (executeContext.getPattern() != null
//                && PcUiBotActivityConstants.PATTERN_CUSTOM.equals(executeContext.getPattern())) {
//            PcUiBotTaskPageDefine taskPageDefine = new PcUiBotTaskPageDefine();
//            taskPageDefine.setExecuteContext(executeContext);
//            taskPageDefine.setDefaultShow(false);
//            taskPageDefine.setParameter(pageDefineList.get(0).getParameter());
//            taskPageDefine.setSubmitType(pageDefineList.get(0).getSubmitType());
//            taskPageDefine.setDataSourceSet(pageDefineList.get(0).getDataSourceSet());
//            return generalPageService.createPage(executeContext, taskPageDefine);
//        } else {
        //低代码设计器DSL rebuild
        //if (ActivityConstants.CATEGORY_DESIGNER_SIGN_DOCUMENT_DOC.equals(executeContext.getCategory())) {
        if (!CollectionUtils.isEmpty(pageDefineList.get(0).getPageLayout())) {
            QueryResultSet queryResultSet = baseDataDesignerDocumentPageBuilder.BuildDataSource(pageDefineList.get(0).getExecuteContext(), pageDefineList.get(0));
            UiBotModel dynamicForm = baseDataDesignerDocumentPageBuilder.createPage(pageDefineList.get(0).getExecuteContext(), queryResultSet, pageDefineList.get(0), apiRequest);
            return dynamicForm;
        }
//            QueryResultSet queryResultSet = basicDataSingleDocumentPageBuilder.BuildDataSource(pageDefineList.get(0).getExecuteContext(), pageDefineList.get(0));
//            return basicDataSingleDocumentPageBuilder.createPage(executeContext, queryResultSet, pageDefineList.get(0));
//        }
        return UiBotModel.emptyUiBotModel();
    }

//    /**
//     * {@inheritDoc}
//     */
//    @Override
//    public DynamicForm createRecycleBasicDataTaskTemplateForm(ExecuteContext executeContext) {
//        List<PageDefine> pageDefineList = baseDataPageDefineAnalyzer.analysis(executeContext);
//        if (CollectionUtils.isNotEmpty(pageDefineList)) {
//            boolean isDoubleDocument = ActivityConstants.CATEGORYS.contains(pageDefineList.get(0).getExecuteContext().getCategory());
//            // 兼容双档browser-page
//            if (isDoubleDocument) {
//                executeContext.setPageCode(ActivityConstants.BROWSE_PAGE);
//                pageDefineList = baseDataPageDefineAnalyzer.analysis(executeContext);
//            }
//
//            if (CollectionUtils.isEmpty(pageDefineList)) {
//                return new DynamicForm();
//            }
//            if (CollectionUtils.isNotEmpty(pageDefineList.get(0).getLayout())) {
//                executeContext.setCategory(UiBotConstants.ACTION_CATEGORY_RECYCLE);
//                if (pageDefineList.get(0).getExecuteContext() != null) {
//                    pageDefineList.get(0).getExecuteContext().setCategory(UiBotConstants.ACTION_CATEGORY_RECYCLE);
//                }
//                pageDefineList.get(0).setOperations(new ArrayList<>());
//                QueryResultSet queryResultSet = baseDataDesignerDocumentPageBuilder.BuildDataSource(pageDefineList.get(0).getExecuteContext(), pageDefineList.get(0));
//                DynamicForm dynamicForm = baseDataDesignerDocumentPageBuilder.createPage(pageDefineList.get(0).getExecuteContext(), queryResultSet, pageDefineList.get(0));
//                return dynamicForm;
//            }
//
//            GeneralPageTemplate generalPageTemplate = findTemplateService(executeContext);
//            if (null != generalPageTemplate) {
//                return generalPageTemplate.createTaskPage(executeContext, pageDefineList.get(0), null);
//            }
//            return new DynamicForm();
//
//        } else {
//            return new DynamicForm();
//        }
//    }

//    private GeneralPageTemplate findTemplateService(ExecuteContext executeContext) {
//        if (BooleanUtils.isTrue(executeContext.getIsRecycle())) {
//            String templateName = StringUtils.lowerCase(executeContext.getClientAgent() + "-" + executeContext.getPattern() + "-" + "recycle");
//            if (templateServiceRegister.containsKey(templateName)) {
//                return templateServiceRegister.get(templateName);
//            }
//        }
//
//        String templateName = StringUtils.lowerCase(executeContext.getClientAgent() + "-" + executeContext.getPattern() + "-" + executeContext.getCategory() + "-" + executeContext.getRelationTag().getIdentity());
//        if (templateServiceRegister.containsKey(templateName)) {
//            return templateServiceRegister.get(templateName);
//        }
//
//        templateName = StringUtils.lowerCase(executeContext.getClientAgent() + "-" + executeContext.getPattern());
//        if (templateServiceRegister.containsKey(templateName)) {
//            return templateServiceRegister.get(templateName);
//        }
//        return null;
//    }


//    /**
//     * {@inheritDoc}
//     */
//    @Override
//    public Object getToolsShow(ExecuteContext executeContext) {
//        List<String> pageCodes = new ArrayList();
//        pageCodes.add(ActivityConstants.BASIC_DATA);
//        pageCodes.add(ActivityConstants.BROWSE_PAGE);
//
//        List<PageDefine> pageDefineList = new ArrayList<>();
//        pageCodes.forEach(pagecode -> {
//            executeContext.setPageCode(pagecode);
//            pageDefineList.addAll(baseDataPageDefineAnalyzer.analysis(executeContext));
//        });
//        List<OperationDTO> operations = new ArrayList<>();
//        Map operationsMap = new HashMap();
//        operationsMap.put("operations", operations);
//        if (CollectionUtils.isEmpty(pageDefineList)) {
//            return operationsMap;
//        }
//        for (PageDefine pageDefine : pageDefineList) {
//            if (CollectionUtils.isEmpty(pageDefine.getOperations())) {
//                continue;
//            }
//            pageDefine.getOperations().stream()
//                    .filter(operation -> BooleanUtils.isTrue(operation.getEnableToolShow()))
//                    .forEach(operation -> operations.add(operation));
//        }
//        return operationsMap;
//    }


//    /**
//     * 创建双档树页面-浏览页面
//     *
//     * @param executeContext
//     * @return
//     */
//    @Override
//    public DynamicLayout creatTreeDataBrowsePageBasicDataTaskTemplateForm(ExecuteContext executeContext) {
//        List<DoubleDocumentPageDefine> pageDefineList = baseDataTreeDocumentPageDefineAnalyzer.analysis(executeContext);
//        if (CollectionUtils.isNotEmpty(pageDefineList)) {
//            DoubleDocumentPageDefine firstPageDefine = pageDefineList.get(0);
//            if (firstPageDefine.isDslLayout()) {
//                return designerTreeDataPageTemplate.createDynamicLayout(executeContext, firstPageDefine);
//            } else {
//                List<DynamicLayout> mainLayout = this.createTreePage(executeContext, firstPageDefine);
//                return designerTreeDataPageTemplate.convertOldToNew(executeContext, mainLayout);
//            }
//        }
//        return null;
//    }

//    private List<DynamicLayout> createTreePage(ExecuteContext executeContext, PageDefine mainAction) {
//        List<DynamicLayout> dynamicLayouts = basicDataTreeDataDocmentGeneralPageTemplate.createTreePage(executeContext, mainAction);
//        DynamicLayout rightLayout = new DynamicLayout();
//        rightLayout.setPosition("right");
//        if (mainAction.getDataSourceSet() != null
//                && CollectionUtils.isNotEmpty(mainAction.getDataSourceSet().getDataSourceList())
//                && mainAction.getDataSourceSet().getDataSourceList().size() > 0) {
//            rightLayout.setTitle(mainAction.getDataSourceSet().getDataSourceList().get(0).getTitle());
//        }
//        rightLayout.setEnableShow(true);
//        if ("TestTreeData".equals(executeContext.getTmActivityId())) {
//            executeContext.setCategory(ActivityConstants.CATEGORY_TREEDATA_SINGLE_DOC);
//        }
//        ExecuteContext newExecuteContext = executeContext.clone();
//        if (ActivityConstants.CATEGORY_TREEDATA_DOUBLE_DOC.equals(executeContext.getCategory())) {
//            //第三个双档界面，根据pagecode --page信息，组装右边动态组件
//            newExecuteContext.setCategory(ActivityConstants.CATEGORY_DOUBLE_DOC);
//            if (mainAction instanceof DoubleDocumentPageDefine) {
//                DoubleDocumentPageDefine documentPageDefine = (DoubleDocumentPageDefine) mainAction;
//                QueryResultSet queryResultSet = baseDataDoubleDocumentPageBuilder.BuildDataSource(newExecuteContext, documentPageDefine);
//                DynamicForm dynamicForm = baseDataDoubleDocumentPageBuilder.createPage(newExecuteContext, queryResultSet, documentPageDefine);
//                rightLayout.setDynamicForm(dynamicForm);
//            }
//        } else if (ActivityConstants.CATEGORY_TREEDATA_SINGLE_DOC.equals(executeContext.getCategory())) {
//            //第三个单档或客制，根据pagecode --page信息，组装右边动态组件
//            if (executeContext.getPattern() != null
//                    && ActivityConstants.PATTERN_CUSTOM.equals(executeContext.getPattern())) {
//                TaskPageDefine taskPageDefine = new TaskPageDefine();
//                taskPageDefine.setExecuteContext(executeContext);
//                taskPageDefine.setDefaultShow(false);
//                taskPageDefine.setParameter(mainAction.getParameter());
//                taskPageDefine.setSubmitType(mainAction.getSubmitType());
//                taskPageDefine.setDataSourceSet(mainAction.getDataSourceSet());
//                rightLayout.setDynamicForm(generalPageService.createOpenPage(executeContext, taskPageDefine));
//            } else {
//                newExecuteContext.setCategory(ActivityConstants.CATEGORY_SINGLE_DOC);
//                QueryResultSet queryResultSet = basicDataSingleDocumentPageBuilder.BuildDataSource(newExecuteContext, mainAction);
//                DynamicForm dynamicForm = basicDataSingleDocumentPageBuilder.createPage(newExecuteContext, queryResultSet, mainAction);
//                if (CollectionUtils.isNotEmpty(dynamicForm.getLayout())) {
//                    List layout = dynamicForm.getLayout().stream()
//                            .filter(subLayout -> subLayout instanceof FormComponent).collect(Collectors.toList());
//                    if (CollectionUtils.isNotEmpty(layout)) {
//                        rightLayout.setAllBatch(true);
//                    }
//                }
//                rightLayout.setDynamicForm(dynamicForm);
//            }
//        } else {
//            rightLayout.setDynamicForm(new DynamicForm());
//        }
//        dynamicLayouts.add(rightLayout);
//        return dynamicLayouts;
//    }
}