package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.impl;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.ConditionPageService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer.ConditionPageAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template.ConditionPageTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;

/**
 * <p>功能描述：查询条件页面服务实现类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ConditionPageServiceImpl.java
 * @Author: wangjwc
 * @Date: created at 2024/9/24 13:08
 */
@Service
public class ConditionPageServiceImpl implements ConditionPageService {

    @Autowired
    private ConditionPageAnalyzer conditionPageAnalyzer;

    @Autowired
    private ConditionPageTemplate conditionPageTemplate;

//    @Resource
//    private DesignerConditionPageTemplate designerConditionPageTemplate;
//
//    @Autowired
//    private GeneralPageService generalPageService;

    /**
     * {@inheritDoc}
     */
    @Override
    public UiBotModel createConditionTemplateForm(ApiRequest apiRequest, PcUiBotExecuteContext executeContext) {
        PcUiBotPageDefine pageDefine = conditionPageAnalyzer.analysis(executeContext);
        if (pageDefine == null) {
            return UiBotModel.emptyUiBotModel();
        }
//        //对于报表来说，如果是指定的catagory，则代表返回的是客制的组件
//        if (PcUiBotActivityConstants.CUSTOM_STATEMENT.equals(executeContext.getCategory())) {
//            // 将pattern设置为CUSTOM，将返回客制组件
//            executeContext.setPattern(PcUiBotActivityConstants.PATTERN_CUSTOM);
//            TaskPageDefine taskPageDefine = new TaskPageDefine();
//            taskPageDefine.setExecuteContext(pageDefine.getExecuteContext());
//            taskPageDefine.setDefaultShow(false);
//            taskPageDefine.setParameter(pageDefine.getParameter());
//            taskPageDefine.setSubmitType(pageDefine.getSubmitType());
//            return generalPageService.createPage(executeContext, taskPageDefine);
//        }
//        if (!CollectionUtils.isEmpty(pageDefine.getPageLayout())) {
//            return designerConditionPageTemplate.createTaskPage(executeContext, pageDefine, Collections.singletonList(pageDefine));
//        }
        return conditionPageTemplate.createTaskPage(apiRequest, executeContext, pageDefine, Collections.singletonList(pageDefine));
    }
}
