package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldLabelStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldValueStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.*;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardOpenDetailTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.input.switchcomponent.InputSwitch;
import com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist.ZtbViewList;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.enums.BusinessTypeEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotPageLayout;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>功能描述：数据视图 原始DSL 渲染 服务</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DataViewRawDslRenderService.java
 * @Author: wangjwc
 * @Date: created at 2023/12/27 10:22
 */
@Slf4j
@Service
public class DataViewRawDslRenderService {

    @Autowired
    private LocaleService localeService;

    public List<UiBotPageLayout> bulidPageLayout(PcUiBotExecuteContext executeContext, PcUiBotDoubleDocumentPageDefine pageDefine, PcUiBotTmViewShowFieldsMobile viewShowFields) {
        UiBotPageLayout uiBotPageLayout = new UiBotPageLayout();
        uiBotPageLayout.setPageBackgroudColor(null);
        uiBotPageLayout.setShowMore(false);
        uiBotPageLayout.setTitle(localeService.getLanguageValue(executeContext.getLocale(), "数据录入-模型驱动"));
        uiBotPageLayout.setTitleVisible(false);
        uiBotPageLayout.setPageId("page1");
        uiBotPageLayout.setSchema("a1h8t2ko0a");
        uiBotPageLayout.setComponentType("set-up-page");
        uiBotPageLayout.setHeader(new ArrayList<>());
        // 原始layout 只构建视图下的组件，具体视图转tab组件在渲染运行态DSL时构建
        uiBotPageLayout.setBody(this.buildBody(executeContext, viewShowFields));
        uiBotPageLayout.setBottom(this.buildBottom(executeContext, pageDefine));
        return Lists.newArrayList(uiBotPageLayout);
    }

    public List<BaseMobileComponentWrapper<BaseMobileComponent>> buildBody(PcUiBotExecuteContext executeContext, PcUiBotTmViewShowFieldsMobile viewShowFields) {
        List<BaseMobileComponentWrapper<BaseMobileComponent>> bodyList = new ArrayList<>();
        if (CollectionUtils.isEmpty(viewShowFields.getField())) {
            return bodyList;
        }
        boolean isTable = PcUiBotConstants.DataType.OBJECT.equals(viewShowFields.getDataType()) && viewShowFields.isArray();
        if (isTable) {
            // 组装cardList组件
            List<PcUiBotTmViewShowFieldsMobile> arraySimpleFields = viewShowFields.getField()
                    .stream()
                    .filter(PcUiBotTmViewShowFieldsMobile::isSimpleField)
                    // cardList对隐藏字段过滤
                    .filter(PcUiBotTmViewShowFieldsMobile::isDisplay)
                    .collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(arraySimpleFields)) {
                bodyList.add(this.buildZtbViewList(executeContext.getLocale(), viewShowFields, arraySimpleFields));
            }
        } else {
            // 对象
            List<PcUiBotTmViewShowFieldsMobile> simpleFields = viewShowFields.getField()
                    .stream()
                    .filter(PcUiBotTmViewShowFieldsMobile::isSimpleField)
                    .collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(simpleFields)) {
                // 构建customGroup组件
                bodyList.add(this.buildCustomGroup(executeContext.getLocale(), viewShowFields, simpleFields));
            }
            List<PcUiBotTmViewShowFieldsMobile> arrayFields = viewShowFields.getField()
                    .stream()
                    .filter(PcUiBotTmViewShowFieldsMobile::isArray)
                    .collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(arrayFields)) {
                // 构建cardList组件
                for (PcUiBotTmViewShowFieldsMobile arrayField : arrayFields) {
                    List<PcUiBotTmViewShowFieldsMobile> arraySimpleFields = arrayField.getField()
                            .stream()
                            .filter(PcUiBotTmViewShowFieldsMobile::isSimpleField)
                            // cardList对隐藏字段过滤
                            .filter(PcUiBotTmViewShowFieldsMobile::isDisplay)
                            .collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(arraySimpleFields)) {
                        bodyList.add(this.buildZtbViewList(executeContext.getLocale(), arrayField, arraySimpleFields));
                    }
                }

            }
        }
        return bodyList;
    }

    private BaseMobileComponentWrapper<BaseMobileComponent> buildCustomGroup(String locale, PcUiBotTmViewShowFieldsMobile parentField, List<PcUiBotTmViewShowFieldsMobile> subFields) {
        CustomGroup customGroup = new CustomGroup();
        customGroup.setSchema(parentField.getDataName());
        customGroup.setName(parentField.getDescription());
        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_ZTB_SCAN_RECEIVE.getValue());
        customGroup.setContentGroup(this.buildCustomGroupContentGroup(locale, parentField, subFields));
        return new BaseMobileComponentWrapper<>(customGroup, "DW_" + CustomGroup.COMPONENT_TYPE, parentField.getDataName(), parentField.getFullName());
    }

    private List<BaseMobileComponentWrapper<BaseMobileComponent>> buildCustomGroupContentGroup(String locale, PcUiBotTmViewShowFieldsMobile parentField, List<PcUiBotTmViewShowFieldsMobile> subFields) {
        // wjw FIXME: 2023/12/27 视图作用于数据录入-浏览页面，因浏览页面只支持查看，故先不考虑映射对应具体组件
        List<BaseMobileComponentWrapper<BaseMobileComponent>> contentGroup = new ArrayList<>();
        for (PcUiBotTmViewShowFieldsMobile subField : subFields) {
//            if ("true".equals(subField.getIsDataKey())) {
//                // 主键隐藏
//                continue;
//            }

//            if (CollectionUtils.isNotEmpty(subField.getFieldDsl())) {
//                // 组件的结构
//            } else {
//                // 根据dataType，映射默认的组件结构
//            }

            String dataType = subField.getDataType();
            if (PcUiBotConstants.DataType.BOOLEAN.equalsIgnoreCase(dataType)) {
                InputSwitch inputSwitch = new InputSwitch();
                //将true给1，false给0
                inputSwitch.setState(0);
                inputSwitch.setTitle(subField.getDescription());
                inputSwitch.setEnable(false);
                contentGroup.add(new BaseMobileComponentWrapper<>(inputSwitch, "DW_" + InputSwitch.COMPONENT_TYPE, subField.getDataName(), subField.getFullName()));
            } else {
                if ("remark".equals(subField.getDataName())) {
                    // 多行文本
                    InputMultiText inputMultiText = new InputMultiText();
                    inputMultiText.setSchema(subField.getDataName());
                    inputMultiText.setTitle(subField.getDescription());
                    inputMultiText.setEnable(false);
                    inputMultiText.setShowShadow(false);
                    inputMultiText.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请输入"));
                    contentGroup.add(new BaseMobileComponentWrapper<>(inputMultiText, "DW_" + InputMultiText.COMPONENT_TYPE, subField.getDataName(), subField.getFullName()));
                } else {
                    Field field = new Field();
                    field.setLabel(subField.getDescription());
                    field.setEnable(false);
                    field.setLabelStyleType(FieldLabelStyleTypeEnum.LABEL_GREY.getValue());
                    field.setValueStyleType(FieldValueStyleTypeEnum.VALUE_BLACK.getValue());
                    contentGroup.add(new BaseMobileComponentWrapper<>(field, "DW_" + Field.COMPONENT_TYPE, subField.getDataName(), subField.getFullName()));
                }
            }
        }
        return contentGroup;
    }

    private BaseMobileComponentWrapper<BaseMobileComponent> buildZtbViewList(String locale, PcUiBotTmViewShowFieldsMobile parentField, List<PcUiBotTmViewShowFieldsMobile> subFields) {
        ZtbViewList ztbViewList = new ZtbViewList();
        ztbViewList.setSchema(UUIDUtil.getUuid());
        ztbViewList.setTitle(parentField.getDescription());
        ztbViewList.setTitleVisible(false);
        ztbViewList.setDetailPageSwiper(true);
        ztbViewList.setIsAllSubmitScene(false);
        ztbViewList.setIsCheckList(false);
        ztbViewList.setCardListData(this.buildCardListData(locale, parentField, subFields));
        return new BaseMobileComponentWrapper<>(ztbViewList, "DW_" + ZtbViewList.COMPONENT_TYPE, parentField.getDataName(), parentField.getFullName());
    }

    private Card buildCardListData(String locale, PcUiBotTmViewShowFieldsMobile parentField, List<PcUiBotTmViewShowFieldsMobile> subFields) {
        Card card = new Card();
        Card.DesignerRawCard designerRawCard = new Card.DesignerRawCard();
        card.setData(designerRawCard);

        designerRawCard.setNode(parentField.getDataName());
        designerRawCard.setNodePath(parentField.getFullName());

        List<Card.DesignerRawCard.Content> contentList = new ArrayList<>();
        designerRawCard.setContent(contentList);

        List<PcUiBotTmViewShowFieldsMobile> notEditFields = subFields;
        for (PcUiBotTmViewShowFieldsMobile notEditField : notEditFields) {
//            if ("true".equals(notEditField.getIsDataKey())) {
//                // 主键隐藏
//                continue;
//            }
            // 临时处理，eoc属性不展示在card上
            if (StringUtils.hasLength(notEditField.getDataName()) && notEditField.getDataName().contains("eoc_")) {
                continue;
            }
            if (notEditField.isTitle()) {
                // 主标题
                PcUiBotTmViewShowFieldsMobile.FieldDslMobile.TitleObj titleObj =
                        JsonUtil.objectToJavaObject(notEditField.getFieldDslMobile().getSetting(), PcUiBotTmViewShowFieldsMobile.FieldDslMobile.TitleObj.class);
                designerRawCard.setIsCustomTitle(false);
                if (titleObj == null) {
                    designerRawCard.setTitle(notEditField.getDataName());
                    designerRawCard.setTitlePath(notEditField.getFullName());
                } else {
                    if (BooleanUtils.isTrue(titleObj.getIsCustomTitle())) {
                        designerRawCard.setIsCustomTitle(true);
                        designerRawCard.setTitle(titleObj.getTitle());
                        designerRawCard.setTitlePath("");
                    } else {
                        designerRawCard.setTitle(notEditField.getDataName());
                        designerRawCard.setTitlePath(notEditField.getFullName());
                        designerRawCard.setTitleSetting(JsonUtil.objectToJavaObject(titleObj.getSetting(), Card.DesignerRawCard.Content.class));
                    }
                }
            } else if (notEditField.isSubTitle()) {
                // 子标题
                PcUiBotTmViewShowFieldsMobile.FieldDslMobile.TitleObj subTitleObj =
                        JsonUtil.objectToJavaObject(notEditField.getFieldDslMobile().getSetting(), PcUiBotTmViewShowFieldsMobile.FieldDslMobile.TitleObj.class);
                designerRawCard.setIsCustomSubTitle(false);
                if (subTitleObj == null) {
                    designerRawCard.setSubTitle(notEditField.getDataName());
                    designerRawCard.setSubTitlePath(notEditField.getFullName());
                } else {
                    if (BooleanUtils.isTrue(subTitleObj.getIsCustomTitle())) {
                        designerRawCard.setIsCustomSubTitle(true);
                        designerRawCard.setSubTitle(subTitleObj.getTitle());
                        designerRawCard.setSubTitlePath("");
                    } else {
                        designerRawCard.setSubTitle(notEditField.getDataName());
                        designerRawCard.setSubTitlePath(notEditField.getFullName());
                        designerRawCard.setSubTitleSetting(JsonUtil.objectToJavaObject(subTitleObj.getSetting(), Card.DesignerRawCard.Content.class));
                    }
                }
            } else {
                // 其它类型
                Card.DesignerRawCard.Content content = new Card.DesignerRawCard.Content();
                content.setSchema(notEditField.getDataName());
                content.setLabel(notEditField.getDescription());
                content.setData_type(notEditField.getDataType());
                content.setFullPath(notEditField.getFullName());
                content.setIs_array(notEditField.isArray() + "");
                PcUiBotTmViewShowFieldsMobile.FieldDslMobile fieldDslMobile = notEditField.getFieldDslMobile();
                if (fieldDslMobile != null) {
                    content.setType(fieldDslMobile.getType());
                    content.setSetting(fieldDslMobile.getSetting());
                }
                contentList.add(content);
            }
        }

        Card.DesignerRawCard.DetailPage detailPage = new Card.DesignerRawCard.DetailPage();
        designerRawCard.setDetailPage(detailPage);

        // 开启弹窗、开启滑动特效
        detailPage.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        detailPage.setDetailPageSwiper(true);
        detailPage.setPageId(PageSettingIdPresetEnum.MOBILE_BASIC_DATA_ENTRY_EDIT_PAGE.name());
        detailPage.setDesignExtendParameter(JsonUtil.jsonStringToObject("[{\"key\":\"DWCallWork\",\"value\":\"edit\"},{\"key\":\"DWIsRawData\",\"value\":\"false\"}]", List.class));

        // card按钮构建
        List<UiBotAction> buttonList = new ArrayList<>();
        // wjw TODO: 2024/1/4 浏览页面卡片先不设置按钮，看后续需求
        designerRawCard.setButtonList(null);

        UiBotAction uiBotAction = new UiBotAction();
        buttonList.add(uiBotAction);

        uiBotAction.setBtnId(parentField.getDataName());
        uiBotAction.setTitle(localeService.getLanguageValue(locale, "查看"));
        uiBotAction.setBtnType(ButtonTypeEnum.JUMP.getValue());
        UiBotJumpAction uiBotJumpAction = new UiBotJumpAction();
        uiBotAction.setJumpAction(uiBotJumpAction);

        uiBotJumpAction.setDetailPageSwiper(true);
        uiBotJumpAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_BASIC_DATA_BROWSE_DETAIL_VIEW_DRIVEN_PARSING_PAGE.name());
        uiBotJumpAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        uiBotJumpAction.setIsCheckButton(false);
        uiBotJumpAction.setBtnStyleType(BottomButtonStyleEnum.DETAIL_NORMAL.getValue());
        Map<String, Object> rawData = new HashMap<>();
        rawData.put("parentField", parentField);
        uiBotJumpAction.setRawData(rawData);
        uiBotJumpAction.setBusinessType(BusinessTypeEnum.OTHER.getValue());

        designerRawCard.setOpenDetailType(CardOpenDetailTypeEnum.BY_BUTTON_AND_CARD.getValue());

        return card;
    }

    private List<BaseMobileComponentWrapper<BaseMobileComponent>> buildBottom(PcUiBotExecuteContext executeContext, PcUiBotDoubleDocumentPageDefine pageDefine) {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.setContentGroup(this.buildButtonGroupContentGroup(executeContext, pageDefine));
        return Lists.newArrayList(new BaseMobileComponentWrapper<>(buttonGroup, "DW_" + ButtonGroup.COMPONENT_TYPE));
    }

    private List<BaseMobileComponentWrapper<BottomButtonDigiwinAthena>> buildButtonGroupContentGroup(PcUiBotExecuteContext executeContext, PcUiBotDoubleDocumentPageDefine pageDefine) {
        String locale = executeContext.getLocale();
        BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
        UiBotAction uiBotAction = new UiBotAction();
        button.setSubmitAction(uiBotAction);

        uiBotAction.setBtnId(UUIDUtil.getUuid());
        uiBotAction.setTitle(localeService.getLanguageValue(locale, "+ 新增"));
        uiBotAction.setBtnType(ButtonTypeEnum.JUMP.getValue());
        UiBotJumpAction uiBotJumpAction = new UiBotJumpAction();
        uiBotAction.setJumpAction(uiBotJumpAction);

        uiBotJumpAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        uiBotJumpAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_BASIC_DATA_ENTRY_EDIT_PAGE.name());
        uiBotJumpAction.setBtnStyleType(BottomButtonStyleEnum.STRESS.getValue());
        uiBotJumpAction.setIsCheckButton(false);
        uiBotJumpAction.setBusinessType(BusinessTypeEnum.OTHER.getValue());
        uiBotJumpAction.setDesignExtendParameter(JsonUtil.jsonStringToObject("[{\"key\":\"DWCallWork\",\"value\":\"add\"},{\"key\":\"DWIsRawData\",\"value\":\"false\"}]", List.class));

        return Lists.newArrayList(new BaseMobileComponentWrapper<>(button, "DW_" + Button.COMPONENT_TYPE));
    }

    /**
     * 将视图显示字段，转为元数据对象
     *
     * @param field 视图字段
     * @return 元数据字段
     */
    public static PcUiBotMetadataField convertToMetadataField(PcUiBotTmViewShowFields field) {
        return convertToMetadataField(null, field);
    }

    /**
     * 将视图显示字段，转为元数据对象
     *
     * @param path  字段路径
     * @param field 视图字段
     * @return 元数据字段
     */
    public static PcUiBotMetadataField convertToMetadataField(String path, PcUiBotTmViewShowFields field) {
        PcUiBotMetadataField metadataField = new PcUiBotMetadataField();
        metadataField.setPath(path);
        metadataField.setName(field.getDataName());
        metadataField.setDataType(field.getDataType());
        metadataField.setArray(field.isArray());
        metadataField.setEnumKey(field.getEnumKey());
        metadataField.setCanFilter(field.getCanFilter());
        metadataField.setCanSort(field.getCanSort());
        metadataField.setDataKey(field.getIsDataKey());
        metadataField.setDescription(field.getDescription());
        List<PcUiBotMetadataField> subFields = Lists.newArrayList();
        metadataField.setSubFields(subFields);
        if (CollectionUtils.isNotEmpty(field.getField())) {
            path = metadataField.getFullName();
            for (PcUiBotTmViewShowFields subField : field.getField()) {
                subFields.add(convertToMetadataField(path, subField));
            }
        }
        return metadataField;
    }

    /**
     * 修改视图配置的name和path
     *
     * @param name           单头名
     * @param viewShowFields 视图配置
     */
    public static PcUiBotTmViewShowFields resetNameAndDslPath(String name, PcUiBotTmViewShowFields viewShowFields) {
        if (StringUtils.isEmpty(name)) {
            return viewShowFields;
        }
        String jsonStr = JsonUtil.javaObjectToJsonString(viewShowFields);
        if (StringUtils.isEmpty(jsonStr)) {
            return viewShowFields;
        }
        String dataNameOri = viewShowFields.getDataName();
        // 替换path
        // "path":"1" -> "path":"2"
        jsonStr = jsonStr.replace(
                "\"path\":\"" + dataNameOri + "\"",
                "\"path\":\"" + name + "\"");
        // "path":"1. -> "path":"2.
        jsonStr = jsonStr.replace(
                "\"path\":\"" + dataNameOri + ".",
                "\"path\":\"" + name + ".");
        viewShowFields = JsonUtil.jsonStringToObject(jsonStr, PcUiBotTmViewShowFields.class);
        // 修改单头名称
        viewShowFields.setDataName(name);
        return viewShowFields;
    }
}
