package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerService;
import com.digiwin.mobile.mobileuibot.proxy.audc.service.DigiwinAudcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTaskPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.ProjectPageService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer.ProjectPageDefineAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template.DesignerProjectPageTemplate;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template.TemplateService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotSubmitActionUtil;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：项目页面服务实现类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ProjectPageServiceImpl.java
 * @Author: wangjwc
 * @Date: created at 2024/12/4 15:45
 */
@Slf4j
@Service
public class ProjectPageServiceImpl implements ProjectPageService, InitializingBean {

    @Autowired
    private List<TemplateService<PcUiBotTaskPageDefine>> templateList;

    private final Map<String, TemplateService<PcUiBotTaskPageDefine>> templateContainer = new HashMap<>();

    @Override
    public void afterPropertiesSet() throws Exception {
        if (templateList != null) {
            for (TemplateService<PcUiBotTaskPageDefine> template : templateList) {
                if (templateContainer.containsKey(template.supportKey())) {
                    throw new IllegalStateException("存在重复的模板，请重修改代码：" + template.supportKey());
                }
                templateContainer.put(template.supportKey(), template);
            }
        }
    }

    @Autowired
    private ProjectPageDefineAnalyzer projectPageDefineAnalyzer;

    @Autowired
    private DigiwinAudcProxyService digiwinAudcProxyService;

    /**
     * 根据已经定义好的页面来生成界面，主要是项目的第四层、任务的已完成、追踪中按钮的显示
     *
     * @return
     * @throws Exception
     */
    @Override
    public UiBotModel createPage(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, ApiRequest apiRequest) {
        appendUserOrderConditions(executeContext, pageDefine);
        // 针对项目详情分享的时候(撤回)提交按钮权限的进行判断
        if (UiBotDesignerService.PAGECODE_PROJECT_DETAIL.equals(executeContext.getPageCode())) {
            if (!CollectionUtils.isEmpty(pageDefine.getSubmitActions())) {
                // 是分享且不是当责者或者代理人
                if (executeContext.isShared() && !executeContext.isOwnerBacklog()) {
                    // 没有按钮权限，进行重置
                    pageDefine.setSubmitActions(new ArrayList<>());
                    //如果没有submit，需要去除 SubmitType
                    pageDefine.setSubmitType(null);
                }
            }
            //针对撤回，针对分批提交的情况
            if (pageDefine.getFinished() != null && !pageDefine.getFinished()
                    && "completed".equals(pageDefine.getDataStateCode())) {
                pageDefine.setSubmitActions(PcUiBotSubmitActionUtil.onlyKeepAction(pageDefine.getSubmitActions()));
            }
        } else {
            //针对撤回，针对分批提交的情况
            if (pageDefine.getFinished() != null && !pageDefine.getFinished()
                    && "completed".equals(pageDefine.getDataStateCode())) {
                pageDefine.setSubmitActions(PcUiBotSubmitActionUtil.onlyKeepWithdrawAction(pageDefine.getSubmitActions()));
            }
        }

        UiBotModel uiBotModel = null;
        TemplateService<PcUiBotTaskPageDefine> templateService = this.getTemplate(executeContext, pageDefine.getVersion(), pageDefine.getIsDesignerDsl());
        if (templateService != null) {
            uiBotModel = templateService.createPage(apiRequest, executeContext, pageDefine, Lists.newArrayList(pageDefine));
        }

        if (uiBotModel == null) {
            return UiBotModel.emptyUiBotModel();
        }

        return uiBotModel;
    }

    /**
     * 组装用户自定义数据排序条件，放到setting中
     */
    private void appendUserOrderConditions(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine) {
        try {
            //低代码平台暂时禁用用户自定义
            if (executeContext.getIsDesigner() != null && executeContext.getIsDesigner()) {
                return;
            }
            //开窗不设定
            if (executeContext.getOpenWindow() != null
                    && (executeContext.getOpenWindow() == null || executeContext.getOpenWindow())) {
                return;
            }
            if (pageDefine == null) {
                return;
            }
            String schema = pageDefine.getDataSourceSet().getMainDatasource();
            if (schema == null) {
                return;
            }

            if (StringUtils.isEmpty(executeContext.getTmActivityId())) {
                return;
            }
            String tmProjectId = "";
            if (org.springframework.util.StringUtils.hasText(executeContext.getTmProjectId())) {
                tmProjectId = executeContext.getTmProjectId();
            } else {
                tmProjectId = "__uibot__";
            }
            JSONObject userSetting =
                    digiwinAudcProxyService.getOrderConditionsByUser(executeContext.getLocale(), executeContext.getAuthoredUser().getToken(),
                            executeContext.getTenantId(), executeContext.getPageCode(), tmProjectId, executeContext.getTmActivityId());
            if (userSetting == null || userSetting.isEmpty()) {
                return;
            }
            if (userSetting.containsKey("order")) {
                if (!userSetting.containsKey(schema)) {
                    JSONObject setting = new JSONObject();
                    setting.put(schema, userSetting);
                    userSetting = setting;
                }
            }
            if (userSetting != null && !userSetting.isEmpty()) {
                JSONObject orderSetting = userSetting.getJSONObject(schema);
                if (orderSetting.containsKey("order")) {
                    pageDefine.setSortInfo(orderSetting.getJSONObject("order").getJSONArray("options"));
                }
            }
            pageDefine.setUserSetting(userSetting);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    @Override
    public UiBotModel createPage(PcUiBotExecuteContext executeContext, String backlogId, ApiRequest apiRequest) {
        long start = System.currentTimeMillis();
        List<PcUiBotTaskPageDefine> pageDefineList = projectPageDefineAnalyzer.analysis(executeContext, backlogId, apiRequest);
        log.debug("[{}]解析页面定义，cost：{} ms", backlogId, System.currentTimeMillis() - start);
        start = System.currentTimeMillis();
        UiBotModel uiBotModel = null;
        //从service调用Builder解析器
        if (!CollectionUtils.isEmpty(pageDefineList)) {
            TemplateService<PcUiBotTaskPageDefine> templateService = this.getTemplate(executeContext, pageDefineList.get(0).getVersion(), pageDefineList.get(0).getIsDesignerDsl());
            if (templateService != null) {
                uiBotModel = templateService.createTaskPage(apiRequest, executeContext, pageDefineList.get(0), pageDefineList);
            }
        }
        log.debug("[{}]创建页面，cost：{} ms", backlogId, System.currentTimeMillis() - start);
        if (uiBotModel == null) {
            return UiBotModel.emptyUiBotModel();
        }
        return uiBotModel;
    }

    private TemplateService<PcUiBotTaskPageDefine> getTemplate(PcUiBotExecuteContext executeContext, String version, Boolean isDesignerDsl) {
        String templateName = DesignerProjectPageTemplate.SUPPORT_KEY;
        return templateContainer.get(templateName);
    }
}

