package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.impl;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTaskPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.StartProjectPageService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer.StartProjectPageAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template.DesignerStartProjectPageTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;

/**
 * StartProjectPageServiceImpl
 * 设计器发起项目实现类
 *
 * @author xujinc
 * @date 2023/12/22
 * @since
 */
@Service
public class StartProjectPageServiceImpl implements StartProjectPageService {

    @Autowired
    private StartProjectPageAnalyzer startProjectPageAnalysisService;

    @Autowired
    private DesignerStartProjectPageTemplate designerStartProjectPageTemplate;

    @Override
    public UiBotModel createPresetActivityTemplateForm(ApiRequest apiRequest, PcUiBotExecuteContext executeContext) {
        PcUiBotPageDefine pageDefine = startProjectPageAnalysisService.analysis(executeContext);
        PcUiBotTaskPageDefine pcUiBotTaskPageDefine = JsonUtil.objectToJavaObject(pageDefine, PcUiBotTaskPageDefine.class);
        return designerStartProjectPageTemplate.createTaskPage(apiRequest, executeContext, pcUiBotTaskPageDefine, Collections.singletonList(pcUiBotTaskPageDefine));
    }
}