package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcActivityData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.audc.service.DigiwinAudcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.TaskPageService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer.TaskPageDefineAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template.AssistanTaskPageTemplate;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template.BusinessProcessPerformerImpl;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template.DesignerApprvalTaskPageTemplate;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template.TemplateService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotPatternUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotSubmitActionUtil;
import com.digiwin.mobile.mobileuibot.sso.enums.SsoSourceTypeEnum;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>功能描述：任务相关的页面页生成服务</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskPageServiceImpl.java
 * @Author: wangjwc
 * @Date: created at 2023/7/11 13:36
 */
@Slf4j
@Service
public class TaskPageServiceImpl implements TaskPageService, InitializingBean {

    @Autowired
    private List<TemplateService<PcUiBotTaskPageDefine>> templateList;

    private final Map<String, TemplateService<PcUiBotTaskPageDefine>> templateContainer = new HashMap<>();

//    @Autowired
//    private List<PageBuilder> pageBuilders;

//    private final Map<String, PageBuilder> builderContainer = new HashMap<>();

//    @Autowired
//    private StaticDataTagBuilder staticDataTagBuilder;

//    @Autowired
//    private TagBuilder tagBuilder;

//    @Autowired
//    private CustomPatternBuilder customPatternBuilder;

//    @Autowired
//    private ManuaTaskPageAnalyzer manuaTaskPageAnalyzer;

//    @Autowired
//    private ManuaTaskGeneralPageTemplate manuaTaskGeneralPageTemplate;

//    @Autowired
//    private DesignerTaskPageService designerTaskPageService;

    @Override
    public void afterPropertiesSet() throws Exception {
        if (templateList != null) {
            for (TemplateService<PcUiBotTaskPageDefine> template : templateList) {
                if (templateContainer.containsKey(template.supportKey())) {
                    throw new IllegalStateException("存在重复的模板，请重修改代码：" + template.supportKey());
                }
                templateContainer.put(template.supportKey(), template);
            }
        }
//        if (pageBuilders != null) {
//            for (PageBuilder pageBuilder : pageBuilders) {
//                if (builderContainer.containsKey(pageBuilder.supportKey())) {
//                    throw new IllegalStateException("存在重复的builder，请重修改代码：" + pageBuilder.supportKey());
//                }
//                builderContainer.put(pageBuilder.supportKey(), pageBuilder);
//            }
//        }
    }

//    @Autowired
//    private ProjectCardDefineAnalyzer projectCardDefineAnalyzer;

    @Autowired
    private TaskPageDefineAnalyzer taskPageDefineAnalyzer;

//    @Autowired
//    private TaskCardDefineAnalyzer taskCardDefineAnalyzer;

    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;

//    @Autowired
//    private DataQueryService dataQueryService;

    //    @Autowired
//    private OverdueTaskPageDefineAnalyzer overdueTaskPageDefineAnalyzer;
//
    @Autowired
    private DigiwinAudcProxyService digiwinAudcProxyService;

//    /**
//     * 卡片页面生成数据，根据据项目自身的数据，不依赖任务
//     * 新项目卡pattern
//     *
//     * @param executeContext
//     * @return
//     */
//    @Override
//    public DynamicForm generateProjectCard(ExecuteContext executeContext, ActivityData activityData) {
//        TaskPageDefine pageDefine = projectCardDefineAnalyzer.analysis(executeContext, activityData);
//        //获取默认显示内容
//        if (pageDefine == null) {
//            return null;
//        }
//        // 获取数据源的数据
//        QueryResultSet queryResultSet = dataQueryService.queryByPagedefineWithMetaData(pageDefine.getExecuteContext(), pageDefine);
//
//        DynamicForm dynamicForm = staticDataTagBuilder.createPage(pageDefine.getExecuteContext(), queryResultSet, pageDefine);
//        //BuildPageInfo(pageDefine.getExecuteContext(), pageDefine, dynamicForm);
//        return dynamicForm;
//    }

//    @Override
//    public DynamicForm generateTaskCard(ExecuteContext executeContext, ActivityData activityData) {
//        TaskPageDefine pageDefine = taskCardDefineAnalyzer.analysis(executeContext, activityData);
//        //获取默认显示内容
//        if (pageDefine == null) {
//            return null;
//        }
//
//        // 获取数据源的数据
//        QueryResultSet queryResultSet = dataQueryService.queryByPagedefineWithMetaData(pageDefine.getExecuteContext(), pageDefine);
//
//        DynamicForm dynamicForm = staticDataTagBuilder.createPage(pageDefine.getExecuteContext(), queryResultSet, pageDefine);
//
//
//        return dynamicForm;
//    }

    /**
     * 根据已经定义好的页面来生成界面，主要是项目的第四层、任务的已完成、追踪中按钮的显示
     *
     * @return
     * @throws Exception
     */
    @Override
    public UiBotModel createPage(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, ApiRequest apiRequest) {
//        if (pageDefine == null) {
//            return new DynamicForm();
//        }
//        if (pageBuilders == null || pageBuilders.size() == 0) {
//            return new DynamicForm();
//        }
//        //低代码DSL需要重新获取
//        designerTaskPageService.analysis(executeContext, pageDefine);
        appendUserOrderConditions(executeContext, pageDefine);
//        String builderName = StringUtils.lowerCase(executeContext.getClientAgent() + "-" + executeContext.getPattern() + "-" + executeContext.getCategory() + "-" + pageDefine.getVersion());
//
//        PageBuilder findPageBuilder = null;
//        //根据上下文定义直接获取相应的Builder解析器，不走service
//        if (builderContainer.containsKey(builderName)) {
//            findPageBuilder = builderContainer.get(builderName);
//        }
//        if (findPageBuilder == null) {
//            if (ActivityConstants.PATTERN_CUSTOM.equals(executeContext.getPattern())) {
//                findPageBuilder = customPatternBuilder;
//            }
//        }
//        if (findPageBuilder == null) {
//            findPageBuilder = tagBuilder;
//        }
//        // 获取数据源的数据
//        QueryResultSet queryResultSet = dataQueryService.queryByPagedefineWithMetaData(pageDefine.getExecuteContext(), pageDefine);
//        if (queryResultSet.getMainQueryResult() != null && pageDefine.getPageInfo() != null) {
//            if (queryResultSet.getMainQueryResult().isHasNext()) {
//                pageDefine.setUseHasNext(true);
//            }
//        }
        // 针对项目详情分享的时候(撤回)提交按钮权限的进行判断
        if (UiBotDesignerService.PAGECODE_PROJECT_DETAIL.equals(executeContext.getPageCode())) {
            if (!CollectionUtils.isEmpty(pageDefine.getSubmitActions())) {
                // 是分享且不是当责者或者代理人
                if (executeContext.isShared() && !executeContext.isOwnerBacklog()) {
                    // 没有按钮权限，进行重置
                    pageDefine.setSubmitActions(new ArrayList<>());
                    //如果没有submit，需要去除 SubmitType
                    pageDefine.setSubmitType(null);
                }
            }
            //针对撤回，针对分批提交的情况
            if (pageDefine.getFinished() != null && !pageDefine.getFinished()
                    && "completed".equals(pageDefine.getDataStateCode())) {
                pageDefine.setSubmitActions(PcUiBotSubmitActionUtil.onlyKeepAction(pageDefine.getSubmitActions()));
            }
        } else {
            //针对撤回，针对分批提交的情况
            if (pageDefine.getFinished() != null && !pageDefine.getFinished()
                    && "completed".equals(pageDefine.getDataStateCode())) {
                pageDefine.setSubmitActions(PcUiBotSubmitActionUtil.onlyKeepWithdrawAction(pageDefine.getSubmitActions()));
            }
        }

        UiBotModel uiBotModel = null;
        TemplateService<PcUiBotTaskPageDefine> templateService = this.getTemplate(executeContext, pageDefine.getVersion(), pageDefine.getIsDesignerDsl());
        if (templateService != null) {
            uiBotModel = templateService.createPage(apiRequest, executeContext, pageDefine, Lists.newArrayList(pageDefine));
        }

        if (uiBotModel == null) {
            return UiBotModel.emptyUiBotModel();
        }

//        UiBotModel dynamicForm = findPageBuilder.createPage(pageDefine.getExecuteContext(), queryResultSet, pageDefine);
//        //页面最大化时显示的区域
//        if (CollectionUtils.isNotEmpty(dynamicForm.getLayout())) {
//            for (AbstractComponent component : dynamicForm.getLayout()) {
//                component.setSupportShowInMaxedWindow(true);
//            }
//        }
        return uiBotModel;
    }

    /**
     * 组装用户自定义数据排序条件，放到setting中
     */
    private void appendUserOrderConditions(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine) {
        try {
            //低代码平台暂时禁用用户自定义
            if (executeContext.getIsDesigner() != null && executeContext.getIsDesigner()) {
                return;
            }
            //开窗不设定
            if (executeContext.getOpenWindow() != null
                    && (executeContext.getOpenWindow() == null || executeContext.getOpenWindow())) {
                return;
            }
            if (pageDefine == null) {
                return;
            }
            String schema = pageDefine.getDataSourceSet().getMainDatasource();
            if (schema == null) {
                return;
            }

            if (StringUtils.isEmpty(executeContext.getTmActivityId())) {
                return;
            }
            String tmProjectId = "";
            if (org.springframework.util.StringUtils.hasText(executeContext.getTmProjectId())) {
                tmProjectId = executeContext.getTmProjectId();
            } else {
                tmProjectId = "__uibot__";
            }
            JSONObject userSetting =
                    digiwinAudcProxyService.getOrderConditionsByUser(executeContext.getLocale(), executeContext.getAuthoredUser().getToken(),
                            executeContext.getTenantId(), executeContext.getPageCode(), tmProjectId, executeContext.getTmActivityId());
            if (userSetting == null || userSetting.isEmpty()) {
                return;
            }
            if (userSetting.containsKey("order")) {
                if (!userSetting.containsKey(schema)) {
                    JSONObject setting = new JSONObject();
                    setting.put(schema, userSetting);
                    userSetting = setting;
                }
            }
            if (userSetting != null && !userSetting.isEmpty()) {
                JSONObject orderSetting = userSetting.getJSONObject(schema);
                if (orderSetting.containsKey("order")) {
                    pageDefine.setSortInfo(orderSetting.getJSONObject("order").getJSONArray("options"));
                }
            }
            pageDefine.setUserSetting(userSetting);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    @Override
    public UiBotModel createPage(PcUiBotExecuteContext executeContext, String backlogId, ApiRequest apiRequest) {
        executeContext.setIsDesigner(null);
        //根据URL获取相应的BpmActionDTO
        long start = System.currentTimeMillis();
        DigiwinAtmcActivityData activityData = digiwinAtmcProxyService.getTaskData(backlogId, executeContext);
        log.debug("[{}]获取任务数据，cost：{} ms", backlogId, System.currentTimeMillis() - start);
        start = System.currentTimeMillis();
        executeContext.appendTaskData(activityData);
        List<PcUiBotTaskPageDefine> taskPageDefines;
//        if (PcUiBotActivityConstants.UIBOT_OVERDUE_TASK.equals(executeContext.getTmActivityId())) {
//            taskPageDefines = overdueTaskPageDefineAnalyzer.analysis(executeContext, activityData);
//        } else {
        taskPageDefines = taskPageDefineAnalyzer.analysis(apiRequest, executeContext, activityData);
//        }
        //如果有多个显示方式，则判断任务是否已完成，如果已完成，则优先显示已完成的按钮
        if (taskPageDefines.size() > 1) {
            boolean isClosed = true;
            for (PcUiBotTaskPageDefine taskPageDefine : taskPageDefines) {
                if (taskPageDefine.getFinished() == null || Boolean.FALSE.equals(taskPageDefine.getFinished())) {
                    isClosed = false;
                    break;
                }
            }
            //如果是已完成，则优先显示已完成的按钮
            if (isClosed) {
                PcUiBotTaskPageDefine completedTaskPageDefine = null;
                for (PcUiBotTaskPageDefine taskPageDefine : taskPageDefines) {
                    if (PcUiBotActivityConstant.TASK_DATA_STATE_CODE_COMPLETED.equals(taskPageDefine.getDataStateCode())) {
                        completedTaskPageDefine = taskPageDefine;
                    }
                }
                if (completedTaskPageDefine != null) {
                    taskPageDefines.remove(completedTaskPageDefine);
                    taskPageDefines.add(0, completedTaskPageDefine);
                }
            }
        }
        //根据流程变量配置显示页签，当没有该流程变量时则默认显示全部
        List<PcUiBotTaskPageDefine> taskPageDefineNews = new ArrayList<>();
        if (!CollectionUtils.isEmpty(taskPageDefines)) {
            if (executeContext.getTaskWithBacklogData() != null
                    && executeContext.getTaskWithBacklogData().getBpmData() != null
                    && executeContext.getTaskWithBacklogData().getBpmData().containsKey("uibot__dataStateCodes")) {
                List<String> dataStateCodes = JsonUtil.objectToJavaObject(
                        executeContext.getTaskWithBacklogData().getBpmData().get("uibot__dataStateCodes"),
                        new TypeReference<List<String>>() {
                        });
                for (PcUiBotTaskPageDefine taskPageDefine : taskPageDefines) {
                    if (dataStateCodes.contains(taskPageDefine.getDataStateCode())) {
                        taskPageDefineNews.add(taskPageDefine);
                    }
                }
            } else {
                taskPageDefineNews = taskPageDefines;
            }
            if (CollectionUtils.isEmpty(taskPageDefineNews)) {
                taskPageDefineNews = taskPageDefines;
            }
        }
        log.debug("[{}]解析页面定义，cost：{} ms", backlogId, System.currentTimeMillis() - start);
        start = System.currentTimeMillis();
        UiBotModel uiBotModel = null;

        //从service调用Builder解析器
        if (!CollectionUtils.isEmpty(taskPageDefineNews)) {
            TemplateService<PcUiBotTaskPageDefine> templateService = this.getTemplate(executeContext, taskPageDefineNews.get(0).getVersion(), taskPageDefineNews.get(0).getIsDesignerDsl());
            if (templateService != null) {
                uiBotModel = templateService.createTaskPage(apiRequest, executeContext, taskPageDefineNews.get(0), taskPageDefineNews);
                if (taskPageDefineNews.size() > 1) {
                    PcUiBotTaskPageDefine taskPageDefineFirst = taskPageDefineNews.get(0);
                    // 任务已完成，且数据状态为completed
                    if (BooleanUtils.isTrue(taskPageDefineFirst.getFinished())
                            && PcUiBotActivityConstant.TASK_DATA_STATE_CODE_COMPLETED.equals(taskPageDefineFirst.getDataStateCode())) {
                        this.setFinishedValue(executeContext, taskPageDefineNews, uiBotModel);
                    }
                } else {
                    if (!CollectionUtils.isEmpty(taskPageDefineNews)
                            && BooleanUtils.isTrue(taskPageDefineNews.get(0).getFinished())) {
                        this.setFinishedValue(executeContext, taskPageDefineNews, uiBotModel);
                    }
                }
                //true 则表示此条数据已经被提交成功，工作提醒点击查看更多则显示对应的图片ui
                if (!ObjectUtils.isEmpty(uiBotModel.getFinished()) && uiBotModel.getFinished()
                        && !TaskStringUtil.isBizApproval(executeContext.getPattern(), executeContext.getCategory())
                        && !TaskStringUtil.isBizDataEntryDriven(executeContext.getPattern(), executeContext.getCategory())
                        && !TaskStringUtil.isBizSmartAdjust(executeContext.getTmActivityId())
                        && !SsoSourceTypeEnum.NANA_MESSAGE.getSource().equals(apiRequest.getSourceType())
                ) {
                    return UiBotModel.workReminderEmptyImageUibotModelV2(apiRequest.getLocale());
                }
            }
        }
        log.debug("[{}]创建页面，cost：{} ms", backlogId, System.currentTimeMillis() - start);
        if (uiBotModel == null) {
            return UiBotModel.emptyUiBotModel();
        }
        //返回的json数据过大，优化处理
        if (!CollectionUtils.isEmpty(taskPageDefineNews)) {
            for (PcUiBotTaskPageDefine taskPageDefineNew : taskPageDefineNews) {
                // 像“已完成”页签可能会显示 新“撤回”，因此这边不能置空
                taskPageDefineNew.setExecuteContext(null);
            }
        }
        return uiBotModel;
    }

    /**
     * 设置已完成状态下，有撤回按钮时，重置finished值
     *
     * @param executeContext
     * @param taskPageDefineNews
     * @param uiBotModel
     */
    private void setFinishedValue(PcUiBotExecuteContext executeContext, List<PcUiBotTaskPageDefine> taskPageDefineNews, UiBotModel uiBotModel) {
        if (taskPageDefineNews.get(0).getSubmitActions() != null) {
            for (PcUiBotSubmitAction submitAction : taskPageDefineNews.get(0).getSubmitActions()) {
                // 旧“撤回”按钮（uibot_retrive）
                if (isRetriveAction(submitAction)) {
                    PcUiBotSubmitAction retriveAction = getRetriveAction(submitAction);
                    if (retriveAction != null) {
                        uiBotModel.setFinished(false);
                        Map<String, Object> map = new HashMap<>();
                        List<DigiwinAtmcBacklogData> backlog = Optional.ofNullable(executeContext.getTaskWithBacklogData().getBacklog()).orElse(new ArrayList<>());
                        List<Long> backlogIds = backlog.stream().map(DigiwinAtmcBacklogData::getBacklogId).collect(Collectors.toList());
                        map.put("workItemIdList", backlogIds);
                        String performerId = backlog.get(0).getPerformerId();
                        map.put("performerId", performerId);
                        map.put("performerType", 0);
                        map.put("agentPerformerId", "");
                        if (!Objects.equals(performerId, executeContext.getAuthoredUser().getUserId())) {
                            //如果待办人员和当前人员不是同一个人，则指定为代理人
                            map.put("performerType", 1);
                            map.put("agentPerformerId", executeContext.getAuthoredUser().getUserId());
                        }
                        retriveAction.setParas(map);
                    }
                }
                // 新“撤回”按钮（uibot_task_withdraw）
                else if (PcUiBotSubmitActionUtil.isTaskWithdrawAction(submitAction)) {
                    uiBotModel.setFinished(false);
                    uiBotModel.setFinishedTitle(null);
                }
            }
        }
    }

    private boolean isRetriveAction(PcUiBotSubmitAction tmAction) {
        if (tmAction == null) {
            return false;
        }
        if (PcUiBotConstants.UIBOT_RETRIEVE.equals(tmAction.getActionId())) {
            return true;
        }

        if (!CollectionUtils.isEmpty(tmAction.getAttachActions())) {
            for (PcUiBotSubmitAction attachAction : tmAction.getAttachActions()) {
                if (isRetriveAction(attachAction)) {
                    return true;
                }
            }
        }
        return false;
    }

    private PcUiBotSubmitAction getRetriveAction(PcUiBotSubmitAction tmAction) {
        if (tmAction == null) {
            return null;
        }
        if (PcUiBotConstants.UIBOT_RETRIEVE.equals(tmAction.getActionId())) {
            return tmAction;
        }

        if (!CollectionUtils.isEmpty(tmAction.getAttachActions())) {
            for (PcUiBotSubmitAction attachAction : tmAction.getAttachActions()) {
                PcUiBotSubmitAction retriveAction = getRetriveAction(attachAction);
                if (retriveAction != null) {
                    return retriveAction;
                }
            }
        }
        return null;
    }

//    /**
//     * 根据已经定义好的页面来生成界面,数据已经查询好了，不需要再处理数据
//     *
//     * @return
//     * @throws Exception
//     */
//    @Override
//    public DynamicForm createPageWithData(ExecuteContext executeContext, TaskPageDefine pageDefine, QueryResultSet queryResultSet) {
//        if (pageDefine == null) {
//            return new DynamicForm();
//        }
//        if (pageBuilders == null || pageBuilders.size() == 0) {
//            return new DynamicForm();
//        }
//        String builderName = StringUtils.lowerCase(executeContext.getClientAgent() + "-" + executeContext.getPattern() + "-" + executeContext.getCategory() + "-" + pageDefine.getVersion());
//
//        PageBuilder findPageBuilder = null;
//        if (builderContainer.containsKey(builderName)) {
//            findPageBuilder = builderContainer.get(builderName);
//        }
//        if (findPageBuilder == null) {
//            if (ActivityConstants.PATTERN_CUSTOM.equals(executeContext.getPattern())) {
//                findPageBuilder = customPatternBuilder;
//            }
//        }
//        if (findPageBuilder == null) {
//            findPageBuilder = tagBuilder;
//        }
//        DynamicForm dynamicForm = findPageBuilder.createPage(pageDefine.getExecuteContext(), queryResultSet, pageDefine);
//        //super.BuildPageInfo(pageDefine.getExecuteContext(), pageDefine, dynamicForm);
//        return dynamicForm;
//    }

    private TemplateService<PcUiBotTaskPageDefine> getTemplate(PcUiBotExecuteContext executeContext, String version, Boolean isDesignerDsl) {
        // wjw TODO: 2023/11/24 去除任务卡pattern、category判断，因 此任务卡不会存在DSL节点layout
        if (/*("BUSINESS_ASSISTAN".equalsIgnoreCase(executeContext.getPattern())
                && "ASSISTAN".equalsIgnoreCase(executeContext.getCategory()))
                || */BooleanUtils.isFalse(isDesignerDsl)) {
            // wjw TODO: 2023/10/17 获取模板类，写死，走数据驱动组件解析类
            String templateName = AssistanTaskPageTemplate.SUPPORT_KEY;
            return templateContainer.get(templateName);
        } else if (PcUiBotPatternUtil.isModelDriven(executeContext)) {
            // wjw TODO: 2024/1/10 模型驱动任务也不会存在layout节点，但是存在绑定的数据录入code
            String templateName = PcUibotSupportKeyConstant.Designer.BUSINESS_DATA_ENTRY_DRIVEN;
            return templateContainer.get(templateName);
        } else if (TaskStringUtil.isBizApproval(executeContext.getPattern(), executeContext.getCategory())) {
            // 签核型任务
            String templateName = DesignerApprvalTaskPageTemplate.SUPPORT_KEY;
            return templateContainer.get(templateName);
        } else {
            // wjw TODO: 2023/8/30 获取模板类，写死，走当前模板解析类
            String templateName = BusinessProcessPerformerImpl.SUPPORT_KEY;
            return templateContainer.get(templateName);
        }

//        String templateName = StringUtils.lowerCase(executeContext.getClientAgent() + "-data-uniformity-" + executeContext.getTaskType());
//        if (templateContainer.containsKey(templateName)) {
//            return templateContainer.get(templateName);
//        }
//
//        String designerStr = "";
//        if (executeContext.getIsDesigner() != null && BooleanUtils.isTrue(executeContext.getIsDesigner())) {
//            designerStr = "designer-";
//        }
//        templateName = StringUtils.lowerCase(designerStr + executeContext.getClientAgent() + "-" + executeContext.getPattern() + "-" + executeContext.getCategory() + "-" + executeContext.getRelationTag().getIdentity() + "-" + version);
//
//        if (templateContainer.containsKey(templateName)) {
//            return templateContainer.get(templateName);
//        }
//
//        templateName = StringUtils.lowerCase(designerStr + executeContext.getClientAgent() + "-" + executeContext.getPattern() + "-" + executeContext.getCategory() + "-" + executeContext.getRelationTag().getIdentity());
//        if (templateContainer.containsKey(templateName)) {
//            return templateContainer.get(templateName);
//        }
//
//        templateName = StringUtils.lowerCase(designerStr + executeContext.getClientAgent() + "-" + executeContext.getPattern() + "-" + executeContext.getRelationTag().getIdentity());
//        if (templateContainer.containsKey(templateName)) {
//            return templateContainer.get(templateName);
//        }
//
//        //返回通用的模板
//        templateName = StringUtils.lowerCase(designerStr + executeContext.getClientAgent() + "-common-" + executeContext.getRelationTag().getIdentity());
//        if (templateContainer.containsKey(templateName)) {
//            return templateContainer.get(templateName);
//        }
//        return null;
    }


//    /**
//     * 根据任务获取任务卡上的摘要信息（字符串）
//     *
//     * @param executeContext
//     * @param activityData
//     * @return
//     */
//    @Override
//    public Map getTaskCardAbstractStr(ExecuteContext executeContext, ActivityData activityData) {
//        if (activityData == null || CollectionUtils.isEmpty(activityData.getTasks())) {
//            return null;
//        }
//
//        TaskPageDefine pageDefine = taskCardDefineAnalyzer.analysisAbstract(executeContext, activityData);
//        //获取默认显示内容
//        if (pageDefine == null || CollectionUtils.isEmpty(pageDefine.getDataTags())) {
//            return null;
//        }
//
//        if (activityData.getType() != null && activityData.getType() == 89) {
//            DataSourceDTO dataSourceDTO = pageDefine.getDataSourceSet().getDataSourceList().get(0);
//            if (dataSourceDTO.getDataSourceProcessors() == null) {
//                dataSourceDTO.setDataSourceProcessors(new ArrayList<>());
//            }
//            TmDataProcess tmDataProcess = new TmDataProcess();
//            tmDataProcess.setType("service");
//            tmDataProcess.setParas(executeContext.getAbnormalData());
//            tmDataProcess.setServiceName("retainAbnormalDataService");
//            dataSourceDTO.getDataSourceProcessors().add(tmDataProcess);
//        }
//
//        // 获取数据源的数据
//        QueryResultSet queryResultSet = dataQueryService.queryByPagedefineWithMetaData(pageDefine.getExecuteContext(), pageDefine);
//
//        Map cardMap = staticDataTagBuilder.getDataTagsData(pageDefine.getExecuteContext(), queryResultSet, pageDefine, false, activityData.getNeedHistoryInfo());
//        cardMap.putAll(staticDataTagBuilder.getStatesData(queryResultSet,pageDefine));
//        return cardMap;
//    }


//    /**
//     * 项目卡摘要信息-不依赖任务（字符串）
//     *
//     * @Author：SYQ
//     * @Date：2021/12/29 17:16
//     */
//    @Override
//    public Map getProjectCardAbstractStr(ExecuteContext executeContext, ActivityData activityData) {
//        TaskPageDefine pageDefine = projectCardDefineAnalyzer.analysisAbstract(executeContext, activityData);
//        //获取默认显示内容
//        if (pageDefine == null || CollectionUtils.isEmpty(pageDefine.getDataTags())) {
//            return null;
//        }
//        // 获取数据源的数据
//        QueryResultSet queryResultSet = dataQueryService.queryByPagedefineWithMetaData(pageDefine.getExecuteContext(), pageDefine);
//
//        Map map = staticDataTagBuilder.getDataTagsData(pageDefine.getExecuteContext(), queryResultSet, pageDefine, true, activityData.getNeedHistoryInfo());
//        return map;
//    }


    /**
     * xuxx 2022-01-07 add 手动发起任务  、 NLP
     * * @return
     *
     * @throws Exception
     */
    @Override
    public UiBotModel createManuaTaskPage(PcUiBotExecuteContext executeContext, String backlogId) {

//        //根据URL 获取相应的BpmActionDTO
//        if (StringUtils.isEmpty(backlogId)) {
//            return manuaTaskGeneralPageTemplate.createEmptyPage(executeContext);
//        }
//        ActivityData activityData = atmcService.getTaskData(backlogId, executeContext);
//        List<TaskExecuteLog> taskExecuteLog = atmcService.getTaskExecuteLog(backlogId, executeContext);
//        if (activityData == null) {
//            return manuaTaskGeneralPageTemplate.createEmptyPage(executeContext);
//        }
//        executeContext.appendTaskData(activityData);
//        if (CollectionUtils.isNotEmpty(activityData.getTasks())) {
//            if (activityData.getTasks().size() > 0) {
//                if (activityData.getTasks().get(0).getBpmData() != null) {
//                    DynamicForm dynamicForm = new DynamicForm();
//                    List layout = new ArrayList();
//                    dynamicForm.setLayout(layout);
//                    manuaTaskGeneralPageTemplate.createPage(executeContext, activityData, dynamicForm, taskExecuteLog);
//                    if (activityData.getTasks().get(0).getBpmData().get("taskCode") != null) {
//                        String tmActivityId = activityData.getTasks().get(0).getBpmData().get("taskCode").toString();
//                        if (StringUtils.isNotBlank(tmActivityId)) {
//                            executeContext.setTmActivityId(tmActivityId);
//                            TaskPageDefine pageDefine = (TaskPageDefine) manuaTaskPageAnalyzer.analysis(executeContext);
//                            pageDefine.setFinished(manuaTaskPageAnalyzer.isManualTaskFinished(executeContext.getTaskWithBacklogDataList()));
//                            manuaTaskGeneralPageTemplate.createManualTaskPage(executeContext, pageDefine, dynamicForm);
//                        }
//                    }
//                    return dynamicForm;
//
//                }
//            }
//        }

        return UiBotModel.emptyUiBotModel();
    }


//    /**
//     * xuxx 2022-01-07 add 手动发起任务  、 NLP
//     * * @return
//     *
//     * @throws Exception
//     */
//    @Override
//    public DynamicForm createSimplePage(ExecuteContext executeContext, Map<String, Object> parameter) {
//        PageDefine pageDefine = manuaTaskPageAnalyzer.analysis(executeContext);
//        if (parameter != null) {
//            pageDefine.setParameter(parameter);
//        }
//        if (null != pageDefine) {
//            return manuaTaskGeneralPageTemplate.createTaskPage(executeContext, pageDefine, null);
//        }
//        return new DynamicForm();
//    }

//    @Override
//    public List<PageDefine> analysisDataUniformityPageDefine(ExecuteContext executeContext, String backlogId) {
//        //根据URL 获取相应的BpmActionDTO
//        ActivityData activityData = atmcService.getTaskData(backlogId, executeContext);
//        executeContext.appendTaskData(activityData);
//        List<TaskPageDefine> actionVOS = taskPageDefineAnalyzer.analysis(executeContext, activityData);
//        if (actionVOS.size() == 0) {
//            return null;
//        }
//        PageDefine waittingPageDefine = null;
//        PageDefine tracingPageDefine = null;
//        //取待处理数据
//        for (TaskPageDefine taskPageDefine : actionVOS) {
//            if (taskPageDefine.getDataStateCode() != null && taskPageDefine.getDataStateCode().startsWith("waitting")) {
//                if (waittingPageDefine == null) {
//                    waittingPageDefine = taskPageDefine;
//                }
//            } else {
//                if (taskPageDefine.isDefaultShow()) {
//                    waittingPageDefine = taskPageDefine;
//                    break;
//                }
//            }
//
//            if (taskPageDefine.getDataStateCode() != null && taskPageDefine.getDataStateCode().startsWith("tracing")) {
//                tracingPageDefine = taskPageDefine;
//            }
//        }
//        if (waittingPageDefine == null) {
//            waittingPageDefine = actionVOS.get(0);
//        }
//        List<PageDefine> resultList = new ArrayList<>();
//        if (null != waittingPageDefine) {
//            resultList.add(waittingPageDefine);
//        }
//        if (null != tracingPageDefine) {
//            resultList.add(tracingPageDefine);
//        }
//        return resultList;
//    }


//    @Override
//    public List<DynamicForm> analysisDataUniformityHistory(ExecuteContext executeContext, String backlogId) {
//        List<DynamicForm> resultList = new ArrayList<>();
//        ActivityData activityData = atmcService.getTaskData(backlogId, executeContext);
//        List<BpmActivityWorkitem> exceptionBacklogIds = activityData.getAbnormalCards();
//        List<Long> backlogIds = exceptionBacklogIds.stream().map(exceptionBacklogId -> exceptionBacklogId.getId()).collect(Collectors.toList());
//        List<Map> pageData = atmcService.queryDataUniformifyTaskSubmitData(backlogIds);
//
//        for(BpmActivityWorkitem bpmActivityWorkitem : exceptionBacklogIds){
//            ExecuteContext newExecuteContext = new ExecuteContext();
//            BeanUtils.copyProperties(executeContext,newExecuteContext);
//            ActivityData exceptionActivityData = atmcService.getTaskData(backlogId, newExecuteContext);
//            newExecuteContext.appendTaskData(exceptionActivityData);
//            TaskWithBacklogData taskWithBacklogData =  exceptionActivityData.getTasks().get(0);
//            newExecuteContext.appendPageInfoAndHistory(ActivityConstants.TASK_DETAIL, taskWithBacklogData.getBpmData().get("taskId").toString(), taskWithBacklogData.getTmActivityId(), ActivityConstants.PERFORMER, false, false);
//            DynamicForm dynamicForm =  createPage(newExecuteContext,bpmActivityWorkitem.getId().toString());
//            if(bpmActivityWorkitem.getClosedTime() == null){
//                bpmActivityWorkitem.setAbnormalTaskState(messageUtils.getMessage("uibot.activity.abnormal.state.unsubmit"));
//            }else{
//                //已经提交的任务
//                bpmActivityWorkitem.setAbnormalTaskState(messageUtils.getMessage("uibot.activity.abnormal.state.submit"));
//                if (CollectionUtils.isEmpty(pageData)){
//                    log.info("主任务：{},的异常任务提交记录查询为空",backlogId);
//                }
//                for(Map map : pageData){
//                    if(map.get("cardId").equals(bpmActivityWorkitem.getId())){
//                        dynamicForm.setPageData((Map<String, Object>) map.get("data"));
//                    }
//                }
//            }
//            if(dynamicForm.getExecuteContext() != null) {
//                dynamicForm.getExecuteContext().getTaskWithBacklogData().setAbnormalTaskInfo(bpmActivityWorkitem);
//            }
//            resultList.add(dynamicForm);
//        }
//        return resultList;
//    }

//    private void assignScrollType(List<DynamicForm> resultList) {
//        if (CollectionUtils.isEmpty(resultList)) {
//            return;
//        }
//        if (resultList.size() > 1) {
//            //如果DynamicForm大于1个，将scrollType设置为null
//            for (DynamicForm dynamicForm : resultList) {
//                if(dynamicForm.getExecuteContext() != null) {
//                    dynamicForm.getExecuteContext().setScrollType(null);
//                }
//                if(CollectionUtils.isEmpty(dynamicForm.getLayout())){
//                    continue;
//                }
//                List<AbstractComponent> layout = dynamicForm.getLayout();
//                layout.stream()
//                        .filter(abstractComponent -> abstractComponent instanceof GridComponent)
//                        .forEach(abstractComponent -> {
//                            ((GridComponent) abstractComponent).setScrollType(null);
//                        });
//            }
//        }
//    }

}

