package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.impl;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.QueryResultSet;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.WorkbenchPageService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer.WorkbenchPageDefineAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.builder.WorkbenchPageBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * <p>功能描述：移动工作台页面 生成服务</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: WorkbenchPageServiceImpl.java
 * @Author: wangjwc
 * @Date: created at 2024/8/26 20:37
 */
@Service
public class WorkbenchPageServiceImpl implements WorkbenchPageService {

    @Autowired
    private WorkbenchPageBuilder workbenchPageBuilder;

    @Autowired
    private WorkbenchPageDefineAnalyzer workbenchPageDefineAnalyzer;

    @Override
    public UiBotModel createPage(PcUiBotExecuteContext executeContext, ApiRequest apiRequest) {
        List<PcUiBotPageDefine> pageDefineList = workbenchPageDefineAnalyzer.analysis(executeContext);
        if (CollectionUtils.isEmpty(pageDefineList)) {
            return UiBotModel.emptyUiBotModel();
        }
        if (CollectionUtils.isEmpty(pageDefineList.get(0).getPageLayout())) {
            return UiBotModel.emptyUiBotModel();
        }
        QueryResultSet queryResultSet = workbenchPageBuilder.BuildDataSource(pageDefineList.get(0).getExecuteContext(), pageDefineList.get(0));
        return workbenchPageBuilder.createPage(pageDefineList.get(0).getExecuteContext(), queryResultSet, pageDefineList.get(0), apiRequest);
    }
}