package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.model;

import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>功能描述：基础资料录入 -- 状态管理 配置</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: BaseDataStatusConfig.java
 * @Author: wangjwc
 * @Date: created at 2023/12/5 16:51
 */
@Data
public class BaseDataStatusConfig {
    // 是否启用状态
    Boolean needStatusColumn;
    // 状态配置
    List<Map<String, Object>> stateConfig;
    // 状态转换配置
    List<Map<String, Object>> stateTransferConfig;

    // 状态ID 列表
    List<String> stateIds;
    // key = 当前状态值，value = 可显示的按钮actionType 列表
    Map<String, List<String>> showIdMap;

    public List<String> getStateIds() {
        if (stateIds == null && !CollectionUtils.isEmpty(this.stateConfig)) {
            stateIds = this.stateConfig.stream().map(state -> StringUtil.valueOf(state.get("id"))).collect(Collectors.toList());
        }
        return stateIds;
    }

    public Map<String, List<String>> getShowIdMap() {
        if (showIdMap == null && !CollectionUtils.isEmpty(this.stateConfig) && !CollectionUtils.isEmpty(this.stateTransferConfig)) {
            Map<String, String> idValueMap = this.stateConfig.stream().collect(Collectors.toMap(k -> StringUtil.valueOf(k.get("id")), v -> StringUtil.valueOf(v.get("value")), (c1, c2) -> c1));
            Map<String, List<String>> idValueTransferMap = this.stateTransferConfig.stream().collect(Collectors.toMap(k -> StringUtil.valueOf(k.get("sourceId")), v -> (List<String>) v.get("targetIds"), (c1, c2) -> c1));
            Map<String, List<String>> tempShowIdMap = new HashMap<>();
            idValueMap.forEach((k, v) -> tempShowIdMap.put(v, idValueTransferMap.get(k)));
            this.showIdMap = tempShowIdMap;
        }
        return showIdMap;
    }
}