package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.common.BackgroundColorEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProjectData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.button.UiBotQueryButton;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.builder.AssistanPatternTaskBuilder;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotPropertyPlaceholderUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * <p>功能描述：数据驱动DSL任务</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AssistanTaskPageTemplate.java
 * @Author: wangjwc
 * @Date: created at 2023/10/17 10:52
 */
@Component
@Slf4j
public class AssistanTaskPageTemplate extends GeneralPageTemplate<PcUiBotTaskPageDefine> {
    public static final String SUPPORT_KEY = "webplatform-business_assistan-assistan-performer";

    @Autowired
    private AssistanPatternTaskBuilder assistanPatternTaskBuilder;

    @Autowired
    private BusinessProcessPerformerImpl businessProcessPerformer;

    @Autowired
    private UiBotDesignerRenderService uiBotDesignerRenderService;

    @Override
    public String supportKey() {
        return SUPPORT_KEY;
    }

    private static final String COMPONENT_TYPE = "ACTIVITY_TITLE";


    private static final String COMPONENT_ACTIVITY_DESCRIPTION = "ACTIVITY_DESCRIPTION";

    /**
     * 创建布局
     *
     * @param executeContext
     * @param queryResultSet
     * @param pageDefine
     * @param pageDefines
     * @param dynamicForm
     */
    @Override
    protected void BuildLayout(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, QueryResultSet queryResultSet, PcUiBotTaskPageDefine pageDefine, List<PcUiBotTaskPageDefine> pageDefines, UiBotModel dynamicForm) {
        List<UiBotLayout> layout = new ArrayList<>();
        dynamicForm.setLayout(layout);
        //创建头部信息
        createHeader(executeContext, pageDefine, layout);

        // 位置不能变，因此方法中构建了设计器的DSL
        assistanPatternTaskBuilder.createDynamicForm(apiRequest, executeContext, pageDefine, dynamicForm, queryResultSet);

        //创建动态区域的组件
        if (CollectionUtils.isNotEmpty(pageDefines)) {
            UiBotLayout queryButtonComponent = createQueryButton(queryResultSet, pageDefines);
//            queryButtonComponent.setSupportShowInMaxedWindow(true);
            layout.add(queryButtonComponent);
        }

        PcUiBotTaskData taskData = createTaskData(executeContext, pageDefine, queryResultSet);
        //设置uibot相关的数据
        Map<String, Object> pageData = dynamicForm.getPageData();
        pageData.put(PcUiBotConstants.UIBOT_FIELDS_ACTIVITY, taskData);

        Map<String, String> templateContentData = new HashMap<>();
        String contentTitle = taskData.getName();
        if (StringUtils.isNotBlank(contentTitle)) {
            templateContentData.put("title", contentTitle);
            templateContentData.put("subTitle", contentTitle);
        }
        pageData.put("uiBot__content", templateContentData);
        pageData.put("uiBot__prompt_message", "");
    }

    /**
     * 添加提交的逻辑
     */
    @Override
    protected void BuildActions(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, UiBotModel dynamicForm) {
        if (!CollectionUtils.isEmpty(pageDefine.getSubmitActions())) {
            dynamicForm.setActions(JsonUtil.objectToJavaObject(pageDefine.getSubmitActions(),
                    new TypeReference<List<UiBotAction>>() {
                    }));
        }
    }


    @Override
    protected void BuildPageData(UiBotModel dynamicForm, QueryResultSet queryResultSet) {
        return;
    }

    /**
     * 创建头部
     */
    protected void createHeader(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, List<UiBotLayout> layout) {
        layout.add(createHeadArea());
        //layout.add(createDescriptionArea());
        createSignOffProgress(executeContext, layout);
    }

    private void createSignOffProgress(PcUiBotExecuteContext executeContext, List<UiBotLayout> layout) {
        if (executeContext != null && executeContext.getTaskWithBacklogData() != null && executeContext.getTaskWithBacklogData().getRelationApproval() != null) {
            //创建审核流程
            UiBotLayout signOffProgressLinkComponent = new UiBotLayout();
            signOffProgressLinkComponent.setId(UUID.randomUUID().toString());
            signOffProgressLinkComponent.setType("SIGN_OFF_PROGRESS_LINK");
            signOffProgressLinkComponent.setSchema(PcUiBotConstants.UIBOT_FIELDS_ACTIVITY);
            layout.add(signOffProgressLinkComponent);
        }
    }

    @Override
    protected void BuildPageInfo(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, UiBotModel dynamicForm) {
        dynamicForm.setFinished(pageDefine.getFinished());
        dynamicForm.setFinishedTitle(pageDefine.getFinishedTitle());
    }

    /**
     * 创建 活动头(标准)
     * 显示部分：
     * xx/xx需完成追料确认排除异常+倒计时
     * 副标题
     *
     * @return
     */
    protected UiBotLayout createHeadArea() {
        UiBotLayout commonComponent = new UiBotLayout();
        commonComponent.setId(UUID.randomUUID().toString());
        commonComponent.setType(COMPONENT_TYPE);
        commonComponent.setSchema(PcUiBotConstants.UIBOT_FIELDS_ACTIVITY);
        return commonComponent;
    }

    /**
     * 创建 活动头(标准)
     * 样例：
     * 2020/xx/xx 由Athena發起當前任務
     * 来源：由xxxxxx組成
     * 预计开工日：2020 06/14
     * 方案：特采
     * 发起人：xxx
     *
     * @return
     */
    protected UiBotLayout createDescriptionArea() {
        UiBotLayout commonComponent = new UiBotLayout();
        commonComponent.setType(COMPONENT_ACTIVITY_DESCRIPTION);
        commonComponent.setSchema(PcUiBotConstants.UIBOT_FIELDS_ACTIVITY);
        return commonComponent;
    }


    protected UiBotLayout createQueryButton(QueryResultSet queryResultSet, List<PcUiBotTaskPageDefine> pageDefines) {
        UiBotLayout queryButtonComponent = new UiBotLayout();
        queryButtonComponent.setId(UUID.randomUUID().toString());
        queryButtonComponent.setType("CONTENT_QUERY_BUTTON");


        //第一个查询产生的界面直接作为任务的布局一部分，其他的查询则是当用户点击的时候才去查询
        if (queryResultSet != null
                && queryResultSet.getQueryResults() != null
                && pageDefines.size() > 0) {
            PcUiBotTaskPageDefine pageDefine = pageDefines.get(0);
            pageDefine.setType("UI");
            if ("byDataKey".equals(pageDefine.getRowSizeType())) {
                int rowSize = 0;
                for (QueryResult queryResult : queryResultSet.getQueryResults()) {
                    if (queryResultSet.getMainQueryResult() != null
                            && StringUtils.isNotEmpty(queryResultSet.getMainQueryResult().getDataSourceName())
                            && queryResultSet.getMainQueryResult().getDataSourceName().equals(queryResult.getDataSourceName())) {
                        if (!CollectionUtils.isEmpty(queryResult.getDataKeyIndex())) {
                            rowSize = rowSize + queryResult.getDataKeyIndex().size();
                        }
                    }
                }
                pageDefine.setRowSize(rowSize);
            } else {
                int rowSize = 0;
                for (QueryResult queryResult : queryResultSet.getQueryResults()) {
                    if (queryResultSet.getMainQueryResult() != null
                            && StringUtils.isNotEmpty(queryResultSet.getMainQueryResult().getDataSourceName())
                            && queryResultSet.getMainQueryResult().getDataSourceName().equals(queryResult.getDataSourceName())) {
                        if (CollectionUtils.isNotEmpty(queryResult.getData())) {
                            rowSize = rowSize + queryResult.getData().size();
                        }
                    }
                }
                pageDefine.setRowSize(rowSize);
            }
            if (queryResultSet.getMainQueryResult().getData() != null
                    && queryResultSet.getMainQueryResult().getData().size() > 0) {
                queryButtonComponent.setData(queryResultSet.getMainQueryResult().getData().get(0));
            }
        }
        for (int i = 1; i < pageDefines.size(); i++) {
            PcUiBotTaskPageDefine pageDefine = pageDefines.get(i);
            pageDefine.setType("async");
        }
        queryButtonComponent.setQueryButtons(JsonUtil.objectToJavaObject(pageDefines,
                new TypeReference<List<UiBotQueryButton>>() {
                }));
        return queryButtonComponent;
    }


    protected PcUiBotTaskData createTaskData(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine, QueryResultSet queryResultSet) {
        PcUiBotTaskData taskDetailDTO = new PcUiBotTaskData();
        String titleDefine = pageDefine.getTitle();
        if (titleDefine != null) {
            String title = titleDefine;
            if (titleDefine.contains("$(") && queryResultSet != null) {
                QueryResult queryResult = queryResultSet.getMainQueryResult();
                if (queryResult.size() > 0) {
                    Pattern p = Pattern.compile("\\$\\((?<var>.*?)\\)");
                    Matcher m = p.matcher(titleDefine);
                    while (m.find()) {
                        String varName = m.group("var");
                        Object varValue = queryResult.getData().get(0).get(varName).toString();
                        title = title.replace("$(" + varName + ")", varValue.toString());
                    }
                }

            }
            taskDetailDTO.setTitle(title);
        }

        taskDetailDTO.setDescription(pageDefine.getDescription());

        DigiwinAtmcTaskWithBacklogData taskData = executeContext.getTaskWithBacklogData();

        // 使用流程变量中值，替换title、description中的占位符

        if (taskData != null && CollectionUtils.isNotEmpty(taskData.getBpmData())) {
            Map<String, Object> bpmData = taskData.getBpmData();
            taskDetailDTO.setTitle(PcUiBotPropertyPlaceholderUtil.resolve(taskDetailDTO.getTitle(), bpmData));
            taskDetailDTO.setDescription(PcUiBotPropertyPlaceholderUtil.resolve(taskDetailDTO.getDescription(), bpmData));
        }

        taskDetailDTO.setSubDescription(pageDefine.getSubDescription());


        if (pageDefine.getDataSourceSet().isEmpty()
                || executeContext.getProjectData() == null
                || taskData == null) {
            return taskDetailDTO;
        }

        if (CollectionUtils.isNotEmpty(taskData.getEocName())) {
            taskDetailDTO.setEocName(taskData.getEocName());
        }

        if (executeContext.getApprovalInfo() != null && executeContext.getApprovalInfo().getSubState() != null) {
            taskDetailDTO.setApprovalInfo(executeContext.getApprovalInfo());
        }

        DigiwinAtmcProjectData projectData = executeContext.getProjectData();
        DigiwinAtmcBacklogData backlogData = new DigiwinAtmcBacklogData();
        List<DigiwinAtmcBacklogData> backlog = taskData.getBacklog();
        if (!CollectionUtils.isEmpty(backlog)) {
            backlogData = backlog.get(0);
        }
        taskDetailDTO.setTaskStartTime(projectData.getStartTime());
        taskDetailDTO.setRemainTime(backlogData.getRemainTime());
        taskDetailDTO.setReadCount(backlogData.getReadCount());
        taskDetailDTO.setTaskEndTime(projectData.getEndTime());
        taskDetailDTO.setTaskName(projectData.getProjectName());
        if (projectData.getProcessCreateTime() == null) {
            taskDetailDTO.setProcessCreateTime(projectData.getStartTime());
        } else {
            taskDetailDTO.setProcessCreateTime(projectData.getProcessCreateTime());
        }
        if (StringUtils.isNotEmpty(backlogData.getBacklogName())) {
            taskDetailDTO.setName(backlogData.getBacklogName());
            taskDetailDTO.setProcessSerialNumber(taskData.getProcessSerialNumber());
            if (CollectionUtils.isNotEmpty(backlogData.getWorkitemList())) {
                taskDetailDTO.setWorkitemId(backlogData.getWorkitemList().get(0).get("workitemId").toString());
            }
        } else {
            taskDetailDTO.setName(taskData.getTmActivityName());
        }
        taskDetailDTO.setSubName(pageDefine.getSubTitle());
        taskDetailDTO.setSteps(taskData.getSteps());
        taskDetailDTO.setApprovalState(taskData.getApprovalState());
        //逾期
        taskDetailDTO.setOverdueDate(backlogData.getOverdueDate());
        taskDetailDTO.setEndTime(backlogData.getPlanEndTime());
        //扩展数据
        Map<String, Object> extend = new HashMap<>();
        taskDetailDTO.setExtendedFields(extend);
        Map<String, Object> signOffData = new HashMap<>();
        signOffData.put("locale", AppRequestContext.getContextEntity().getLocale());
        extend.put("signOffProgressData", signOffData);
        List<Map> processInstances = new ArrayList<>();
        if (taskData.getRelationApproval() != null) {
            Map<String, Object> process = taskData.getRelationApproval();
            process.putAll(taskData.getRelationApproval());
            processInstances.add(process);
            signOffData.put("processInstances", processInstances);
        } else {
            Map<String, Object> process = new HashMap<>();
            process.put("processSerialNumber", taskData.getProcessSerialNumber());
            process.put("tmActivityIds", new String[]{taskData.getTmActivityId()});
            if (backlogData != null && backlogData.getBacklogId() != null) {
                process.put("workitemId", backlogData.getBacklogId());
            }
            processInstances.add(process);
            signOffData.put("processInstances", processInstances);
        }
        return taskDetailDTO;
    }

    @Override
    public UiBotModel createPage(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine mainAction, List<PcUiBotTaskPageDefine> pageDefines) {
        UiBotModel uiBotModel = super.createTaskPage(apiRequest, executeContext, mainAction, pageDefines);
        if (ObjectUtils.isEmpty(uiBotModel.getRenderData())) {
            uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
        }
        // 页面内容
        businessProcessPerformer.bulidRanderData(apiRequest, mainAction, executeContext, uiBotModel, 2, null);
        // 原始数据
        uiBotModel.setRawUiBotPageData(JsonUtil.objectToJavaObject(uiBotModel.getPageData(), UiBotPageData.class));

        // 构建机制参数和交付设计器参数
        uiBotDesignerRenderService.buildVariablesAndDelivery(apiRequest, uiBotModel, executeContext);

        uiBotModel.getLayout().clear();
        uiBotModel.getPageData().clear();
        uiBotModel.getActions().clear();
        uiBotModel.setPageDataIndex(null);
        uiBotModel.setPageDataKeys(null);
        uiBotModel.initMobileLayoutType();
        uiBotModel.setExecuteContext(JsonUtil.objectToJavaObject(executeContext, UiBotExecuteContext.class));
        uiBotModel.setPageBackgroudColor(org.springframework.util.StringUtils.hasLength(uiBotModel.getPageBackgroudColor())
                ?
                uiBotModel.getPageBackgroudColor()
                :
                BackgroundColorEnum.APP_MAIN_GREY.getValue());
        return uiBotModel;
    }

    @Override
    public UiBotModel createTaskPage(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine mainAction, List<PcUiBotTaskPageDefine> pageDefines) {
        int type = businessProcessPerformer.useTabComponentRender(pageDefines) ? 2 : 1;
        UiBotModel uiBotModel = super.createTaskPage(apiRequest, executeContext, mainAction, pageDefines);
        if (ObjectUtils.isEmpty(uiBotModel.getRenderData())) {
            uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
        }
        // 转派
        DigiwinAtmcBacklogDetail backlogDetail = uiBotDesignerRenderService.buildApprovalReassign(apiRequest, uiBotModel);
        // titleBody
        uiBotDesignerRenderService.buildTitleBody(apiRequest, uiBotModel, backlogDetail, true);
        // 页面内容
        businessProcessPerformer.bulidRanderData(apiRequest, mainAction, executeContext, uiBotModel, type, null);
        // 原始数据
        uiBotModel.setRawUiBotPageData(JsonUtil.objectToJavaObject(uiBotModel.getPageData(), UiBotPageData.class));

        // 构建机制参数和交付设计器参数
        uiBotDesignerRenderService.buildVariablesAndDelivery(apiRequest, uiBotModel, executeContext);

        uiBotModel.getLayout().clear();
        uiBotModel.getPageData().clear();
        uiBotModel.getActions().clear();
        uiBotModel.setPageDataIndex(null);
        uiBotModel.setPageDataKeys(null);
        uiBotModel.initMobileLayoutType();
        uiBotModel.setExecuteContext(JsonUtil.objectToJavaObject(executeContext, UiBotExecuteContext.class));
        uiBotModel.setPageBackgroudColor(org.springframework.util.StringUtils.hasLength(uiBotModel.getPageBackgroudColor())
                ?
                uiBotModel.getPageBackgroudColor()
                :
                BackgroundColorEnum.APP_MAIN_GREY.getValue());
        return uiBotModel;
    }
}
