package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.common.BackgroundColorEnum;
import com.digiwin.mobile.mobileuibot.core.common.PcmFilterUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.layout.singlelistcontainer.SingleListContainer;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.*;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.bean.PcModuleEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer.multipledatasource.UiBotModelDesignerMultipleDataSources;
import com.digiwin.mobile.mobileuibot.designer.uibot.enums.SourceCategoryEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.DigiwinAtdmRequest;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.button.UiBotQueryButton;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.LayoutComponentTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotPageLayout;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

import static com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.constant.KnowledgeMapsConstant.ENABLE_SHOW_WAY;

/**
 * <p>功能描述：标准型任务</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: BusinessProcessPerformerImpl.java
 * @Author: wangjwc
 * @Date: created at 2023/7/11 20:36
 */
@Service
public class BusinessProcessPerformerImpl extends CommonStandardPerformerGeneralPageTemplate {
    public static final String SUPPORT_KEY = "webplatform-business-process-performer-2.0";

    /**
     * 返回支持的模板
     *
     * @return
     */
    @Override
    public String supportKey() {
        return SUPPORT_KEY;
    }

    @Autowired
    private UiBotDesignerRenderService uiBotDesignerRenderService;

//
//    @Autowired
//    private ProcessTaskPatternBuilder processTaskPatternBuilder;
//
//    /**
//     * 获取动态区域的构建器
//     * @return
//     */
//    protected PageBuilder getPageBuilder(){
//        return processTaskPatternBuilder;
//    }

    //PCM成本价体现的交付设计器参数
    public static final String PCM_ENABLE_SHOW_WAY = "1";
    //PCM成本价体现的接口提交参数
    public static final String CONTRACT_AMOUNT_TYPE = "1";
    //PCM非成本价体现的交付设计器参数
    public static final String PCM_NOT_ENABLE_SHOW_WAY = "-1";
    //PCM非成本价体现的接口提交参数
    public static final String NOT_CONTRACT_AMOUNT_TYPE = "2";

    @Override
    public UiBotModel createPage(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine mainAction, List<PcUiBotTaskPageDefine> pageDefines) {
        UiBotModel uiBotModel = super.createTaskPage(apiRequest, executeContext, mainAction, pageDefines);
        if (ObjectUtils.isEmpty(uiBotModel.getRenderData())) {
            uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
        }
        // 页面内容
        this.bulidRanderData(apiRequest, mainAction, executeContext, uiBotModel, 2, null);
        // 原始数据
        uiBotModel.setRawUiBotPageData(JsonUtil.objectToJavaObject(uiBotModel.getPageData(), UiBotPageData.class));
        uiBotModel.getLayout().clear();
        uiBotModel.getPageData().clear();
        uiBotModel.getActions().clear();
        uiBotModel.setPageDataIndex(null);
        uiBotModel.setPageDataKeys(null);
        uiBotModel.initMobileLayoutType();
        uiBotModel.setExecuteContext(JsonUtil.objectToJavaObject(executeContext, UiBotExecuteContext.class));
        uiBotModel.setPageBackgroudColor(StringUtils.hasLength(uiBotModel.getPageBackgroudColor())
                ?
                uiBotModel.getPageBackgroudColor()
                :
                BackgroundColorEnum.APP_MAIN_GREY.getValue());
        return uiBotModel;
    }

    @Override
    public UiBotModel createTaskPage(ApiRequest apiRequest, PcUiBotExecuteContext executeContext,
                                     PcUiBotTaskPageDefine mainAction, List<PcUiBotTaskPageDefine> pageDefines) {
//        // 判断数据状态是否显示名称，如果任意一个显示名称，表示走tab逻辑，异步加载数据
//        if (this.useTabComponentRender(pageDefines)) {
//            // tab型页面构建，异步加载数据
//            return this.createMobileTablePage(apiRequest, executeContext, mainAction, pageDefines);
//        }
//        // 表单型页面构建，无tab组件异步加载过程
//        return this.createMobileFormPage(apiRequest, executeContext, mainAction, pageDefines);

        int type = this.useTabComponentRender(pageDefines) ? 2 : 1;
        UiBotModel uiBotModel = super.createTaskPage(apiRequest, executeContext, mainAction, pageDefines);
        if (ObjectUtils.isEmpty(uiBotModel.getRenderData())) {
            uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
        }
        if (TaskStringUtil.isBizSmartAdjust(executeContext.getTmActivityId())) {
            // 随心控(人工型：code+_task_manual;审核型：code+_task_approve) 根据PCsubmitAction构建底部按钮
            uiBotDesignerRenderService.buildSmartAdjustBottomButton(apiRequest, uiBotModel);
        }
        // 处理单身新增功能--ZtbViewList卡片列表组件与表单组件
        UiBotDesignerRenderService.handleRawPageData(apiRequest, uiBotModel);
        // 转派
        DigiwinAtmcBacklogDetail backlogDetail = uiBotDesignerRenderService.buildApprovalReassign(apiRequest, uiBotModel);
        // titleBody
        uiBotDesignerRenderService.buildTitleBody(apiRequest, uiBotModel, backlogDetail, false);
        // 构建机制参数和交付设计器参数
        uiBotDesignerRenderService.buildVariablesAndDelivery(apiRequest, uiBotModel, executeContext);

        // 构建单头
        this.buildSingleHead(apiRequest, executeContext, uiBotModel, mainAction);
        // 页面内容
        this.bulidRanderData(apiRequest, mainAction, executeContext, uiBotModel, type, null);
        //由于构建交付设计器的方法先执行，后面参数可能会被覆盖掉
        UiBotPageData rawUiBotPageData = uiBotModel.getRawUiBotPageData();
        uiBotModel.getPageData().putAll(rawUiBotPageData);
        // 原始数据
        uiBotModel.setRawUiBotPageData(JsonUtil.objectToJavaObject(uiBotModel.getPageData(), UiBotPageData.class));

        uiBotModel.getLayout().clear();
        uiBotModel.getPageData().clear();
        uiBotModel.getActions().clear();
        uiBotModel.setPageDataIndex(null);
        uiBotModel.setPageDataKeys(null);
        uiBotModel.initMobileLayoutType();
        uiBotModel.setExecuteContext(JsonUtil.objectToJavaObject(executeContext, UiBotExecuteContext.class));
        uiBotModel.setPageBackgroudColor(StringUtils.hasLength(uiBotModel.getPageBackgroudColor())
                ?
                uiBotModel.getPageBackgroudColor()
                :
                BackgroundColorEnum.APP_MAIN_GREY.getValue());
        UiBotModelDesignerMultipleDataSources.handleVssTask(apiRequest, executeContext);
        return uiBotModel;
    }

//    private UiBotModel createMobileTablePage(ApiRequest apiRequest, PcUiBotExecuteContext executeContext,
//                                             PcUiBotTaskPageDefine mainAction, List<PcUiBotTaskPageDefine> pageDefines) {
//        // 构建tab骨架，增加开关，不查询数据源
//        apiRequest.getRawData().put("not_query_datasource", true);
//        UiBotModel uiBotModel = super.createTaskPage(apiRequest, executeContext, mainAction, pageDefines);
//        if (ObjectUtils.isEmpty(uiBotModel.getRenderData())) {
//            uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
//        }
//        // 转派
//        DigiwinAtmcBacklogDetail backlogDetail = this.buildApprovalReassign(apiRequest, uiBotModel);
//        // titleBody
//        this.buildTitleBody(apiRequest, uiBotModel, backlogDetail);
//        // 页面内容
//        this.bulidRanderData(apiRequest, executeContext, uiBotModel, 3);
//        // 原始数据
//        uiBotModel.setRawUiBotPageData(JsonUtil.objectToJavaObject(uiBotModel.getPageData(), UiBotPageData.class));
//        uiBotModel.getLayout().clear();
//        uiBotModel.getPageData().clear();
//        uiBotModel.getActions().clear();
//        uiBotModel.setPageDataIndex(null);
//        uiBotModel.setPageDataKeys(null);
//        uiBotModel.initMobileLayoutType();
//        uiBotModel.setExecuteContext(JsonUtil.objectToJavaObject(executeContext, UiBotExecuteContext.class));
//        uiBotModel.setPageBackgroudColor(StringUtils.hasLength(uiBotModel.getPageBackgroudColor())
//                ?
//                uiBotModel.getPageBackgroudColor()
//                :
//                BackgroundColorEnum.APP_MAIN_GREY.getValue());
//        return uiBotModel;
//    }

//    private UiBotModel createMobileFormPage(ApiRequest apiRequest, PcUiBotExecuteContext executeContext,
//                                            PcUiBotTaskPageDefine mainAction, List<PcUiBotTaskPageDefine> pageDefines) {
//        UiBotModel uiBotModel = super.createTaskPage(apiRequest, executeContext, mainAction, pageDefines);
//        if (ObjectUtils.isEmpty(uiBotModel.getRenderData())) {
//            uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
//        }
//        // 转派
//        DigiwinAtmcBacklogDetail backlogDetail = this.buildApprovalReassign(apiRequest, uiBotModel);
//        // titleBody
//        this.buildTitleBody(apiRequest, uiBotModel, backlogDetail);
//        // 页面内容
//        this.bulidRanderData(apiRequest, executeContext, uiBotModel, 1);
//        // 原始数据
//        uiBotModel.setRawUiBotPageData(JsonUtil.objectToJavaObject(uiBotModel.getPageData(), UiBotPageData.class));
//        uiBotModel.getLayout().clear();
//        uiBotModel.getPageData().clear();
//        uiBotModel.getActions().clear();
//        uiBotModel.setPageDataIndex(null);
//        uiBotModel.setPageDataKeys(null);
//        uiBotModel.initMobileLayoutType();
//        uiBotModel.setExecuteContext(JsonUtil.objectToJavaObject(executeContext, UiBotExecuteContext.class));
//        uiBotModel.setPageBackgroudColor(StringUtils.hasLength(uiBotModel.getPageBackgroudColor())
//                ?
//                uiBotModel.getPageBackgroudColor()
//                :
//                BackgroundColorEnum.APP_MAIN_GREY.getValue());
//        return uiBotModel;
//    }

    public Boolean useTabComponentRender(List<PcUiBotTaskPageDefine> pageDefines) {
        if (CollectionUtils.isEmpty(pageDefines)) {
            return false;
        }
        return pageDefines.stream().anyMatch(r -> BooleanUtils.isTrue(r.getShowTitle()));
    }

    private void buildSingleHead(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, UiBotModel uiBotModel, PcUiBotTaskPageDefine mainAction) {
        if (BooleanUtils.isTrue(mainAction.getShowSingleHeadFrom()))
            bulidRanderData(apiRequest, mainAction, executeContext, uiBotModel, 1, LayoutComponentTypeEnum.SINGLE_HEAD.getValue());
    }

    public void bulidRanderData(ApiRequest apiRequest, PcUiBotTaskPageDefine mainAction, PcUiBotExecuteContext executeContext,
                                UiBotModel uiBotModel, int type, String componentType) {
        ComponentContext cmptContext = JsonUtil.objectToJavaObject(apiRequest, ComponentContext.class);
        cmptContext.setRawUiBotPageData(JsonUtil.objectToJavaObject(uiBotModel.getPageData(), UiBotPageData.class));
        cmptContext.setExecuteContext(executeContext);
        cmptContext.setPageDefine(mainAction);
        MobilePageRawData mobilePageRawData = new MobilePageRawData();
        mobilePageRawData.setSourceCategory(SourceCategoryEnum.TASK.name());

        // 处理页面组件数据
        this.handleRanderData(executeContext, uiBotModel, type, componentType, mobilePageRawData, cmptContext);
    }

    public void handleRanderData(PcUiBotExecuteContext executeContext, UiBotModel uiBotModel, int type, String componentType, MobilePageRawData mobilePageRawData, ComponentContext cmptContext) {
        Optional<UiBotLayout> optional = uiBotModel.getLayout().stream()
                .filter(layout ->
                        PcModuleEnum.CONTENT_QUERY_BUTTON.getValue().equalsIgnoreCase(layout.getType()))
                .findFirst();
        if (!optional.isPresent() || CollectionUtils.isEmpty(optional.get().getQueryButtons())) {
            // 添加空组件
            uiBotModel.getRenderData().addEmptyComponentToBody();
            return;
        }
        List<UiBotQueryButton> queryButtonList = optional.get().getQueryButtons();
        // 填充submitActions属性值
        queryButtonList.forEach(uiBotDesignerRenderService::buildCmptSubmitAction);

        // 高级属性--构建主页面hooks与上下文中组件级hooks
        uiBotDesignerRenderService.buildMainPageHooksByQueryButton(queryButtonList.get(0), cmptContext, uiBotModel, componentType);

        // 数据状态都不显示标题showTitle!=true
        if (type == 1) {
            // 设置数据状态code
            executeContext.setDataStateCode(queryButtonList.get(0).getDataStateCode());
            // 数据状态存在一个，不显示tabs组件
            List<BaseMobileComponentWrapper<BaseMobileComponent>> bodyCmptList =
                    this.buildBodyCmpt(executeContext, uiBotModel, cmptContext, queryButtonList.get(0), mobilePageRawData, componentType);
            if (CollectionUtils.isEmpty(bodyCmptList)) {
                // 添加空组件
                uiBotModel.getRenderData().addEmptyComponentToBody();
            } else {
                int bodyContainerType = UiBotDesignerRenderService.getBodyContainerType(bodyCmptList);
                if (bodyContainerType == 1) {
                    SingleListContainer<BaseMobileComponent> singleListContainer = new SingleListContainer<>();
                    singleListContainer.addAll(bodyCmptList);
                    uiBotModel.getRenderData().addWrapperedComponentToBody(
                            new BaseMobileComponentWrapper<>(singleListContainer, "DW_" + singleListContainer.returnComponentType()));
                } else {
                    uiBotModel.getRenderData().addWrapperedComponentListToBody(bodyCmptList);
                }

                // 构建bottom
                List<BaseMobileComponentWrapper<BaseMobileComponent>> bottomCmptList =
                        this.buildBottomCmpt(executeContext, uiBotModel, cmptContext, queryButtonList.get(0), mobilePageRawData, componentType);
                if (!CollectionUtils.isEmpty(bottomCmptList)) {
                    uiBotModel.getRenderData().addWrapperedComponentListToBottom(bottomCmptList);
                }
            }
        } else if (type == 2) {
            // 数据状态存在多个，显示tabs
            BaseMobileComponent tabs = this.buildTabs(executeContext, uiBotModel, cmptContext, queryButtonList, mobilePageRawData, componentType);
            uiBotModel.getRenderData().addWrapperedComponentToBody(
                    new BaseMobileComponentWrapper<>(tabs, "DW_" + tabs.returnComponentType()));
        }
//        else if (type == 3) {
//            // 展示数据状态tab骨架
//            BaseMobileComponent tabs = this.buildTabsSkeleton(executeContext, uiBotModel, apiRequest, queryButtonList, mobilePageRawData);
//            uiBotModel.getRenderData().addWrapperedComponentToBody(
//                    new BaseMobileComponentWrapper<>(tabs, "DW_" + tabs.returnComponentType()));
//        }
    }

    public List<BaseMobileComponentWrapper<BaseMobileComponent>> buildBottomCmpt(
            PcUiBotExecuteContext executeContext, UiBotModel uiBotModel, ComponentContext cmptContext,
            UiBotQueryButton queryButton, MobilePageRawData mobilePageRawData, String componentType) {
        List<UiBotPageLayout> pageLayout = queryButton.getPageLayout();
        if (CollectionUtils.isEmpty(pageLayout)) {
            // 未设计移动DSL，返回空组件
            return null;
        }
        // 获取主页面
        UiBotPageLayout mainPageLayout = uiBotDesignerRenderService.getMainPageLayout(pageLayout, componentType);

        String path = UiBotDesignerRenderService.getPath(queryButton);
        if (!StringUtils.hasLength(path)) {
            // 无DataSourceName，表示无数据，返回空组件
            return null;
        }
        // wjw FIXME: 2023/7/25 page中只存储了第一个数据状态下的数据源数据，其它数据状态下可能需要重新查询数据源数据
        Object dataResult = uiBotModel.getPageData().get(path);
        if (dataResult == null) {
            return null;
        }

        Map<String, Object> map = new HashMap<>();
        map.put(path, dataResult);
        cmptContext.setCanBottomButton(true);
        List<BaseMobileComponentWrapper<BaseMobileComponent>> cmptList =
                uiBotDesignerRenderService.buildCmptDsl(cmptContext, executeContext, mainPageLayout.getBottom(), map, mobilePageRawData);
        if (CollectionUtils.isEmpty(cmptList)) {
            return null;
        } else {
            return cmptList;
        }
    }

//    private BaseMobileComponent buildTabsSkeleton(PcUiBotExecuteContext executeContext, UiBotModel uiBotModel, ApiRequest apiRequest,
//                                                  List<UiBotQueryButton> queryButtonList, MobilePageRawData mobilePageRawData) {
//        CustomTabController customTabController = new CustomTabController();
//        customTabController.setSwipeable(true);
//        customTabController.setTabAlign(0);
//        List<CustomTabControllerItem> items = new ArrayList<>(queryButtonList.size());
//        customTabController.setTabLayoutType(CustomTabControllerItemLayoutTypeEnum.HORIZONTAL.getValue());
//        customTabController.setTabItems(items);
//        for (int i = 0; i < queryButtonList.size(); i++) {
//            if (BooleanUtils.isNotTrue(queryButtonList.get(i).getShowTitle())) {
//                // 不显示标题，直接continue
//                continue;
//            }
//            CustomTabControllerItem item = new CustomTabControllerItem();
//            items.add(item);
//            item.setFlushType(1);
//            item.setContentUseSchema(CustomTabControllerItemContentEnum.CONTENT_AREA.getValue());
//            UiBotQueryButton queryButton = queryButtonList.get(i);
//            if (i == 0 && !CollectionUtils.isEmpty(queryButton.getPageLayout())) {
//                List<UiBotPageLayout> pageLayout = queryButton.getPageLayout();
//                UiBotPageLayout mainPageLayout = pageLayout.get(0);
//                uiBotModel.setShowMore(mainPageLayout.getShowMore());
//                uiBotModel.setPageBackgroudColor(mainPageLayout.getPageBackgroudColor());
//            }
//            String tabTitle = queryButton.getQueryTitle();
//            item.setId(queryButton.getDataStateCode());
//            item.setName(tabTitle);
//            item.setLayoutType(1);
//            item.setScrollable(true);
//            item.setContentArea(new CustomTabContentArea());
//            item.setAsyncForData(true);
//            Map<String, Object> rawData = JsonUtil.objectToJavaObject(queryButton,
//                    new TypeReference<Map<String, Object>>() {
//                    });
//            rawData.put("executeContext", executeContext);
//
//            // 塞入异步请求配置
//            item.setAsyncConfig(CustomTabControllerItemAsyncConfig.create(
//                    apiRequest.getIamUserToken(),
//                    apiRequest.getLocale(), item.getId(),
//                    AppContext.getBaseUrl() + "/mobile/v1/uibot/action/show",
//                    apiRequest.getClientId(), apiRequest.getTenantId(), rawData));
//            item.setAsyncResponseType(CustomTabControllerItemAsyncResponseTypeEnum.UIBOTMODE.getType());
//        }
//        return customTabController;
//    }

    private BaseMobileComponent buildTabs(PcUiBotExecuteContext executeContext, UiBotModel uiBotModel, ComponentContext cmptContext,
                                          List<UiBotQueryButton> queryButtonList, MobilePageRawData mobilePageRawData, String componentType) {
        CustomTabController customTabController = new CustomTabController();
        customTabController.setSwipeable(true);
        customTabController.setTabAlign(0);
        List<CustomTabControllerItem> items = new ArrayList<>(queryButtonList.size());
        customTabController.setTabLayoutType(CustomTabControllerItemLayoutTypeEnum.HORIZONTAL.getValue());
        customTabController.setTabItems(items);
        customTabController.setDefaultSelected(0);
        for (int i = 0; i < queryButtonList.size(); i++) {
            // 现只使用与项目卡中
            if (BooleanUtils.isTrue(queryButtonList.get(i).getIsDefault())) {
                customTabController.setDefaultSelected(i);
            }
        }
        for (int i = 0; i < queryButtonList.size(); i++) {
            if (BooleanUtils.isNotTrue(queryButtonList.get(i).getShowTitle())) {
                // 不显示标题，直接continue
                continue;
            }
            CustomTabControllerItem item = new CustomTabControllerItem();
            items.add(item);
            item.setFlushType(1);
            item.setContentUseSchema(CustomTabControllerItemContentEnum.CONTENT_AREA.getValue());
            UiBotQueryButton queryButton = queryButtonList.get(i);
            String tabTitle = queryButton.getQueryTitle();
            item.setId(queryButton.getDataStateCode());
            item.setName(tabTitle);
            item.setLayoutType(CustomTabControllerItemLayoutTypeEnum.VERTICAL.getValue());
            item.setScrollable(true);
            CustomTabContentArea contentArea = new CustomTabContentArea();
            if (i == customTabController.getDefaultSelected()) {
                // 设置数据状态code
                executeContext.setDataStateCode(queryButton.getDataStateCode());
                item.setContentArea(contentArea);
                item.setAsyncForData(false);

                List<BaseMobileComponentWrapper<BaseMobileComponent>> bodyCmptList =
                        this.buildBodyCmpt(executeContext, uiBotModel, cmptContext, queryButton, mobilePageRawData, componentType);
                if (CollectionUtils.isEmpty(bodyCmptList)) {
                    CustomTabContentContainer<BaseMobileComponent> customTabContentContainer = CustomTabContentContainer.emptyContainerUnContainCustomGroup(cmptContext.getLocale());
                    customTabContentContainer.setContentCmptType("DW_" + customTabContentContainer.getContentCmptType());
                    contentArea.getBodyArea().add(customTabContentContainer);
                } else {
                    contentArea.getBodyArea().addAll(bodyCmptList
                            .stream()
                            .map(r -> {
                                CustomTabContentContainer<BaseMobileComponent> container = new CustomTabContentContainer<>();
                                container.setMobilePath(r.getMobilePath());
                                container.setSchema(r.getSchema());
                                container.setContentCmptType(r.getComponentType());
                                container.setData(r.getData());
                                return container;
                            })
                            .collect(Collectors.toList()));

                    // 构建bottom
                    List<BaseMobileComponentWrapper<BaseMobileComponent>> bottomCmptList =
                            this.buildBottomCmpt(executeContext, uiBotModel, cmptContext, queryButton, mobilePageRawData, componentType);
                    if (!CollectionUtils.isEmpty(bottomCmptList)) {
                        contentArea.getBottomArea().addAll(bottomCmptList
                                .stream()
                                .map(r -> {
                                    CustomTabContentContainer<BaseMobileComponent> container = new CustomTabContentContainer<>();
                                    container.setMobilePath(r.getMobilePath());
                                    container.setSchema(r.getSchema());
                                    container.setContentCmptType(r.getComponentType());
                                    container.setData(r.getData());
                                    return container;
                                })
                                .collect(Collectors.toList()));
                    }
                }

                // 塞入内容
                contentArea.resetSize();
            } else {
                item.setContentArea(contentArea);
                item.setAsyncForData(true);
                contentArea.setSize(0);

                Map<String, Object> rawData = JsonUtil.objectToJavaObject(queryButton,
                        new TypeReference<Map<String, Object>>() {
                        });
                PcUiBotExecuteContext newExecuteContext = JsonUtil.objectToJavaObject(executeContext, PcUiBotExecuteContext.class);
                // 设置数据状态code
                newExecuteContext.setDataStateCode(queryButton.getDataStateCode());
                rawData.put("executeContext", newExecuteContext);
                // rawdata中存入代理token，此值在拦截器中处理
                rawData.put("digi-proxy-token", AppRequestContext.getContextEntity().getProxyToken());

                // 塞入异步请求配置
                item.setAsyncConfig(CustomTabControllerItemAsyncConfig.create(
                        cmptContext.getIamUserToken(),
                        cmptContext.getLocale(), cmptContext.getRequestId(),
                        AppContext.getBaseUrl() + "/mobile/v1/uibot/action/show",
                        cmptContext.getClientId(), cmptContext.getTenantId(), rawData));
                item.setAsyncResponseType(CustomTabControllerItemAsyncResponseTypeEnum.UIBOTMODE.getType());
            }
        }
        return customTabController;
    }

    public List<BaseMobileComponentWrapper<BaseMobileComponent>> buildBodyCmpt(
            PcUiBotExecuteContext executeContext, UiBotModel uiBotModel, ComponentContext cmptContext,
            UiBotQueryButton queryButton, MobilePageRawData mobilePageRawData, String componentType
    ) {
        List<UiBotPageLayout> pageLayout = queryButton.getPageLayout();
        if (CollectionUtils.isEmpty(pageLayout)) {
            // 未设计移动DSL，返回空组件
            return null;
        }
        // 获取主页面所有的pageID和数据源
        cmptContext.setPageLayoutInfo(queryButton.getPageLayoutInfo());
        // 获取主页面
        UiBotPageLayout mainPageLayout = uiBotDesignerRenderService.getMainPageLayout(pageLayout, componentType);
        uiBotModel.setTitleVisible(mainPageLayout.getTitleVisible());
        // 设计器配置标题隐藏时，设置title为空字符串，flutter端根据标题为空默认隐藏
        uiBotModel.setPageTitle(BooleanUtils.isTrue(mainPageLayout.getTitleVisible()) ? mainPageLayout.getTitle() : "");
        uiBotModel.setShowMore(mainPageLayout.getShowMore());
        uiBotModel.setPageBackgroudColor(mainPageLayout.getPageBackgroudColor());

        String path = UiBotDesignerRenderService.getPath(queryButton);
        if (!StringUtils.hasLength(path)) {
            // 无DataSourceName，表示无数据，返回空组件
            return null;
        }
        // wjw FIXME: 2023/7/25 page中只存储了第一个数据状态下的数据源数据，其它数据状态下可能需要重新查询数据源数据
        Object dataResult = uiBotModel.getPageData().get(path);
        if (dataResult == null) {
            // 无数据
            List<BaseMobileComponentWrapper<BaseMobileComponent>> cmptList =
                    uiBotDesignerRenderService.buildCmptDsl(cmptContext, executeContext, mainPageLayout.getBody(), new HashMap<>(), mobilePageRawData);
            if (CollectionUtils.isEmpty(cmptList)) {
                return null;
            } else {
                return cmptList;
            }
        } else if (dataResult instanceof List) {
            mobilePageRawData.setRawDataType("array");
            List<Map<String, Object>> list = (List<Map<String, Object>>) dataResult;
            // wjw TODO: 2023/11/29 先注释掉，因数据录入新增，结果为空集合导致直接返回
//            if (CollectionUtils.isEmpty(list)) {
//                return null;
//            } else {
            // wjw FIXME: 2023/7/25 待处理 判断DSL中是否存在列表组件，不存在，则取第一条数据展示
            // 是数组，表示表格
            if (UiBotDesignerRenderService.isContainListComponent(mainPageLayout.getBody())) {
                Map<String, Object> map = new HashMap<>();
                // 任务详情页列表标记
                map.put(UiBotDesignerRenderService.LIST_MARKER, true);
                map.put(path, list);
                List<BaseMobileComponentWrapper<BaseMobileComponent>> cmptList =
                        uiBotDesignerRenderService.buildCmptDsl(cmptContext, executeContext, mainPageLayout.getBody(), map, mobilePageRawData);
                if (CollectionUtils.isEmpty(cmptList)) {
                    return null;
                } else {
                    return cmptList;
                }
            } else {
                if (!CollectionUtils.isEmpty(list)) {
                    // PCM_项目预算签核定制
                    Map<String, Object> newData = this.customizePcmBudgetProjectApprovals(list.get(0), executeContext, uiBotModel);
                    List<BaseMobileComponentWrapper<BaseMobileComponent>> cmptList =
                            uiBotDesignerRenderService.buildCmptDsl(cmptContext, executeContext, mainPageLayout.getBody(), newData, mobilePageRawData);
                    if (CollectionUtils.isEmpty(cmptList)) {
                        return null;
                    } else {
                        return cmptList;
                    }
                } else {
                    // 注意：一定要返回null，否则会导致任务卡渲染错误，如pcc手动任务
                    return null;
                }

            }
//            }
        } else if (dataResult instanceof Map) {
            mobilePageRawData.setRawDataType("object");
            // 是对象，表示表单
            Map<String, Object> map = (Map<String, Object>) dataResult;
            // wjw TODO: 2023/11/29 先注释掉，因数据录入新增，结果为空集合导致直接返回
//            if (CollectionUtils.isEmpty(map)) {
//                return null;
//            } else {
            List<BaseMobileComponentWrapper<BaseMobileComponent>> cmptList =
                    uiBotDesignerRenderService.buildCmptDsl(cmptContext, executeContext, mainPageLayout.getBody(), map, mobilePageRawData);
            if (CollectionUtils.isEmpty(cmptList)) {
                return null;
            } else {
                return cmptList;
            }
//            }
        } else {
            // 其它
            List<BaseMobileComponentWrapper<BaseMobileComponent>> cmptList =
                    uiBotDesignerRenderService.buildCmptDsl(cmptContext, executeContext, mainPageLayout.getBody(), new HashMap<>(), mobilePageRawData);
            if (CollectionUtils.isEmpty(cmptList)) {
                return null;
            } else {
                return cmptList;
            }
        }
    }

    private Map<String, Object> customizePcmBudgetProjectApprovals(Map<String, Object> data, PcUiBotExecuteContext executeContext, UiBotModel uiBotModel) {
        if (!PcmFilterUtil.isPcmCustomized(executeContext.getTmActivityId(), executeContext.getTmProjectId())) {
            return data;
        }
        // PCM_项目预算签核定制 --- tab下数据 来源于调用新数据源获取
        return this.customizePcmBudgetProjectApprovalsData(data, executeContext, uiBotModel);
    }

    private Map<String, Object> customizePcmBudgetProjectApprovalsData(Map<String, Object> data, PcUiBotExecuteContext executeContext, UiBotModel uiBotModel) {
        Map<String, Object> bpmData = Optional.ofNullable(executeContext.getBpmData()).orElse(new HashMap<>());
        Map<String, Object> parameter = new HashMap<>(2);
        //获取UiBotModel中的PCM交付设计器参数uiBot__variables
        String contract_amount_type = CONTRACT_AMOUNT_TYPE;
        if (uiBotModel.getRawUiBotPageData() != null) {
            if (uiBotModel.getRawUiBotPageData().get("uiBot__variables") instanceof Map) {
                if (PCM_ENABLE_SHOW_WAY.equals(((Map) uiBotModel.getRawUiBotPageData().get("uiBot__variables")).get(ENABLE_SHOW_WAY))) {
                    contract_amount_type = CONTRACT_AMOUNT_TYPE;
                } else if (PCM_NOT_ENABLE_SHOW_WAY.equals(((Map) uiBotModel.getRawUiBotPageData().get("uiBot__variables")).get(ENABLE_SHOW_WAY))) {
                    contract_amount_type = NOT_CONTRACT_AMOUNT_TYPE;
                }
            }
        }
        if ("budgetProjectApprovals_DTD".equals(executeContext.getTmActivityId()) ||
                "projectBudgetConfirmationApproval_DTD".equals(executeContext.getTmActivityId()) ||
                "projectBudgetConfirmation_DTD".equals(executeContext.getTmActivityId())) {
            parameter.put("project_no", bpmData.get("project_no"));
            parameter.put("version_no", bpmData.get("version_no"));
        } else if ("projectMaterialApproval_DTD".equals(executeContext.getTmActivityId())) {
            parameter.put("project_no", bpmData.get("project_no"));
            parameter.put("project_budget_item_info", bpmData.get("project_budget_item_info_material"));
        } else if ("projectCostApproval_DTD".equals(executeContext.getTmActivityId())) {
            parameter.put("project_no", bpmData.get("project_no"));
            parameter.put("version_no", bpmData.get("version_no"));
            parameter.put("project_budget_item_info", bpmData.get("project_budget_item_info_cost"));
        }
        parameter.put("contract_amount_type", contract_amount_type);
        DigiwinAtdmRequest request = DigiwinAtdmRequest.create("bm.pcsc.budget.get",
                parameter,
                JsonUtil.objectToJavaObject(executeContext, Map.class),
                JsonUtil.objectToJavaObject(executeContext.getBusinessUnit(), Map.class)
        );
        DigiwinAthenaApiResponse<Map<String, Object>> athenaApiResponse = SpringContextHolder.getBean(DigiwinAtdmProxyService.class)
                .dataQueryByActionId(
                        AppRequestContext.getContextEntity().getLocale(),
                        AppRequestContext.getContextEntity().getIamUserToken(),
                        JsonUtil.javaObjectToJsonString(request),
                        AppRequestContext.getContextEntity().getTenantId()
                );
        if (athenaApiResponse == null) {
            return data;
        }
        Map<String, Object> map = athenaApiResponse.getResponse();
        if (map == null) {
            return data;
        }
        // 以主数据源结构构建
        List<Map<String, Object>> projectBudgetItemInfo = (List<Map<String, Object>>) map.get("project_budget_item_info");
        map.remove("project_budget_item_info");
        map.put("project_budget_item_detail", projectBudgetItemInfo);
        List<Map<String, Object>> projectExpenseBudgetInfo = (List<Map<String, Object>>) map.get("project_expense_budget_info");
        map.remove("project_expense_budget_info");
        map.put("project_expense_budget_detail", projectExpenseBudgetInfo);
        List<Map<String, Object>> projectMaterialBudgetInfo = (List<Map<String, Object>>) map.get("project_material_budget_info");
        map.remove("project_material_budget_info");
        map.put("project_material_budget_detail", projectMaterialBudgetInfo);
        if (!CollectionUtils.isEmpty(projectMaterialBudgetInfo)) {
            projectMaterialBudgetInfo.forEach(item -> {
                List<Map<String, Object>> projectMaterialBudgetDetail = (List<Map<String, Object>>) item.get("project_material_budget_detail");
                item.remove("project_material_budget_detail");
                item.put("project_material_budget_subitem_detail", projectMaterialBudgetDetail);
            });
        }
        String versionNo = String.valueOf(data.get("version_no"));
        map.put("version_no", versionNo);
        //处理版本号
        this.handleVersionNo(map, versionNo);
        // 处理栏位精度
        this.customizePcmBudgetProjectApprovalsPrecision(map, executeContext);
        return map;
    }

    private void customizePcmBudgetProjectApprovalsPrecision(Map<String, Object> map, PcUiBotExecuteContext executeContext) {
        String eocCompanyId = Optional.ofNullable(executeContext.getBusinessUnit()).map(r -> r.get("eoc_company_id")).map(StringUtil::valueOf).orElse(null);
        if (!StringUtils.hasLength(eocCompanyId)) {
            return;
        }
        try {
            CompletableFuture<Map<String, Object>> currencyAsync = CompletableFuture.supplyAsync(() -> {
                Map<String, Object> parameter = new HashMap<>(1);
                Map<String, Object> query_condition = new HashMap<>(1);
                query_condition.put("eoc_company_id", eocCompanyId);
                parameter.put("query_condition", Lists.newArrayList(query_condition));
                DigiwinAtdmRequest request = DigiwinAtdmRequest.create("bm.cisc.currency.parameter.get",
                        parameter,
                        JsonUtil.objectToJavaObject(executeContext, Map.class),
                        JsonUtil.objectToJavaObject(executeContext.getBusinessUnit(), Map.class)
                );
                DigiwinAthenaApiResponse<Map<String, Object>> athenaApiResponse = SpringContextHolder.getBean(DigiwinAtdmProxyService.class)
                        .dataQueryByActionId(
                                AppRequestContext.getContextEntity().getLocale(),
                                AppRequestContext.getContextEntity().getIamUserToken(),
                                JsonUtil.javaObjectToJsonString(request),
                                AppRequestContext.getContextEntity().getTenantId()
                        );
                if (athenaApiResponse == null) {
                    return new HashMap<>();
                }
                Map<String, Object> currencyMap = athenaApiResponse.getResponse();
                if (currencyMap == null) {
                    return new HashMap<>();
                }
                List<Map<String, Object>> currency_data = (List<Map<String, Object>>) currencyMap.get("currency_data");
                if (CollectionUtils.isEmpty(currency_data)) {
                    return new HashMap<>();
                }
                return currency_data.stream()
                        .filter(r -> eocCompanyId.equals(r.get("eoc_company_id")))
                        .findFirst().orElse(new HashMap<>());
            }, this.threadPoolTaskExecutor);
            Map<String, Object> currencyMap = currencyAsync.get();
            if (currencyMap == null || currencyMap.isEmpty()) {
                return;
            }
            // 金额(cost_amount) 小数点保留位数
            String costDecimalPlaces = StringUtil.valueOf(((Number) currencyMap.get("cost_decimal_places")).intValue());
            // 单价(price) 小数点保留位数
            String unitIssueCostDecimalPlaces = StringUtil.valueOf(((Number) currencyMap.get("unit_production_cost_decimal_places")).intValue());
            // exist_previous_budget：true时需要展示新旧值，fasle不需要展示新旧值
            String existPreviousBudget = StringUtil.valueOf(map.get("exist_previous_budget"));
            // 处理栏位小数位数
            this.handleDecimalPlaces(map, costDecimalPlaces, unitIssueCostDecimalPlaces, existPreviousBudget);
        } catch (Exception ignored) {
        }
    }

    private void handleVersionNo(Map<String, Object> map, String versionNo) {
        if (CollectionUtils.isEmpty(map)) {
            return;
        }
        map.put("mobile_version_no", versionNo);
        map.forEach((k, v) -> {
            if (v != null) {
                if (v instanceof Map) {
                    handleVersionNo((Map<String, Object>) v, versionNo);
                } else if (v instanceof List) {
                    List list = (List) v;
                    if (!CollectionUtils.isEmpty(list)) {
                        for (Object o : list) {
                            if (o instanceof Map) {
                                handleVersionNo((Map<String, Object>) o, versionNo);
                            }
                        }
                    }
                }
            }
        });
    }

    private void handleDecimalPlaces(Map<String, Object> map, String costDecimalPlaces, String unitIssueCostDecimalPlaces, String existPreviousBudget) {
        if (CollectionUtils.isEmpty(map)) {
            return;
        }
        map.put("mobile_cost_decimal_places", costDecimalPlaces);
        map.put("mobile_unit_issue_cost_decimal_places", unitIssueCostDecimalPlaces);
        map.put("mobile_exist_previous_budget", existPreviousBudget);
        map.forEach((k, v) -> {
            if (v != null) {
                if (v instanceof Map) {
                    handleDecimalPlaces((Map<String, Object>) v, costDecimalPlaces, unitIssueCostDecimalPlaces, existPreviousBudget);
                } else if (v instanceof List) {
                    List list = (List) v;
                    if (!CollectionUtils.isEmpty(list)) {
                        for (Object o : list) {
                            if (o instanceof Map) {
                                handleDecimalPlaces((Map<String, Object>) o, costDecimalPlaces, unitIssueCostDecimalPlaces, existPreviousBudget);
                            }
                        }
                    }
                }
            }
        });
    }

}