package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProjectData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.button.UiBotQueryButton;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotPropertyPlaceholderUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * <p>功能描述：项目卡标准模板</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: CommonStandardChargeGeneralPageTemplate.java
 * @Author: wangjwc
 * @Date: created at 2024/12/4 17:10
 */
@Slf4j
@Service
public class CommonStandardChargeGeneralPageTemplate extends GeneralPageTemplate<PcUiBotTaskPageDefine> {
    /**
     * 返回支持的模板
     *
     * @return
     */
    @Override
    public String supportKey() {
        return PcUiBotConstants.WEB_PLATFORM + "-common-" + PcUiBotActivityConstants.CHARGE;
    }

    @Override
    public UiBotModel createPage(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine mainAction, List<PcUiBotTaskPageDefine> pageDefines) {
        if (!CollectionUtils.isEmpty(pageDefines) && pageDefines.size() > 1) {
            mainAction = this.handleDefaultPageDefine(apiRequest, executeContext, mainAction, pageDefines);
        }
        return super.createPage(apiRequest, executeContext, mainAction, pageDefines);
    }

    @Override
    public UiBotModel createTaskPage(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine mainAction, List<PcUiBotTaskPageDefine> pageDefines) {
        if (!CollectionUtils.isEmpty(pageDefines) && pageDefines.size() > 1) {
            mainAction = this.handleDefaultPageDefine(apiRequest, executeContext, mainAction, pageDefines);
        }
        return super.createTaskPage(apiRequest, executeContext, mainAction, pageDefines);
    }

    /**
     * 创建布局
     *
     * @param executeContext
     * @param queryResultSet
     * @param pageDefine
     * @param dynamicForm
     */
    @Override
    protected void BuildLayout(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, QueryResultSet queryResultSet,
                               PcUiBotTaskPageDefine pageDefine, List<PcUiBotTaskPageDefine> pageDefines,
                               UiBotModel dynamicForm) {
        super.BuildLayout(apiRequest, executeContext, queryResultSet, pageDefine, pageDefines, dynamicForm);
        List<UiBotLayout> layout = new ArrayList<>();
        dynamicForm.setLayout(layout);

        //创建动态区域的组件
        if (!CollectionUtils.isEmpty(pageDefines)) {
            UiBotLayout queryButtonComponent = createQueryButton(queryResultSet, pageDefines);
            layout.add(queryButtonComponent);
        }
    }

    protected UiBotLayout createQueryButton(QueryResultSet queryResultSet, List<PcUiBotTaskPageDefine> pageDefines) {
        UiBotLayout queryButtonComponent = new UiBotLayout();
        queryButtonComponent.setId(UUID.randomUUID().toString());
        queryButtonComponent.setType("CONTENT_QUERY_BUTTON");
        queryButtonComponent.setQueryButtons(JsonUtil.objectToJavaObject(pageDefines,
                new TypeReference<List<UiBotQueryButton>>() {
                }));
        return queryButtonComponent;
    }

    @Override
    protected void BuildPageInfo(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, UiBotModel dynamicForm) {
        dynamicForm.setFinished(pageDefine.getFinished());
        dynamicForm.setFinishedTitle(pageDefine.getFinishedTitle());
    }

    @Override
    protected void BuildRule(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, UiBotModel dynamicForm, QueryResultSet queryResultSet) {
        List<UiBotRule> rules = pcRuleService.buildRuleOfKm(executeContext.getTmActivityId(), apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId());
        if (!CollectionUtils.isEmpty(rules)) {
            dynamicForm.setRules(rules);
        }
    }

    /**
     * 创建数据源
     *
     * @param executeContext
     * @param pageDefine
     * @param dynamicForm
     */
    @Override
    public QueryResultSet BuildDataSource(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, UiBotModel dynamicForm, ApiRequest apiRequest) {
        QueryResultSet queryResultSet = super.BuildDataSource(executeContext, pageDefine, dynamicForm, apiRequest);
        Map<String, Object> pageData = dynamicForm.getPageData();
        PcUiBotTaskData taskData = createTaskData(executeContext, pageDefine, queryResultSet);
        //设置uibot相关的数据
        pageData.put(PcUiBotConstants.UIBOT_FIELDS_ACTIVITY, taskData);

        Map<String, String> templateContentData = new HashMap<>();
        String contentTitle = taskData.getName();
        if (StringUtils.isNotBlank(contentTitle)) {
            templateContentData.put("title", contentTitle);
            templateContentData.put("subTitle", contentTitle);
        }
        pageData.put("uiBot__content", templateContentData);
        pageData.put("uiBot__prompt_message", "");
        return queryResultSet;
    }

    protected PcUiBotTaskData createTaskData(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine, QueryResultSet queryResultSet) {
        PcUiBotTaskData taskDetailDTO = new PcUiBotTaskData();
        String titleDefine = pageDefine.getTitle();
        if (titleDefine != null) {
            String title = titleDefine;
            if (titleDefine.contains("$(") && queryResultSet != null) {
                QueryResult queryResult = queryResultSet.getMainQueryResult();
                if (queryResult.size() > 0) {
                    Pattern p = Pattern.compile("\\$\\((?<var>.*?)\\)");
                    Matcher m = p.matcher(titleDefine);
                    while (m.find()) {
                        String varName = m.group("var");
                        Object varValue = queryResult.getData().get(0).get(varName).toString();
                        title = title.replace("$(" + varName + ")", varValue.toString());
                    }
                }

            }
            taskDetailDTO.setTitle(title);
        }

        taskDetailDTO.setDescription(pageDefine.getDescription());

        DigiwinAtmcTaskWithBacklogData taskData = executeContext.getTaskWithBacklogData();

        // 使用流程变量中值，替换title、description中的占位符
        if (taskData != null && !CollectionUtils.isEmpty(taskData.getBpmData())) {
            Map<String, Object> bpmData = taskData.getBpmData();
            if (bpmData.containsKey("__DERIVE_MAIN_TASK")) {
                taskDetailDTO.setDeriveMainTask(bpmData.get("__DERIVE_MAIN_TASK"));
            }
            taskDetailDTO.setTitle(PcUiBotPropertyPlaceholderUtil.resolve(taskDetailDTO.getTitle(), bpmData));
            taskDetailDTO.setDescription(PcUiBotPropertyPlaceholderUtil.resolve(taskDetailDTO.getDescription(), bpmData));
        }

        taskDetailDTO.setSubDescription(pageDefine.getSubDescription());


        if (pageDefine.getDataSourceSet().isEmpty()
                || executeContext.getProjectData() == null
                || taskData == null) {
            return taskDetailDTO;
        }

        if (!CollectionUtils.isEmpty(taskData.getEocName())) {
            taskDetailDTO.setEocName(taskData.getEocName());
        }

        if (executeContext.getApprovalInfo() != null && executeContext.getApprovalInfo().getSubState() != null) {
            taskDetailDTO.setApprovalInfo(executeContext.getApprovalInfo());
        }

        DigiwinAtmcProjectData projectData = executeContext.getProjectData();
        DigiwinAtmcBacklogData backlogData = new DigiwinAtmcBacklogData();
        List<DigiwinAtmcBacklogData> backlog = taskData.getBacklog();
        if (!CollectionUtils.isEmpty(backlog)) {
            backlogData = backlog.get(0);
        }
        taskDetailDTO.setTaskStartTime(projectData.getStartTime());
        taskDetailDTO.setRemainTime(backlogData.getRemainTime());
        taskDetailDTO.setReadCount(backlogData.getReadCount());
        taskDetailDTO.setTaskEndTime(projectData.getEndTime());
        taskDetailDTO.setTaskName(projectData.getProjectName());
        if (projectData.getProcessCreateTime() == null) {
            taskDetailDTO.setProcessCreateTime(projectData.getStartTime());
        } else {
            taskDetailDTO.setProcessCreateTime(projectData.getProcessCreateTime());
        }
        if (backlogData != null && StringUtils.isNotEmpty(backlogData.getBacklogName())) {
            taskDetailDTO.setName(backlogData.getBacklogName());
            taskDetailDTO.setProcessSerialNumber(taskData.getProcessSerialNumber());
            if (!CollectionUtils.isEmpty(backlogData.getWorkitemList())) {
                taskDetailDTO.setWorkitemId(backlogData.getWorkitemList().get(0).get("workitemId").toString());
            }
        } else {
            taskDetailDTO.setName(taskData.getTmActivityName());
        }
        taskDetailDTO.setSubName(pageDefine.getSubTitle());
        taskDetailDTO.setSteps(taskData.getSteps());
        taskDetailDTO.setApprovalState(taskData.getApprovalState());
        //逾期
        taskDetailDTO.setOverdueDate(backlogData.getOverdueDate());
        taskDetailDTO.setEndTime(backlogData.getPlanEndTime());
        //扩展数据
        Map<String, Object> extend = new HashMap<>();
        taskDetailDTO.setExtendedFields(extend);
        Map<String, Object> signOffData = new HashMap<>();
        signOffData.put("locale", AppRequestContext.getContextEntity().getLocale());
        extend.put("signOffProgressData", signOffData);
        List<Map> processInstances = new ArrayList<>();
        if (taskData.getRelationApproval() != null) {
            Map<String, Object> process = taskData.getRelationApproval();
            process.putAll(taskData.getRelationApproval());
            processInstances.add(process);
            signOffData.put("processInstances", processInstances);
        } else {
            Map<String, Object> process = new HashMap<>();
            process.put("processSerialNumber", taskData.getProcessSerialNumber());
            process.put("tmActivityIds", new String[]{taskData.getTmActivityId()});
            if (backlogData != null && backlogData.getBacklogId() != null) {
                process.put("workitemId", backlogData.getBacklogId());
            }
            processInstances.add(process);
            signOffData.put("processInstances", processInstances);
        }
        taskDetailDTO.setMerge(backlogData.getMerge());
        taskDetailDTO.setPlanEndTimeMin(backlogData.getPlanEndTimeMin());
        taskDetailDTO.setPlanEndTimeMax(backlogData.getPlanEndTimeMax());
        return taskDetailDTO;
    }
}
