package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProjectData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.button.UiBotQueryButton;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotPropertyPlaceholderUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * <p>功能描述：任务卡标准页面</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: CommonStandardPerformerGeneralPageTemplate.java
 * @Author: wangjwc
 * @Date: created at 2023/7/11 20:37
 */
@Slf4j
@Service
public class CommonStandardPerformerGeneralPageTemplate extends GeneralPageTemplate<PcUiBotTaskPageDefine> {

    private static final String COMPONENT_TYPE = "ACTIVITY_TITLE";
    private static final String COMPONENT_ACTIVITY_DESCRIPTION = "ACTIVITY_DESCRIPTION";

    /**
     * 返回支持的模板
     *
     * @return
     */
    @Override
    public String supportKey() {
        return PcUiBotConstants.WEB_PLATFORM + "-common-" + PcUiBotActivityConstants.PERFORMER;
    }

//    /**
//     * 获取动态区域的构建器
//     *
//     * @return
//     */
//    protected PageBuilder getPageBuilder() {
//        return super.pageBuilder;
//    }

    @Override
    public UiBotModel createTaskPage(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine mainAction, List<PcUiBotTaskPageDefine> pageDefines) {
        if (!CollectionUtils.isEmpty(pageDefines) && pageDefines.size() > 1) {
            //工单上线已完成单头显示不出来的问题，怕影响其他卡，先定制处理
            if (Objects.equals(executeContext.getTmActivityId(), "apc_workShopOnline")) {
                mainAction = this.handleDefaultPageDefine(apiRequest, executeContext, mainAction, pageDefines);
            }
            //合并工时已完成单头显示不出来的问题- 合并工时没有show接口，返回的数据需要过滤数据状态
            if (Objects.equals(executeContext.getTmActivityId(), "apc_mergeWork")) {
                mainAction = this.handleDefaultPageDefineByFilter(apiRequest, executeContext, mainAction, pageDefines);
            }
        }
        return super.createTaskPage(apiRequest, executeContext, mainAction, pageDefines);
    }


    /**
     * 创建数据源
     *
     * @param pageDefine
     * @param dynamicForm
     */
    @Override
    public QueryResultSet BuildDataSource(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, UiBotModel dynamicForm, ApiRequest apiRequest) {
        QueryResultSet queryResultSet = super.BuildDataSource(executeContext, pageDefine, dynamicForm, apiRequest);
        Map<String, Object> pageData = dynamicForm.getPageData();
        PcUiBotTaskData taskData = createTaskData(executeContext, pageDefine, queryResultSet);
        //设置uibot相关的数据
        pageData.put(PcUiBotConstants.UIBOT_FIELDS_ACTIVITY, taskData);

        Map<String, String> templateContentData = new HashMap<>();
        String contentTitle = taskData.getName();
        if (StringUtils.isNotBlank(contentTitle)) {
            templateContentData.put("title", contentTitle);
            templateContentData.put("subTitle", contentTitle);
        }
        pageData.put("uiBot__content", templateContentData);
        pageData.put("uiBot__prompt_message", "");
        return queryResultSet;
    }

    /**
     * 创建布局
     *
     * @param executeContext
     * @param queryResultSet
     * @param pageDefine
     * @param dynamicForm
     */
    @Override
    protected void BuildLayout(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, QueryResultSet queryResultSet,
                               PcUiBotTaskPageDefine pageDefine, List<PcUiBotTaskPageDefine> pageDefines,
                               UiBotModel dynamicForm) {
        super.BuildLayout(apiRequest, executeContext, queryResultSet, pageDefine, pageDefines, dynamicForm);
        List<UiBotLayout> layout = new ArrayList<>();
        dynamicForm.setLayout(layout);

        //创建头部信息
        createHeader(executeContext, pageDefine, layout);

        //创建动态区域的组件
        if (!CollectionUtils.isEmpty(pageDefines)) {
            UiBotLayout queryButtonComponent = createQueryButton(queryResultSet, pageDefines);
//            queryButtonComponent.setSupportShowInMaxedWindow(true);
            layout.add(queryButtonComponent);

            //非客制的才走动态构建逻辑
//            if (!isCustomize(executeContext)) {
//                UiBotModel dynamicFormByTag = null;//getPageBuilder().createPage(executeContext, queryResultSet, pageDefine);
//                if (dynamicFormByTag != null) {
//                    if (dynamicFormByTag.getLayout() != null && dynamicFormByTag.getLayout().size() > 0) {
//                        //页面最大化时显示的区域
//                        for (UiBotLayout component : dynamicFormByTag.getLayout()) {
////                            component.setSupportShowInMaxedWindow(true);
//                        }
//                        dynamicForm.getLayout().addAll(dynamicFormByTag.getLayout());
//                    }
//                    if (CollUtil.isNotEmpty(dynamicFormByTag.getRules())) {
//                        dynamicForm.getRules().addAll(dynamicFormByTag.getRules());
//                    }
//                    if (null != dynamicFormByTag.getStyle()) {
////                        dynamicForm.getStyle().putAll(dynamicFormByTag.getStyle());
//                    }
//                    // 合并解析DataSource和解析Layout产生的pageData
//                    if (!CollectionUtils.isEmpty(dynamicFormByTag.getPageData())) {
//                        if (null == dynamicForm.getPageData()) {
////                            dynamicForm.setPageData(new HashMap<>());
//                        }
//                        dynamicForm.getPageData().putAll(dynamicFormByTag.getPageData());
//                    }
//                    // 机制规则
////                    if (!CollectionUtils.isEmpty(dynamicFormByTag.getMechnismConfig())) {
////                        dynamicForm.setMechnismConfig(dynamicFormByTag.getMechnismConfig());
////                    }
//                }
//            }
            if (executeContext != null && "task-detail-mobile".equals(executeContext.getPageCode())) {
                if (executeContext != null && !"APPROVAL".equals(executeContext.getCategory())) {
                    if (queryButtonComponent != null && queryButtonComponent.getData() != null) {
                        Map<String, Object> pageData = new HashMap<>();
                        pageData.put("uiBot__APPROVAL_DESCRIPTION", queryButtonComponent.getData());
                        dynamicForm.getPageData().putAll(pageData);
                    }
                }
            }
        }

    }

    /**
     * 创建头部
     */
    protected void createHeader(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, List<UiBotLayout> layout) {
        layout.add(createHeadArea());
        //layout.add(createDescriptionArea());
        createSignOffProgress(executeContext, layout);
        createDataUniformityHistory(executeContext, layout);
        if (executeContext != null && "task-detail-mobile".equals(executeContext.getPageCode())) {
            if (executeContext != null && !"APPROVAL".equals(executeContext.getCategory())) {
                UiBotLayout abstractComponent = this.createActivityDescriptionComponent(executeContext, pageDefine);
                if (abstractComponent != null) {
                    layout.add(abstractComponent);
                }
            }
        }
        //layout.add(createContentTitle());
        //layout.add(createContentSubtitle());
    }

    protected void createSignOffProgress(PcUiBotExecuteContext executeContext, List<UiBotLayout> layout) {
        if (executeContext != null && executeContext.getTaskWithBacklogData() != null
                && executeContext.getTaskWithBacklogData().getRelationApproval() != null) {
            //创建审核流程
            UiBotLayout signOffProgressLinkComponent = new UiBotLayout();
            signOffProgressLinkComponent.setId(UUID.randomUUID().toString());
            signOffProgressLinkComponent.setType("SIGN_OFF_PROGRESS_LINK");
            signOffProgressLinkComponent.setSchema(PcUiBotConstants.UIBOT_FIELDS_ACTIVITY);
            layout.add(signOffProgressLinkComponent);
        }
    }

    private void createDataUniformityHistory(PcUiBotExecuteContext executeContext, List<UiBotLayout> layout) {
        if (!CollectionUtils.isEmpty(executeContext.getAbnormalCards())) {
            //创建业务数据不一致历程入口组件
            UiBotLayout dataUniformityHistoryComponent = new UiBotLayout();
            dataUniformityHistoryComponent.setId(UUID.randomUUID().toString());
            dataUniformityHistoryComponent.setType("DATA_UNIFORMITY_HISTORY");
            dataUniformityHistoryComponent.setSchema(PcUiBotConstants.UIBOT_FIELDS_ACTIVITY);
            layout.add(dataUniformityHistoryComponent);
        }
    }

    protected PcUiBotTaskData createTaskData(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine, QueryResultSet queryResultSet) {
        PcUiBotTaskData taskDetailDTO = new PcUiBotTaskData();
        String titleDefine = pageDefine.getTitle();
        if (titleDefine != null) {
            String title = titleDefine;
            if (titleDefine.contains("$(") && queryResultSet != null) {
                QueryResult queryResult = queryResultSet.getMainQueryResult();
                if (queryResult.size() > 0) {
                    Pattern p = Pattern.compile("\\$\\((?<var>.*?)\\)");
                    Matcher m = p.matcher(titleDefine);
                    while (m.find()) {
                        String varName = m.group("var");
                        Object varValue = queryResult.getData().get(0).get(varName).toString();
                        title = title.replace("$(" + varName + ")", varValue.toString());
                    }
                }

            }
            taskDetailDTO.setTitle(title);
        }

        taskDetailDTO.setDescription(pageDefine.getDescription());

        DigiwinAtmcTaskWithBacklogData taskData = executeContext.getTaskWithBacklogData();

        // 使用流程变量中值，替换title、description中的占位符
        if (taskData != null && !CollectionUtils.isEmpty(taskData.getBpmData())) {
            Map<String, Object> bpmData = taskData.getBpmData();
            if (bpmData.containsKey("__DERIVE_MAIN_TASK")) {
                taskDetailDTO.setDeriveMainTask(bpmData.get("__DERIVE_MAIN_TASK"));
            }
            taskDetailDTO.setTitle(PcUiBotPropertyPlaceholderUtil.resolve(taskDetailDTO.getTitle(), bpmData));
            taskDetailDTO.setDescription(PcUiBotPropertyPlaceholderUtil.resolve(taskDetailDTO.getDescription(), bpmData));
        }

        taskDetailDTO.setSubDescription(pageDefine.getSubDescription());


        if (pageDefine.getDataSourceSet().isEmpty()
                || executeContext.getProjectData() == null
                || taskData == null) {
            return taskDetailDTO;
        }

        if (!CollectionUtils.isEmpty(taskData.getEocName())) {
            taskDetailDTO.setEocName(taskData.getEocName());
        }

        if (executeContext.getApprovalInfo() != null && executeContext.getApprovalInfo().getSubState() != null) {
            taskDetailDTO.setApprovalInfo(executeContext.getApprovalInfo());
        }

        DigiwinAtmcProjectData projectData = executeContext.getProjectData();
        DigiwinAtmcBacklogData backlogData = new DigiwinAtmcBacklogData();
        List<DigiwinAtmcBacklogData> backlog = taskData.getBacklog();
        if (!CollectionUtils.isEmpty(backlog)) {
            backlogData = backlog.get(0);
        }
        taskDetailDTO.setTaskStartTime(projectData.getStartTime());
        taskDetailDTO.setRemainTime(backlogData.getRemainTime());
        taskDetailDTO.setReadCount(backlogData.getReadCount());
        taskDetailDTO.setTaskEndTime(projectData.getEndTime());
        taskDetailDTO.setTaskName(projectData.getProjectName());
        if (projectData.getProcessCreateTime() == null) {
            taskDetailDTO.setProcessCreateTime(projectData.getStartTime());
        } else {
            taskDetailDTO.setProcessCreateTime(projectData.getProcessCreateTime());
        }
        if (backlogData != null && StringUtils.isNotEmpty(backlogData.getBacklogName())) {
            taskDetailDTO.setName(backlogData.getBacklogName());
            taskDetailDTO.setProcessSerialNumber(taskData.getProcessSerialNumber());
            if (!CollectionUtils.isEmpty(backlogData.getWorkitemList())) {
                taskDetailDTO.setWorkitemId(backlogData.getWorkitemList().get(0).get("workitemId").toString());
            }
        } else {
            taskDetailDTO.setName(taskData.getTmActivityName());
        }
        taskDetailDTO.setSubName(pageDefine.getSubTitle());
        taskDetailDTO.setSteps(taskData.getSteps());
        taskDetailDTO.setApprovalState(taskData.getApprovalState());
        //逾期
        taskDetailDTO.setOverdueDate(backlogData.getOverdueDate());
        taskDetailDTO.setEndTime(backlogData.getPlanEndTime());
        //扩展数据
        Map<String, Object> extend = new HashMap<>();
        taskDetailDTO.setExtendedFields(extend);
        Map<String, Object> signOffData = new HashMap<>();
        signOffData.put("locale", AppRequestContext.getContextEntity().getLocale());
        extend.put("signOffProgressData", signOffData);
        List<Map> processInstances = new ArrayList<>();
        if (taskData.getRelationApproval() != null) {
            Map<String, Object> process = taskData.getRelationApproval();
            process.putAll(taskData.getRelationApproval());
            processInstances.add(process);
            signOffData.put("processInstances", processInstances);
        } else {
            Map<String, Object> process = new HashMap<>();
            process.put("processSerialNumber", taskData.getProcessSerialNumber());
            process.put("tmActivityIds", new String[]{taskData.getTmActivityId()});
            if (backlogData != null && backlogData.getBacklogId() != null) {
                process.put("workitemId", backlogData.getBacklogId());
            }
            processInstances.add(process);
            signOffData.put("processInstances", processInstances);
        }
        taskDetailDTO.setMerge(backlogData.getMerge());
        taskDetailDTO.setPlanEndTimeMin(backlogData.getPlanEndTimeMin());
        taskDetailDTO.setPlanEndTimeMax(backlogData.getPlanEndTimeMax());
        return taskDetailDTO;
    }


    /**
     * 创建 活动头(标准)
     * 显示部分：
     * xx/xx需完成追料确认排除异常+倒计时
     * 副标题
     *
     * @return
     */
    protected UiBotLayout createHeadArea() {
        UiBotLayout commonComponent = new UiBotLayout();
        commonComponent.setId(UUID.randomUUID().toString());
        commonComponent.setType(COMPONENT_TYPE);
        commonComponent.setSchema(PcUiBotConstants.UIBOT_FIELDS_ACTIVITY);
        return commonComponent;
    }

    /**
     * 创建 活动头(标准)
     * 样例：
     * 2020/xx/xx 由Athena發起當前任務
     * 来源：由xxxxxx組成
     * 预计开工日：2020 06/14
     * 方案：特采
     * 发起人：xxx
     *
     * @return
     */
    protected UiBotLayout createDescriptionArea() {
        UiBotLayout commonComponent = new UiBotLayout();
        commonComponent.setType(COMPONENT_ACTIVITY_DESCRIPTION);
        commonComponent.setSchema(PcUiBotConstants.UIBOT_FIELDS_ACTIVITY);
        return commonComponent;
    }

    /**
     * 创建标题
     *
     * @return
     */
    protected UiBotLayout createContentTitle() {
        UiBotLayout commonComponent = new UiBotLayout();
        commonComponent.setId(UUID.randomUUID().toString());
        commonComponent.setType("CONTENT_TITLE");
        commonComponent.setSchema("uiBot__content");
        return commonComponent;
    }

    /**
     * 创建标题描述
     *
     * @return
     */
    protected UiBotLayout createContentSubtitle() {
        UiBotLayout commonComponent = new UiBotLayout();
        commonComponent.setId(UUID.randomUUID().toString());
        commonComponent.setType("CONTENT_SUBTITLE");
        commonComponent.setSchema("uiBot__content");
        return commonComponent;
    }


    protected UiBotLayout createQueryButton(QueryResultSet queryResultSet, List<PcUiBotTaskPageDefine> pageDefines) {
        UiBotLayout queryButtonComponent = new UiBotLayout();
        queryButtonComponent.setId(UUID.randomUUID().toString());
        queryButtonComponent.setType("CONTENT_QUERY_BUTTON");


        //第一个查询产生的界面直接作为任务的布局一部分，其他的查询则是当用户点击的时候才去查询
        if (queryResultSet != null
                && queryResultSet.getQueryResults() != null
                && pageDefines.size() > 0) {
            PcUiBotTaskPageDefine pageDefine = pageDefines.get(0);
            pageDefine.setType("UI");
            if ("byDataKey".equals(pageDefine.getRowSizeType())) {
                int rowSize = 0;
                for (QueryResult queryResult : queryResultSet.getQueryResults()) {
                    if (queryResultSet.getMainQueryResult() != null
                            && StringUtils.isNotEmpty(queryResultSet.getMainQueryResult().getDataSourceName())
                            && queryResultSet.getMainQueryResult().getDataSourceName().equals(queryResult.getDataSourceName())) {
                        if (queryResult.isHasNext()) {
                            rowSize = rowSize + queryResult.getTotalResults();
                        } else {
                            if (!CollectionUtils.isEmpty(queryResult.getDataKeyIndex())) {
                                rowSize = rowSize + queryResult.getDataKeyIndex().size();
                            }
                        }
                    }
                }
                pageDefine.setRowSize(rowSize);
            } else {
                int rowSize = 0;
                for (QueryResult queryResult : queryResultSet.getQueryResults()) {
                    if (queryResultSet.getMainQueryResult() != null
                            && StringUtils.isNotEmpty(queryResultSet.getMainQueryResult().getDataSourceName())
                            && queryResultSet.getMainQueryResult().getDataSourceName().equals(queryResult.getDataSourceName())) {
                        if (queryResult.isHasNext()) {
                            rowSize = rowSize + queryResult.getTotalResults();
                        } else {
                            if (!CollectionUtils.isEmpty(queryResult.getData())) {
                                rowSize = rowSize + queryResult.getData().size();
                            }
                        }
                    }
                }
                pageDefine.setRowSize(rowSize);
            }
            if (queryResultSet.getMainQueryResult().getData() != null
                    && queryResultSet.getMainQueryResult().getData().size() > 0) {
                queryButtonComponent.setData(queryResultSet.getMainQueryResult().getData().get(0));
            }
        }
        for (int i = 1; i < pageDefines.size(); i++) {
            PcUiBotTaskPageDefine pageDefine = pageDefines.get(i);
            pageDefine.setType("async");
            if (CollectionUtils.isEmpty(queryButtonComponent.getData())) {
                try {
                    QueryResultSet resultSet = this.queryByActivityQueryDTO(pageDefine.getExecuteContext(), pageDefine.getDataSourceSet(), null, null, null, null);
                    if (resultSet != null && resultSet.getQueryResults() != null) {
                        int rowSize = 0;
                        if ("byDataKey".equals(pageDefine.getRowSizeType())) {
                            for (QueryResult queryResult : resultSet.getQueryResults()) {
                                if (queryResultSet != null
                                        && queryResultSet.getMainQueryResult() != null
                                        && StringUtils.isNotEmpty(queryResultSet.getMainQueryResult().getDataSourceName())
                                        && queryResultSet.getMainQueryResult().getDataSourceName().equals(queryResult.getDataSourceName())) {
                                    if (CollUtil.isNotEmpty(queryResult.getDataKeyIndex())) {
                                        rowSize = rowSize + queryResult.getDataKeyIndex().size();
                                    }
                                }
                            }
                        } else {
                            for (QueryResult queryResult : resultSet.getQueryResults()) {
                                if (queryResultSet != null
                                        && queryResultSet.getMainQueryResult() != null
                                        && StringUtils.isNotEmpty(queryResultSet.getMainQueryResult().getDataSourceName())
                                        && queryResultSet.getMainQueryResult().getDataSourceName().equals(queryResult.getDataSourceName())) {
                                    if (CollUtil.isNotEmpty(queryResult.getData())) {
                                        rowSize = rowSize + queryResult.getData().size();
                                    }
                                }
                            }
                        }
                        pageDefine.setRowSize(rowSize);

                        if (resultSet.getMainQueryResult().getData().size() > 0) {
                            queryButtonComponent.setData(resultSet.getMainQueryResult().getData().get(0));
                        }
                    }
                } catch (Exception ex) {
                    log.error("error:", ex);
                    pageDefine.setRowSize(0);
                }
            }
        }

        queryButtonComponent.setQueryButtons(JsonUtil.objectToJavaObject(pageDefines,
                new TypeReference<List<UiBotQueryButton>>() {
                }));
        return queryButtonComponent;
    }

    protected boolean isCustomize(PcUiBotExecuteContext executeContext) {
        if (BooleanUtils.isTrue(executeContext.getIsCustomize())) {
            return true;
        }

        String pattern = executeContext.getPattern();
        // pattern为CUSTOM 且 为任务详情/项目详情/基础资料录入
        if (PcUiBotActivityConstants.PATTERN_CUSTOM.equals(pattern)) {
            return true;
        }

        return false;
    }

    @Override
    protected void BuildPageInfo(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, UiBotModel dynamicForm) {
        dynamicForm.setFinished(pageDefine.getFinished());
        dynamicForm.setFinishedTitle(pageDefine.getFinishedTitle());
    }

    public UiBotLayout createActivityDescriptionComponent(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine) {
//        //创建自定义表头信息
//        PcUiBotShowMetadata showMetadata = null;//pageBuilder.createShowMetadata(executeContext, pageDefine);
//        if (showMetadata != null && CollUtil.isNotEmpty(showMetadata.getShowFields())) {
//            UiBotLayout formComponent = new UiBotLayout();
//            formComponent.setId(UUID.randomUUID().toString());
//            List<UiBotLayout> group = new ArrayList<>();
////            BuildContext buildContext = new BuildContext();
////            buildContext.setExecuteContext(executeContext);
////            buildContext.setPageDefine(pageDefine);
////            ApprovalDescriptionComponentImpl.createGroupByShowMetadata(group, null, showMetadata.getShowFields(), buildContext);
//            formComponent.setGroup(group);
//            formComponent.setType("APPROVAL_DESCRIPTION");
//            formComponent.setSchema("uiBot__APPROVAL_DESCRIPTION");
//            return formComponent;
//        }
        return null;
    }


//    @Override
//    public DynamicForm createTaskPage(ExecuteContext executeContext, TaskPageDefine mainAction, List<TaskPageDefine> pageDefines){
//        return super.createTaskPage(executeContext,mainAction,pageDefines);
//    }


    @Override
    protected void BuildRule(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, UiBotModel dynamicForm, QueryResultSet queryResultSet) {
        List<UiBotRule> rules = pcRuleService.buildRuleOfKm(executeContext.getTmActivityId(), apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId());
        if (!CollectionUtils.isEmpty(rules)) {
            dynamicForm.setRules(rules);
        }
    }
}
