package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.common.BackgroundColorEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotTaggingData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.PcRuleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.QueryActionCreateService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.ShowFieldService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.SignTagService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotApiMetadataUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotDefaultTagUtils;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotPropertyPlaceholderUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotUnEditableTagUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PropertyPlaceholderHelper;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.*;

/**
 * <p>功能描述：条件页面模板</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ConditionPageTemplate.java
 * @Author: wangjwc
 * @Date: created at 2024/9/24 13:52
 */
@Component
@Slf4j
public class ConditionPageTemplate extends GeneralPageTemplate<PcUiBotPageDefine> {
    private static final String SUPPORT_KEY = "webplatform-statement-general-page-template";

    private static final String RESID = "STATEMENT__resid";

    private static final String SCHEMA_KEY = "UIBOT__schema";

    private static final DateTimePlaceHolderResolver dateTimePlaceHolderResolver = new DateTimePlaceHolderResolver();
    @Autowired
    private PcRuleService pcRuleService;
//    @Autowired
//    private TagService tagService;

//    @Autowired
//    private TagDefinitionService tagDefService;

    @Autowired
    private SignTagService signTagService;


//    @Autowired
//    private OrderTagInterpreter orderTagInterpreter;
//
//    @Autowired
//    private OperationService operationService;
//
//    @Autowired
//    private GroupTagInterpreter groupTagInterpreter;
//
//    @Autowired
//    private TagMergeService tagMergeService;
//
//    @Autowired
//    private FormInterpreter formInterpreter;
//
//    @Autowired
//    private JsonConfig jsonConfig;

    @Autowired
    private ShowFieldService showFieldService;

    @Override
    public String supportKey() {
        return SUPPORT_KEY;
    }

    /**
     * 创建数据源
     *
     * @param executeContext
     * @param pageDefine
     * @param dynamicForm
     */
    @Override
    public QueryResultSet BuildDataSource(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine, UiBotModel dynamicForm, ApiRequest apiRequest) {
        // 不需要解析数据源
        return null;
    }

    /**
     * 创建布局
     *
     * @param executeContext
     * @param queryResultSet
     * @param pageDefine
     * @param pageDefines
     * @param dynamicForm
     */
    @Override
    protected void BuildLayout(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, QueryResultSet queryResultSet, PcUiBotPageDefine pageDefine, List<PcUiBotPageDefine> pageDefines, UiBotModel dynamicForm) {
        //createDynamicForm(apiRequest, executeContext, pageDefine, dynamicForm);

        // 置空headerName属性，设置placeholder属性
//        regularFormColumns(dynamicForm.getLayout());
        // 设置表单的显示方向
//        setLayoutDisplayDirection(dynamicForm.getLayout());

        Map<String, Object> pageData = dynamicForm.getPageData();
        putExtendedFieldToPageData(pageData, pageDefine.getExtendedFields());
        pageData.put("UIBOT__activityName", pageDefine.getSubTitle());
    }

//    private void setLayoutDisplayDirection(List<AbstractComponent> layoutList) {
//        if (CollectionUtils.isEmpty(layoutList)) {
//            return;
//        }
//
//        for (Object layout : layoutList) {
//            FormComponent formComponent = (FormComponent) layout;
//            setFormDisplayDirection(formComponent);
//        }
//    }

//    private void setFormDisplayDirection(FormComponent formComponent) {
//        if (null == formComponent) {
//            return;
//        }
//        // 如果FromComponent没有显式设置过direction，则规整为COLUMN
//        if (StringUtils.isBlank(formComponent.getDirection())) {
//            formComponent.setDirection(ActivityConstants.DIRECTION_COLUMN);
//        }
//
//        // 递归处理group
//        if (CollectionUtils.isNotEmpty(formComponent.getGroup())) {
//            for (AbstractComponent subComponent : formComponent.getGroup()) {
//                if (subComponent instanceof FormComponent) {
//                    setFormDisplayDirection((FormComponent) subComponent);
//                }
//            }
//        }
//    }

    private void putExtendedFieldToPageData(Map<String, Object> pageData, Map<String, Object> extendedFields) {
        if (MapUtils.isEmpty(extendedFields)) {
            return;
        }

        // 找到当前语系的STATEMENT_resid配置
        String locale = AppRequestContext.getContextEntity().getLocale();
        String targetResid = RESID + "_" + locale;

        String finalResid = RESID;
        Set<Map.Entry<String, Object>> entries = extendedFields.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            if (StringUtils.equalsIgnoreCase(entry.getKey(), targetResid)) {
                finalResid = entry.getKey();
                break;
            }
        }

        entries = extendedFields.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            // 塞入报表resid等数据
            if (StringUtils.startsWith(entry.getKey(), RESID)) {
                if (StringUtils.equalsIgnoreCase(entry.getKey(), finalResid)) {
                    pageData.put(RESID, entry.getValue());
                }
            }
            // 塞入其他配置
            else {
                pageData.put(entry.getKey(), entry.getValue());
            }
        }
    }

//    private void regularFormColumns(List layoutList) {
//        if (CollectionUtils.isEmpty(layoutList)) {
//            return;
//        }
//        for (Object layout : layoutList) {
//            FormComponent formComponent = (FormComponent) layout;
//            setFormComponentPlaceholder(formComponent);
//        }
//
//    }

//    private void setFormComponentPlaceholder(FormComponent formComponent) {
//        // 主表单不支持title
//        formComponent.setTitle(null);
//        for (Object column : formComponent.getGroup()) {
//            // 表单组件，需递归
//            if (column instanceof FormComponent) {
//                setFormComponentPlaceholder((FormComponent) column);
//                // 子表单不支持title
//                ((FormComponent) column).setTitle(null);
//            } else if (column instanceof CommonComponent) {
//                CommonComponent commonComponent = (CommonComponent) column;
//                this.setPlaceholderIfNecessary(commonComponent);
//            }
//            // 下拉选择列表组件
//            else if (column instanceof SelectComponent) {
//                SelectComponent commonComponent = (SelectComponent) column;
//                this.setPlaceholderIfNecessary(commonComponent);
//            }
//            // 内含外显组件
//            else if (column instanceof ContainExplicitFormComponent) {
//                ContainExplicitFormComponent containExplicitFormComponent = (ContainExplicitFormComponent) column;
//                if (containExplicitFormComponent.getColumns() != null) {
//                    for (Object col : containExplicitFormComponent.getColumns()) {
//                        if (col instanceof CommonComponent) {
//                            CommonComponent commonComponent = (CommonComponent) col;
//                            this.setPlaceholderIfNecessary(commonComponent);
//                        }
//                    }
//                }
//                this.setPlaceholderIfNecessary(containExplicitFormComponent);
//            }
//            // 开窗组件
//            else if (column instanceof GridColumnDef
//                    && StringUtils.equals(((GridColumnDef) column).getType(), "OPERATION_EDITOR")) {
//                GridColumnDef gridColumnDef = (GridColumnDef) column;
//                // 将headerName设置为null，无需设置placeholder，开窗是显示operations.title
//                gridColumnDef.setHeaderName(null);
//            } else if (column instanceof OpenWindowComponent || column instanceof InputWithWindowComponent) {
//                // 处理逻辑同上；
//                AbstractComponent abstractComponent = (AbstractComponent) column;
//                abstractComponent.setHeaderName(null);
//            }
//        }
//    }

//    /**
//     * 将headerName挪到placeHolder中；如果placeHolder已存在，则不挪；清空headerName
//     *
//     * @param abstractComponent 抽象组件
//     */
//    private void setPlaceholderIfNecessary(AbstractComponent abstractComponent) {
//        if (StringUtils.isBlank(abstractComponent.getPlaceholder())) {
//            abstractComponent.setPlaceholder(abstractComponent.getHeaderName());
//        }
//        abstractComponent.setHeaderName(null);
//        abstractComponent.setTitle(null);
//    }

    protected String getActionId(PcUiBotPageDefine mainQueryDTO) {
        // 获取第一个按钮的actionId
        return Optional.ofNullable(mainQueryDTO.getSubmitActions())
                .map(submitActions -> {
                    if (CollectionUtils.isNotEmpty(submitActions)) {
                        return submitActions.get(0).getActionId();
                    } else {
                        return "";
                    }
                })
                .orElse("");
    }

    protected void createDynamicForm(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, PcUiBotPageDefine mainQueryDTO, UiBotModel dynamicForm) {
        String actionId = getActionId(mainQueryDTO);
        if (StringUtils.isBlank(actionId)) {
            return;
        }

        PcUiBotApiMetadata apiMetadata = SpringContextHolder.getBean(QueryActionCreateService.class).getMetadata(executeContext, actionId);

        // 处理attachActions，设置UIBOT__schema
        handleAttachActions(mainQueryDTO, executeContext);

        // 根据配置添加EOC列
        appendEocMetadataField(executeContext, mainQueryDTO, apiMetadata);
        PcUiBotApiMetadataUtil.flatMetaData(apiMetadata);

        // 获取所用到的标签
        PcUiBotTaggingData taggingData = this.getMetadataTags(mainQueryDTO, executeContext, actionId);

        // 把tagData设置到元数据上
        signTagService.sinTagToMetadata(taggingData, apiMetadata);

        // 设置所有请求字段可编辑
        tagFieldCanEdit(apiMetadata.getRequestFields());

        // 获取rules
        List<UiBotRule> rules = pcRuleService.buildRuleOfKm(executeContext.getRelationTag().getActivityId(),
                apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId());
        mainQueryDTO.setRules(JsonUtil.objectToJavaObject(rules, List.class));
        List<String> notShowWords = showFieldService.getWordsByAbility(executeContext, Lists.newArrayList(), null, mainQueryDTO);
        rules = JsonUtil.objectToJavaObject(mainQueryDTO.getRules(), List.class);
        // 删除rules里的hidden规则
        showFieldService.removeWordHiddenRule(rules);

        // 字段显示范围
        PcUiBotShowMetadata showMetadata = getRequestShowFields(apiMetadata, notShowWords);

        // 统一处理不可编辑字段
        PcUiBotUnEditableTagUtils.analysisTag(showMetadata.getShowFields());

//        // 排序功能
//        orderTagInterpreter.analysisTag(showMetadata);
//        // 处理操作服务
//        operationService.addMetadataOperation(showMetadata, mainQueryDTO.getOperations(), apiMetadata);

        // 创建界面
        createConditionPage(executeContext, showMetadata, mainQueryDTO, dynamicForm, apiMetadata, rules);
    }

    private void handleAttachActions(PcUiBotPageDefine mainQueryDTO, PcUiBotExecuteContext executeContext) {
        List<PcUiBotSubmitAction> attachActions = mainQueryDTO.getSubmitActions().get(0).getAttachActions();
        if (CollectionUtils.isEmpty(attachActions)) {
            return;
        }

        for (PcUiBotSubmitAction attachAction : attachActions) {
            if (StringUtils.isBlank(attachAction.getActionId())) {
                continue;
            }

            if (null == attachAction.getExtendParas()) {
                attachAction.executeExtendParas(new HashMap<>(), executeContext);
            }
            if (attachAction.getExtendParas().containsKey(SCHEMA_KEY)) {
                continue;
            }
            // 获取元数据定义
            PcUiBotApiMetadata apiMetadata = SpringContextHolder.getBean(QueryActionCreateService.class).getMetadata(executeContext, attachAction.getActionId());

            String schema = apiMetadata.getRequestFields().get(0).getName();
            attachAction.getExtendParas().put(SCHEMA_KEY, schema);
        }
    }

    private void appendEocMetadataField(PcUiBotExecuteContext executeContext, PcUiBotPageDefine mainQueryDTO, PcUiBotApiMetadata apiMetadata) {
        Optional<Map<String, List<Object>>> optional = Optional.ofNullable(mainQueryDTO.getExtendedFields())
                .map(extendedFields -> (Map<String, List<Object>>) extendedFields.get("UIBOT__appendEocFields"));
        if (!optional.isPresent()) {
            return;
        }

        Map<String, List<Object>> appendEocFields = optional.get();
        if (MapUtils.isEmpty(appendEocFields)) {
            return;
        }

        Set<Map.Entry<String, List<Object>>> entrySet = appendEocFields.entrySet();
        for (Map.Entry<String, List<Object>> entry : entrySet) {
            if (StringUtils.isBlank(entry.getKey()) || CollectionUtils.isEmpty(entry.getValue())) {
                continue;
            }

            for (PcUiBotMetadataField requestField : apiMetadata.getRequestFields()) {
                // 是目标字段，并且目标字段类型为object
                if (PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(requestField.getDataType()) && requestField.getName().equals(entry.getKey())) {
                    List<PcUiBotMetadataField> eocFields = createEocMetadataFields(entry.getValue());
                    requestField.getSubFields().addAll(eocFields);
                }
            }
        }
    }

    private List<PcUiBotMetadataField> createEocMetadataFields(List<Object> fieldObjects) {
        List<PcUiBotMetadataField> eocFields = new ArrayList<>(fieldObjects.size());
        for (Object fieldObject : fieldObjects) {
            PcUiBotMetadataField metadataField = new PcUiBotMetadataField();
            try {
                metadataField = JsonUtil.objectToJavaObject(fieldObject, PcUiBotMetadataField.class);
                String description = parseDescriptionByLang(fieldObject);
                if (StringUtils.isNotBlank(description)) {
                    metadataField.setDescription(description);
                }
                // 需设置为可编辑，这样EocSelectComponent才能下拉编辑
                metadataField.setCanEdit(true);
            } catch (Exception ex) {
                // 吃掉异常
                log.error("[ConditionPageTemplate] create eoc field throw exception: ", ex);
                continue;
            }
            eocFields.add(metadataField);
        }
        return eocFields;
    }

    private String parseDescriptionByLang(Object fieldObj) {
        if (null == fieldObj) {
            return null;
        }

        String locale = AppRequestContext.getContextEntity().getLocale();
        Map fieldJsonObj = JsonUtil.objectToJavaObject(fieldObj, Map.class);
        if (null != fieldJsonObj && fieldJsonObj.containsKey("language")) {
            Map langJsonObj = JsonUtil.objectToJavaObject(fieldJsonObj.get("language"), Map.class);
            if (null != langJsonObj && langJsonObj.containsKey("description")) {
                Map descJsonObj = JsonUtil.objectToJavaObject(langJsonObj.get("description"), Map.class);
                if (null != descJsonObj && !descJsonObj.isEmpty() && descJsonObj.containsKey(locale)) {
                    return StringUtil.valueOf(descJsonObj.get(locale));
                }
            }
        }
        return null;
    }

    private void createConditionPage(PcUiBotExecuteContext executeContext, PcUiBotShowMetadata showMetadata, PcUiBotPageDefine pageDefine, UiBotModel dynamicForm,
                                     PcUiBotApiMetadata apiMetadata, List<UiBotRule> rules) {

//        //当执行者的时候才会去查询规则
//        if (executeContext.getRelationTag() != null
//                && executeContext.getRelationTag().getIdentity() != null
//                && executeContext.getRelationTag().getIdentity().equals("performer")
//                // 不是被分享
//                && executeContext.isNotShared()) {
//            dynamicForm.setRules(rules);
//            tagMergeService.addTagRules("", showMetadata.getShowFields(), dynamicForm.getRules());
//            this.cleanRule(dynamicForm, pageDefine);
//            /**
//             * 设置页面需要的一些附加变量
//             */
//            BuilderUtils.BuildVariables(dynamicForm);
//        }

        //支持多个API合集
        //每组代表一个原生态的
//        BuildContext buildContext = this.createBuildContext(pageDefine, null, executeContext);

//        List<AbstractComponent> topLayout = new ArrayList<>();
//        if (CollectionUtils.isNotEmpty(showMetadata.getShowFields())) {
//            // 无数据源，默认数据源名称和元数据的名称一致
//            for (MetadataField showField : showMetadata.getShowFields()) {
//                AbstractComponent layout = createConditionPage(buildContext, showField, showField.getSubFields(), dynamicForm, apiMetadata);
//                if (layout instanceof Collection) {
//                    topLayout.addAll((Collection<AbstractComponent>) layout);
//                } else {
//                    if (layout instanceof FormComponent) {
//                        FormComponent layoutForm = (FormComponent) layout;
//                        if (CollectionUtils.isNotEmpty(layoutForm.getGroup())) {
//                            layoutForm.setDirection("COLUMN");
//                            topLayout.add(layoutForm);
//                        }
//                    } else {
//                        topLayout.add(layout);
//                    }
//
//                }
//            }
//        }
//
//        dynamicForm.setLayout(topLayout);
        setActionOperations(executeContext, pageDefine);
        // 根据元数据定义，初始化查询条件数据
        // 解析出form表单的schema，其实就是提交的业务数据key
        String formSchema = parseFormSchema(showMetadata.getShowFields());
        dynamicForm.setPageData(initConditionPageData(formSchema, pageDefine, apiMetadata.getRequestFields()));
    }

    private String parseFormSchema(List<PcUiBotMetadataField> showFields) {
        if (CollectionUtils.isNotEmpty(showFields)) {
            for (PcUiBotMetadataField showField : showFields) {
                // abi报表只展示M参数，不能展示P参数
                // 正常情况下打了TAG，showFields中只会剩下M参数，这里为了预防TAG数据丢失造成异常报错
                if (PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(showField.getDataType()) && showField.isArray()) {
                    return showField.getName();
                }
            }
            // 保留之前的代码逻辑，增加冗余性
            return Optional.ofNullable(showFields.get(0).getName()).orElse("");
        }
        return "";
    }

    protected UiBotPageData initConditionPageData(String submitVariableName, PcUiBotPageDefine pageDefine, List<PcUiBotMetadataField> showMetadataList) {
        Map<String, Object> pageData = initConditionPageData(showMetadataList, 1);

        UiBotPageData pageDataResult = new UiBotPageData();
        if (MapUtils.isNotEmpty(pageData)) {
            for (Map.Entry<String, Object> entry : pageData.entrySet()) {
                pageDataResult.put(entry.getKey(), entry.getValue());
                pageDataResult.put(SCHEMA_KEY, entry.getKey());
            }
        }

        if (StringUtils.isNotBlank(submitVariableName)) {
            pageDataResult.put(SCHEMA_KEY, submitVariableName);
        }

        parseConstantSubmitActionParams(pageDefine.getSubmitActions(), pageDataResult);
        return pageDataResult;
    }

    private void parseConstantSubmitActionParams(List<PcUiBotSubmitAction> submitActions, Map<String, Object> pageData) {
        if (CollectionUtils.isEmpty(submitActions) || MapUtils.isEmpty(pageData)) {
            return;
        }

        List<PcUiBotActionParameterMapping> actionParamList = submitActions.get(0).getActionParams();
        if (CollectionUtils.isEmpty(actionParamList)) {
            return;
        }

        String schema = String.valueOf(pageData.get(SCHEMA_KEY));
        Map<String, Object> dataSrcMap = (Map<String, Object>) ((Object[]) pageData.get(schema))[0];

        for (PcUiBotActionParameterMapping actionParamMapping : actionParamList) {
            if ("CONSTANT".equals(actionParamMapping.getType())) {
                String[] namePathList = actionParamMapping.getName().split("\\.");
                int start = 1;
                if (namePathList.length <= 1) {
                    start = 0;
                }
                for (int idx = start; idx < namePathList.length; idx++) {
                    parseConstantSubmitActionParams(dataSrcMap, namePathList, idx, actionParamMapping);
                }
            }
        }
    }

    private void parseConstantSubmitActionParams(Map<String, Object> dataSrcMap, String[] namePathList, int idx, PcUiBotActionParameterMapping actionParamMapping) {
        String name = namePathList[idx];
        if (idx < namePathList.length - 1) {
            Map<String, Object> valueMap = (Map<String, Object>) dataSrcMap.get(name);
            if (null == valueMap) {
                valueMap = new HashMap<>();
            }
            parseConstantSubmitActionParams(valueMap, namePathList, idx++, actionParamMapping);
        } else { // 已经遍历到最后一个
            String value = parseValueConfig(actionParamMapping.getValue());
            dataSrcMap.put(name, value);
        }
    }

    private String parseValueConfig(String value) {
        if (StringUtils.isBlank(value)) {
            return value;
        }

        // 解析时间常量占位符
        String actualValue = PcUiBotPropertyPlaceholderUtil.HELPER.replacePlaceholders(value, dateTimePlaceHolderResolver);
        return actualValue;
    }

    /**
     * 根据ShowMetadata生成pageData
     *
     * @return
     */
    private Map<String, Object> initConditionPageData(List<PcUiBotMetadataField> showMetadataList, int level) {
        Map<String, Object> pageData = new HashMap<>();
        if (CollectionUtils.isEmpty(showMetadataList)) {
            return pageData;
        }

        for (PcUiBotMetadataField showField : showMetadataList) {
            if (1 == level) {
                // 第一层，如果是数组
                if (showField.isArray()) {
                    Object[] objects = new Object[1];
                    if (showField.getDataType().equals(PcUiBotApiMetadataConstants.METADATA_OBJECT)) {
                        // 递归分析
                        objects[0] = initConditionPageData(showField.getSubFields(), level + 1);
                        pageData.put(showField.getName(), objects);
                    } else {
                        objects[0] = PcUiBotDefaultTagUtils.genPrimitiveTypeDefaultValue(showField);
                        pageData.put(showField.getName(), objects);
                    }
                }
            } else {
                // > 第一层
                // 如果是数组，值为空数组；
                if (showField.isArray()) {
                    Object[] objects = new Object[0];
                    pageData.put(showField.getName(), objects);
                }
                // 如果是对象，值为空Map
                else if (PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(showField.getDataType())) {
                    pageData.put(showField.getName(), new HashMap<>());
                }
                // 如果是基本数据类型及其包装类型 + String
                else {
                    pageData.put(showField.getName(), PcUiBotDefaultTagUtils.genPrimitiveTypeDefaultValue(showField));
                }
            }
        }

        // 解析submitAction.actionParams中的常量
        return pageData;
    }

    private void setActionOperations(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine) {
        //todo: 这个代码有问题
        List<PcUiBotOperationDTO> operations = pageDefine.getOperations();
        if (CollectionUtils.isNotEmpty(operations)) {
            // 添加 当前用户职责和活动
            for (PcUiBotOperationDTO operation : operations) {
                operation.setRelationTag(executeContext.getRelationTag());
                operation.setPageCode(executeContext.getPageCode());
            }
        }
    }

//    /**
//     * 清理不需要添加的规则
//     *
//     * @param page
//     */
//    private void cleanRule(DynamicForm page, PageDefine pageDefine) {
//        List<Map<String, Object>> newRules = new ArrayList<>();
//        List<Map<String, Object>> rules = page.getRules();
//        if (CollectionUtils.isNotEmpty(rules)) {
//            for (Map<String, Object> rule : rules) {
//                if (rule == null) {
//                    continue;
//                }
//                String scope = (!rule.containsKey("scope") || rule.get("scope") == null) ? "" : rule.get("scope").toString();
//                if ("EDIT".equals(scope) && CollectionUtils.isEmpty(pageDefine.getSubmitActions())) {
//                    continue;
//                } else {
//                    newRules.add(rule);
//                }
//            }
//            page.setRules(newRules);
//        }
//    }

//    private AbstractComponent createConditionPage(BuildContext buildContext, MetadataField headMetadataField, List<MetadataField> subFields, DynamicForm page, ApiMetadata apiMetadata) {
//        List<MetadataField> bodyShowFields = new ArrayList<>();
//        //循环所有节点
//        if (TagUtil.renderObjectMetadataField(headMetadataField)) {
//            bodyShowFields.add(headMetadataField);
//        } else {
//            if (CollectionUtils.isNotEmpty(subFields)) {
//                for (MetadataField showField : subFields) {
//                    if (TagUtil.renderObjectMetadataField(showField)) {
//                        bodyShowFields.add(showField);
//                    } else if (showField.getDataType().equals(ApiMetadataConstants.METADATA_OBJECT)) {
//                        MetadataField newMetadataField = new MetadataField();
//                        newMetadataField.setDataType(ApiMetadataConstants.METADATA_OBJECT);
//                        newMetadataField.setDescription(showField.getDescription());
//                        newMetadataField.setName(showField.getName());
//                        newMetadataField.setTagDefinitions(showField.getTagDefinitions());
//
//                        newMetadataField.setObjectData(createConditionPage(buildContext, showField, showField.getSubFields(), page, apiMetadata));
//                        //导出table 下载使用
//                        newMetadataField.setExportTableFields(showField.getExportTableFields());
//                        bodyShowFields.add(newMetadataField);
//                    } else {
//                        bodyShowFields.add(showField);
//                    }
//                }
//            }
//        }
//
//        List<GroupMetadataField> groupMetadataFields = groupTagInterpreter.analysisTagGroup(bodyShowFields, buildContext);
//        // 特殊处理eoc分组
//        EocSelectInterpreter.handleEocGroup(groupMetadataFields);
//        AbstractComponent component = formInterpreter.createComponent(headMetadataField, groupMetadataFields, buildContext, apiMetadata);
//        //TODO:XUXX 这里先置空，需要从请求体中获取
//        if (component instanceof FormComponent) {
//            FormComponent formComponent = (FormComponent) component;
//            formComponent.setAllFields(null);
//        }
//        return component;
//    }

    private void tagFieldCanEdit(List<PcUiBotMetadataField> requestFields) {
        //获取get API的字段
        for (PcUiBotMetadataField metadataField : requestFields) {
            metadataField.setCanEdit(true);
            if (PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(metadataField.getDataType())) {
                tagFieldCanEdit(metadataField.getSubFields());
            }
        }
    }

    private PcUiBotShowMetadata getRequestShowFields(PcUiBotApiMetadata masterMetadata, List<String> notShowFields) {
        PcUiBotShowMetadata showMetadata = new PcUiBotShowMetadata();
        if (masterMetadata == null) {
            return showMetadata;
        }
        showMetadata.setActionId(masterMetadata.getActionId());
        showMetadata.setServiceName(masterMetadata.getServiceName());
//        showMetadata.setMetadataTags(masterMetadata.getApiTags());

        // 请求元数据集
        List<PcUiBotMetadataField> requestFields = masterMetadata.getRequestFields();

        showMetadata.setShowFields(new ArrayList<>());
        List<PcUiBotMetadataField> tagMetadata = showFields(requestFields, notShowFields);
        if (CollectionUtils.isNotEmpty(tagMetadata)) {
            showMetadata.getShowFields().addAll(tagMetadata);
        } else {
            showMetadata.getShowFields().addAll(requestFields);
        }

        return showMetadata;
    }

    /**
     * 获取只显示字段
     *
     * @param metadataFields
     * @return
     */
    private List<PcUiBotMetadataField> showFields(List<PcUiBotMetadataField> metadataFields, List<String> noShowFields) {
        List<PcUiBotMetadataField> showFields = new ArrayList<>();
        for (PcUiBotMetadataField metadataField : metadataFields) {
            if (PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(metadataField.getDataType())) {
                List<PcUiBotMetadataField> sonTagFields = showFields(metadataField.getSubFields(), noShowFields);
                if ((CollectionUtils.isNotEmpty(sonTagFields) || CollectionUtils.isNotEmpty(metadataField.getTagDefinitions()))
                        && !noShowFields.contains(metadataField.getName())) {
                    PcUiBotMetadataField newMetadataField = createMetadataField(metadataField, sonTagFields);
                    showFields.add(newMetadataField);
                }
            }
            if (CollectionUtils.isNotEmpty(metadataField.getTagDefinitions()) && !PcUiBotApiMetadataConstants.METADATA_OBJECT.equals(metadataField.getDataType())
                    && !noShowFields.contains(metadataField.getName())) {
                showFields.add(metadataField);
            }
        }
        return showFields;
    }

    /**
     * 创建字段
     *
     * @param metadataField
     * @param sonTagFields
     * @return
     */
    private PcUiBotMetadataField createMetadataField(PcUiBotMetadataField metadataField, List<PcUiBotMetadataField> sonTagFields) {
        PcUiBotMetadataField newMetadataField = new PcUiBotMetadataField();
        newMetadataField.setDataType(metadataField.getDataType());
        newMetadataField.setDataKey(metadataField.getDataKey());
        newMetadataField.setRemark(metadataField.getRemark());
        newMetadataField.setDescription(metadataField.getDescription());
        newMetadataField.setRequired(metadataField.isRequired());
        newMetadataField.setName(metadataField.getName());
        newMetadataField.setArray(metadataField.isArray());
        newMetadataField.setCanEdit(metadataField.isCanEdit());
        newMetadataField.setTagDefinitions(metadataField.getTagDefinitions());
        newMetadataField.setFieldType(metadataField.getFieldType());
        newMetadataField.setSubFields(sonTagFields);
        return newMetadataField;
    }

    private PcUiBotTaggingData getMetadataTags(PcUiBotPageDefine mainQueryDTO, PcUiBotExecuteContext executeContext, String actionId) {
//        PcUiBotTaggingData taggingData = tagService.getThemeMapTag(mainQueryDTO.getQueryTagSuffix(), executeContext.getRelationTag(), actionId, "TAG", executeContext);
//        if (taggingData != null) {
//            //在tagData上添加tag相关的定义
//            tagDefService.processTagDefinitions(taggingData, executeContext);
//        }
//        return taggingData;
        return null;
    }

//    /**
//     * 之后用的判断条件
//     *
//     * @param pageDefine
//     * @return
//     */
//    private BuildContext createBuildContext(PcUiBotPageDefine pageDefine, QueryResultSet queryResultSet, PcUiBotExecuteContext executeContext) {
//        BuildContext buildContext = new BuildContext();
//        buildContext.setPageDefine(pageDefine);
//        buildContext.setQueryResultSet(queryResultSet);
//        buildContext.setExecuteContext(executeContext);
//        return buildContext;
//    }

    /**
     * 解析“查询”按钮 查询条件中的
     */
    private static class DateTimePlaceHolderResolver implements PropertyPlaceholderHelper.PlaceholderResolver {
        @Override
        public String resolvePlaceholder(String placeholderName) {
            if (!StringUtils.startsWithIgnoreCase(placeholderName, "DATE")) {
                // 不会替换占位符: {@code null} if no replacement is to be made
                return null;
            }

            // DATE:DAY:-1;yyyy-MM-dd
            // 根据;分隔
            String[] arr = StringUtils.split(placeholderName, ";");
            // 根据:分隔
            String[] strArr = StringUtils.split(arr[0], ":");

            LocalDateTime dateTime = null;
            if (1 == strArr.length) {
                dateTime = LocalDateTime.now();
            } else if (3 <= strArr.length) {
                dateTime = parseDateTime(placeholderName, strArr);
            } else {
                throw new RuntimeException("invalid date expression: " + placeholderName);
            }

            // 解析日期格式
            String pattern = 1 < arr.length ? arr[1] : "yyyy-MM-dd";
            DateTimeFormatter df = DateTimeFormatter.ofPattern(pattern);
            return df.format(dateTime);
        }

        private LocalDateTime parseDateTime(String placeholderName, String[] strArr) {
            LocalDateTime dateTime = LocalDateTime.now();

            // DATE:DAY:-1;yyyy-MM-dd
            int amountToAdd = -1;
            try {
                amountToAdd = Integer.parseInt(strArr[2]);
            } catch (NumberFormatException ex) {
                throw new RuntimeException("invalid date expression: " + placeholderName);
            }

            ChronoUnit timeUnit = null;
            switch (strArr[1]) {
                case "YEAR":
                    timeUnit = ChronoUnit.YEARS;
                    break;
                case "MONTH":
                    timeUnit = ChronoUnit.MONTHS;
                    break;
                case "DAY":
                    timeUnit = ChronoUnit.DAYS;
                    break;
                case "WEEK":
                    timeUnit = ChronoUnit.WEEKS;
                    break;
                default:
                    throw new RuntimeException("invalid date expression: " + placeholderName);
            }
            return dateTime.plus(amountToAdd, timeUnit);
        }
    }

    @Override
    public UiBotModel createTaskPage(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, PcUiBotPageDefine mainAction, List<PcUiBotPageDefine> pageDefines) {
        UiBotModel uiBotModel = super.createTaskPage(apiRequest, executeContext, mainAction, pageDefines);
        if (ObjectUtils.isEmpty(uiBotModel.getRenderData())) {
            uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
        }
//        // 页面内容
//        this.bulidRanderData(apiRequest, executeContext, uiBotModel, pageDefines.get(0), null);
        // 原始数据
        uiBotModel.setRawUiBotPageData(JsonUtil.objectToJavaObject(uiBotModel.getPageData(), UiBotPageData.class));

//        uiBotDesignerRenderService.buildVariablesAndDelivery(apiRequest, uiBotModel, executeContext);

        uiBotModel.getLayout().clear();
        uiBotModel.getPageData().clear();
//        // 注释掉，因为报表导出会用到此action
//        if (Objects.nonNull(uiBotModel.getActions())) {
//            uiBotModel.getActions().clear();
//        }
        uiBotModel.setPageDataIndex(null);
        uiBotModel.setPageDataKeys(null);
        uiBotModel.initMobileLayoutType();
        uiBotModel.setExecuteContext(JsonUtil.objectToJavaObject(executeContext, UiBotExecuteContext.class));
        uiBotModel.setPageBackgroudColor(StringUtils.isNotBlank(uiBotModel.getPageBackgroudColor())
                ?
                uiBotModel.getPageBackgroudColor()
                :
                BackgroundColorEnum.APP_MAIN_GREY.getValue());
        return uiBotModel;
    }
}
