package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.TaskPageService;
import com.fasterxml.jackson.core.type.TypeReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * <p>功能描述：任务卡自定义模板</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: CustomerPerformerGeneralPageTemplate.java
 * @Author: wangjwc
 * @Date: created at 2023/7/14 11:14
 */
@Service
public class CustomerPerformerGeneralPageTemplate extends CommonStandardPerformerGeneralPageTemplate {

    @Autowired
    private TaskPageService taskPageService;

    /**
     * 返回支持的模板
     *
     * @return
     */
    @Override
    public String supportKey() {
        return PcUiBotConstants.WEB_PLATFORM +
                "-" + PcUiBotActivityConstants.PATTERN_CUSTOM.toLowerCase() +
                "-" + PcUiBotActivityConstants.PERFORMER;
    }

    /**
     * 创建数据源
     *
     * @param executeContext
     * @param pageDefine
     * @param dynamicForm
     */
    @Override
    public QueryResultSet BuildDataSource(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, UiBotModel dynamicForm, ApiRequest apiRequest) {
        QueryResultSet queryResultSet = super.BuildDataSource(executeContext, pageDefine, dynamicForm, apiRequest);
        Map<String, Object> pageData = new HashMap<>();
        pageData.put("customData", new ArrayList());
        pageData.put("parameterData", pageDefine.getParameter());

        dynamicForm.getPageData().putAll(pageData);
        return queryResultSet;
    }

    /**
     * 创建布局
     *
     * @param executeContext
     * @param queryResultSet
     * @param pageDefine
     * @param pageDefines
     * @param dynamicForm
     */
    @Override
    protected void BuildLayout(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, QueryResultSet queryResultSet, PcUiBotTaskPageDefine pageDefine, List<PcUiBotTaskPageDefine> pageDefines, UiBotModel dynamicForm) {
        List<UiBotLayout> layout = new ArrayList<>();
        layout.add(createHeadArea());
        //layout.add(createDescriptionArea());
        super.createSignOffProgress(executeContext, layout);
        if (executeContext != null && "task-detail-mobile".equals(executeContext.getPageCode())) {
            if (executeContext != null && !"APPROVAL".equals(executeContext.getCategory())) {
                UiBotLayout abstractComponent = this.createActivityDescriptionComponent(executeContext, pageDefine);
                if (abstractComponent != null) {
                    layout.add(abstractComponent);
                }
            }
        }
        //layout.add(createContentTitle());
        //layout.add(createContentSubtitle());

        //创建多个查询按钮
        if (!CollectionUtils.isEmpty(pageDefines)) {
            UiBotLayout queryButtonComponent = this.createQueryButton(queryResultSet, pageDefines);
            layout.add(queryButtonComponent);
//            queryButtonComponent.setSupportShowInMaxedWindow(true);

            if (executeContext != null && "task-detail-mobile".equals(executeContext.getPageCode())) {
                if (executeContext != null && !"APPROVAL".equals(executeContext.getCategory())) {
                    if (queryResultSet != null && queryResultSet.getMainQueryResult() != null && queryResultSet.getMainQueryResult().getData() != null) {
                        if (queryResultSet.getMainQueryResult().getData().size() > 0) {
                            Map<String, Object> pageData = new HashMap<>();
                            pageData.put("uiBot__APPROVAL_DESCRIPTION", queryResultSet.getMainQueryResult().getData().get(0));
                            dynamicForm.getPageData().putAll(pageData);
                        }
                    }
                }
            }
        }

        //创建客制控件
        UiBotLayout customizeContainerComponent = new UiBotLayout();
        customizeContainerComponent.setId(UUID.randomUUID().toString());
        customizeContainerComponent.setSchema("customData");
//        customizeContainerComponent.setStateCode(pageDefine.getDataStateCode());
//        customizeContainerComponent.setType(genComponentType(executeContext, pageDefine));
        customizeContainerComponent.setActions(JsonUtil.objectToJavaObject(pageDefine.getSubmitActions(),
                new TypeReference<List<UiBotAction>>() {
                }));
        customizeContainerComponent.setFinished(pageDefine.getFinished());
        customizeContainerComponent.setFinishedTitle(pageDefine.getFinishedTitle());
//        customizeContainerComponent.setSupportShowInMaxedWindow(true);
        //追加原始的配置
        if (executeContext.getNeedOriginalLayout() != null && executeContext.getNeedOriginalLayout()) {//NOSONAR
            PcUiBotExecuteContext newExecuteContext = executeContext.clone();
            newExecuteContext.setPattern("Business");
//            UiBotModel dynamicForm1 = taskPageService.createPageWithData(newExecuteContext, pageDefine, queryResultSet);
//            customizeContainerComponent.setOriginalLayout(dynamicForm1);
//            dynamicForm1.setPageData(null);
        }

        layout.add(customizeContainerComponent);
        if (!pageDefine.getShowSubmitActions()) {
            pageDefine.setSubmitActions(null);
        }
        dynamicForm.setLayout(layout);
        //mechnismConfig放入dynamicForm里
        Map<String, Object> mechnismConfig = pageDefine.getMechnismConfig();
        if (mechnismConfig == null) {
            return;
        }
//        dynamicForm.setMechnismConfig(mechnismConfig);
    }

    /**
     * 添加提交的逻辑
     *
     * @param pageDefine
     * @param dynamicForm
     */
    @Override
    protected void BuildActions(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, UiBotModel dynamicForm) {
        List<PcUiBotSubmitAction> actions = pageDefine.getSubmitActions();
        if (!CollectionUtils.isEmpty(actions)) {
            for (PcUiBotSubmitAction action : actions) {
                setExtendedFieldsForAction(executeContext, action);
            }
        }
        dynamicForm.setActions(JsonUtil.objectToJavaObject(actions, new TypeReference<List<UiBotAction>>() {
        }));
    }

    private void setExtendedFieldsForAction(PcUiBotExecuteContext executeContext, PcUiBotSubmitAction action) {

        if (PcUiBotConstants.ACTION_CATEGORY_BPM.equals(action.getCategory())
                && action.getServiceId() != null
                && (PcUiBotActivityConstant.APPROVAL_STEP_REEXECUTE_NAME.equals(action.getServiceId().getName())
                || PcUiBotActivityConstant.APPROVAL_STEP_REAPPVORE_NAME.equals(action.getServiceId().getName()))) {
//            ActivityQueryDTO bpmActionDTO = buildContext.getActivityQueryDTOS().get(0);
            DigiwinAtmcTaskWithBacklogData taskData = executeContext.getTaskWithBacklogData();

            //扩展数据
            Map<String, Object> extend = new HashMap<>();
            action.setExtendedFields(extend);
            Map<String, Object> reExecuteData = new HashMap<>();
            extend.put("reexecuteData", reExecuteData);
            if (taskData != null) {
                reExecuteData.put("processSerialNumber", taskData.getProcessSerialNumber());
                if (!CollectionUtils.isEmpty(taskData.getBacklog())) {
                    List<Map<String, Object>> workitemList = taskData.getBacklog().get(0).getWorkitemList();
                    if (!CollectionUtils.isEmpty(workitemList)) {
                        Map<String, Object> workitem = workitemList.get(0);
                        if (workitem.containsKey("workitemId")) {
                            reExecuteData.put("workitemId", workitem.get("workitemId"));
                        }
                    }
                }
            }
            reExecuteData.put("tmActivityIds", action.getStartApproveActivity());
            reExecuteData.put("locale", AppRequestContext.getContextEntity().getLocale());

            if (PcUiBotActivityConstant.APPROVAL_STEP_REEXECUTE_NAME.equals(action.getServiceId().getName())) {
                //退回重办的，除了输入一个签核意见，会直接提交，所以要把退回任务的ID直接放到taskId中
                if (action.getParas() != null && !CollectionUtils.isEmpty(action.getStartApproveActivity())) {
                    Map<String, Object> para = action.getParas();
                    para.put("taskId", action.getStartApproveActivity().get(0));
                }
            }
        }

        if (!CollectionUtils.isEmpty(action.getAttachActions())) {
            for (PcUiBotSubmitAction attachAction : action.getAttachActions()) {
                setExtendedFieldsForAction(executeContext, attachAction);
            }
        }
    }


}
