package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import java.util.*;

/**
 * 设计器-核签任务DSL
 *
 * @author yanfeng
 * @date 2024/03/08
 * @since
 */
@Component("designerApprvalTaskPageTemplate")
@Slf4j
public class DesignerApprvalTaskPageTemplate extends CommonStandardPerformerGeneralPageTemplate {
    public static final String SUPPORT_KEY = "webplatform-business-designer-approval-performer";

    @Autowired
    private BusinessProcessPerformerImpl businessProcessPerformer;

    @Override
    public String supportKey() {
        return SUPPORT_KEY;
    }


    /**
     * 创建数据源
     *
     * @param executeContext
     * @param pageDefine
     * @param dynamicForm
     */
    @Override
    public QueryResultSet BuildDataSource(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, UiBotModel dynamicForm, ApiRequest apiRequest) {
        QueryResultSet queryResultSet = super.BuildDataSource(executeContext, pageDefine, dynamicForm, apiRequest);
       /*Map  pageData = dynamicForm.getPageData();
            if (queryResultSet.getMainQueryResult()!= null && queryResultSet.getMainQueryResult().size()>0){
            pageData.put(ACTIVITY_DESCRIPTION_SCHEMA_NAME,queryResultSet.getMainQueryResult().getData().get(0));
        }

        pageData.put("uiBot__approvalMessage", "");*/
        return queryResultSet;
    }

    /**
     * 创建头部
     *
     * @param layout
     */
    @Override
    protected void createHeader(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, List<UiBotLayout> layout) {
        layout.add(createHeadArea());
       /* //创建签核描述
        ShowMetadata showMetadata = pageBuilder.createShowMetadata(executeContext,pageDefine);
        if(showMetadata != null) {
            addFiledToMetadata(showMetadata, executeContext);
            Object object =this.createApprovalDescriptionComponent(executeContext,pageDefine,showMetadata);
            layout.add((AbstractComponent) object);
        }*/

        //创建审核流程
        UiBotLayout signOffProgressLinkComponent = this.createSignOffProgress();
        layout.add(signOffProgressLinkComponent);
    }


    /**
     * 添加提交的逻辑
     *
     * @param pageDefine
     * @param dynamicForm
     */
    @Override
    protected void BuildActions(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, UiBotModel dynamicForm) {
        List<PcUiBotSubmitAction> actions = pageDefine.getSubmitActions();
        if (!org.springframework.util.CollectionUtils.isEmpty(actions)) {
            for (PcUiBotSubmitAction action : actions) {
                setExtendedFieldsForAction(executeContext, action);
            }
        }
        dynamicForm.setActions(JsonUtil.objectToJavaObject(actions, new TypeReference<List<UiBotAction>>() {
        }));
    }


    private UiBotLayout createSignOffProgress() {
        UiBotLayout commonComponent = new UiBotLayout();
        commonComponent.setId(UUID.randomUUID().toString());
        commonComponent.setType("SIGN_OFF_PROGRESS_LINK");
        commonComponent.setSchema(PcUiBotConstants.UIBOT_FIELDS_ACTIVITY);
        return commonComponent;
    }


    private void setExtendedFieldsForAction(PcUiBotExecuteContext executeContext, PcUiBotSubmitAction action) {

        if (PcUiBotConstants.ACTION_CATEGORY_BPM.equals(action.getCategory())
                && action.getServiceId() != null
                && (PcUiBotActivityConstant.APPROVAL_STEP_REEXECUTE_NAME.equals(action.getServiceId().getName())
                || PcUiBotActivityConstant.APPROVAL_STEP_REAPPVORE_NAME.equals(action.getServiceId().getName()))) {
//            ActivityQueryDTO bpmActionDTO = buildContext.getActivityQueryDTOS().get(0);
            DigiwinAtmcTaskWithBacklogData taskData = executeContext.getTaskWithBacklogData();

            //扩展数据
            Map<String, Object> extend = new HashMap<>();
            action.setExtendedFields(extend);
            Map<String, Object> reExecuteData = new HashMap<>();
            extend.put("reexecuteData", reExecuteData);
            if (taskData != null) {
                reExecuteData.put("processSerialNumber", taskData.getProcessSerialNumber());
                if (CollectionUtils.isNotEmpty(taskData.getBacklog())) {
                    List<Map<String, Object>> workitemList = taskData.getBacklog().get(0).getWorkitemList();
                    if (CollectionUtils.isNotEmpty(workitemList)) {
                        Map<String, Object> workitem = workitemList.get(0);
                        if (workitem.containsKey("workitemId")) {
                            reExecuteData.put("workitemId", workitem.get("workitemId"));
                        }
                    }
                }
            }
            reExecuteData.put("tmActivityIds", action.getStartApproveActivity());
            reExecuteData.put("locale", AppRequestContext.getContextEntity().getLocale());

            if (PcUiBotActivityConstant.APPROVAL_STEP_REEXECUTE_NAME.equals(action.getServiceId().getName())) {
                //退回重办的，除了输入一个签核意见，会直接提交，所以要把退回任务的ID直接放到taskId中
                if (action.getParas() != null && !CollectionUtils.isEmpty(action.getStartApproveActivity())) {
                    Map<String, Object> para = action.getParas();
                    para.put("taskId", action.getStartApproveActivity().get(0));
                }
            }
        }

        if (!CollectionUtils.isEmpty(action.getAttachActions())) {
            for (PcUiBotSubmitAction attachAction : action.getAttachActions()) {
                setExtendedFieldsForAction(executeContext, attachAction);
            }
        }
    }

    @Override
    public UiBotModel createTaskPage(ApiRequest apiRequest, PcUiBotExecuteContext executeContext,
                                     PcUiBotTaskPageDefine mainAction, List<PcUiBotTaskPageDefine> pageDefines) {
        if (!ObjectUtils.isEmpty(mainAction.getFinished()) && mainAction.getFinished()) {
            //已完成过滤掉按钮组件
            pageDefines.get(0).getPageLayout().forEach(layout -> {
                if (!CollectionUtils.isEmpty(layout.getBottom())) {
                    layout.setBottom(new ArrayList<>());
                }
            });
        }
        return businessProcessPerformer.createTaskPage(apiRequest, executeContext, mainAction, pageDefines);
    }

}
