package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template;


import com.alibaba.ttl.TransmittableThreadLocal;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.common.BackgroundColorEnum;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.layout.singlelistcontainer.SingleListContainer;
import com.digiwin.mobile.mobileuibot.designer.uibot.enums.SourceCategoryEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.button.UiBotQueryButton;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.builder.DesignerBusinessDataEntryDrivenTaskBuilder;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.UUID;

/**
 * 模型驱动的任务模板
 *
 * @author yanfenga
 */
@Service("designerBusinessDataEntryDrivenTaskPageTemplate")
public class DesignerBusinessDataEntryDrivenTaskPageTemplate extends CommonStandardPerformerGeneralPageTemplate {

    @Autowired
    private DesignerBusinessDataEntryDrivenTaskBuilder designerBusinessDataEntryDrivenTaskBuilder;

    @Autowired
    private BusinessProcessPerformerImpl businessProcessPerformer;

    @Autowired
    private UiBotDesignerRenderService uiBotDesignerRenderService;

    private static final ThreadLocal<QueryResultSet> CONTEXT_HOLDER = new TransmittableThreadLocal<>();

    @Override
    public String supportKey() {
        return PcUibotSupportKeyConstant.Designer.BUSINESS_DATA_ENTRY_DRIVEN;
    }

//    @Resource
//    private DesignerBusinessDataEntryDrivenTaskBuilder designerBusinessDataEntryDrivenTaskBuilder;
//
//    @Override
//    protected PageBuilder<PcUiBotTaskPageDefine> getPageBuilder() {
//        return this.designerBusinessDataEntryDrivenTaskBuilder;
//    }


    @Override
    protected void BuildLayout(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, QueryResultSet queryResultSet,
                               PcUiBotTaskPageDefine pageDefine, List<PcUiBotTaskPageDefine> pageDefines,
                               UiBotModel dynamicForm) {
        CONTEXT_HOLDER.set(queryResultSet);
        super.BuildLayout(apiRequest, executeContext, queryResultSet, pageDefine, pageDefines, dynamicForm);
//        // 需要重新设置layout,如果不设置会导致构造任务的头不对
//        pageDefine.setLayout(dynamicForm.getLayout());
//        CommonUtil.sortLayoutByPageDefine(dynamicForm, pageDefine);
    }

    @Override
    protected void createSignOffProgress(PcUiBotExecuteContext executeContext, List<UiBotLayout> layout) {
        if (executeContext != null && executeContext.getTaskWithBacklogData() != null) {
            //创建审核流程
            UiBotLayout workflowProgressComponent = new UiBotLayout();
            workflowProgressComponent.setId(UUID.randomUUID().toString());
            workflowProgressComponent.setType(PcUiBotConstants.ComponentType.WORKFLOW_PROGRESS);
            workflowProgressComponent.setSchema(PcUiBotConstants.UIBOT_FIELDS_ACTIVITY);
            layout.add(workflowProgressComponent);
        }
    }

    @Override
    public UiBotModel createTaskPage(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine mainAction, List<PcUiBotTaskPageDefine> pageDefines) {
        try {
            UiBotModel uiBotModel = super.createTaskPage(apiRequest, executeContext, mainAction, pageDefines);
            QueryResultSet queryResultSet = CONTEXT_HOLDER.get();
            UiBotModel page = designerBusinessDataEntryDrivenTaskBuilder.createPage(executeContext, queryResultSet, mainAction, apiRequest);
            uiBotModel.setRules(page.getRules());
            if (MapUtils.isNotEmpty(page.getPageData())) {
                uiBotModel.getPageData().putAll(page.getPageData());
            }
            if (ObjectUtils.isEmpty(uiBotModel.getRenderData())) {
                uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
            }
            // 处理单身新增功能--ZtbViewList卡片列表组件与表单组件
            UiBotDesignerRenderService.handleRawPageData(apiRequest, uiBotModel);
            // 转派
            DigiwinAtmcBacklogDetail backlogDetail = uiBotDesignerRenderService.buildApprovalReassign(apiRequest, uiBotModel);
            // titleBody
            uiBotDesignerRenderService.buildTitleBody(apiRequest, uiBotModel, backlogDetail, false);
            // 页面内容
            this.bulidRanderData(apiRequest, executeContext, uiBotModel, mainAction, null);
            // 原始数据
            uiBotModel.setRawUiBotPageData(JsonUtil.objectToJavaObject(uiBotModel.getPageData(), UiBotPageData.class));

            // 构建机制参数和交付设计器参数
            uiBotDesignerRenderService.buildVariablesAndDelivery(apiRequest, uiBotModel, executeContext);

            uiBotModel.getLayout().clear();
            uiBotModel.getPageData().clear();
            uiBotModel.getActions().clear();
            uiBotModel.setPageDataIndex(null);
            uiBotModel.setPageDataKeys(null);
            uiBotModel.initMobileLayoutType();
            uiBotModel.setExecuteContext(JsonUtil.objectToJavaObject(executeContext, UiBotExecuteContext.class));
            uiBotModel.setPageBackgroudColor(StringUtils.hasLength(uiBotModel.getPageBackgroudColor())
                    ?
                    uiBotModel.getPageBackgroudColor()
                    :
                    BackgroundColorEnum.APP_MAIN_GREY.getValue());
            return uiBotModel;
        } finally {
            CONTEXT_HOLDER.remove();
        }
    }

    private void bulidRanderData(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, UiBotModel uiBotModel, PcUiBotTaskPageDefine pageDefine, String componentType) {
        ComponentContext cmptContext = JsonUtil.objectToJavaObject(apiRequest, ComponentContext.class);
        cmptContext.setPageDefine(pageDefine);
        MobilePageRawData mobilePageRawData = new MobilePageRawData();
        mobilePageRawData.setSourceCategory(SourceCategoryEnum.DATA_ENTRY_MODEL_DRIVEN.name());

        UiBotQueryButton queryButton = JsonUtil.objectToJavaObject(pageDefine, UiBotQueryButton.class);

        // 高级属性--构建主页面hooks与上下文中组件级hooks
        uiBotDesignerRenderService.buildMainPageHooksByPageDefine(pageDefine, cmptContext, uiBotModel, componentType);

        // 不显示tabs组件
        List<BaseMobileComponentWrapper<BaseMobileComponent>> bodyCmptList =
                businessProcessPerformer.buildBodyCmpt(executeContext, uiBotModel, cmptContext, queryButton, mobilePageRawData, componentType);
        if (CollectionUtils.isEmpty(bodyCmptList)) {
            // 添加空组件
            uiBotModel.getRenderData().addEmptyComponentToBody();
        } else {
            int bodyContainerType = UiBotDesignerRenderService.getBodyContainerType(bodyCmptList);
            if (bodyContainerType == 1) {
                SingleListContainer<BaseMobileComponent> singleListContainer = new SingleListContainer<>();
                singleListContainer.addAll(bodyCmptList);
                uiBotModel.getRenderData().addWrapperedComponentToBody(
                        new BaseMobileComponentWrapper<>(singleListContainer, "DW_" + singleListContainer.returnComponentType()));
            } else {
                uiBotModel.getRenderData().addWrapperedComponentListToBody(bodyCmptList);
            }

            // 构建bottom
            List<BaseMobileComponentWrapper<BaseMobileComponent>> bottomCmptList =
                    businessProcessPerformer.buildBottomCmpt(executeContext, uiBotModel, cmptContext, queryButton, mobilePageRawData, componentType);
            if (!CollectionUtils.isEmpty(bottomCmptList)) {
                uiBotModel.getRenderData().addWrapperedComponentListToBottom(bottomCmptList);
            }
        }
    }
}